// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllBindFrontendOKCode is the HTTP code returned for type GetAllBindFrontendOK
const GetAllBindFrontendOKCode int = 200

/*
GetAllBindFrontendOK Successful operation

swagger:response getAllBindFrontendOK
*/
type GetAllBindFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Binds `json:"body,omitempty"`
}

// NewGetAllBindFrontendOK creates GetAllBindFrontendOK with default headers values
func NewGetAllBindFrontendOK() *GetAllBindFrontendOK {

	return &GetAllBindFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all bind frontend o k response
func (o *GetAllBindFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllBindFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all bind frontend o k response
func (o *GetAllBindFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all bind frontend o k response
func (o *GetAllBindFrontendOK) WithPayload(payload models.Binds) *GetAllBindFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all bind frontend o k response
func (o *GetAllBindFrontendOK) SetPayload(payload models.Binds) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllBindFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Binds{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllBindFrontendDefault General Error

swagger:response getAllBindFrontendDefault
*/
type GetAllBindFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllBindFrontendDefault creates GetAllBindFrontendDefault with default headers values
func NewGetAllBindFrontendDefault(code int) *GetAllBindFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllBindFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all bind frontend default response
func (o *GetAllBindFrontendDefault) WithStatusCode(code int) *GetAllBindFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all bind frontend default response
func (o *GetAllBindFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all bind frontend default response
func (o *GetAllBindFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllBindFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all bind frontend default response
func (o *GetAllBindFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all bind frontend default response
func (o *GetAllBindFrontendDefault) WithPayload(payload *models.Error) *GetAllBindFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all bind frontend default response
func (o *GetAllBindFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllBindFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
