// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPResponseRuleBackendCreatedCode is the HTTP code returned for type CreateHTTPResponseRuleBackendCreated
const CreateHTTPResponseRuleBackendCreatedCode int = 201

/*
CreateHTTPResponseRuleBackendCreated HTTP Response Rule created

swagger:response createHttpResponseRuleBackendCreated
*/
type CreateHTTPResponseRuleBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleBackendCreated creates CreateHTTPResponseRuleBackendCreated with default headers values
func NewCreateHTTPResponseRuleBackendCreated() *CreateHTTPResponseRuleBackendCreated {

	return &CreateHTTPResponseRuleBackendCreated{}
}

// WithPayload adds the payload to the create Http response rule backend created response
func (o *CreateHTTPResponseRuleBackendCreated) WithPayload(payload *models.HTTPResponseRule) *CreateHTTPResponseRuleBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule backend created response
func (o *CreateHTTPResponseRuleBackendCreated) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPResponseRuleBackendAcceptedCode is the HTTP code returned for type CreateHTTPResponseRuleBackendAccepted
const CreateHTTPResponseRuleBackendAcceptedCode int = 202

/*
CreateHTTPResponseRuleBackendAccepted Configuration change accepted and reload requested

swagger:response createHttpResponseRuleBackendAccepted
*/
type CreateHTTPResponseRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleBackendAccepted creates CreateHTTPResponseRuleBackendAccepted with default headers values
func NewCreateHTTPResponseRuleBackendAccepted() *CreateHTTPResponseRuleBackendAccepted {

	return &CreateHTTPResponseRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the create Http response rule backend accepted response
func (o *CreateHTTPResponseRuleBackendAccepted) WithReloadID(reloadID string) *CreateHTTPResponseRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http response rule backend accepted response
func (o *CreateHTTPResponseRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http response rule backend accepted response
func (o *CreateHTTPResponseRuleBackendAccepted) WithPayload(payload *models.HTTPResponseRule) *CreateHTTPResponseRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule backend accepted response
func (o *CreateHTTPResponseRuleBackendAccepted) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPResponseRuleBackendBadRequestCode is the HTTP code returned for type CreateHTTPResponseRuleBackendBadRequest
const CreateHTTPResponseRuleBackendBadRequestCode int = 400

/*
CreateHTTPResponseRuleBackendBadRequest Bad request

swagger:response createHttpResponseRuleBackendBadRequest
*/
type CreateHTTPResponseRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleBackendBadRequest creates CreateHTTPResponseRuleBackendBadRequest with default headers values
func NewCreateHTTPResponseRuleBackendBadRequest() *CreateHTTPResponseRuleBackendBadRequest {

	return &CreateHTTPResponseRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http response rule backend bad request response
func (o *CreateHTTPResponseRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPResponseRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http response rule backend bad request response
func (o *CreateHTTPResponseRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http response rule backend bad request response
func (o *CreateHTTPResponseRuleBackendBadRequest) WithPayload(payload *models.Error) *CreateHTTPResponseRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule backend bad request response
func (o *CreateHTTPResponseRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPResponseRuleBackendConflictCode is the HTTP code returned for type CreateHTTPResponseRuleBackendConflict
const CreateHTTPResponseRuleBackendConflictCode int = 409

/*
CreateHTTPResponseRuleBackendConflict The specified resource already exists

swagger:response createHttpResponseRuleBackendConflict
*/
type CreateHTTPResponseRuleBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleBackendConflict creates CreateHTTPResponseRuleBackendConflict with default headers values
func NewCreateHTTPResponseRuleBackendConflict() *CreateHTTPResponseRuleBackendConflict {

	return &CreateHTTPResponseRuleBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http response rule backend conflict response
func (o *CreateHTTPResponseRuleBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPResponseRuleBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http response rule backend conflict response
func (o *CreateHTTPResponseRuleBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http response rule backend conflict response
func (o *CreateHTTPResponseRuleBackendConflict) WithPayload(payload *models.Error) *CreateHTTPResponseRuleBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule backend conflict response
func (o *CreateHTTPResponseRuleBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPResponseRuleBackendDefault General Error

swagger:response createHttpResponseRuleBackendDefault
*/
type CreateHTTPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleBackendDefault creates CreateHTTPResponseRuleBackendDefault with default headers values
func NewCreateHTTPResponseRuleBackendDefault(code int) *CreateHTTPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP response rule backend default response
func (o *CreateHTTPResponseRuleBackendDefault) WithStatusCode(code int) *CreateHTTPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP response rule backend default response
func (o *CreateHTTPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP response rule backend default response
func (o *CreateHTTPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP response rule backend default response
func (o *CreateHTTPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP response rule backend default response
func (o *CreateHTTPResponseRuleBackendDefault) WithPayload(payload *models.Error) *CreateHTTPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP response rule backend default response
func (o *CreateHTTPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
