// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateQUICInitialRuleDefaultsCreatedCode is the HTTP code returned for type CreateQUICInitialRuleDefaultsCreated
const CreateQUICInitialRuleDefaultsCreatedCode int = 201

/*
CreateQUICInitialRuleDefaultsCreated HTTP Response Rule created

swagger:response createQuicInitialRuleDefaultsCreated
*/
type CreateQUICInitialRuleDefaultsCreated struct {

	/*
	  In: Body
	*/
	Payload *models.QUICInitialRule `json:"body,omitempty"`
}

// NewCreateQUICInitialRuleDefaultsCreated creates CreateQUICInitialRuleDefaultsCreated with default headers values
func NewCreateQUICInitialRuleDefaultsCreated() *CreateQUICInitialRuleDefaultsCreated {

	return &CreateQUICInitialRuleDefaultsCreated{}
}

// WithPayload adds the payload to the create Quic initial rule defaults created response
func (o *CreateQUICInitialRuleDefaultsCreated) WithPayload(payload *models.QUICInitialRule) *CreateQUICInitialRuleDefaultsCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Quic initial rule defaults created response
func (o *CreateQUICInitialRuleDefaultsCreated) SetPayload(payload *models.QUICInitialRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateQUICInitialRuleDefaultsCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateQUICInitialRuleDefaultsAcceptedCode is the HTTP code returned for type CreateQUICInitialRuleDefaultsAccepted
const CreateQUICInitialRuleDefaultsAcceptedCode int = 202

/*
CreateQUICInitialRuleDefaultsAccepted Configuration change accepted and reload requested

swagger:response createQuicInitialRuleDefaultsAccepted
*/
type CreateQUICInitialRuleDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.QUICInitialRule `json:"body,omitempty"`
}

// NewCreateQUICInitialRuleDefaultsAccepted creates CreateQUICInitialRuleDefaultsAccepted with default headers values
func NewCreateQUICInitialRuleDefaultsAccepted() *CreateQUICInitialRuleDefaultsAccepted {

	return &CreateQUICInitialRuleDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the create Quic initial rule defaults accepted response
func (o *CreateQUICInitialRuleDefaultsAccepted) WithReloadID(reloadID string) *CreateQUICInitialRuleDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Quic initial rule defaults accepted response
func (o *CreateQUICInitialRuleDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Quic initial rule defaults accepted response
func (o *CreateQUICInitialRuleDefaultsAccepted) WithPayload(payload *models.QUICInitialRule) *CreateQUICInitialRuleDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Quic initial rule defaults accepted response
func (o *CreateQUICInitialRuleDefaultsAccepted) SetPayload(payload *models.QUICInitialRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateQUICInitialRuleDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateQUICInitialRuleDefaultsBadRequestCode is the HTTP code returned for type CreateQUICInitialRuleDefaultsBadRequest
const CreateQUICInitialRuleDefaultsBadRequestCode int = 400

/*
CreateQUICInitialRuleDefaultsBadRequest Bad request

swagger:response createQuicInitialRuleDefaultsBadRequest
*/
type CreateQUICInitialRuleDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateQUICInitialRuleDefaultsBadRequest creates CreateQUICInitialRuleDefaultsBadRequest with default headers values
func NewCreateQUICInitialRuleDefaultsBadRequest() *CreateQUICInitialRuleDefaultsBadRequest {

	return &CreateQUICInitialRuleDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Quic initial rule defaults bad request response
func (o *CreateQUICInitialRuleDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *CreateQUICInitialRuleDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Quic initial rule defaults bad request response
func (o *CreateQUICInitialRuleDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Quic initial rule defaults bad request response
func (o *CreateQUICInitialRuleDefaultsBadRequest) WithPayload(payload *models.Error) *CreateQUICInitialRuleDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Quic initial rule defaults bad request response
func (o *CreateQUICInitialRuleDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateQUICInitialRuleDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateQUICInitialRuleDefaultsConflictCode is the HTTP code returned for type CreateQUICInitialRuleDefaultsConflict
const CreateQUICInitialRuleDefaultsConflictCode int = 409

/*
CreateQUICInitialRuleDefaultsConflict The specified resource already exists

swagger:response createQuicInitialRuleDefaultsConflict
*/
type CreateQUICInitialRuleDefaultsConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateQUICInitialRuleDefaultsConflict creates CreateQUICInitialRuleDefaultsConflict with default headers values
func NewCreateQUICInitialRuleDefaultsConflict() *CreateQUICInitialRuleDefaultsConflict {

	return &CreateQUICInitialRuleDefaultsConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Quic initial rule defaults conflict response
func (o *CreateQUICInitialRuleDefaultsConflict) WithConfigurationVersion(configurationVersion string) *CreateQUICInitialRuleDefaultsConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Quic initial rule defaults conflict response
func (o *CreateQUICInitialRuleDefaultsConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Quic initial rule defaults conflict response
func (o *CreateQUICInitialRuleDefaultsConflict) WithPayload(payload *models.Error) *CreateQUICInitialRuleDefaultsConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Quic initial rule defaults conflict response
func (o *CreateQUICInitialRuleDefaultsConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateQUICInitialRuleDefaultsConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateQUICInitialRuleDefaultsDefault General Error

swagger:response createQuicInitialRuleDefaultsDefault
*/
type CreateQUICInitialRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateQUICInitialRuleDefaultsDefault creates CreateQUICInitialRuleDefaultsDefault with default headers values
func NewCreateQUICInitialRuleDefaultsDefault(code int) *CreateQUICInitialRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateQUICInitialRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create QUIC initial rule defaults default response
func (o *CreateQUICInitialRuleDefaultsDefault) WithStatusCode(code int) *CreateQUICInitialRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create QUIC initial rule defaults default response
func (o *CreateQUICInitialRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create QUIC initial rule defaults default response
func (o *CreateQUICInitialRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *CreateQUICInitialRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create QUIC initial rule defaults default response
func (o *CreateQUICInitialRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create QUIC initial rule defaults default response
func (o *CreateQUICInitialRuleDefaultsDefault) WithPayload(payload *models.Error) *CreateQUICInitialRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create QUIC initial rule defaults default response
func (o *CreateQUICInitialRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateQUICInitialRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
