// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceUserOKCode is the HTTP code returned for type ReplaceUserOK
const ReplaceUserOKCode int = 200

/*
ReplaceUserOK User replaced

swagger:response replaceUserOK
*/
type ReplaceUserOK struct {

	/*
	  In: Body
	*/
	Payload *models.User `json:"body,omitempty"`
}

// NewReplaceUserOK creates ReplaceUserOK with default headers values
func NewReplaceUserOK() *ReplaceUserOK {

	return &ReplaceUserOK{}
}

// WithPayload adds the payload to the replace user o k response
func (o *ReplaceUserOK) WithPayload(payload *models.User) *ReplaceUserOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace user o k response
func (o *ReplaceUserOK) SetPayload(payload *models.User) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceUserOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceUserAcceptedCode is the HTTP code returned for type ReplaceUserAccepted
const ReplaceUserAcceptedCode int = 202

/*
ReplaceUserAccepted Configuration change accepted and reload requested

swagger:response replaceUserAccepted
*/
type ReplaceUserAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.User `json:"body,omitempty"`
}

// NewReplaceUserAccepted creates ReplaceUserAccepted with default headers values
func NewReplaceUserAccepted() *ReplaceUserAccepted {

	return &ReplaceUserAccepted{}
}

// WithReloadID adds the reloadId to the replace user accepted response
func (o *ReplaceUserAccepted) WithReloadID(reloadID string) *ReplaceUserAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace user accepted response
func (o *ReplaceUserAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace user accepted response
func (o *ReplaceUserAccepted) WithPayload(payload *models.User) *ReplaceUserAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace user accepted response
func (o *ReplaceUserAccepted) SetPayload(payload *models.User) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceUserAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceUserBadRequestCode is the HTTP code returned for type ReplaceUserBadRequest
const ReplaceUserBadRequestCode int = 400

/*
ReplaceUserBadRequest Bad request

swagger:response replaceUserBadRequest
*/
type ReplaceUserBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceUserBadRequest creates ReplaceUserBadRequest with default headers values
func NewReplaceUserBadRequest() *ReplaceUserBadRequest {

	return &ReplaceUserBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace user bad request response
func (o *ReplaceUserBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceUserBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace user bad request response
func (o *ReplaceUserBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace user bad request response
func (o *ReplaceUserBadRequest) WithPayload(payload *models.Error) *ReplaceUserBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace user bad request response
func (o *ReplaceUserBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceUserBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceUserNotFoundCode is the HTTP code returned for type ReplaceUserNotFound
const ReplaceUserNotFoundCode int = 404

/*
ReplaceUserNotFound The specified resource was not found

swagger:response replaceUserNotFound
*/
type ReplaceUserNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceUserNotFound creates ReplaceUserNotFound with default headers values
func NewReplaceUserNotFound() *ReplaceUserNotFound {

	return &ReplaceUserNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace user not found response
func (o *ReplaceUserNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceUserNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace user not found response
func (o *ReplaceUserNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace user not found response
func (o *ReplaceUserNotFound) WithPayload(payload *models.Error) *ReplaceUserNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace user not found response
func (o *ReplaceUserNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceUserNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceUserDefault General Error

swagger:response replaceUserDefault
*/
type ReplaceUserDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceUserDefault creates ReplaceUserDefault with default headers values
func NewReplaceUserDefault(code int) *ReplaceUserDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceUserDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace user default response
func (o *ReplaceUserDefault) WithStatusCode(code int) *ReplaceUserDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace user default response
func (o *ReplaceUserDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace user default response
func (o *ReplaceUserDefault) WithConfigurationVersion(configurationVersion string) *ReplaceUserDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace user default response
func (o *ReplaceUserDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace user default response
func (o *ReplaceUserDefault) WithPayload(payload *models.Error) *ReplaceUserDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace user default response
func (o *ReplaceUserDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceUserDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
