# Examples

:::{admonition} Disclaimer
Examples and [input files](input/index.md) distributed with Cantera are provided for
**illustration purposes only**. They are intended to demonstrate features of the
software and typical workflows, with individual examples often using simplifying
assumptions. Users are responsible for verifying suitability before adapting them for
research or applications.
:::

- To see all examples written in a particular programming language, select the
  corresponding category below.
- To browse all examples covering a particular topic, regardless of programming
  language, select from the {ref}`list of example tags <tagoverview>`.

## Python Examples

```{seealso}
If you're just getting started with Cantera, see our [](/userguide/python-tutorial) for
an introduction to the Cantera Python interface.
```

````{grid} 2 2 2 3
:gutter: 3

```{grid-item-card} Thermodynamics
:link: python/thermo/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Kinetics
:link: python/kinetics/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Transport
:link: python/transport/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Reactor networks
:link: python/reactors/index
:link-type: doc
:text-align: center
```

```{grid-item-card} 1D reacting flows
:link: python/onedim/index
:link-type: doc
:text-align: center
```

````

## Examples in Other Languages

````{grid} 2 2 3 3
:gutter: 3

```{grid-item-card} C++
:link: cxx/index
:link-type: doc
:text-align: center
```

```{grid-item-card} C
:link: clib/index
:link-type: doc
:text-align: center
```

```{grid-item-card} C (legacy)
:link: clib_legacy/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Matlab
:link: matlab/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Fortran
:link: fortran/index
:link-type: doc
:text-align: center
```

```{grid-item-card} .NET
:link: dotnet/index
:link-type: doc
:text-align: center
```

````

## Input File Examples

````{grid} 2 2 3 3
:gutter: 3

```{grid-item-card} YAML
:link: input/index
:link-type: doc
:text-align: center
```

````


% The following pages are generated by sphinx-gallery
```{toctree}
:maxdepth: 2
:hidden:

python/index
cxx/index
clib/index
clib_legacy/index
matlab/index
fortran/index
dotnet/index
input/index
```

% The following page is generated by sphinx-tags
```{toctree}
:maxdepth: 1
:hidden:

/_tags/tagsindex
```
