/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.WekaPackageClassLoaderManager;

public class InheritanceUtils {
    public static boolean isSubclass(String superclass, String otherclass) {
        try {
            return InheritanceUtils.isSubclass(WekaPackageClassLoaderManager.forName(superclass), WekaPackageClassLoaderManager.forName(otherclass));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSubclass(Class<?> superclass, Class<?> otherclass) {
        boolean result = false;
        Class<?> currentclass = otherclass;
        do {
            result = currentclass.equals(superclass);
            if (currentclass.equals(Object.class)) break;
            if (result) continue;
            currentclass = currentclass.getSuperclass();
        } while (!result);
        return result;
    }

    public static boolean hasInterface(String intf, String cls) {
        try {
            return InheritanceUtils.hasInterface(WekaPackageClassLoaderManager.forName(intf), WekaPackageClassLoaderManager.forName(cls));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasInterface(Class<?> intf, Class<?> cls) {
        boolean result = false;
        Class<?> currentclass = cls;
        block0: do {
            Class<?>[] intfs = currentclass.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                if (!intfs[i].equals(intf)) continue;
                result = true;
                continue block0;
            }
        } while ((result || (currentclass = currentclass.getSuperclass()) != null && !currentclass.equals(Object.class)) && !result);
        return result;
    }
}

