/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.Saver;

public abstract class AbstractSaver
implements Saver,
CapabilitiesHandler,
CapabilitiesIgnorer {
    private static final long serialVersionUID = -27467499727819258L;
    protected static final int WRITE = 0;
    protected static final int WAIT = 1;
    protected static final int CANCEL = 2;
    protected static final int STRUCTURE_READY = 3;
    private Instances m_instances;
    protected int m_retrieval;
    private int m_writeMode;
    protected boolean m_DoNotCheckCapabilities = false;

    public String doNotCheckCapabilitiesTipText() {
        return "If set, saver capabilities are not checked (Use with caution to reduce runtime).";
    }

    @Override
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    @Override
    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    public void resetOptions() {
        this.m_instances = null;
        this.m_writeMode = 1;
    }

    public void resetStructure() {
        this.m_instances = null;
        this.m_writeMode = 1;
    }

    @Override
    public void setRetrieval(int mode) {
        this.m_retrieval = mode;
    }

    protected int getRetrieval() {
        return this.m_retrieval;
    }

    protected void setWriteMode(int mode) {
        this.m_writeMode = mode;
    }

    @Override
    public int getWriteMode() {
        return this.m_writeMode;
    }

    @Override
    public void setInstances(Instances instances) {
        Capabilities cap = this.getCapabilities();
        if (!cap.test(instances)) {
            throw new IllegalArgumentException(cap.getFailReason());
        }
        if (this.m_retrieval == 2) {
            if (this.setStructure(instances) == 2) {
                this.cancel();
            }
        } else {
            this.m_instances = instances;
        }
    }

    public Instances getInstances() {
        return this.m_instances;
    }

    @Override
    public void setDestination(File file) throws IOException {
        throw new IOException("Writing to a file not supported");
    }

    @Override
    public void setDestination(OutputStream output) throws IOException {
        throw new IOException("Writing to an outputstream not supported");
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public int setStructure(Instances headerInfo) {
        Capabilities cap = this.getCapabilities();
        if (!cap.test(headerInfo)) {
            throw new IllegalArgumentException(cap.getFailReason());
        }
        if (this.m_writeMode == 1 && headerInfo != null) {
            this.m_instances = headerInfo;
            this.m_writeMode = 3;
        } else if (headerInfo == null || this.m_writeMode != 3 || !headerInfo.equalHeaders(this.m_instances)) {
            this.m_instances = null;
            if (this.m_writeMode != 1) {
                System.err.println("A structure cannot be set up during an active incremental saving process.");
            }
            this.m_writeMode = 2;
        }
        return this.m_writeMode;
    }

    public void cancel() {
        if (this.m_writeMode == 2) {
            this.resetOptions();
        }
    }

    @Override
    public void writeIncremental(Instance i) throws IOException {
        throw new IOException("No Incremental saving possible.");
    }

    @Override
    public abstract void writeBatch() throws IOException;

    @Override
    public String getFileExtension() throws Exception {
        throw new Exception("Saving in a file not supported.");
    }

    @Override
    public void setFile(File file) throws IOException {
        throw new IOException("Saving in a file not supported.");
    }

    @Override
    public void setFilePrefix(String prefix) throws Exception {
        throw new Exception("Saving in a file not supported.");
    }

    @Override
    public String filePrefix() throws Exception {
        throw new Exception("Saving in a file not supported.");
    }

    @Override
    public void setDir(String dir) throws IOException {
        throw new IOException("Saving in a file not supported.");
    }

    @Override
    public void setDirAndPrefix(String relationName, String add) throws IOException {
        throw new IOException("Saving in a file not supported.");
    }

    @Override
    public String retrieveDir() throws IOException {
        throw new IOException("Saving in a file not supported.");
    }
}

