// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListObjectsV2`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_bucket):<br>required: **true**<br><p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must follow the format <code> <i>bucket-base-name</i>--<i>zone-id</i>--x-s3</code> (for example, <code> <i>amzn-s3-demo-bucket</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts, the destination bucket must be the Outposts access point ARN or the access point alias. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`delimiter(impl Into<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::delimiter) / [`set_delimiter(Option<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_delimiter):<br>required: **false**<br><p>A delimiter is a character that you use to group keys.</p><note>  <ul>   <li>    <p><b>Directory buckets</b> - For directory buckets, <code>/</code> is the only supported delimiter.</p></li>   <li>    <p><b>Directory buckets </b> - When you query <code>ListObjectsV2</code> with a delimiter during in-progress multipart uploads, the <code>CommonPrefixes</code> response parameter contains the prefixes that are associated with the in-progress multipart uploads. For more information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a> in the <i>Amazon S3 User Guide</i>.</p></li>  </ul> </note><br>
    ///   - [`encoding_type(EncodingType)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::encoding_type) / [`set_encoding_type(Option<EncodingType>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_encoding_type):<br>required: **false**<br><p>Encoding type used by Amazon S3 to encode the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html">object keys</a> in the response. Responses are encoded only in UTF-8. An object key can contain any Unicode character. However, the XML 1.0 parser can't parse certain characters, such as characters with an ASCII value from 0 to 10. For characters that aren't supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response. For more information about characters to avoid in object key names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-guidelines">Object key naming guidelines</a>.</p><note>  <p>When using the URL encoding type, non-ASCII characters that are used in an object's key name will be percent-encoded according to UTF-8 code values. For example, the object <code>test_file(3).png</code> will appear as <code>test_file%283%29.png</code>.</p> </note><br>
    ///   - [`max_keys(i32)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::max_keys) / [`set_max_keys(Option<i32>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_max_keys):<br>required: **false**<br><p>Sets the maximum number of keys returned in the response. By default, the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p><br>
    ///   - [`prefix(impl Into<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::prefix) / [`set_prefix(Option<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_prefix):<br>required: **false**<br><p>Limits the response to keys that begin with the specified prefix.</p><note>  <p><b>Directory buckets</b> - For directory buckets, only prefixes that end in a delimiter (<code>/</code>) are supported.</p> </note><br>
    ///   - [`continuation_token(impl Into<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::continuation_token) / [`set_continuation_token(Option<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_continuation_token):<br>required: **false**<br><p><code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket with a token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this <code>ContinuationToken</code> for pagination of the list results.</p><br>
    ///   - [`fetch_owner(bool)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::fetch_owner) / [`set_fetch_owner(Option<bool>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_fetch_owner):<br>required: **false**<br><p>The owner field is not present in <code>ListObjectsV2</code> by default. If you want to return the owner field with each key in the result, then set the <code>FetchOwner</code> field to <code>true</code>.</p><note>  <p><b>Directory buckets</b> - For directory buckets, the bucket owner is returned as the object owner for all objects.</p> </note><br>
    ///   - [`start_after(impl Into<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::start_after) / [`set_start_after(Option<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_start_after):<br>required: **false**<br><p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`optional_object_attributes(OptionalObjectAttributes)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::optional_object_attributes) / [`set_optional_object_attributes(Option<Vec::<OptionalObjectAttributes>>)`](crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::set_optional_object_attributes):<br>required: **false**<br><p>Specifies the optional fields that you want returned in the response. Fields that you do not specify are not returned.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    /// - On success, responds with [`ListObjectsV2Output`](crate::operation::list_objects_v2::ListObjectsV2Output) with field(s):
    ///   - [`is_truncated(Option<bool>)`](crate::operation::list_objects_v2::ListObjectsV2Output::is_truncated): <p>Set to <code>false</code> if all of the results were returned. Set to <code>true</code> if more keys are available to return. If the number of results exceeds that specified by <code>MaxKeys</code>, all of the results might not be returned.</p>
    ///   - [`contents(Option<Vec::<Object>>)`](crate::operation::list_objects_v2::ListObjectsV2Output::contents): <p>Metadata about each object returned.</p>
    ///   - [`name(Option<String>)`](crate::operation::list_objects_v2::ListObjectsV2Output::name): <p>The bucket name.</p>
    ///   - [`prefix(Option<String>)`](crate::operation::list_objects_v2::ListObjectsV2Output::prefix): <p>Keys that begin with the indicated prefix.</p><note>  <p><b>Directory buckets</b> - For directory buckets, only prefixes that end in a delimiter (<code>/</code>) are supported.</p> </note>
    ///   - [`delimiter(Option<String>)`](crate::operation::list_objects_v2::ListObjectsV2Output::delimiter): <p>Causes keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter to be rolled up into a single result element in the <code>CommonPrefixes</code> collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up result counts as only one return against the <code>MaxKeys</code> value.</p><note>  <p><b>Directory buckets</b> - For directory buckets, <code>/</code> is the only supported delimiter.</p> </note>
    ///   - [`max_keys(Option<i32>)`](crate::operation::list_objects_v2::ListObjectsV2Output::max_keys): <p>Sets the maximum number of keys returned in the response. By default, the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
    ///   - [`common_prefixes(Option<Vec::<CommonPrefix>>)`](crate::operation::list_objects_v2::ListObjectsV2Output::common_prefixes): <p>All of the keys (up to 1,000) that share the same prefix are grouped together. When counting the total numbers of returns by this API operation, this group of keys is considered as one item.</p> <p>A response can contain <code>CommonPrefixes</code> only if you specify a delimiter.</p> <p><code>CommonPrefixes</code> contains all (if there are any) keys between <code>Prefix</code> and the next occurrence of the string specified by a delimiter.</p> <p><code>CommonPrefixes</code> lists keys that act like subdirectories in the directory specified by <code>Prefix</code>.</p> <p>For example, if the prefix is <code>notes/</code> and the delimiter is a slash (<code>/</code>) as in <code>notes/summer/july</code>, the common prefix is <code>notes/summer/</code>. All of the keys that roll up into a common prefix count as a single return when calculating the number of returns.</p><note>  <ul>   <li>    <p><b>Directory buckets</b> - For directory buckets, only prefixes that end in a delimiter (<code>/</code>) are supported.</p></li>   <li>    <p><b>Directory buckets </b> - When you query <code>ListObjectsV2</code> with a delimiter during in-progress multipart uploads, the <code>CommonPrefixes</code> response parameter contains the prefixes that are associated with the in-progress multipart uploads. For more information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a> in the <i>Amazon S3 User Guide</i>.</p></li>  </ul> </note>
    ///   - [`encoding_type(Option<EncodingType>)`](crate::operation::list_objects_v2::ListObjectsV2Output::encoding_type): <p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p> <p>If you specify the <code>encoding-type</code> request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p> <p><code>Delimiter, Prefix, Key,</code> and <code>StartAfter</code>.</p>
    ///   - [`key_count(Option<i32>)`](crate::operation::list_objects_v2::ListObjectsV2Output::key_count): <p><code>KeyCount</code> is the number of keys returned with this request. <code>KeyCount</code> will always be less than or equal to the <code>MaxKeys</code> field. For example, if you ask for 50 keys, your result will include 50 keys or fewer.</p>
    ///   - [`continuation_token(Option<String>)`](crate::operation::list_objects_v2::ListObjectsV2Output::continuation_token): <p>If <code>ContinuationToken</code> was sent with the request, it is included in the response. You can use the returned <code>ContinuationToken</code> for pagination of the list response. You can use this <code>ContinuationToken</code> for pagination of the list results.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::operation::list_objects_v2::ListObjectsV2Output::next_continuation_token): <p><code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which means there are more keys in the bucket that can be listed. The next list requests to Amazon S3 can be continued with this <code>NextContinuationToken</code>. <code>NextContinuationToken</code> is obfuscated and is not a real key</p>
    ///   - [`start_after(Option<String>)`](crate::operation::list_objects_v2::ListObjectsV2Output::start_after): <p>If StartAfter was sent with the request, it is included in the response.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::list_objects_v2::ListObjectsV2Output::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<ListObjectsV2Error>`](crate::operation::list_objects_v2::ListObjectsV2Error)
    pub fn list_objects_v2(&self) -> crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder {
        crate::operation::list_objects_v2::builders::ListObjectsV2FluentBuilder::new(self.handle.clone())
    }
}
