// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.07/07       [395015]
Creator        : qati
Date           : Fri Sep 16 08:58:31 2016
Host           : Linux Q 4.4.0-34-generic #53-Ubuntu SMP Wed Jul 27 16:06:39 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /media/share/code/GSOC/wd/notebooks
Training events: 6000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "850" [Number of trees in the forest]
MaxDepth: "3" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
Shrinkage: "1.000000e+00" [Learning rate for GradBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Possion distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in traning sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-8.96602058411,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                  F                                 'F'    [-4.08540010452,4.0258936882]
var3                          var3                          var3                          Variable 3                    F                                 'F'    [-5.05078554153,4.35967063904]
var4                          var4                          var4                          Variable 4                    F                                 'F'    [-5.95050764084,4.92254400253]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   F                                 'F'    [-9.91655540466,9.52782058716]
var1*3                        spec2                         spec2                         Spectator 2                   F                                 'F'    [-14.874833107,14.2917308807]


============================================================================ */

#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#define NN new BDTNode
   
#ifndef BDTNode__def
#define BDTNode__def
   
class BDTNode {
   
public:
   
   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it decends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it decends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value appplied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 
   
//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 
   
//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it decends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] > fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}
   
//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it decends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}
   
#endif
   
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars ) 
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 4 ),
        fIsNormalised( false )
   {      
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the 
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   const bool fIsNormalised;
   bool IsNormalised() const { return fIsNormalised; }
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
};

void ReadBDT::Initialize()
{
  // itree = 0
  fBoostWeights.push_back(0.631247187972796);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495192,-99) , 
3, -0.566751, 0, 0, 0.715875,-99) , 
NN(
0, 
0, 
-1, 3.91808, 1, -1, 0.15,-99) , 
0, 3.28781, 1, 0, 0.616764,-99) , 
NN(
0, 
0, 
-1, -2.26877, 0, -1, 0.0755008,-99) , 
3, -1.22249, 0, 0, 0.501477,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.502433);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393855,-99) , 
3, -0.956299, 0, 0, 0.639652,-99) , 
NN(
0, 
0, 
-1, 4.59378, 1, -1, 0.221812,-99) , 
0, 3.12243, 1, 0, 0.565404,-99) , 
NN(
0, 
0, 
-1, -2.20353, 0, -1, 0.0246685,-99) , 
3, -1.95282, 0, 0, 0.477501,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.414166);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324435,-99) , 
3, -1.50472, 0, 0, 0.606125,-99) , 
NN(
0, 
0, 
-1, 4.84835, 1, -1, 0.209852,-99) , 
0, 3.5079, 1, 0, 0.552343,-99) , 
NN(
0, 
0, 
-1, -3.01875, 0, -1, 0.00555646,-99) , 
3, -2.32616, 0, 0, 0.484733,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.340593);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.624968, 0, 1, 0.603212,-99) , 
NN(
0, 
0, 
-1, 4.64258, 1, -1, 0.378793,-99) , 
0, 1.47269, 1, 0, 0.513877,-99) , 
NN(
0, 
0, 
-1, -2.11263, 0, -1, 0.00338899,-99) , 
3, -2.09303, 0, 0, 0.442997,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.275924);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.72822, 0, 1, 0.567392,-99) , 
NN(
0, 
0, 
-1, 4.68199, 1, -1, 0.374116,-99) , 
0, 1.94353, 1, 0, 0.502905,-99) , 
NN(
0, 
0, 
-1, -2.63294, 0, -1, 0.0394923,-99) , 
3, -1.97353, 0, 0, 0.443793,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.291023);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395657,-99) , 
3, 0.0283472, 0, 0, 0.515581,-99) , 
NN(
0, 
0, 
-1, 5.18133, 1, -1, 0.220737,-99) , 
0, 4.50617, 1, 0, 0.495864,-99) , 
NN(
0, 
0, 
-1, -3.07504, 0, -1, 0.0253916,-99) , 
3, -2.37526, 0, 0, 0.445919,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.245415);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477916,-99) , 
3, 1.21626, 0, 0, 0.522595,-99) , 
NN(
0, 
0, 
-1, 5.11846, 1, -1, 0.169226,-99) , 
0, 4.0826, 1, 0, 0.493955,-99) , 
NN(
0, 
0, 
-1, -2.17147, 0, -1, 0.00860309,-99) , 
3, -2.1871, 0, 0, 0.441881,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.224993);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.659854, 0, 1, 0.552805,-99) , 
NN(
0, 
0, 
-1, 0.543021, 1, -1, 0.389696,-99) , 
0, 1.29587, 1, 0, 0.485435,-99) , 
NN(
0, 
0, 
-1, -3.24588, 0, -1, 0.0282926,-99) , 
3, -2.39062, 0, 0, 0.446007,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.271895);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41771,-99) , 
3, -0.20326, 0, 0, 0.544697,-99) , 
NN(
0, 
0, 
-1, 3.58568, 1, -1, 0.389735,-99) , 
1, 0.736794, 1, 0, 0.50281,-99) , 
NN(
0, 
0, 
-1, -3.77008, 0, -1, 0.0122068,-99) , 
3, -2.10265, 0, 0, 0.456701,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.234174);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435712,-99) , 
0, -0.0906773, 1, 0, 0.482922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148761,-99) , 
0, 4.78525, 1, 0, 0.467002,-99) , 
NN(
0, 
0, 
-1, -3.09292, 0, -1, 0.0465015,-99) , 
3, -2.42022, 0, 0, 0.427957,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.218756);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450237,-99) , 
3, 0.269995, 0, 0, 0.525555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159609,-99) , 
0, 4.82478, 1, 0, 0.5098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.58957, 0, 0, 0.473873,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.241977);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479571,-99) , 
3, 1.12254, 0, 0, 0.524209,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301471,-99) , 
1, -1.00614, 1, 0, 0.349546,-99) , 
0, 2.27736, 1, 0, 0.477903,-99) , 
NN(
0, 
0, 
-1, -3.04508, 0, -1, 0.0403422,-99) , 
3, -2.24106, 0, 0, 0.442456,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.264333);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0615126, 0, 1, 0.660505,-99) , 
NN(
0, 
0, 
-1, 0.725552, 0, -1, 0.442923,-99) , 
0, 0.132892, 1, 0, 0.517516,-99) , 
NN(
0, 
0, 
-1, -2.42916, 0, -1, 0.095305,-99) , 
3, -1.67274, 0, 0, 0.467962,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.179789);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304174,-99) , 
3, -1.6217, 0, 0, 0.526655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232621,-99) , 
2, 2.47426, 1, 0, 0.512413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -3.00763, 0, 0, 0.48692,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.202468);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.938801, 0, 1, 0.62218,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454387,-99) , 
0, -1.61847, 1, 0, 0.477637,-99) , 
1, -0.559937, 1, 0, 0.52124,-99) , 
NN(
0, 
0, 
-1, -4.56473, 0, -1, 0.0736897,-99) , 
3, -2.45609, 0, 0, 0.491439,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.214267);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.16148, 0, 1, 0.698893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255006,-99) , 
3, -0.71822, 0, 0, 0.514247,-99) , 
0, -1.93486, 1, 0, 0.534324,-99) , 
NN(
0, 
0, 
-1, -2.30532, 0, -1, 0.0926533,-99) , 
3, -2.19802, 0, 0, 0.498122,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.225158);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.132455, 0, 1, 0.66043,-99) , 
NN(
0, 
0, 
-1, 0.409134, 0, -1, 0.451253,-99) , 
0, -0.263703, 1, 0, 0.500806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0218408,-99) , 
0, -2.3142, 1, 0, 0.300181,-99) , 
NN(
0, 
0, 
-1, -3.30454, 0, -1, 0.0223313,-99) , 
3, -2.24608, 0, 0, 0.153758,-99) , 
3, -1.37351, 0, 0, 0.458065,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.202533);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4603, 1, 1, 0.565711,-99) , 
NN(
0, 
0, 
-1, 0.591781, 1, -1, 0.413538,-99) , 
3, 0.741237, 0, 0, 0.488816,-99) , 
NN(
0, 
0, 
-1, -2.3535, 0, -1, 0.0674021,-99) , 
3, -2.19479, 0, 0, 0.460783,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.11773);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490866,-99) , 
3, 2.35625, 0, 0, 0.504928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169557,-99) , 
0, 4.68435, 1, 0, 0.490794,-99) , 
NN(
0, 
0, 
-1, -5.00634, 0, -1, 0.0309232,-99) , 
3, -2.42344, 0, 0, 0.465008,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.197449);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433702,-99) , 
0, 1.67579, 1, 0, 0.520102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132149,-99) , 
0, 4.98957, 1, 0, 0.507361,-99) , 
NN(
0, 
0, 
-1, -0.261516, 1, -1, 0.0309684,-99) , 
3, -2.46611, 0, 0, 0.479438,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.212378);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.891647, 0, 1, 0.743762,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313298,-99) , 
3, -0.25361, 0, 0, 0.510755,-99) , 
0, -1.66812, 1, 0, 0.527639,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60705,-99) , 
NN(
0, 
0, 
-1, -2.06009, 0, -1, 0.151734,-99) , 
1, -1.3432, 1, 0, 0.265854,-99) , 
3, -1.41157, 0, 0, 0.493019,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.166848);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474591,-99) , 
1, -0.21924, 1, 0, 0.520867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22602,-99) , 
0, 4.68435, 1, 0, 0.507645,-99) , 
NN(
0, 
0, 
-1, -2.81163, 0, -1, 0.0539279,-99) , 
3, -2.32616, 0, 0, 0.482523,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.167663);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464627,-99) , 
3, 1.34737, 0, 0, 0.503612,-99) , 
NN(
0, 
0, 
-1, 2.75747, 0, -1, 0.342557,-99) , 
2, 2.0836, 1, 0, 0.485667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.95863, 0, 0, 0.468492,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.154941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.13421, 0, 1, 0.698721,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247241,-99) , 
0, 3.91837, 1, 0, 0.479817,-99) , 
0, -1.11746, 1, 0, 0.511797,-99) , 
NN(
0, 
0, 
-1, -3.03258, 0, -1, 0.189125,-99) , 
3, -1.52072, 0, 0, 0.476828,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.196791);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455806,-99) , 
3, -1.13909, 0, 0, 0.622608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262816,-99) , 
3, 0.179262, 0, 0, 0.491477,-99) , 
0, -0.448661, 1, 0, 0.525669,-99) , 
NN(
0, 
0, 
-1, -0.341599, 1, -1, 0.0872587,-99) , 
3, -2.32616, 0, 0, 0.503341,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.223204);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458011,-99) , 
3, -0.114926, 0, 0, 0.551107,-99) , 
NN(
0, 
0, 
-1, 0.91117, 0, -1, 0.408204,-99) , 
0, 0.846656, 1, 0, 0.479104,-99) , 
NN(
0, 
0, 
-1, -3.15205, 0, -1, 0.130411,-99) , 
3, -2.16519, 0, 0, 0.459597,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.172337);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.6558, 0, 1, 0.616727,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322731,-99) , 
3, 0.256226, 0, 0, 0.472205,-99) , 
0, -0.931238, 1, 0, 0.500462,-99) , 
NN(
0, 
0, 
-1, -3.3385, 0, -1, 0.0962944,-99) , 
3, -2.19802, 0, 0, 0.478278,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.141127);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418365,-99) , 
1, 0.487403, 1, 0, 0.484025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.065342,-99) , 
0, 5.03516, 1, 0, 0.471613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -3.1413, 0, 0, 0.457998,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.166471);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.120079, 0, 1, 0.547514,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257093,-99) , 
3, 0.962412, 0, 0, 0.435067,-99) , 
0, 0.269982, 1, 0, 0.478318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.68578, 0, 0, 0.462632,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.206717);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418502,-99) , 
0, -0.361584, 1, 0, 0.455046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0438884,-99) , 
0, 4.68435, 1, 0, 0.437871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.59262, 0, 0, 0.423078,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.158078);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491421,-99) , 
3, 0.946878, 0, 0, 0.528243,-99) , 
NN(
0, 
0, 
-1, 2.06832, 0, -1, 0.405885,-99) , 
2, 1.25063, 1, 0, 0.49275,-99) , 
NN(
0, 
0, 
-1, -0.321467, 1, -1, 0.0346161,-99) , 
3, -1.96134, 0, 0, 0.467864,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.115752);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.74701, 0, 1, 0.521607,-99) , 
NN(
0, 
0, 
-1, 4.94297, 1, -1, 0.197875,-99) , 
0, 4.0826, 1, 0, 0.501174,-99) , 
NN(
0, 
0, 
-1, -3.09565, 0, -1, 0.138493,-99) , 
3, -2.09303, 0, 0, 0.480568,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.137112);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.403002, 1, 1, 0.73735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219812,-99) , 
3, -0.378356, 0, 0, 0.487669,-99) , 
0, -1.04842, 1, 0, 0.508771,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194861,-99) , 
0, -2.32209, 1, 0, 0.371172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0693947,-99) , 
3, -2.58868, 0, 0, 0.314803,-99) , 
3, -0.90724, 0, 0, 0.474038,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.12422);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475037,-99) , 
0, -2.73757, 1, 0, 0.483926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0851428,-99) , 
0, 5.02093, 1, 0, 0.472437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0549738,-99) , 
3, -2.24582, 0, 0, 0.452863,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.197245);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46874,-99) , 
3, 0.651477, 0, 0, 0.515714,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339569,-99) , 
3, 1.97242, 0, 0, 0.410139,-99) , 
0, 0.992285, 1, 0, 0.462213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.32616, 0, 0, 0.445983,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.136795);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364427,-99) , 
3, -1.20874, 0, 0, 0.506675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0933715,-99) , 
3, -2.33049, 0, 0, 0.488964,-99) , 
NN(
0, 
0, 
-1, 4.64734, 1, -1, 0.184683,-99) , 
0, 3.92229, 1, 0, 0.466128,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.193468);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462871,-99) , 
3, 0.6671, 0, 0, 0.518018,-99) , 
NN(
0, 
0, 
-1, 5.09145, 1, -1, 0.401055,-99) , 
0, 1.62197, 1, 0, 0.472905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.59414, 0, 0, 0.459522,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.170468);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.609341, 0, 1, 0.620788,-99) , 
NN(
0, 
0, 
-1, 4.88511, 1, -1, 0.442734,-99) , 
0, -0.731366, 1, 0, 0.484932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0396204,-99) , 
3, -2.32616, 0, 0, 0.47105,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.0880994);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.71959, 1, 1, 0.522969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205782,-99) , 
3, -2.31926, 0, 0, 0.509845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235317,-99) , 
0, 4.407, 1, 0, 0.498239,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.194184);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395081,-99) , 
3, -0.586718, 0, 0, 0.518579,-99) , 
NN(
0, 
0, 
-1, 1.88238, 0, -1, 0.379101,-99) , 
0, 2.17946, 1, 0, 0.481686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0668314,-99) , 
3, -2.32616, 0, 0, 0.467264,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.142059);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7022,-99) , 
NN(
0, 
0, 
-1, -1.31971, 0, -1, 0.451388,-99) , 
0, -2.26309, 1, 0, 0.467092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.124567,-99) , 
3, -2.01635, 0, 0, 0.45378,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.208692);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284848,-99) , 
0, 4.59963, 1, 0, 0.612846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451668,-99) , 
2, -1.28423, 1, 0, 0.482743,-99) , 
3, 1.81621, 0, 0, 0.513073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0994308,-99) , 
3, -2.32616, 0, 0, 0.501826,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.150434);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.04821, 0, 1, 0.680896,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35966,-99) , 
3, 0.504325, 0, 0, 0.501057,-99) , 
0, -0.464351, 1, 0, 0.557273,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453661,-99) , 
2, -1.10879, 1, 0, 0.469568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214691,-99) , 
3, -1.91957, 0, 0, 0.45891,-99) , 
1, -0.783555, 1, 0, 0.480908,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.179148);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.018656, 0, 1, 0.580258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290991,-99) , 
3, 0.728525, 0, 0, 0.487976,-99) , 
0, 0.218671, 1, 0, 0.523295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0506364,-99) , 
3, -2.39062, 0, 0, 0.510832,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.124721);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485082,-99) , 
3, -0.601516, 0, 0, 0.569983,-99) , 
NN(
0, 
0, 
-1, 0.28028, 0, -1, 0.463366,-99) , 
2, 0.24136, 1, 0, 0.507509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249464,-99) , 
3, -2.32616, 0, 0, 0.499409,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.0908989);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19146, 0, 1, 0.527678,-99) , 
NN(
0, 
0, 
-1, 4.88107, 1, -1, 0.360417,-99) , 
0, 3.91997, 1, 0, 0.514523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218923,-99) , 
3, -2.17644, 0, 0, 0.503833,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.174338);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.13639, 1, 1, 0.562983,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355942,-99) , 
1, -1.23334, 1, 0, 0.415168,-99) , 
3, -0.630056, 0, 0, 0.532228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291713,-99) , 
0, 4.38122, 1, 0, 0.519782,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.180001);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.621566, 0, 1, 0.578918,-99) , 
NN(
0, 
0, 
-1, 0.847668, 0, -1, 0.430044,-99) , 
0, 0.913995, 1, 0, 0.493908,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195463,-99) , 
3, -2.28557, 0, 0, 0.396769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155458,-99) , 
0, -2.15479, 1, 0, 0.318109,-99) , 
3, -1.00523, 0, 0, 0.470055,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.12427);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454663,-99) , 
3, -1.22153, 0, 0, 0.618691,-99) , 
NN(
0, 
0, 
-1, -0.0941867, 0, -1, 0.468393,-99) , 
0, -1.03021, 1, 0, 0.492365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203977,-99) , 
3, -1.80839, 0, 0, 0.478752,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.162365);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14331, 0, 1, 0.69346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290913,-99) , 
3, 1.31853, 0, 0, 0.497781,-99) , 
0, 1.58125, 1, 0, 0.549828,-99) , 
NN(
0, 
0, 
-1, 0.336408, 1, -1, 0.432414,-99) , 
3, 0.758749, 0, 0, 0.48824,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.139485);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.22354, 1, 1, 0.585168,-99) , 
NN(
0, 
0, 
-1, 1.14676, 0, -1, 0.453518,-99) , 
0, 0.358289, 1, 0, 0.501955,-99) , 
NN(
0, 
0, 
-1, -0.492214, 1, -1, 0.310895,-99) , 
3, -1.68724, 0, 0, 0.48919,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.10847);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0660035, 0, 1, 0.562833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325233,-99) , 
3, 0.752496, 0, 0, 0.477602,-99) , 
2, 0.340279, 1, 0, 0.518116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234959,-99) , 
1, 2.26043, 1, 0, 0.510384,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.221641);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.797593, 1, 1, 0.586667,-99) , 
NN(
0, 
0, 
-1, -1.65391, 0, -1, 0.420633,-99) , 
3, -0.629769, 0, 0, 0.530344,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341677,-99) , 
2, 2.26094, 1, 0, 0.513058,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294333,-99) , 
1, -1.02511, 1, 0, 0.342859,-99) , 
3, 1.90852, 0, 0, 0.422747,-99) , 
2, 0.755923, 1, 0, 0.487086,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.0760615);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698409,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49157,-99) , 
3, 2.62896, 0, 0, 0.505892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241723,-99) , 
2, 2.3394, 1, 0, 0.494429,-99) , 
3, 3.53655, 0, 0, 0.501861,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.172118);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480728,-99) , 
0, 2.39515, 1, 0, 0.572222,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289396,-99) , 
0, 0.517426, 1, 0, 0.473752,-99) , 
3, 0.959199, 0, 0, 0.514454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307073,-99) , 
2, 2.58872, 1, 0, 0.50541,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.160223);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483782,-99) , 
3, -0.135109, 0, 0, 0.551115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253276,-99) , 
1, 0.0564594, 1, 0, 0.390869,-99) , 
1, -0.0405231, 1, 0, 0.52972,-99) , 
NN(
0, 
0, 
-1, 2.00269, 1, -1, 0.422267,-99) , 
1, 0.163373, 1, 0, 0.47998,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.142468);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.597504, 0, 1, 0.624608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282815,-99) , 
3, -0.0119599, 0, 0, 0.484438,-99) , 
0, -1.02177, 1, 0, 0.506637,-99) , 
NN(
0, 
0, 
-1, -2.15577, 0, -1, 0.200388,-99) , 
3, -1.59439, 0, 0, 0.489,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.145701);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758242,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428916,-99) , 
3, 0.58605, 0, 0, 0.488078,-99) , 
0, -2.37671, 1, 0, 0.500462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.111457,-99) , 
3, -1.91957, 0, 0, 0.485771,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.156735);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.48827, 0, 1, 0.567619,-99) , 
NN(
0, 
0, 
-1, 0.966424, 0, -1, 0.427954,-99) , 
0, 0.813325, 1, 0, 0.494718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173552,-99) , 
2, -1.98162, 0, 0, 0.48495,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.142461);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.669789, 0, 1, 0.61218,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358292,-99) , 
3, 0.568787, 0, 0, 0.46089,-99) , 
0, -0.853464, 1, 0, 0.491954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151022,-99) , 
3, -2.09303, 0, 0, 0.481623,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.157295);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50802, 1, 1, 0.596591,-99) , 
NN(
0, 
0, 
-1, 0.520779, 1, -1, 0.460802,-99) , 
3, 1.04176, 0, 0, 0.498036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158959,-99) , 
0, 4.47881, 1, 0, 0.460349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173102,-99) , 
3, 2.18095, 0, 0, 0.383172,-99) , 
0, 2.73605, 1, 0, 0.477267,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.124476);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46129,-99) , 
3, 2.18996, 0, 0, 0.481569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258719,-99) , 
2, 2.69063, 1, 0, 0.474164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227501,-99) , 
3, -1.97353, 0, 0, 0.464925,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.108657);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493437,-99) , 
2, -0.432652, 1, 0, 0.518365,-99) , 
NN(
0, 
0, 
-1, -0.500847, 0, -1, 0.322239,-99) , 
2, 1.97088, 1, 0, 0.495766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181032,-99) , 
2, -1.91397, 0, 0, 0.4855,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.141088);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.392362, 1, 1, 0.569347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373212,-99) , 
2, -1.63874, 0, 0, 0.468664,-99) , 
3, -0.964048, 0, 0, 0.553106,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651611,-99) , 
NN(
0, 
0, 
-1, -0.62779, 0, -1, 0.43644,-99) , 
0, -2.16252, 1, 0, 0.458251,-99) , 
1, 0.433074, 1, 0, 0.515335,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.212847);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.35488, 1, 1, 0.641619,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354464,-99) , 
2, 0.39603, 1, 0, 0.502028,-99) , 
3, 1.11835, 0, 0, 0.540337,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340425,-99) , 
1, -0.320247, 1, 0, 0.427038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.117224,-99) , 
3, 2.33571, 0, 0, 0.356571,-99) , 
0, 3.04575, 1, 0, 0.510558,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.113809);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600843,-99) , 
NN(
0, 
0, 
-1, -0.412938, 0, -1, 0.454446,-99) , 
1, -1.84463, 1, 0, 0.462101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200953,-99) , 
3, -1.96134, 0, 0, 0.45354,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.208421);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19719, 1, 1, 0.590315,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370896,-99) , 
0, -0.727992, 1, 0, 0.466394,-99) , 
3, 0.281435, 0, 0, 0.521328,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314995,-99) , 
0, 4.12295, 1, 0, 0.504726,-99) , 
NN(
0, 
0, 
-1, 2.37697, 1, -1, 0.316888,-99) , 
3, 2.34874, 0, 0, 0.399676,-99) , 
2, 1.22285, 1, 0, 0.487923,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.155576);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495505,-99) , 
0, -1.4732, 1, 0, 0.543684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28662,-99) , 
3, -1.92345, 0, 0, 0.520763,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443259,-99) , 
0, 0.699401, 1, 0, 0.46573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31219,-99) , 
3, 0.554655, 0, 0, 0.444394,-99) , 
2, 0.293868, 1, 0, 0.479887,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.192646);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.03899, 1, 1, 0.592391,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452558,-99) , 
3, 2.6073, 0, 0, 0.472407,-99) , 
2, 0.461555, 1, 0, 0.524732,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295024,-99) , 
1, -0.38992, 1, 0, 0.5227,-99) , 
NN(
0, 
0, 
-1, -1.36188, 0, -1, 0.199073,-99) , 
0, -2.58049, 1, 0, 0.359388,-99) , 
3, -1.02508, 0, 0, 0.500083,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.13779);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.00981178, 0, 1, 0.672268,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482146,-99) , 
0, 0.197129, 1, 0, 0.498109,-99) , 
2, -0.136853, 1, 0, 0.521378,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400493,-99) , 
3, -1.1822, 0, 0, 0.474467,-99) , 
NN(
0, 
0, 
-1, -1.34747, 1, -1, 0.313152,-99) , 
2, -0.942541, 1, 0, 0.40746,-99) , 
3, -0.356397, 0, 0, 0.497019,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.143134);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728074,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439869,-99) , 
3, 0.0260031, 0, 0, 0.522555,-99) , 
2, -1.36868, 1, 0, 0.534244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268681,-99) , 
3, -1.76489, 0, 0, 0.522344,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.205202);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13232, 1, 1, 0.731096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250673,-99) , 
2, 2.64578, 1, 0, 0.502283,-99) , 
0, 1.26705, 1, 0, 0.560958,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420491,-99) , 
3, -0.552317, 0, 0, 0.457599,-99) , 
NN(
0, 
0, 
-1, 0.132165, 0, -1, 0.30489,-99) , 
0, -0.368403, 1, 0, 0.410621,-99) , 
3, 0.297075, 0, 0, 0.497408,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.0828027);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816307,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488607,-99) , 
2, -0.085234, 1, 0, 0.542653,-99) , 
1, -1.63928, 0, 0, 0.637044,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391604,-99) , 
2, 1.96887, 1, 0, 0.50068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300472,-99) , 
3, -1.88206, 0, 0, 0.493267,-99) , 
1, -1.38164, 1, 0, 0.507272,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.171008);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461127,-99) , 
3, -0.552296, 0, 0, 0.518908,-99) , 
3, 1.03024, 0, 0, 0.538622,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463841,-99) , 
2, 1.43896, 1, 0, 0.517451,-99) , 
NN(
0, 
0, 
-1, 1.94966, 1, -1, 0.319214,-99) , 
3, 1.46027, 0, 0, 0.454341,-99) , 
0, 1.22482, 1, 0, 0.500367,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.0649762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.08838, 0, 1, 0.635387,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366022,-99) , 
3, -0.698683, 0, 0, 0.490406,-99) , 
2, -1.01637, 1, 0, 0.505539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281065,-99) , 
2, -1.91397, 0, 0, 0.49919,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.173616);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.40011, 1, 1, 0.556877,-99) , 
NN(
0, 
0, 
-1, -0.243412, 1, -1, 0.378812,-99) , 
3, -1.48039, 0, 0, 0.533217,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421805,-99) , 
0, 2.4323, 1, 0, 0.476207,-99) , 
NN(
0, 
0, 
-1, 1.15904, 0, -1, 0.325147,-99) , 
3, 1.39098, 0, 0, 0.437485,-99) , 
0, 1.32209, 1, 0, 0.492457,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.165743);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75785,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481625,-99) , 
3, 1.68248, 0, 0, 0.509102,-99) , 
0, -0.592706, 1, 0, 0.518383,-99) , 
NN(
NN(
0, 
0, 
-1, -1.95216, 0, 1, 0.70373,-99) , 
NN(
0, 
0, 
-1, -1.04406, 1, -1, 0.334167,-99) , 
0, -2.97743, 1, 0, 0.41155,-99) , 
3, -0.195379, 0, 0, 0.48476,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.134492);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.47747, 1, 1, 0.702672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392302,-99) , 
3, -2.21839, 0, 0, 0.633824,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441726,-99) , 
0, 1.2587, 1, 0, 0.483031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211038,-99) , 
3, -1.08464, 0, 0, 0.474006,-99) , 
0, -1.89984, 1, 0, 0.494275,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.084312);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.774114, 1, 1, 0.561712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309499,-99) , 
0, 1.26423, 1, 0, 0.480306,-99) , 
3, 1.182, 0, 0, 0.50975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344658,-99) , 
0, 4.38122, 1, 0, 0.501547,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.174296);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43457, 1, 1, 0.639971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338876,-99) , 
3, 1.93214, 0, 0, 0.456301,-99) , 
1, 0.296335, 0, 0, 0.546544,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482043,-99) , 
3, 0.128122, 0, 0, 0.519666,-99) , 
NN(
0, 
0, 
-1, 0.640055, 0, -1, 0.372365,-99) , 
0, 0.342505, 1, 0, 0.463625,-99) , 
3, 1.46467, 0, 0, 0.490952,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.12165);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333164,-99) , 
0, -2.47037, 1, 0, 0.512494,-99) , 
3, -1.14644, 0, 0, 0.582521,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493062,-99) , 
0, -0.387849, 1, 0, 0.508231,-99) , 
NN(
0, 
0, 
-1, -0.996862, 1, -1, 0.317942,-99) , 
3, -0.228635, 0, 0, 0.478721,-99) , 
2, -0.996, 1, 0, 0.494472,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.155809);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.61727, 1, 1, 0.645211,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236943,-99) , 
0, -2.48695, 1, 0, 0.446757,-99) , 
3, -1.30868, 0, 0, 0.585748,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481053,-99) , 
0, 0.227139, 1, 0, 0.49939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292522,-99) , 
0, -0.611212, 1, 0, 0.375547,-99) , 
3, 0.291385, 0, 0, 0.481973,-99) , 
2, -0.173828, 1, 0, 0.512368,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.169195);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486801,-99) , 
3, 2.45719, 0, 0, 0.548485,-99) , 
2, 0.739102, 1, 0, 0.568958,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445978,-99) , 
3, -1.28148, 0, 0, 0.5566,-99) , 
NN(
0, 
0, 
-1, 0.182542, 0, -1, 0.425332,-99) , 
0, -1.26315, 1, 0, 0.456988,-99) , 
3, 1.34573, 0, 0, 0.499076,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.185468);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.94636, 0, 1, 0.742457,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422998,-99) , 
3, 0.0383825, 0, 0, 0.539334,-99) , 
2, -1.42686, 1, 0, 0.56353,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389471,-99) , 
1, 0.309988, 0, 0, 0.513577,-99) , 
NN(
0, 
0, 
-1, 0.218955, 1, -1, 0.401205,-99) , 
3, 0.796004, 0, 0, 0.459095,-99) , 
1, -0.0100907, 1, 0, 0.509241,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.0858029);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.98633, 1, 1, 0.71996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486307,-99) , 
3, -1.8783, 0, 0, 0.647835,-99) , 
NN(
NN(
0, 
0, 
-1, -0.993953, 1, 1, 0.5133,-99) , 
NN(
0, 
0, 
-1, -1.58361, 1, -1, 0.331586,-99) , 
3, -0.668066, 0, 0, 0.499041,-99) , 
2, -1.01795, 1, 0, 0.518747,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.0704434);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72972, 1, 1, 0.649732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43882,-99) , 
3, -1.08487, 0, 0, 0.607354,-99) , 
NN(
NN(
0, 
0, 
-1, -3.03901, 1, 1, 0.515194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34222,-99) , 
2, 2.53173, 1, 0, 0.508405,-99) , 
1, -1.20374, 1, 0, 0.521201,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.110028);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43925,-99) , 
3, 0.0671971, 0, 0, 0.485647,-99) , 
1, -1.94635, 1, 0, 0.494905,-99) , 
NN(
0, 
0, 
-1, -0.392618, 0, -1, 0.303143,-99) , 
2, 2.05721, 1, 0, 0.474683,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.119043);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -3.67836, 1, 1, 0.672906,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479599,-99) , 
3, -0.925739, 0, 0, 0.536569,-99) , 
1, -0.492214, 1, 0, 0.590646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652911,-99) , 
NN(
0, 
0, 
-1, 2.77589, 1, -1, 0.458697,-99) , 
3, 3.45738, 0, 0, 0.46852,-99) , 
0, -1.03312, 1, 0, 0.493917,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.153022);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.81402, 0, 1, 0.622031,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414525,-99) , 
3, 0.561243, 0, 0, 0.48784,-99) , 
0, -1.91435, 1, 0, 0.507508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187748,-99) , 
2, 2.59136, 1, 0, 0.498183,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.109345);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71835,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4604,-99) , 
2, -0.235523, 1, 0, 0.482729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321214,-99) , 
1, 1.94756, 1, 0, 0.474802,-99) , 
1, -1.91975, 1, 0, 0.48665,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.103383);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495681,-99) , 
2, 0.373842, 1, 0, 0.53403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282099,-99) , 
0, 4.74147, 1, 0, 0.525721,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193803,-99) , 
3, -1.98282, 0, 0, 0.360142,-99) , 
3, -1.59907, 0, 0, 0.514792,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.127986);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401298,-99) , 
3, -1.40589, 0, 0, 0.534114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344474,-99) , 
2, 2.52866, 1, 0, 0.52457,-99) , 
NN(
0, 
0, 
-1, 1.16452, 0, -1, 0.345831,-99) , 
1, 1.68967, 1, 0, 0.510408,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.124828);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687873,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349838,-99) , 
0, 4.9442, 1, 0, 0.527749,-99) , 
0, -0.762711, 1, 0, 0.537819,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426197,-99) , 
3, -1.62611, 0, 0, 0.505556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30438,-99) , 
0, -1.66623, 1, 0, 0.434192,-99) , 
3, -0.681783, 0, 0, 0.518565,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.136783);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0256728, 1, 1, 0.673266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45542,-99) , 
3, -2.08356, 0, 0, 0.611129,-99) , 
NN(
NN(
0, 
0, 
-1, 4.32397, 1, 1, 0.597113,-99) , 
NN(
0, 
0, 
-1, 1.95516, 1, -1, 0.443773,-99) , 
3, 2.81274, 0, 0, 0.45782,-99) , 
2, -1.13063, 1, 0, 0.473824,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.0925851);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.387338, 1, 1, 0.648727,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485517,-99) , 
0, -3.07708, 1, 0, 0.49425,-99) , 
NN(
0, 
0, 
-1, 4.6957, 1, -1, 0.365781,-99) , 
0, 3.40407, 1, 0, 0.478104,-99) , 
1, -1.41712, 1, 0, 0.493797,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.151737);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.273394, 1, 1, 0.685875,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342826,-99) , 
2, 2.34246, 1, 0, 0.540807,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425191,-99) , 
3, 1.87791, 0, 0, 0.464232,-99) , 
1, 0.555069, 1, 0, 0.515478,-99) , 
2, -1.49556, 1, 0, 0.533282,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.0983232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712306,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328171,-99) , 
0, 2.58392, 1, 0, 0.487943,-99) , 
3, 2.47561, 0, 0, 0.497337,-99) , 
NN(
0, 
0, 
-1, -0.362658, 1, -1, 0.239916,-99) , 
0, 3.79175, 1, 0, 0.478484,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.118027);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.63941, 0, 1, 0.540049,-99) , 
NN(
0, 
0, 
-1, 4.81109, 1, -1, 0.308955,-99) , 
0, 4.04225, 1, 0, 0.523349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241944,-99) , 
3, -1.88206, 0, 0, 0.512776,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.12282);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84973, 0, 1, 0.61581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419811,-99) , 
0, 0.526128, 1, 0, 0.480704,-99) , 
3, 1.2069, 0, 0, 0.502242,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272105,-99) , 
1, 1.04091, 1, 0, 0.45972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228057,-99) , 
3, 1.76599, 0, 0, 0.422001,-99) , 
0, 2.14005, 1, 0, 0.480034,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.155587);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770341,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445081,-99) , 
0, 2.27912, 1, 0, 0.511657,-99) , 
3, 3.77718, 0, 0, 0.52083,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318049,-99) , 
0, -2.58049, 1, 0, 0.508269,-99) , 
NN(
0, 
0, 
-1, -2.65058, 1, -1, 0.205141,-99) , 
1, -0.243412, 1, 0, 0.37498,-99) , 
3, -1.09081, 0, 0, 0.502413,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.148564);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324107,-99) , 
0, 3.09806, 1, 0, 0.50854,-99) , 
3, 3.46111, 0, 0, 0.52727,-99) , 
NN(
NN(
0, 
0, 
-1, -1.9415, 1, 1, 0.609299,-99) , 
NN(
0, 
0, 
-1, 0.857014, 0, -1, 0.433851,-99) , 
1, -1.43698, 1, 0, 0.457167,-99) , 
1, 0.549625, 0, 0, 0.482752,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.124344);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799136,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408293,-99) , 
1, 0.794761, 1, 0, 0.483243,-99) , 
2, -0.922661, 1, 0, 0.496152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542877,-99) , 
NN(
0, 
0, 
-1, 0.0278957, 1, -1, 0.31612,-99) , 
0, -3.1202, 1, 0, 0.384058,-99) , 
3, -0.864953, 0, 0, 0.477218,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.153309);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620043,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340456,-99) , 
0, 4.03185, 1, 0, 0.510594,-99) , 
NN(
0, 
0, 
-1, 1.58637, 1, -1, 0.434689,-99) , 
3, 1.86116, 0, 0, 0.450552,-99) , 
2, -1.91397, 1, 0, 0.458567,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.166811);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.509404, 1, 1, 0.580691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434262,-99) , 
2, -0.551173, 1, 0, 0.485752,-99) , 
3, 0.526685, 0, 0, 0.527147,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408469,-99) , 
1, 0.0887542, 1, 0, 0.505439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201559,-99) , 
1, -0.73235, 0, 0, 0.442194,-99) , 
0, 2.91606, 1, 0, 0.509609,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.110116);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451171,-99) , 
3, 1.98165, 0, 0, 0.468052,-99) , 
1, -1.89161, 1, 0, 0.473651,-99) , 
NN(
0, 
0, 
-1, -0.231044, 0, -1, 0.323841,-99) , 
3, -1.61604, 0, 0, 0.464293,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.091677);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.330066, 1, 1, 0.629483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461824,-99) , 
0, 1.73631, 1, 0, 0.501387,-99) , 
0, -1.93486, 1, 0, 0.513459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260948,-99) , 
3, -2.15749, 0, 0, 0.506791,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.169507);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.726371, 1, 1, 0.56815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343995,-99) , 
0, -0.019434, 1, 0, 0.472901,-99) , 
3, 0.626503, 0, 0, 0.505132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64262,-99) , 
NN(
0, 
0, 
-1, 4.0115, 1, -1, 0.36686,-99) , 
3, 3.44551, 0, 0, 0.397549,-99) , 
2, 1.1732, 1, 0, 0.47107,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.187854);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.294655, 0, 1, 0.572308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408805,-99) , 
0, 1.47391, 1, 0, 0.458199,-99) , 
1, 0.925141, 1, 0, 0.544814,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412107,-99) , 
0, -1.38508, 1, 0, 0.453266,-99) , 
NN(
0, 
0, 
-1, -1.53336, 1, -1, 0.328234,-99) , 
3, -1.46398, 0, 0, 0.433603,-99) , 
3, 0.780429, 0, 0, 0.487762,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.122076);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.68269, 0, 1, 0.609674,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453626,-99) , 
3, 1.67694, 0, 0, 0.469058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27333,-99) , 
0, 3.4916, 1, 0, 0.45931,-99) , 
3, 2.91589, 0, 0, 0.471349,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.0942562);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434261,-99) , 
0, 1.42311, 1, 0, 0.479162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274281,-99) , 
3, -1.95596, 0, 0, 0.472858,-99) , 
1, -1.95083, 1, 0, 0.481385,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.136165);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.446512, 1, 1, 0.538727,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354235,-99) , 
0, -1.93492, 1, 0, 0.446332,-99) , 
3, -0.245714, 0, 0, 0.503065,-99) , 
NN(
0, 
0, 
-1, 1.55008, 0, -1, 0.426128,-99) , 
0, 1.85781, 1, 0, 0.477889,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.121384);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457446,-99) , 
3, 1.45338, 0, 0, 0.485366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307401,-99) , 
0, 4.29346, 1, 0, 0.47712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323453,-99) , 
1, 1.92364, 1, 0, 0.469078,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.0970044);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.15826, 1, 1, 0.524119,-99) , 
NN(
0, 
0, 
-1, 0.112437, 0, -1, 0.409616,-99) , 
1, 1.33846, 1, 0, 0.509377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529633,-99) , 
NN(
0, 
0, 
-1, -2.27616, 1, -1, 0.213457,-99) , 
0, -3.00619, 1, 0, 0.352675,-99) , 
3, -1.11247, 0, 0, 0.4919,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.184418);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.733498, 0, 1, 0.572502,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373326,-99) , 
3, 2.12654, 0, 0, 0.422959,-99) , 
0, 1.23137, 1, 0, 0.484731,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409117,-99) , 
3, -1.48967, 1, 0, 0.499475,-99) , 
NN(
0, 
0, 
-1, -0.379046, 1, -1, 0.355536,-99) , 
1, 0.759581, 0, 0, 0.399039,-99) , 
3, -0.356397, 0, 0, 0.465079,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.145193);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.240748, 1, 1, 0.559534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423533,-99) , 
3, 1.12299, 0, 0, 0.468379,-99) , 
1, -0.331174, 1, 0, 0.500916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180494,-99) , 
0, 4.29346, 1, 0, 0.48837,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.189818);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.53766, 1, 1, 0.755169,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458137,-99) , 
1, -1.53827, 1, 0, 0.473303,-99) , 
0, 0.845394, 1, 0, 0.502651,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401109,-99) , 
3, -0.342431, 0, 0, 0.462622,-99) , 
NN(
0, 
0, 
-1, -1.04018, 0, -1, 0.3119,-99) , 
2, 0.0227249, 1, 0, 0.417642,-99) , 
3, 0.502667, 0, 0, 0.464907,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.152799);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43098, 1, 1, 0.591817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30206,-99) , 
0, 0.563653, 1, 0, 0.488517,-99) , 
3, 0.629522, 0, 0, 0.525483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678245,-99) , 
NN(
0, 
0, 
-1, 3.86742, 1, -1, 0.388967,-99) , 
3, 3.63038, 0, 0, 0.420064,-99) , 
2, 1.2562, 1, 0, 0.495609,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.0915248);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470524,-99) , 
0, -2.96392, 1, 0, 0.477132,-99) , 
2, 2.86633, 0, 0, 0.485379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220754,-99) , 
2, -1.91397, 0, 0, 0.47893,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.159007);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25719, 1, 1, 0.601185,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356602,-99) , 
0, 2.98239, 1, 0, 0.469529,-99) , 
1, -0.260326, 0, 0, 0.549793,-99) , 
NN(
NN(
0, 
0, 
-1, -1.72238, 0, 1, 0.587346,-99) , 
NN(
0, 
0, 
-1, -0.79534, 0, -1, 0.42408,-99) , 
0, -2.08153, 1, 0, 0.456765,-99) , 
3, 0.754349, 0, 0, 0.50161,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.100159);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71042, 0, 1, 0.521561,-99) , 
NN(
0, 
0, 
-1, 2.84639, 0, -1, 0.414619,-99) , 
0, 2.95932, 1, 0, 0.503518,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33958,-99) , 
1, -0.321467, 1, 0, 0.480486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.108862,-99) , 
0, -2.52191, 1, 0, 0.37903,-99) , 
3, -1.15495, 0, 0, 0.489552,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.100681);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491069,-99) , 
2, 2.65851, 0, 0, 0.608754,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451098,-99) , 
0, 0.198082, 1, 0, 0.477865,-99) , 
NN(
0, 
0, 
-1, -1.9978, 1, -1, 0.341275,-99) , 
1, -1.71303, 0, 0, 0.467191,-99) , 
3, 3.10362, 0, 0, 0.476129,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.0961317);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481265,-99) , 
3, -0.389228, 0, 0, 0.537845,-99) , 
NN(
0, 
0, 
-1, 0.0969324, 0, -1, 0.470098,-99) , 
0, -0.671461, 1, 0, 0.483697,-99) , 
NN(
0, 
0, 
-1, -0.334711, 0, -1, 0.283024,-99) , 
3, -1.59907, 0, 0, 0.471878,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.142298);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.55656, 1, 1, 0.547894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335316,-99) , 
3, -1.51782, 0, 0, 0.536223,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472721,-99) , 
3, 1.09016, 0, 0, 0.50205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296614,-99) , 
1, -1.21365, 1, 0, 0.352072,-99) , 
2, 1.08018, 1, 0, 0.454116,-99) , 
1, -0.0583898, 0, 0, 0.497926,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.121295);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.920025, 1, 1, 0.603107,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354722,-99) , 
0, 0.628797, 1, 0, 0.485931,-99) , 
3, 0.78588, 0, 0, 0.519126,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44839,-99) , 
3, 2.79594, 0, 0, 0.486075,-99) , 
NN(
0, 
0, 
-1, 2.21407, 0, -1, 0.364937,-99) , 
1, -0.263191, 0, 0, 0.445582,-99) , 
0, 2.26267, 1, 0, 0.498686,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.140885);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.446562, 0, 1, 0.60777,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28225,-99) , 
3, 0.320551, 0, 0, 0.484821,-99) , 
2, 0.148214, 1, 0, 0.521311,-99) , 
NN(
0, 
0, 
-1, -0.492214, 1, -1, 0.360197,-99) , 
3, -1.18029, 0, 0, 0.503188,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.140465);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.56536, 1, 1, 0.53188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218257,-99) , 
3, -2.11143, 0, 0, 0.514999,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441753,-99) , 
0, 1.60876, 1, 0, 0.46524,-99) , 
NN(
0, 
0, 
-1, 0.0217441, 1, -1, 0.363403,-99) , 
3, 1.1657, 0, 0, 0.434435,-99) , 
0, 0.613219, 1, 0, 0.471856,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.17324);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482594,-99) , 
3, 1.31471, 0, 0, 0.541528,-99) , 
NN(
0, 
0, 
-1, -1.97651, 0, -1, 0.422885,-99) , 
3, 0.264602, 0, 0, 0.495687,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288379,-99) , 
0, -1.01689, 0, 0, 0.485021,-99) , 
NN(
0, 
0, 
-1, 1.83132, 1, -1, 0.254409,-99) , 
0, 1.03623, 1, 0, 0.351885,-99) , 
1, 1.35534, 1, 0, 0.476057,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.120441);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.22977, 1, 1, 0.523743,-99) , 
NN(
0, 
0, 
-1, -1.90672, 0, -1, 0.342243,-99) , 
3, -1.27783, 0, 0, 0.504163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527653,-99) , 
NN(
0, 
0, 
-1, -0.299676, 0, -1, 0.387576,-99) , 
1, 0.715309, 1, 0, 0.406105,-99) , 
1, 0.549625, 1, 0, 0.470346,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.100001);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733971,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448179,-99) , 
1, -0.114864, 1, 0, 0.476635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246031,-99) , 
1, -1.77208, 0, 0, 0.469548,-99) , 
1, -2.0635, 1, 0, 0.479612,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.11956);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475451,-99) , 
0, -0.483876, 1, 0, 0.485345,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344298,-99) , 
2, -1.21193, 1, 0, 0.40071,-99) , 
3, -0.111947, 0, 0, 0.46216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282833,-99) , 
0, 4.45129, 1, 0, 0.455258,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.112891);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.672745, 0, 1, 0.581913,-99) , 
NN(
0, 
0, 
-1, -0.241504, 0, -1, 0.463135,-99) , 
0, -0.701568, 1, 0, 0.48543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236674,-99) , 
3, -1.66559, 0, 0, 0.473008,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.145819);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457085,-99) , 
3, 2.91967, 0, 0, 0.525511,-99) , 
0, 2.7005, 1, 0, 0.575143,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43554,-99) , 
2, 0.025144, 1, 0, 0.477976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275855,-99) , 
3, -1.66374, 0, 0, 0.466243,-99) , 
3, 1.91587, 0, 0, 0.488986,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.143398);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.83003, 0, 1, 0.573167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264907,-99) , 
0, 4.72667, 1, 0, 0.553839,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458074,-99) , 
1, 1.07091, 0, 0, 0.473838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313261,-99) , 
1, 1.61873, 1, 0, 0.460356,-99) , 
3, 0.913643, 0, 0, 0.504,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.170178);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00442, 0, 1, 0.655609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437512,-99) , 
2, 1.35903, 1, 0, 0.486501,-99) , 
2, 0.420616, 1, 0, 0.522759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437627,-99) , 
3, -1.10915, 0, 0, 0.530243,-99) , 
NN(
0, 
0, 
-1, -0.258937, 0, -1, 0.382433,-99) , 
1, -0.454082, 1, 0, 0.434149,-99) , 
3, 0.262665, 0, 0, 0.488773,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.160513);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442356,-99) , 
0, 4.63049, 1, 0, 0.610421,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441479,-99) , 
3, -0.102692, 0, 0, 0.511826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354431,-99) , 
2, 0.885411, 1, 0, 0.385514,-99) , 
0, 2.0607, 1, 0, 0.483008,-99) , 
3, 2.75934, 0, 0, 0.494482,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.100941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366392,-99) , 
2, 2.55315, 1, 0, 0.50941,-99) , 
0, -0.819722, 1, 0, 0.523472,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396546,-99) , 
1, -0.163811, 1, 0, 0.480509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332111,-99) , 
0, -1.60299, 1, 0, 0.435484,-99) , 
3, -0.595744, 0, 0, 0.507635,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.0854387);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670151,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477763,-99) , 
3, 2.13132, 0, 0, 0.495708,-99) , 
2, -1.37514, 1, 0, 0.502128,-99) , 
NN(
0, 
0, 
-1, -0.100228, 0, -1, 0.338395,-99) , 
3, -1.59192, 0, 0, 0.493602,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.114806);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.556274, 1, 1, 0.58699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392886,-99) , 
0, 1.31131, 1, 0, 0.475618,-99) , 
3, 1.8985, 0, 0, 0.49848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296745,-99) , 
2, 2.56977, 1, 0, 0.490631,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.0733582);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699298,-99) , 
NN(
NN(
0, 
0, 
-1, -1.83379, 0, 1, 0.596125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418527,-99) , 
3, -0.797349, 0, 0, 0.507665,-99) , 
2, -1.49556, 1, 0, 0.514196,-99) , 
1, -1.99531, 1, 0, 0.520645,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.145157);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.392495, 0, 1, 0.677756,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421039,-99) , 
1, -0.386291, 1, 0, 0.514433,-99) , 
3, -0.608383, 0, 0, 0.561414,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380475,-99) , 
1, 1.57304, 1, 0, 0.495951,-99) , 
NN(
0, 
0, 
-1, -0.506933, 1, -1, 0.396877,-99) , 
1, -0.347148, 0, 0, 0.461795,-99) , 
0, -0.472878, 1, 0, 0.488506,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.165891);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.466444, 0, 1, 0.642027,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34453,-99) , 
0, -0.489448, 1, 0, 0.475559,-99) , 
3, 0.0861532, 0, 0, 0.536711,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29901,-99) , 
0, 4.85481, 1, 0, 0.556306,-99) , 
NN(
0, 
0, 
-1, 2.95048, 1, -1, 0.434022,-99) , 
3, 2.36281, 0, 0, 0.469173,-99) , 
0, 0.948527, 1, 0, 0.503308,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.158634);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715436,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472553,-99) , 
0, 2.80289, 1, 0, 0.54524,-99) , 
3, 3.44322, 0, 0, 0.572309,-99) , 
NN(
NN(
0, 
0, 
-1, 1.04564, 0, 1, 0.528871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363772,-99) , 
0, 0.171809, 1, 0, 0.392132,-99) , 
2, 0.351623, 1, 0, 0.474828,-99) , 
3, 1.81596, 0, 0, 0.498409,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.10951);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0151594, 1, 1, 0.632961,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469627,-99) , 
0, -2.98427, 1, 0, 0.479939,-99) , 
3, 2.13095, 0, 0, 0.494963,-99) , 
NN(
0, 
0, 
-1, 0.28614, 0, -1, 0.337297,-99) , 
0, 3.95761, 1, 0, 0.483295,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.128026);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485451,-99) , 
3, 1.83221, 0, 0, 0.506626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159094,-99) , 
0, 4.6467, 1, 0, 0.494495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371504,-99) , 
3, -2.02085, 0, 0, 0.521289,-99) , 
NN(
0, 
0, 
-1, -1.15406, 0, -1, 0.330655,-99) , 
0, -2.40172, 1, 0, 0.401945,-99) , 
3, -0.386164, 0, 0, 0.474165,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.16266);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.161, 0, 1, 0.580199,-99) , 
NN(
0, 
0, 
-1, -1.57017, 0, -1, 0.446879,-99) , 
3, 0.217194, 0, 0, 0.514253,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278013,-99) , 
0, 4.11686, 1, 0, 0.493527,-99) , 
NN(
0, 
0, 
-1, 1.68525, 0, -1, 0.341969,-99) , 
1, 0.35139, 1, 0, 0.419949,-99) , 
3, 1.67782, 1, 0, 0.487235,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.0643363);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656038,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493561,-99) , 
1, -1.2022, 1, 0, 0.507541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267889,-99) , 
1, 0.234804, 0, 0, 0.392711,-99) , 
2, 2.14598, 1, 0, 0.49713,-99) , 
1, 1.97524, 0, 0, 0.502179,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.0641839);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.11423, 0, 1, 0.635702,-99) , 
NN(
0, 
0, 
-1, -0.897022, 0, -1, 0.484326,-99) , 
0, -1.70076, 1, 0, 0.494067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302743,-99) , 
3, -1.59907, 0, 0, 0.484548,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.115832);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.99241, 1, 1, 0.646725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466564,-99) , 
3, -1.07126, 0, 0, 0.616262,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490464,-99) , 
2, 0.008394, 1, 0, 0.508254,-99) , 
NN(
0, 
0, 
-1, -1.76127, 1, -1, 0.424937,-99) , 
3, -0.479528, 0, 0, 0.492927,-99) , 
1, -0.609131, 1, 0, 0.5255,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.15209);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.158148, 1, 1, 0.637426,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38571,-99) , 
2, 0.063028, 0, 0, 0.516544,-99) , 
0, 0.0288655, 1, 0, 0.539793,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392468,-99) , 
2, -1.73027, 0, 0, 0.495823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231611,-99) , 
2, -0.9487, 1, 0, 0.407839,-99) , 
3, -0.73012, 0, 0, 0.519514,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.0915808);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495551,-99) , 
0, -3.06993, 1, 0, 0.538806,-99) , 
3, -0.342799, 0, 0, 0.577661,-99) , 
NN(
0, 
0, 
-1, -0.214534, 0, -1, 0.467034,-99) , 
0, -0.60653, 1, 0, 0.494812,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.112401);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683301,-99) , 
NN(
NN(
0, 
0, 
-1, 1.83219, 1, 1, 0.615602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447578,-99) , 
1, 0.162161, 0, 0, 0.482591,-99) , 
1, 1.46453, 0, 0, 0.496969,-99) , 
1, -1.95083, 1, 0, 0.505158,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.132741);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.18757, 0, 1, 0.571192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458371,-99) , 
1, 1.8587, 0, 0, 0.47211,-99) , 
1, -0.0260903, 1, 0, 0.519199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532023,-99) , 
NN(
0, 
0, 
-1, -0.665003, 1, -1, 0.379405,-99) , 
1, 1.12975, 0, 0, 0.408908,-99) , 
0, 2.90547, 1, 0, 0.500648,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.117939);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.00512884, 0, 1, 0.590005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400736,-99) , 
1, 1.29294, 1, 0, 0.500913,-99) , 
2, 0.320241, 1, 0, 0.534072,-99) , 
NN(
0, 
0, 
-1, -2.0357, 0, -1, 0.359179,-99) , 
3, -1.37351, 0, 0, 0.51973,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.125347);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.428987, 1, 1, 0.677374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267307,-99) , 
1, -0.492214, 1, 0, 0.403854,-99) , 
3, -1.60113, 0, 0, 0.599207,-99) , 
NN(
NN(
0, 
0, 
-1, 2.03932, 0, 1, 0.52741,-99) , 
NN(
0, 
0, 
-1, 3.28842, 0, -1, 0.427321,-99) , 
0, 2.81791, 1, 0, 0.505684,-99) , 
0, -0.840422, 1, 0, 0.525337,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.156489);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29199, 0, 1, 0.70643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478606,-99) , 
0, 3.55571, 0, 0, 0.511819,-99) , 
0, 1.90038, 1, 0, 0.563694,-99) , 
NN(
NN(
0, 
0, 
-1, 0.0903591, 0, 1, 0.531915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331303,-99) , 
1, 0.127148, 0, 0, 0.405016,-99) , 
2, -0.247004, 1, 0, 0.469201,-99) , 
3, 0.913643, 0, 0, 0.511148,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.137488);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43359,-99) , 
2, 1.18524, 1, 0, 0.636382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404714,-99) , 
1, 1.15845, 1, 0, 0.517761,-99) , 
0, 1.44224, 1, 0, 0.539877,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747516,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487577,-99) , 
1, -0.638825, 1, 0, 0.617051,-99) , 
NN(
0, 
0, 
-1, 0.945364, 1, -1, 0.450571,-99) , 
2, -1.79439, 1, 0, 0.470376,-99) , 
3, 0.789529, 0, 0, 0.503141,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.1198);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.176178, 1, 1, 0.732791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470148,-99) , 
3, 1.82895, 0, 0, 0.496985,-99) , 
1, -0.261221, 0, 0, 0.522944,-99) , 
NN(
0, 
0, 
-1, -2.53151, 0, -1, 0.445304,-99) , 
1, -0.0831057, 1, 0, 0.481206,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.142569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.623833, 0, 1, 0.576146,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467023,-99) , 
0, -0.689839, 1, 0, 0.50061,-99) , 
1, -0.429901, 1, 0, 0.524653,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347263,-99) , 
0, 3.90508, 1, 0, 0.440096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282403,-99) , 
3, 2.39998, 0, 0, 0.396498,-99) , 
0, 3.04473, 1, 0, 0.505984,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.138481);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0432971, 0, 1, 0.646383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359078,-99) , 
1, 2.11112, 1, 0, 0.595498,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411802,-99) , 
0, 2.38865, 1, 0, 0.486959,-99) , 
NN(
0, 
0, 
-1, -1.66623, 1, -1, 0.399525,-99) , 
3, -0.687832, 0, 0, 0.469923,-99) , 
1, 1.22062, 0, 0, 0.490438,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.117176);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.599042, 1, 1, 0.673917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432412,-99) , 
3, -1.95801, 0, 0, 0.622204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390134,-99) , 
2, -0.311206, 0, 0, 0.500775,-99) , 
NN(
0, 
0, 
-1, -1.02278, 1, -1, 0.326163,-99) , 
3, -0.262711, 0, 0, 0.480525,-99) , 
0, -1.43024, 1, 0, 0.502216,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.11035);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.33464, 1, 1, 0.583755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465109,-99) , 
0, -2.27303, 1, 0, 0.478876,-99) , 
3, 1.74204, 0, 0, 0.499631,-99) , 
NN(
0, 
0, 
-1, 0.197941, 1, -1, 0.372745,-99) , 
0, 3.81421, 1, 0, 0.490816,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.0561909);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685638,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366169,-99) , 
3, -0.562126, 0, 0, 0.485505,-99) , 
0, -2.1341, 1, 0, 0.493196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360538,-99) , 
3, -1.75944, 0, 0, 0.487327,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.104692);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43386,-99) , 
0, 3.52707, 1, 0, 0.540052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398239,-99) , 
2, 0.450655, 1, 0, 0.473636,-99) , 
3, 1.33246, 0, 0, 0.495521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277688,-99) , 
2, 2.51048, 1, 0, 0.487298,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.117437);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494049,-99) , 
2, 1.09822, 1, 0, 0.533102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377679,-99) , 
2, 0.0970057, 0, 0, 0.521225,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298533,-99) , 
3, -1.97881, 0, 0, 0.505615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373593,-99) , 
1, -0.498227, 1, 0, 0.414793,-99) , 
0, -0.6601, 1, 0, 0.459958,-99) , 
3, 0.789529, 0, 0, 0.489579,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.147041);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353075,-99) , 
1, 0.173378, 0, 0, 0.47864,-99) , 
0, 3.36971, 1, 0, 0.563438,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428592,-99) , 
1, 1.96035, 1, 0, 0.549528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447177,-99) , 
2, -1.12897, 1, 0, 0.460335,-99) , 
1, 0.939195, 0, 0, 0.482585,-99) , 
2, 1.7072, 0, 0, 0.494495,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.120077);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399511,-99) , 
3, -1.48339, 0, 0, 0.520432,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357991,-99) , 
2, 2.70225, 0, 0, 0.415334,-99) , 
2, 2.06479, 1, 0, 0.509238,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522669,-99) , 
NN(
0, 
0, 
-1, 1.51008, 1, -1, 0.343483,-99) , 
0, -0.393953, 1, 0, 0.384955,-99) , 
1, 1.09063, 1, 0, 0.486011,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.0773195);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429874,-99) , 
2, 1.60346, 1, 0, 0.491197,-99) , 
1, -2.02337, 1, 0, 0.498624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553355,-99) , 
NN(
0, 
0, 
-1, 1.56718, 1, -1, 0.343688,-99) , 
1, 2.05198, 0, 0, 0.400535,-99) , 
1, 1.32873, 1, 0, 0.485901,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.111127);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410136,-99) , 
1, 1.90118, 1, 0, 0.544724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503433,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396364,-99) , 
1, 0.126878, 1, 0, 0.463727,-99) , 
1, 1.05042, 0, 0, 0.479066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287172,-99) , 
2, 2.52297, 1, 0, 0.472521,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.158553);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.360965, 0, 1, 0.676323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448484,-99) , 
3, 1.86091, 0, 0, 0.479941,-99) , 
0, -0.691202, 1, 0, 0.494806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355833,-99) , 
2, -1.70086, 0, 0, 0.465737,-99) , 
NN(
0, 
0, 
-1, -1.27725, 0, -1, 0.319492,-99) , 
0, -2.48072, 1, 0, 0.374193,-99) , 
3, -0.668425, 0, 0, 0.473973,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.163527);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.152101, 1, 1, 0.581256,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539853,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439286,-99) , 
2, -0.714522, 1, 0, 0.485027,-99) , 
3, 0.194245, 0, 0, 0.530701,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447337,-99) , 
0, 3.57261, 0, 0, 0.507541,-99) , 
NN(
0, 
0, 
-1, 2.60101, 0, -1, 0.324396,-99) , 
1, -0.0139463, 0, 0, 0.413928,-99) , 
0, 2.26267, 1, 0, 0.497414,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.119854);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461086,-99) , 
3, -2.09442, 0, 0, 0.565047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454652,-99) , 
0, 0.0323117, 1, 0, 0.477472,-99) , 
NN(
0, 
0, 
-1, -1.11766, 1, -1, 0.289559,-99) , 
3, -0.979939, 0, 0, 0.466502,-99) , 
0, -2.27225, 1, 0, 0.474963,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.1197);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.06417, 1, 1, 0.646435,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48104,-99) , 
3, 1.11835, 0, 0, 0.516392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31944,-99) , 
3, 2.76253, 0, 0, 0.421351,-99) , 
0, 3.03844, 1, 0, 0.501204,-99) , 
1, 1.57667, 0, 0, 0.513291,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.192239);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427875,-99) , 
2, 1.18437, 1, 0, 0.605771,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37637,-99) , 
1, -0.663404, 1, 0, 0.42985,-99) , 
3, -0.453806, 0, 0, 0.540321,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683862,-99) , 
NN(
0, 
0, 
-1, 3.21872, 1, -1, 0.432243,-99) , 
3, 3.56598, 0, 0, 0.44693,-99) , 
0, 1.43306, 1, 0, 0.499614,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.111043);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59206, 1, 1, 0.563229,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450736,-99) , 
1, -0.314879, 1, 0, 0.487684,-99) , 
3, 1.06393, 0, 0, 0.515912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313189,-99) , 
3, 3.1674, 1, 0, 0.509738,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.163904);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49576,-99) , 
3, 1.4012, 0, 0, 0.578355,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44409,-99) , 
1, 0.0751783, 1, 0, 0.504516,-99) , 
2, 1.01498, 1, 0, 0.528267,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46206,-99) , 
1, 0.77685, 1, 0, 0.52769,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377982,-99) , 
2, -1.51559, 1, 0, 0.40633,-99) , 
1, -0.0112745, 0, 0, 0.463747,-99) , 
3, 0.862213, 0, 0, 0.494823,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.12825);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466694,-99) , 
2, -0.189994, 0, 0, 0.526759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450299,-99) , 
3, 3.56623, 0, 0, 0.463472,-99) , 
0, 1.66368, 1, 0, 0.500724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.141767,-99) , 
0, -2.86434, 1, 0, 0.365078,-99) , 
3, -1.29063, 0, 0, 0.487979,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.16502);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415386,-99) , 
0, 3.69223, 1, 0, 0.5658,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434327,-99) , 
0, -0.655712, 1, 0, 0.469482,-99) , 
1, 0.663985, 0, 0, 0.500358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230013,-99) , 
3, -1.91589, 0, 0, 0.491809,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.0782401);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68304,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39424,-99) , 
3, -0.648994, 0, 0, 0.50699,-99) , 
0, -1.96834, 1, 0, 0.515557,-99) , 
NN(
0, 
0, 
-1, -1.95216, 1, -1, 0.356894,-99) , 
3, -1.59907, 0, 0, 0.506541,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.140251);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.51004, 1, 1, 0.583379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347202,-99) , 
3, -2.10662, 0, 0, 0.568791,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488526,-99) , 
0, 1.68517, 1, 0, 0.522843,-99) , 
NN(
0, 
0, 
-1, -0.584849, 1, -1, 0.378,-99) , 
3, 0.827648, 0, 0, 0.495587,-99) , 
2, 0.326618, 1, 0, 0.526868,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.156398);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469855,-99) , 
0, -0.461581, 0, 0, 0.555105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393464,-99) , 
1, 1.307, 0, 0, 0.466195,-99) , 
1, 1.01979, 1, 0, 0.534237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576658,-99) , 
NN(
0, 
0, 
-1, 0.293868, 1, -1, 0.373501,-99) , 
1, -1.82688, 1, 0, 0.41408,-99) , 
1, -0.830196, 0, 0, 0.507966,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.147523);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.94749, 0, 1, 0.566336,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425432,-99) , 
2, 1.53116, 0, 0, 0.490941,-99) , 
2, 0.864066, 1, 0, 0.520993,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378474,-99) , 
0, -2.6121, 1, 0, 0.548832,-99) , 
NN(
0, 
0, 
-1, -1.14257, 0, -1, 0.430192,-99) , 
2, -1.46159, 1, 0, 0.456623,-99) , 
3, 0.24633, 0, 0, 0.497333,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.140959);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447968,-99) , 
2, 1.92328, 1, 0, 0.548302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394973,-99) , 
2, -0.134699, 1, 0, 0.470428,-99) , 
3, 1.00183, 0, 0, 0.501835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343724,-99) , 
2, 2.5672, 1, 0, 0.496189,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.18971);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492097,-99) , 
2, -0.924639, 0, 0, 0.697058,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419906,-99) , 
3, 1.10784, 0, 0, 0.486496,-99) , 
0, -1.11746, 1, 0, 0.5065,-99) , 
NN(
0, 
0, 
-1, -0.852681, 0, -1, 0.299988,-99) , 
3, -1.18029, 0, 0, 0.487654,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.0830742);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340881,-99) , 
1, 2.15817, 1, 0, 0.515813,-99) , 
2, -1.4017, 1, 0, 0.524149,-99) , 
NN(
0, 
0, 
-1, -0.334711, 0, -1, 0.342725,-99) , 
3, -1.52072, 0, 0, 0.513295,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.138542);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32217, 0, 1, 0.540126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371901,-99) , 
3, -1.99426, 0, 0, 0.530565,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382773,-99) , 
3, 1.59362, 0, 0, 0.482322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369099,-99) , 
3, 3.47183, 0, 0, 0.400539,-99) , 
0, 2.81038, 1, 0, 0.439087,-99) , 
0, 1.65845, 1, 0, 0.494823,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.112394);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.666548, 1, 1, 0.524907,-99) , 
NN(
0, 
0, 
-1, -1.07784, 1, -1, 0.422623,-99) , 
3, -0.864953, 0, 0, 0.507411,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434044,-99) , 
3, -1.21038, 0, 0, 0.554857,-99) , 
NN(
0, 
0, 
-1, 1.08305, 0, -1, 0.427054,-99) , 
0, -1.30302, 1, 0, 0.444069,-99) , 
1, 0.163373, 1, 0, 0.476236,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.0870087);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.37898, 1, -1, 0.483856,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262614,-99) , 
0, -3.16047, 1, 0, 0.366585,-99) , 
3, -1.27229, 0, 0, 0.472328,-99) , 
NN(
0, 
0, 
-1, 4.68851, 1, -1, 0.281036,-99) , 
0, 3.72663, 1, 0, 0.457654,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.136357);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414638,-99) , 
1, -1.21221, 0, 0, 0.559847,-99) , 
NN(
0, 
0, 
-1, -0.140547, 0, -1, 0.458623,-99) , 
3, 0.341086, 1, 0, 0.489457,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359247,-99) , 
0, -2.751, 1, 0, 0.471242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204196,-99) , 
1, -0.162839, 0, 0, 0.357099,-99) , 
3, -1.09741, 0, 0, 0.47672,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.114647);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61244, 1, 1, 0.626793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481974,-99) , 
3, 1.70793, 0, 0, 0.492697,-99) , 
0, 2.40638, 0, 0, 0.520374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209867,-99) , 
2, 2.4325, 1, 0, 0.507919,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.156982);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480411,-99) , 
3, 0.650543, 0, 0, 0.533047,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33304,-99) , 
1, -0.597251, 1, 0, 0.410634,-99) , 
3, 2.45796, 1, 0, 0.511257,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415818,-99) , 
1, -0.321467, 1, 0, 0.52023,-99) , 
NN(
0, 
0, 
-1, -1.42273, 0, -1, 0.382407,-99) , 
2, -1.55597, 1, 0, 0.419203,-99) , 
3, -0.2551, 0, 0, 0.487596,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.0985028);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481384,-99) , 
3, 0.972419, 1, 0, 0.512485,-99) , 
NN(
0, 
0, 
-1, 3.57623, 0, -1, 0.332039,-99) , 
0, 3.85297, 1, 0, 0.499164,-99) , 
NN(
0, 
0, 
-1, -2.81391, 1, -1, 0.332029,-99) , 
3, -1.37351, 0, 0, 0.4872,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.101796);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.9214, 0, 1, 0.619478,-99) , 
NN(
NN(
0, 
0, 
-1, 0.0748393, 1, 1, 0.545293,-99) , 
NN(
0, 
0, 
-1, 1.10225, 1, -1, 0.455582,-99) , 
3, 0.261768, 0, 0, 0.514161,-99) , 
2, -1.49456, 1, 0, 0.522267,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.140624);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.645042, 1, 1, 0.729577,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376994,-99) , 
2, 2.0841, 1, 0, 0.524971,-99) , 
1, 0.525671, 0, 0, 0.546809,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46494,-99) , 
3, -0.426107, 0, 0, 0.529043,-99) , 
NN(
0, 
0, 
-1, 2.17034, 0, -1, 0.412956,-99) , 
0, 0.364266, 1, 0, 0.456995,-99) , 
1, 0.736794, 1, 0, 0.522895,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.129729);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462512,-99) , 
0, -0.392769, 1, 0, 0.51733,-99) , 
3, 0.647151, 0, 0, 0.531006,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418921,-99) , 
1, 0.82205, 0, 0, 0.519242,-99) , 
NN(
0, 
0, 
-1, 0.942996, 0, -1, 0.422154,-99) , 
1, 0.555069, 0, 0, 0.456143,-99) , 
0, 0.905658, 1, 0, 0.491773,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.121365);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.792279, 0, 1, 0.537285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349991,-99) , 
1, 1.8786, 1, 0, 0.525505,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43302,-99) , 
3, -0.385286, 0, 0, 0.468545,-99) , 
NN(
0, 
0, 
-1, 1.05501, 0, -1, 0.344775,-99) , 
1, 0.663752, 1, 0, 0.435739,-99) , 
3, 0.167018, 0, 0, 0.493485,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.0734461);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673592,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439067,-99) , 
1, -0.887209, 0, 0, 0.493826,-99) , 
1, 2.02302, 0, 0, 0.500764,-99) , 
NN(
0, 
0, 
-1, 2.12117, 0, -1, 0.293403,-99) , 
0, 3.92144, 1, 0, 0.487751,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.136424);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.89198, 1, 1, 0.539011,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259851,-99) , 
3, 2.0206, 0, 0, 0.458041,-99) , 
0, 2.17946, 1, 0, 0.513756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318901,-99) , 
3, -2.02183, 0, 0, 0.507629,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.133073);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.29562, 0, -1, 0.479229,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402475,-99) , 
1, -2.00637, 1, 0, 0.418806,-99) , 
1, -0.115038, 0, 0, 0.451004,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180803,-99) , 
2, 2.57327, 1, 0, 0.442713,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.101607);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448888,-99) , 
3, 0.717666, 0, 0, 0.487015,-99) , 
NN(
0, 
0, 
-1, 0.575013, 1, -1, 0.430141,-99) , 
1, -0.885064, 0, 0, 0.473909,-99) , 
NN(
0, 
0, 
-1, 1.12167, 0, -1, 0.339096,-99) , 
1, 1.78462, 1, 0, 0.465609,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.082447);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.86212, 1, 1, 0.64623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427731,-99) , 
1, -1.99001, 1, 0, 0.51378,-99) , 
1, -1.48862, 0, 0, 0.589752,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329535,-99) , 
3, 3.15949, 1, 0, 0.493277,-99) , 
NN(
0, 
0, 
-1, -1.62449, 1, -1, 0.341966,-99) , 
0, -2.29496, 0, 0, 0.481977,-99) , 
1, -0.876828, 1, 0, 0.505283,-99)    );
  // itree = 200
  fBoostWeights.push_back(0.102044);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.63536, 0, 1, 0.529202,-99) , 
NN(
0, 
0, 
-1, 1.48043, 0, -1, 0.440292,-99) , 
0, 1.24069, 1, 0, 0.486645,-99) , 
NN(
0, 
0, 
-1, -0.0204706, 0, -1, 0.357758,-99) , 
1, -1.57729, 0, 0, 0.477425,-99)    );
  // itree = 201
  fBoostWeights.push_back(0.152024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.610177, 0, 1, 0.593333,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29845,-99) , 
0, -2.61561, 1, 0, 0.428735,-99) , 
3, -1.14316, 0, 0, 0.554949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693116,-99) , 
NN(
0, 
0, 
-1, 4.42193, 1, -1, 0.452819,-99) , 
1, -1.62958, 1, 0, 0.469314,-99) , 
2, 0.340279, 1, 0, 0.510742,-99)    );
  // itree = 202
  fBoostWeights.push_back(0.159412);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454654,-99) , 
1, -1.66461, 0, 0, 0.62589,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409218,-99) , 
2, -0.589307, 1, 0, 0.462609,-99) , 
2, 0.368346, 0, 0, 0.54338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67578,-99) , 
NN(
0, 
0, 
-1, 0.54287, 0, -1, 0.439531,-99) , 
3, 3.44828, 0, 0, 0.44954,-99) , 
1, -0.318477, 1, 0, 0.481529,-99)    );
  // itree = 203
  fBoostWeights.push_back(0.0707679);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48716,-99) , 
1, 0.723437, 0, 0, 0.501439,-99) , 
NN(
0, 
0, 
-1, 2.16669, 1, -1, 0.352056,-99) , 
1, 1.76042, 1, 0, 0.492736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320672,-99) , 
2, 2.35729, 1, 0, 0.484775,-99)    );
  // itree = 204
  fBoostWeights.push_back(0.0716205);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470499,-99) , 
2, 2.3263, 1, 0, 0.58594,-99) , 
NN(
0, 
0, 
-1, 2.89126, 1, -1, 0.470694,-99) , 
3, 2.85149, 0, 0, 0.479485,-99)    );
  // itree = 205
  fBoostWeights.push_back(0.100412);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721687,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523728,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368182,-99) , 
0, 3.68496, 1, 0, 0.510624,-99) , 
2, -1.44689, 1, 0, 0.518976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188925,-99) , 
3, -1.70657, 0, 0, 0.507116,-99)    );
  // itree = 206
  fBoostWeights.push_back(0.0943772);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.8163, 1, 1, 0.571967,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453283,-99) , 
1, 0.268167, 0, 0, 0.512053,-99) , 
NN(
0, 
0, 
-1, 0.791801, 1, -1, 0.468356,-99) , 
2, 0.518423, 0, 0, 0.48845,-99) , 
1, -1.03268, 1, 0, 0.502461,-99)    );
  // itree = 207
  fBoostWeights.push_back(0.147192);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0942541, 1, 1, 0.551327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337733,-99) , 
3, 3.19814, 1, 0, 0.541196,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402008,-99) , 
0, -1.82172, 1, 0, 0.453347,-99) , 
NN(
0, 
0, 
-1, -1.71533, 1, -1, 0.346895,-99) , 
3, -1.3401, 0, 0, 0.422997,-99) , 
3, -0.2551, 0, 0, 0.511417,-99)    );
  // itree = 208
  fBoostWeights.push_back(0.131229);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477665,-99) , 
0, -0.572259, 0, 0, 0.509372,-99) , 
3, 0.647291, 0, 0, 0.522153,-99) , 
NN(
0, 
0, 
-1, 1.70728, 1, -1, 0.417209,-99) , 
0, 0.696347, 1, 0, 0.467611,-99)    );
  // itree = 209
  fBoostWeights.push_back(0.135366);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495335,-99) , 
2, 0.564938, 0, 0, 0.547664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445377,-99) , 
0, -1.65698, 1, 0, 0.474421,-99) , 
0, 0.62799, 0, 0, 0.501425,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365594,-99) , 
0, 3.96089, 1, 0, 0.485181,-99) , 
NN(
0, 
0, 
-1, 2.02114, 1, -1, 0.323534,-99) , 
3, 2.01688, 0, 0, 0.433535,-99) , 
2, 1.22735, 1, 0, 0.483309,-99)    );
  // itree = 210
  fBoostWeights.push_back(0.13957);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492398,-99) , 
3, 1.77001, 1, 0, 0.590382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410414,-99) , 
0, 0.0425119, 0, 0, 0.505139,-99) , 
1, -0.883652, 0, 0, 0.55953,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496748,-99) , 
1, 0.978615, 1, 0, 0.525928,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240296,-99) , 
1, 0.697683, 1, 0, 0.447832,-99) , 
1, 0.825236, 0, 0, 0.496173,-99) , 
1, 0.29044, 1, 0, 0.532431,-99)    );
  // itree = 211
  fBoostWeights.push_back(0.131494);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.06024, 0, 1, 0.666031,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460927,-99) , 
1, 0.669116, 1, 0, 0.526263,-99) , 
1, 1.72723, 0, 0, 0.536287,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488662,-99) , 
2, 2.2305, 0, 0, 0.555792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25977,-99) , 
1, 0.028572, 0, 0, 0.423266,-99) , 
0, 3.44754, 1, 0, 0.524348,-99)    );
  // itree = 212
  fBoostWeights.push_back(0.0805188);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.00699727, 0, 1, 0.716469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496331,-99) , 
2, 1.05172, 1, 0, 0.644668,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489844,-99) , 
2, 1.65225, 0, 0, 0.49814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286619,-99) , 
3, 2.82679, 0, 0, 0.389532,-99) , 
2, 1.9931, 1, 0, 0.485844,-99) , 
1, 1.4448, 0, 0, 0.50169,-99)    );
  // itree = 213
  fBoostWeights.push_back(0.177357);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.219374, 0, 1, 0.601272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404473,-99) , 
3, 1.91695, 0, 0, 0.503133,-99) , 
3, 0.816476, 1, 0, 0.543843,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437566,-99) , 
2, 0.10982, 1, 0, 0.480781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192254,-99) , 
3, -1.74487, 0, 0, 0.468974,-99) , 
1, 0.549625, 0, 0, 0.496831,-99)    );
  // itree = 214
  fBoostWeights.push_back(0.154505);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47848, 0, 1, 0.583983,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449135,-99) , 
2, -0.390125, 1, 0, 0.46652,-99) , 
1, -0.456651, 1, 0, 0.502232,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369931,-99) , 
1, 0.379866, 0, 0, 0.435498,-99) , 
NN(
0, 
0, 
-1, -1.14328, 1, -1, 0.305568,-99) , 
2, -1.02304, 1, 0, 0.379129,-99) , 
3, -0.528121, 0, 0, 0.477639,-99)    );
  // itree = 215
  fBoostWeights.push_back(0.115366);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481993,-99) , 
2, 1.1127, 1, 0, 0.611384,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498562,-99) , 
1, 1.6637, 0, 0, 0.508303,-99) , 
2, 0.574486, 0, 0, 0.528274,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433635,-99) , 
0, 2.77107, 1, 0, 0.519789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39758,-99) , 
3, 2.56475, 0, 0, 0.434765,-99) , 
1, 0.296887, 0, 0, 0.4709,-99) , 
0, 1.34675, 1, 0, 0.503691,-99)    );
  // itree = 216
  fBoostWeights.push_back(0.0968866);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496902,-99) , 
1, 0.299451, 1, 0, 0.532893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277712,-99) , 
1, -2.00964, 1, 0, 0.420312,-99) , 
1, -1.54581, 0, 0, 0.522873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346317,-99) , 
3, -1.80839, 0, 0, 0.516412,-99)    );
  // itree = 217
  fBoostWeights.push_back(0.0730585);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614983,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488264,-99) , 
3, 1.13476, 0, 0, 0.515286,-99) , 
NN(
0, 
0, 
-1, -1.49179, 1, -1, 0.407819,-99) , 
3, -1.20023, 0, 0, 0.50849,-99) , 
2, -1.91397, 1, 0, 0.513484,-99)    );
  // itree = 218
  fBoostWeights.push_back(0.123637);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.768645, 1, 1, 0.683098,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332428,-99) , 
2, -1.82875, 0, 0, 0.523376,-99) , 
3, 1.39737, 0, 0, 0.540346,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499126,-99) , 
0, 4.15893, 1, 0, 0.567273,-99) , 
NN(
0, 
0, 
-1, 3.33053, 1, -1, 0.427651,-99) , 
3, 2.73904, 0, 0, 0.466856,-99) , 
2, 1.1098, 1, 0, 0.516842,-99)    );
  // itree = 219
  fBoostWeights.push_back(0.159081);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425445,-99) , 
2, 2.1288, 1, 0, 0.61608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472053,-99) , 
3, 0.458286, 0, 0, 0.497485,-99) , 
3, 0.780429, 0, 0, 0.559635,-99) , 
NN(
NN(
0, 
0, 
-1, -1.46203, 1, 1, 0.614353,-99) , 
NN(
0, 
0, 
-1, -0.249787, 0, -1, 0.452489,-99) , 
2, -0.513497, 1, 0, 0.490352,-99) , 
1, -0.020627, 0, 0, 0.525702,-99)    );
  // itree = 220
  fBoostWeights.push_back(0.101651);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.664918, 1, 1, 0.628341,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485214,-99) , 
0, 0.613772, 1, 0, 0.514438,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287132,-99) , 
2, -0.890029, 0, 0, 0.373198,-99) , 
3, -0.934938, 0, 0, 0.499379,-99) , 
0, -2.92224, 1, 0, 0.507048,-99)    );
  // itree = 221
  fBoostWeights.push_back(0.154232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.409758, 1, 1, 0.615966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460581,-99) , 
1, 0.163373, 0, 0, 0.516672,-99) , 
3, -0.205347, 0, 0, 0.574803,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360111,-99) , 
0, 4.60458, 1, 0, 0.497317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329392,-99) , 
0, 1.20186, 0, 0, 0.483566,-99) , 
2, 1.1098, 1, 0, 0.54572,-99)    );
  // itree = 222
  fBoostWeights.push_back(0.136469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.9363, 1, 1, 0.572587,-99) , 
NN(
0, 
0, 
-1, 3.26317, 1, -1, 0.391321,-99) , 
2, 1.70324, 1, 0, 0.545584,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426572,-99) , 
2, 0.233941, 0, 0, 0.472064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282924,-99) , 
1, 2.27675, 1, 0, 0.459124,-99) , 
1, 0.296887, 1, 0, 0.509016,-99)    );
  // itree = 223
  fBoostWeights.push_back(0.176395);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344405,-99) , 
3, 1.03189, 1, 0, 0.574735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439944,-99) , 
2, -0.800154, 1, 0, 0.486363,-99) , 
1, 0.163373, 0, 0, 0.52828,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365831,-99) , 
1, -0.84752, 0, 0, 0.508226,-99) , 
NN(
0, 
0, 
-1, 0.29839, 1, -1, 0.398202,-99) , 
2, 1.22602, 0, 0, 0.459866,-99) , 
0, 1.12, 1, 0, 0.496804,-99)    );
  // itree = 224
  fBoostWeights.push_back(0.188439);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.12923, 1, 1, 0.565913,-99) , 
NN(
0, 
0, 
-1, 2.74424, 0, -1, 0.353783,-99) , 
0, 3.04075, 1, 0, 0.530073,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392746,-99) , 
2, -1.23104, 1, 0, 0.452248,-99) , 
NN(
0, 
0, 
-1, -2.92555, 1, -1, 0.272983,-99) , 
2, -1.63833, 0, 0, 0.404654,-99) , 
2, -0.569616, 0, 0, 0.503328,-99)    );
  // itree = 225
  fBoostWeights.push_back(0.0671791);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417494,-99) , 
2, -1.88868, 1, 0, 0.540317,-99) , 
3, -1.43572, 0, 0, 0.612226,-99) , 
NN(
NN(
0, 
0, 
-1, -0.694015, 1, 1, 0.507749,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181231,-99) , 
0, -0.972504, 1, 0, 0.430093,-99) , 
3, -0.413034, 0, 0, 0.496847,-99) , 
0, -1.89984, 1, 0, 0.508775,-99)    );
  // itree = 226
  fBoostWeights.push_back(0.127642);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400509,-99) , 
3, -0.0562056, 1, 0, 0.5077,-99) , 
3, 0.259467, 0, 0, 0.52857,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385791,-99) , 
3, 1.47013, 0, 0, 0.515767,-99) , 
NN(
0, 
0, 
-1, 0.474641, 1, -1, 0.409779,-99) , 
0, 1.92988, 0, 0, 0.458509,-99) , 
2, -0.120038, 1, 0, 0.481037,-99)    );
  // itree = 227
  fBoostWeights.push_back(0.104009);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.21085, 1, 1, 0.636656,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457927,-99) , 
1, 0.0453671, 1, 0, 0.483846,-99) , 
NN(
0, 
0, 
-1, -1.45335, 1, -1, 0.383576,-99) , 
1, -1.20374, 0, 0, 0.470632,-99) , 
0, -2.86752, 1, 0, 0.482586,-99)    );
  // itree = 228
  fBoostWeights.push_back(0.0915746);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.33342, 1, 1, 0.656355,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486443,-99) , 
0, -1.46139, 1, 0, 0.506742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274538,-99) , 
3, -1.95281, 0, 0, 0.500209,-99) , 
3, 2.91809, 0, 0, 0.512953,-99)    );
  // itree = 229
  fBoostWeights.push_back(0.125824);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.15772, 1, 1, 0.744174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405988,-99) , 
2, -1.74841, 0, 0, 0.606828,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45799,-99) , 
3, 2.28501, 0, 0, 0.473529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237025,-99) , 
3, -1.23773, 0, 0, 0.465743,-99) , 
0, -2.17846, 1, 0, 0.479369,-99)    );
  // itree = 230
  fBoostWeights.push_back(0.117995);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.67754, 0, 1, 0.602226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47218,-99) , 
3, 2.81428, 0, 0, 0.544122,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465879,-99) , 
3, 1.40154, 0, 0, 0.481302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312452,-99) , 
1, -0.547851, 1, 0, 0.375758,-99) , 
0, 2.49854, 1, 0, 0.465636,-99) , 
2, 2.04297, 0, 0, 0.473368,-99)    );
  // itree = 231
  fBoostWeights.push_back(0.0742454);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47436, 1, 1, 0.666608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480364,-99) , 
3, 2.78345, 0, 0, 0.488121,-99) , 
1, -1.97069, 1, 0, 0.495075,-99) , 
1, 1.72723, 0, 0, 0.504474,-99)    );
  // itree = 232
  fBoostWeights.push_back(0.142617);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693148,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350154,-99) , 
1, 1.4718, 1, 0, 0.545475,-99) , 
1, 2.04568, 0, 0, 0.549942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309876,-99) , 
3, 3.22613, 1, 0, 0.542698,-99)    );
  // itree = 233
  fBoostWeights.push_back(0.155509);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478878,-99) , 
1, -0.0257961, 0, 0, 0.531163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373206,-99) , 
2, 2.67609, 0, 0, 0.411914,-99) , 
2, 1.63531, 1, 0, 0.506451,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412668,-99) , 
2, -1.42931, 0, 0, 0.477533,-99) , 
NN(
0, 
0, 
-1, -1.68631, 1, -1, 0.297274,-99) , 
0, -2.20458, 1, 0, 0.389161,-99) , 
3, -0.708844, 0, 0, 0.483115,-99)    );
  // itree = 234
  fBoostWeights.push_back(0.0546272);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496939,-99) , 
0, -2.05356, 1, 0, 0.508282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334976,-99) , 
3, -1.83474, 0, 0, 0.501094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240322,-99) , 
3, 3.20309, 1, 0, 0.493575,-99)    );
  // itree = 235
  fBoostWeights.push_back(0.0876118);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473294,-99) , 
3, 0.0297919, 0, 0, 0.519737,-99) , 
NN(
0, 
0, 
-1, -1.79304, 1, -1, 0.398888,-99) , 
3, -1.52411, 0, 0, 0.512264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30795,-99) , 
0, 4.45129, 1, 0, 0.505819,-99)    );
  // itree = 236
  fBoostWeights.push_back(0.156892);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408989,-99) , 
1, -1.43772, 0, 0, 0.55076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32472,-99) , 
2, -1.08238, 0, 0, 0.447654,-99) , 
1, 0.70029, 1, 0, 0.523807,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450992,-99) , 
2, 1.51916, 1, 0, 0.534247,-99) , 
NN(
0, 
0, 
-1, 0.229965, 0, -1, 0.426595,-99) , 
1, -0.497624, 1, 0, 0.454125,-99) , 
0, 0.45556, 1, 0, 0.483335,-99)    );
  // itree = 237
  fBoostWeights.push_back(0.105717);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48727,-99) , 
3, -0.693063, 0, 0, 0.638524,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494595,-99) , 
0, 0.553464, 1, 0, 0.520634,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379936,-99) , 
1, 1.2447, 0, 0, 0.464249,-99) , 
1, 0.746727, 1, 0, 0.504298,-99) , 
1, -1.61109, 1, 0, 0.514475,-99)    );
  // itree = 238
  fBoostWeights.push_back(0.131778);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.318457, 1, 1, 0.541205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396002,-99) , 
1, -1.62958, 0, 0, 0.532085,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31836,-99) , 
3, -1.9214, 0, 0, 0.522466,-99) , 
NN(
0, 
0, 
-1, -0.689193, 0, -1, 0.319395,-99) , 
2, -1.24278, 1, 0, 0.416315,-99) , 
2, -0.610124, 0, 0, 0.50996,-99)    );
  // itree = 239
  fBoostWeights.push_back(0.0541285);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.85222, 0, 1, 0.522894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369074,-99) , 
0, 4.20372, 1, 0, 0.516993,-99)    );
  // itree = 240
  fBoostWeights.push_back(0.135302);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.11797, 1, 1, 0.641804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347192,-99) , 
2, -0.694124, 1, 0, 0.447151,-99) , 
3, -0.163408, 0, 0, 0.584685,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498241,-99) , 
2, -0.268483, 0, 0, 0.550882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445229,-99) , 
0, 3.25135, 0, 0, 0.464018,-99) , 
0, 0.278003, 1, 0, 0.497738,-99) , 
1, -0.851532, 1, 0, 0.5155,-99)    );
  // itree = 241
  fBoostWeights.push_back(0.112932);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.750357, 1, 1, 0.573324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436645,-99) , 
2, 0.653608, 0, 0, 0.49309,-99) , 
2, 0.26342, 1, 0, 0.521642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355414,-99) , 
3, -1.92415, 0, 0, 0.467118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271613,-99) , 
0, -1.84412, 1, 0, 0.369382,-99) , 
2, -1.01773, 0, 0, 0.502244,-99)    );
  // itree = 242
  fBoostWeights.push_back(0.104169);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374336,-99) , 
2, 2.37678, 1, 0, 0.549085,-99) , 
1, 0.475288, 0, 0, 0.604571,-99) , 
NN(
NN(
0, 
0, 
-1, 2.48236, 1, -1, 0.480942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296024,-99) , 
3, 2.1933, 0, 0, 0.371695,-99) , 
2, 1.37542, 1, 0, 0.462742,-99) , 
2, 2.05721, 0, 0, 0.478997,-99)    );
  // itree = 243
  fBoostWeights.push_back(0.108059);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71051, 0, 1, 0.544131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346385,-99) , 
3, -1.78267, 0, 0, 0.532414,-99) , 
NN(
0, 
0, 
-1, 2.54205, 1, -1, 0.437212,-99) , 
0, 2.29856, 1, 0, 0.507367,-99)    );
  // itree = 244
  fBoostWeights.push_back(0.0980549);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469619,-99) , 
3, 0.0973884, 0, 0, 0.516821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351337,-99) , 
3, -1.57159, 0, 0, 0.507759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279523,-99) , 
2, 2.6428, 1, 0, 0.500013,-99)    );
  // itree = 245
  fBoostWeights.push_back(0.12887);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818424,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307459,-99) , 
0, -2.64068, 1, 0, 0.463559,-99) , 
3, -1.06796, 0, 0, 0.559822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464719,-99) , 
2, 0.772037, 1, 0, 0.499638,-99) , 
NN(
0, 
0, 
-1, 0.911899, 1, -1, 0.421393,-99) , 
3, 0.0511098, 0, 0, 0.480582,-99) , 
2, -0.987992, 1, 0, 0.48951,-99)    );
  // itree = 246
  fBoostWeights.push_back(0.106065);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0197685, 0, 1, 0.675842,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465067,-99) , 
2, 1.77626, 0, 0, 0.473865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32502,-99) , 
2, 2.4924, 1, 0, 0.46743,-99) , 
1, -1.57017, 1, 0, 0.483025,-99)    );
  // itree = 247
  fBoostWeights.push_back(0.10777);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.00582828, 0, 1, 0.548736,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324546,-99) , 
3, 0.733676, 0, 0, 0.490182,-99) , 
2, 0.609904, 1, 0, 0.523545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.163957,-99) , 
0, 4.24728, 1, 0, 0.512089,-99)    );
  // itree = 248
  fBoostWeights.push_back(0.0775365);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767188,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451067,-99) , 
1, -1.7299, 0, 0, 0.524294,-99) , 
2, -0.399216, 1, 0, 0.601407,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487587,-99) , 
2, -0.63389, 1, 0, 0.499077,-99) , 
NN(
0, 
0, 
-1, -2.66388, 1, -1, 0.36606,-99) , 
3, -1.21175, 0, 0, 0.490664,-99) , 
1, -1.38164, 1, 0, 0.500651,-99)    );
  // itree = 249
  fBoostWeights.push_back(0.0963076);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416566,-99) , 
0, 0.80858, 1, 0, 0.536913,-99) , 
2, 1.3575, 0, 0, 0.576625,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433306,-99) , 
1, 1.15802, 1, 0, 0.50441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317116,-99) , 
0, 4.17721, 1, 0, 0.495821,-99) , 
1, -0.995383, 1, 0, 0.508575,-99)    );
  // itree = 250
  fBoostWeights.push_back(0.117896);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431697,-99) , 
3, -2.34548, 0, 0, 0.623806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475329,-99) , 
0, -0.615757, 1, 0, 0.499551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275419,-99) , 
3, -1.22736, 0, 0, 0.490108,-99) , 
2, -1.57305, 1, 0, 0.501233,-99)    );
  // itree = 251
  fBoostWeights.push_back(0.110724);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.21148, 0, 1, 0.663212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373575,-99) , 
3, -0.211708, 0, 0, 0.515309,-99) , 
0, -1.09108, 1, 0, 0.528924,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434704,-99) , 
2, -0.888921, 0, 0, 0.534493,-99) , 
NN(
0, 
0, 
-1, -1.62979, 0, -1, 0.399496,-99) , 
3, -0.674536, 0, 0, 0.444069,-99) , 
2, -0.604311, 0, 0, 0.511715,-99)    );
  // itree = 252
  fBoostWeights.push_back(0.133498);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.46022, 1, 1, 0.576625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474697,-99) , 
1, -1.40389, 1, 0, 0.496814,-99) , 
1, 0.178544, 0, 0, 0.51765,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451113,-99) , 
3, 1.83119, 0, 0, 0.493678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139682,-99) , 
3, 2.55702, 1, 0, 0.446713,-99) , 
1, 0.794761, 1, 0, 0.498561,-99)    );
  // itree = 253
  fBoostWeights.push_back(0.161595);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.744255, 0, 1, 0.593125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407768,-99) , 
3, 2.73786, 0, 0, 0.452082,-99) , 
0, 1.75679, 1, 0, 0.541511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431966,-99) , 
2, -0.407451, 1, 0, 0.45463,-99) , 
0, -1.77318, 1, 0, 0.46325,-99) , 
1, -0.0762474, 1, 0, 0.497322,-99)    );
  // itree = 254
  fBoostWeights.push_back(0.146241);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.268119, 0, 1, 0.563594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351272,-99) , 
3, 2.20787, 1, 0, 0.49342,-99) , 
1, 0.481759, 1, 0, 0.538316,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471984,-99) , 
3, -0.582863, 1, 0, 0.579044,-99) , 
NN(
0, 
0, 
-1, 0.38363, 1, -1, 0.423973,-99) , 
1, 0.779774, 0, 0, 0.468026,-99) , 
2, -0.106321, 0, 0, 0.513811,-99)    );
  // itree = 255
  fBoostWeights.push_back(0.145376);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70463,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477414,-99) , 
0, -0.963415, 0, 0, 0.549881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414629,-99) , 
1, 0.62739, 0, 0, 0.442191,-99) , 
2, -0.510447, 1, 0, 0.465089,-99) , 
1, 1.90789, 0, 0, 0.476372,-99)    );
  // itree = 256
  fBoostWeights.push_back(0.116002);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468238,-99) , 
2, 0.40447, 1, 0, 0.508261,-99) , 
NN(
0, 
0, 
-1, -1.16785, 1, -1, 0.437824,-99) , 
3, -0.478883, 0, 0, 0.494384,-99) , 
NN(
0, 
0, 
-1, 0.463462, 1, -1, 0.361679,-99) , 
0, 3.81421, 1, 0, 0.484598,-99)    );
  // itree = 257
  fBoostWeights.push_back(0.0909478);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690547,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460833,-99) , 
3, 0.986476, 0, 0, 0.496169,-99) , 
2, -1.99061, 1, 0, 0.501546,-99) , 
1, -1.91975, 1, 0, 0.506468,-99)    );
  // itree = 258
  fBoostWeights.push_back(0.102101);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.70419, 0, 1, 0.644255,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393737,-99) , 
1, 0.883957, 1, 0, 0.481177,-99) , 
0, -1.20451, 1, 0, 0.495229,-99) , 
NN(
0, 
0, 
-1, -1.38774, 1, -1, 0.336518,-99) , 
3, -1.18029, 0, 0, 0.481039,-99)    );
  // itree = 259
  fBoostWeights.push_back(0.0619297);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.53905, 0, 1, 0.631117,-99) , 
NN(
NN(
0, 
0, 
-1, 3.29033, 0, 1, 0.516351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292927,-99) , 
3, -1.1323, 0, 0, 0.509435,-99) , 
0, -2.29066, 1, 0, 0.519128,-99)    );
  // itree = 260
  fBoostWeights.push_back(0.0735752);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394595,-99) , 
0, 2.59251, 1, 0, 0.48829,-99) , 
2, 2.50402, 0, 0, 0.495056,-99) , 
NN(
0, 
0, 
-1, 0.387338, 0, -1, 0.380893,-99) , 
1, -1.68977, 0, 0, 0.488599,-99)    );
  // itree = 261
  fBoostWeights.push_back(0.150773);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59849, 0, 1, 0.552433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342106,-99) , 
2, 2.55012, 1, 0, 0.444673,-99) , 
2, 2.14669, 1, 0, 0.538228,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337267,-99) , 
1, -1.11406, 0, 0, 0.518489,-99) , 
NN(
0, 
0, 
-1, -0.425735, 1, -1, 0.364158,-99) , 
0, -1.11168, 1, 0, 0.435928,-99) , 
3, 0.333731, 0, 0, 0.498175,-99)    );
  // itree = 262
  fBoostWeights.push_back(0.156382);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.33304, 0, 1, 0.63793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43458,-99) , 
0, -1.70115, 1, 0, 0.499823,-99) , 
1, -0.492214, 1, 0, 0.551859,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475449,-99) , 
0, 1.39141, 1, 0, 0.489363,-99) , 
NN(
0, 
0, 
-1, 0.660638, 1, -1, 0.389234,-99) , 
3, 1.14664, 0, 0, 0.447714,-99) , 
3, -0.0338118, 1, 0, 0.480244,-99)    );
  // itree = 263
  fBoostWeights.push_back(0.169322);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429661,-99) , 
2, 2.24115, 1, 0, 0.58678,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429179,-99) , 
1, 1.46481, 0, 0, 0.474614,-99) , 
1, 0.652165, 1, 0, 0.544548,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421327,-99) , 
2, -0.492669, 1, 0, 0.536393,-99) , 
NN(
0, 
0, 
-1, -1.67746, 0, -1, 0.434924,-99) , 
1, 0.700061, 0, 0, 0.460857,-99) , 
3, 0.546034, 0, 0, 0.506046,-99)    );
  // itree = 264
  fBoostWeights.push_back(0.0905957);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41484, 0, 1, 0.525138,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323248,-99) , 
3, 3.22172, 0, 0, 0.401485,-99) , 
0, 3.41856, 1, 0, 0.510723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319944,-99) , 
3, -1.69439, 0, 0, 0.502179,-99)    );
  // itree = 265
  fBoostWeights.push_back(0.105461);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327337,-99) , 
2, 2.49259, 1, 0, 0.506875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44543,-99) , 
0, -1.60856, 1, 0, 0.462332,-99) , 
1, 0.0340048, 1, 0, 0.488016,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37021,-99) , 
2, 0.558472, 1, 0, 0.426248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19528,-99) , 
3, -0.176623, 0, 0, 0.382672,-99) , 
1, 1.32213, 1, 0, 0.473973,-99)    );
  // itree = 266
  fBoostWeights.push_back(0.0932078);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473596,-99) , 
2, 0.281292, 1, 0, 0.503481,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220822,-99) , 
3, 0.419851, 0, 0, 0.383066,-99) , 
1, -1.75575, 0, 0, 0.49617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333803,-99) , 
3, -1.70657, 0, 0, 0.490106,-99)    );
  // itree = 267
  fBoostWeights.push_back(0.10209);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430444,-99) , 
1, 1.30642, 1, 0, 0.518236,-99) , 
NN(
0, 
0, 
-1, 2.12659, 1, -1, 0.456294,-99) , 
1, -0.336206, 0, 0, 0.49781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24342,-99) , 
0, 4.58999, 1, 0, 0.490989,-99)    );
  // itree = 268
  fBoostWeights.push_back(0.155233);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07536, 0, 1, 0.550701,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411557,-99) , 
1, 0.448322, 1, 0, 0.493526,-99) , 
3, 1.18402, 0, 0, 0.518377,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452761,-99) , 
3, 1.87784, 0, 0, 0.479439,-99) , 
NN(
0, 
0, 
-1, 0.422706, 1, -1, 0.30161,-99) , 
1, -0.583524, 1, 0, 0.441812,-99) , 
1, -0.413667, 0, 0, 0.493714,-99)    );
  // itree = 269
  fBoostWeights.push_back(0.137752);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04911, 1, 1, 0.666673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351541,-99) , 
2, 0.589672, 1, 0, 0.4667,-99) , 
1, 1.52544, 1, 0, 0.585049,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433727,-99) , 
0, 2.23894, 1, 0, 0.497151,-99) , 
NN(
0, 
0, 
-1, -2.79844, 1, -1, 0.391855,-99) , 
0, -1.53825, 0, 0, 0.481752,-99) , 
1, 0.935877, 0, 0, 0.50449,-99)    );
  // itree = 270
  fBoostWeights.push_back(0.120969);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.72559, 0, 1, 0.590105,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438182,-99) , 
0, 0.396209, 1, 0, 0.461522,-99) , 
NN(
0, 
0, 
-1, -0.106913, 1, -1, 0.334464,-99) , 
2, -0.816636, 0, 0, 0.450025,-99) , 
0, -2.6197, 1, 0, 0.45993,-99)    );
  // itree = 271
  fBoostWeights.push_back(0.135447);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467911,-99) , 
1, -1.58156, 0, 0, 0.585814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440222,-99) , 
1, -1.48379, 1, 0, 0.478839,-99) , 
2, 1.06603, 1, 0, 0.542495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40933,-99) , 
1, 1.91819, 1, 0, 0.547435,-99) , 
NN(
0, 
0, 
-1, 0.758749, 0, -1, 0.442527,-99) , 
1, 1.35017, 0, 0, 0.457176,-99) , 
1, -0.836164, 1, 0, 0.472663,-99)    );
  // itree = 272
  fBoostWeights.push_back(0.116882);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740327,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358353,-99) , 
2, 2.36426, 1, 0, 0.521536,-99) , 
0, 3.18466, 1, 0, 0.607744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475641,-99) , 
3, 1.29498, 0, 0, 0.493607,-99) , 
NN(
0, 
0, 
-1, 2.38698, 0, -1, 0.353084,-99) , 
0, 2.91505, 1, 0, 0.482279,-99) , 
2, 1.94389, 0, 0, 0.497783,-99)    );
  // itree = 273
  fBoostWeights.push_back(0.146638);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755103,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460109,-99) , 
0, -2.858, 1, 0, 0.544399,-99) , 
3, -1.0918, 0, 0, 0.622666,-99) , 
NN(
NN(
0, 
0, 
-1, -0.147225, 1, 1, 0.543468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398015,-99) , 
3, 0.16113, 0, 0, 0.444158,-99) , 
0, 0.301988, 0, 0, 0.513135,-99) , 
2, -0.999519, 1, 0, 0.528154,-99)    );
  // itree = 274
  fBoostWeights.push_back(0.107875);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.320502, 0, 1, 0.610835,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498186,-99) , 
0, 0.69392, 1, 0, 0.555432,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463639,-99) , 
1, -0.642307, 1, 0, 0.480137,-99) , 
1, 1.01236, 0, 0, 0.497311,-99) , 
1, -1.15969, 1, 0, 0.513534,-99)    );
  // itree = 275
  fBoostWeights.push_back(0.0715634);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.804789, 0, 1, 0.522566,-99) , 
NN(
0, 
0, 
-1, -0.305873, 0, -1, 0.440189,-99) , 
1, 1.32213, 1, 0, 0.512488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133703,-99) , 
0, 4.38122, 1, 0, 0.502885,-99)    );
  // itree = 276
  fBoostWeights.push_back(0.141416);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404934,-99) , 
2, 1.25418, 0, 0, 0.512931,-99) , 
2, 0.522483, 1, 0, 0.533118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640264,-99) , 
NN(
0, 
0, 
-1, 0.99624, 1, -1, 0.448346,-99) , 
0, -3.06202, 1, 0, 0.462767,-99) , 
0, 1.42435, 0, 0, 0.490131,-99)    );
  // itree = 277
  fBoostWeights.push_back(0.134745);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.355332, 0, 1, 0.686364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49805,-99) , 
1, -0.359572, 1, 0, 0.563583,-99) , 
2, -0.128544, 0, 0, 0.598257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459234,-99) , 
3, 2.47541, 0, 0, 0.476415,-99) , 
1, 1.87045, 0, 0, 0.484664,-99) , 
0, 0.0600484, 1, 0, 0.524001,-99)    );
  // itree = 278
  fBoostWeights.push_back(0.129005);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.440489, 1, 1, 0.607941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422987,-99) , 
0, -1.03955, 0, 0, 0.568571,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408884,-99) , 
2, 1.9657, 1, 0, 0.510327,-99) , 
NN(
0, 
0, 
-1, 0.866707, 1, -1, 0.447514,-99) , 
3, 0.758749, 0, 0, 0.476092,-99) , 
1, 0.935877, 0, 0, 0.496276,-99)    );
  // itree = 279
  fBoostWeights.push_back(0.142033);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.378574, 0, 1, 0.59578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351952,-99) , 
0, -2.58049, 1, 0, 0.459515,-99) , 
3, -1.14813, 0, 0, 0.564195,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475318,-99) , 
2, 0.784442, 1, 0, 0.509733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323508,-99) , 
3, 0.454878, 0, 0, 0.494064,-99) , 
0, 0.280805, 1, 0, 0.522848,-99)    );
  // itree = 280
  fBoostWeights.push_back(0.152721);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.782754, 0, 1, 0.615398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458859,-99) , 
3, 2.28586, 0, 0, 0.4944,-99) , 
0, 0.926355, 1, 0, 0.529765,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468185,-99) , 
1, 0.202494, 1, 0, 0.506759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319375,-99) , 
1, -1.24009, 1, 0, 0.412899,-99) , 
1, -0.43731, 0, 0, 0.475748,-99) , 
2, -0.148863, 0, 0, 0.51229,-99)    );
  // itree = 281
  fBoostWeights.push_back(0.129878);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.82645, 0, 1, 0.680587,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366582,-99) , 
1, -1.2012, 0, 0, 0.519947,-99) , 
1, -1.97011, 1, 0, 0.524676,-99) , 
3, 3.20309, 0, 0, 0.53327,-99)    );
  // itree = 282
  fBoostWeights.push_back(0.155282);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475895,-99) , 
3, 0.289575, 1, 0, 0.534226,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348259,-99) , 
0, -2.20458, 1, 0, 0.429797,-99) , 
3, -0.60381, 0, 0, 0.502541,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426154,-99) , 
0, 3.09358, 1, 0, 0.465629,-99) , 
NN(
0, 
0, 
-1, 1.20652, 0, -1, 0.365511,-99) , 
3, 1.69586, 0, 0, 0.424925,-99) , 
0, 1.24069, 1, 0, 0.467869,-99)    );
  // itree = 283
  fBoostWeights.push_back(0.118971);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489713,-99) , 
1, -0.616771, 1, 0, 0.518414,-99) , 
NN(
0, 
0, 
-1, 2.27095, 0, -1, 0.410784,-99) , 
2, 1.4051, 1, 0, 0.491714,-99) , 
NN(
0, 
0, 
-1, -1.76973, 1, -1, 0.315041,-99) , 
3, -1.19804, 0, 0, 0.477123,-99)    );
  // itree = 284
  fBoostWeights.push_back(0.181823);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55788, 1, 1, 0.617217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434365,-99) , 
3, 3.51114, 0, 0, 0.466898,-99) , 
0, 2.81701, 1, 0, 0.560344,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322523,-99) , 
3, -1.98729, 0, 0, 0.560942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445792,-99) , 
0, 0.71319, 0, 0, 0.468004,-99) , 
0, -1.33229, 1, 0, 0.494744,-99) , 
0, 1.05477, 0, 0, 0.52567,-99)    );
  // itree = 285
  fBoostWeights.push_back(0.193669);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49523,-99) , 
1, -1.31902, 0, 0, 0.582875,-99) , 
NN(
0, 
0, 
-1, -1.97694, 1, -1, 0.386996,-99) , 
3, -1.59105, 0, 0, 0.569926,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365268,-99) , 
0, 3.80559, 1, 0, 0.49727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336023,-99) , 
3, 2.24474, 0, 0, 0.435168,-99) , 
2, 1.62206, 1, 0, 0.547989,-99)    );
  // itree = 286
  fBoostWeights.push_back(0.117579);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.111504, 1, 1, 0.546973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439934,-99) , 
2, 1.87018, 0, 0, 0.465712,-99) , 
1, -0.541154, 0, 0, 0.523835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290304,-99) , 
0, -3.53378, 1, 0, 0.378296,-99) , 
3, -1.41157, 0, 0, 0.513485,-99)    );
  // itree = 287
  fBoostWeights.push_back(0.158072);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452691,-99) , 
2, 2.44192, 0, 0, 0.579789,-99) , 
1, -0.320247, 1, 0, 0.624108,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477311,-99) , 
3, -0.355731, 0, 0, 0.558921,-99) , 
NN(
0, 
0, 
-1, 0.246589, 0, -1, 0.442448,-99) , 
0, 0.604959, 1, 0, 0.497588,-99) , 
0, 3.59609, 0, 0, 0.512694,-99)    );
  // itree = 288
  fBoostWeights.push_back(0.183605);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417552,-99) , 
1, 1.43988, 1, 0, 0.597405,-99) , 
NN(
0, 
0, 
-1, -0.732401, 1, -1, 0.398568,-99) , 
3, -1.47675, 0, 0, 0.571256,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465396,-99) , 
1, 0.589296, 1, 0, 0.533601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328206,-99) , 
0, -0.0359975, 1, 0, 0.370414,-99) , 
2, 0.694225, 0, 0, 0.496038,-99) , 
2, 0.317942, 1, 0, 0.528098,-99)    );
  // itree = 289
  fBoostWeights.push_back(0.11205);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15865, 1, 1, 0.668339,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373886,-99) , 
1, -2.08416, 1, 0, 0.459693,-99) , 
1, -1.74812, 0, 0, 0.585165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64447,-99) , 
NN(
0, 
0, 
-1, 1.7396, 1, -1, 0.461698,-99) , 
3, 3.26988, 0, 0, 0.469872,-99) , 
1, -1.19786, 1, 0, 0.485915,-99)    );
  // itree = 290
  fBoostWeights.push_back(0.124704);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.327603, 0, 1, 0.713924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337852,-99) , 
0, -1.97376, 1, 0, 0.454372,-99) , 
0, -1.232, 0, 0, 0.538711,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441297,-99) , 
2, 1.02049, 1, 0, 0.473761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362296,-99) , 
2, 0.293099, 0, 0, 0.395505,-99) , 
0, -0.206115, 0, 0, 0.458744,-99) , 
2, -0.591197, 1, 0, 0.4738,-99)    );
  // itree = 291
  fBoostWeights.push_back(0.133892);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.373146, 0, 1, 0.620036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465631,-99) , 
1, 1.00167, 1, 0, 0.520886,-99) , 
3, 1.51325, 1, 0, 0.551245,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478617,-99) , 
3, 0.00411606, 0, 0, 0.516316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374543,-99) , 
2, 0.628905, 0, 0, 0.420858,-99) , 
2, 0.216579, 1, 0, 0.489369,-99) , 
2, 0.761195, 0, 0, 0.514406,-99)    );
  // itree = 292
  fBoostWeights.push_back(0.105932);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473694,-99) , 
3, -2.02813, 0, 0, 0.650263,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485129,-99) , 
1, 0.945366, 0, 0, 0.509443,-99) , 
0, -2.39962, 1, 0, 0.520937,-99) , 
NN(
0, 
0, 
-1, 0.0669036, 1, -1, 0.305849,-99) , 
0, 3.92229, 1, 0, 0.508732,-99)    );
  // itree = 293
  fBoostWeights.push_back(0.0823105);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.513299, 1, 1, 0.731256,-99) , 
NN(
NN(
0, 
0, 
-1, -1.68292, 1, 1, 0.525112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38043,-99) , 
3, -1.25789, 0, 0, 0.517936,-99) , 
0, -3.28984, 1, 0, 0.529865,-99)    );
  // itree = 294
  fBoostWeights.push_back(0.120773);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839075,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401412,-99) , 
2, -1.5086, 1, 0, 0.566213,-99) , 
2, -0.672927, 0, 0, 0.638328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742108,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364055,-99) , 
2, 1.88501, 1, 0, 0.499079,-99) , 
2, 2.82516, 0, 0, 0.508102,-99) , 
0, -1.55896, 1, 0, 0.52539,-99)    );
  // itree = 295
  fBoostWeights.push_back(0.0847401);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64476,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482289,-99) , 
0, -0.572906, 1, 0, 0.499115,-99) , 
2, 1.71251, 0, 0, 0.510713,-99) , 
NN(
0, 
0, 
-1, -0.314799, 0, -1, 0.378367,-99) , 
2, 2.05056, 1, 0, 0.498863,-99)    );
  // itree = 296
  fBoostWeights.push_back(0.123979);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.235411, 0, 1, 0.57337,-99) , 
NN(
NN(
0, 
0, 
-1, 1.08972, 1, 1, 0.53628,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37519,-99) , 
1, 0.593141, 0, 0, 0.40507,-99) , 
3, 0.961914, 0, 0, 0.494058,-99) , 
0, 0.00039523, 1, 0, 0.520871,-99)    );
  // itree = 297
  fBoostWeights.push_back(0.111512);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.97679, 0, 1, 0.618269,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482822,-99) , 
2, 1.4091, 1, 0, 0.538022,-99) , 
NN(
0, 
0, 
-1, 0.649247, 1, -1, 0.455107,-99) , 
3, 1.15671, 0, 0, 0.49107,-99) , 
2, -1.5221, 1, 0, 0.500644,-99)    );
  // itree = 298
  fBoostWeights.push_back(0.118585);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.498743, 1, 1, 0.615213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492516,-99) , 
3, -0.580682, 0, 0, 0.589549,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402452,-99) , 
0, 4.17524, 1, 0, 0.529643,-99) , 
NN(
0, 
0, 
-1, 0.204078, 0, -1, 0.453026,-99) , 
0, 2.90547, 0, 0, 0.466024,-99) , 
1, -1.03268, 1, 0, 0.484101,-99)    );
  // itree = 299
  fBoostWeights.push_back(0.16156);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376346,-99) , 
0, 1.8417, 0, 0, 0.528381,-99) , 
0, 1.56541, 1, 0, 0.549737,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348295,-99) , 
1, 1.18753, 1, 0, 0.541755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402484,-99) , 
1, -0.667526, 1, 0, 0.437734,-99) , 
0, 0.00955809, 1, 0, 0.485848,-99) , 
3, 1.29819, 0, 0, 0.508682,-99)    );
  // itree = 300
  fBoostWeights.push_back(0.170844);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385148,-99) , 
1, 0.0390534, 0, 0, 0.582314,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331212,-99) , 
1, 1.19893, 0, 0, 0.474828,-99) , 
1, 0.957287, 1, 0, 0.543547,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492857,-99) , 
1, -1.12955, 1, 0, 0.523415,-99) , 
NN(
0, 
0, 
-1, 3.04636, 1, -1, 0.420682,-99) , 
2, -0.397302, 1, 0, 0.446281,-99) , 
1, -0.0583898, 0, 0, 0.498255,-99)    );
  // itree = 301
  fBoostWeights.push_back(0.106564);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682505,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428666,-99) , 
1, -1.91408, 0, 0, 0.529864,-99) , 
3, 1.21658, 0, 0, 0.561746,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463885,-99) , 
0, 2.01847, 1, 0, 0.506388,-99) , 
NN(
0, 
0, 
-1, 1.16907, 0, -1, 0.386713,-99) , 
1, -0.477547, 0, 0, 0.482653,-99) , 
1, -1.1404, 1, 0, 0.493616,-99)    );
  // itree = 302
  fBoostWeights.push_back(0.124699);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98861, 0, 1, 0.53425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331511,-99) , 
3, 2.98672, 1, 0, 0.516535,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383726,-99) , 
2, -0.0639171, 1, 0, 0.508194,-99) , 
NN(
0, 
0, 
-1, 0.00896422, 0, -1, 0.388239,-99) , 
0, -0.322689, 1, 0, 0.453349,-99) , 
3, 0.660714, 0, 0, 0.486985,-99)    );
  // itree = 303
  fBoostWeights.push_back(0.0563343);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684039,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274601,-99) , 
3, -1.0876, 0, 0, 0.503265,-99) , 
0, -2.25623, 1, 0, 0.508185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337805,-99) , 
3, -1.69439, 0, 0, 0.500308,-99)    );
  // itree = 304
  fBoostWeights.push_back(0.114991);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415282,-99) , 
0, 1.78025, 1, 0, 0.581736,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304582,-99) , 
1, 1.5646, 1, 0, 0.489869,-99) , 
3, 0.78588, 0, 0, 0.51505,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442299,-99) , 
3, 1.76202, 0, 0, 0.531863,-99) , 
NN(
0, 
0, 
-1, 0.463552, 0, -1, 0.406247,-99) , 
1, -0.0139463, 1, 0, 0.458454,-99) , 
0, 2.02582, 1, 0, 0.498008,-99)    );
  // itree = 305
  fBoostWeights.push_back(0.14237);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.849618, 0, 1, 0.57187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397369,-99) , 
1, 0.504069, 0, 0, 0.469261,-99) , 
1, -0.0831057, 1, 0, 0.515618,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413103,-99) , 
3, 2.73231, 0, 0, 0.45977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25452,-99) , 
3, 1.53385, 0, 0, 0.422569,-99) , 
0, 1.98044, 1, 0, 0.486707,-99)    );
  // itree = 306
  fBoostWeights.push_back(0.134327);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.359124, 1, 1, 0.545004,-99) , 
NN(
0, 
0, 
-1, 1.08926, 0, -1, 0.448857,-99) , 
0, 1.30583, 1, 0, 0.493473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419251,-99) , 
2, -1.72162, 0, 0, 0.50348,-99) , 
NN(
0, 
0, 
-1, -1.06908, 0, -1, 0.322433,-99) , 
2, -1.36361, 1, 0, 0.404973,-99) , 
3, -0.667559, 0, 0, 0.477124,-99)    );
  // itree = 307
  fBoostWeights.push_back(0.100528);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.23678, 0, 1, 0.533677,-99) , 
NN(
0, 
0, 
-1, -1.36971, 0, -1, 0.36183,-99) , 
3, -0.772864, 0, 0, 0.506676,-99)    );
  // itree = 308
  fBoostWeights.push_back(0.14574);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494265,-99) , 
0, 0.836392, 1, 0, 0.568083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455065,-99) , 
0, -0.450591, 1, 0, 0.465015,-99) , 
1, -0.494972, 1, 0, 0.493482,-99) , 
NN(
0, 
0, 
-1, 0.84528, 1, -1, 0.38342,-99) , 
3, -0.195379, 0, 0, 0.466004,-99)    );
  // itree = 309
  fBoostWeights.push_back(0.104706);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666327,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352282,-99) , 
3, -0.437943, 0, 0, 0.517005,-99) , 
0, -1.65776, 1, 0, 0.525164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54852,-99) , 
NN(
0, 
0, 
-1, -2.15156, 0, -1, 0.323224,-99) , 
1, -0.175047, 1, 0, 0.418406,-99) , 
2, -1.01773, 0, 0, 0.512273,-99)    );
  // itree = 310
  fBoostWeights.push_back(0.118929);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462617,-99) , 
3, -2.04136, 0, 0, 0.593833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381004,-99) , 
0, -0.143899, 0, 0, 0.479887,-99) , 
0, -1.54475, 1, 0, 0.495462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221582,-99) , 
0, 4.36081, 1, 0, 0.485742,-99)    );
  // itree = 311
  fBoostWeights.push_back(0.146106);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443294,-99) , 
3, 1.31515, 0, 0, 0.479465,-99) , 
NN(
0, 
0, 
-1, 0.258603, 1, -1, 0.423954,-99) , 
1, 0.861374, 0, 0, 0.437773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313895,-99) , 
3, -1.71025, 0, 0, 0.433045,-99)    );
  // itree = 312
  fBoostWeights.push_back(0.147557);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793512,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438765,-99) , 
1, -1.47958, 1, 0, 0.560282,-99) , 
3, 1.4278, 0, 0, 0.620398,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308209,-99) , 
1, -1.04873, 0, 0, 0.505334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409883,-99) , 
2, 1.51538, 0, 0, 0.446717,-99) , 
1, 0.366426, 1, 0, 0.47758,-99) , 
1, -1.19786, 1, 0, 0.495546,-99)    );
  // itree = 313
  fBoostWeights.push_back(0.170024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.58165, 0, 1, 0.581592,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393413,-99) , 
0, 3.59904, 1, 0, 0.4659,-99) , 
1, -0.176369, 0, 0, 0.535462,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416234,-99) , 
1, 1.34873, 1, 0, 0.501863,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396214,-99) , 
1, -1.88764, 1, 0, 0.406065,-99) , 
1, 0.687396, 0, 0, 0.431226,-99) , 
0, 2.02582, 0, 0, 0.46234,-99)    );
  // itree = 314
  fBoostWeights.push_back(0.12596);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.15475, 0, 1, 0.670929,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447301,-99) , 
3, -0.243389, 0, 0, 0.515992,-99) , 
NN(
0, 
0, 
-1, 0.892527, 1, -1, 0.419202,-99) , 
0, 2.23364, 1, 0, 0.485967,-99) , 
2, -1.50391, 1, 0, 0.499671,-99)    );
  // itree = 315
  fBoostWeights.push_back(0.123711);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470038,-99) , 
2, 0.253488, 0, 0, 0.583657,-99) , 
NN(
0, 
0, 
-1, -0.288344, 1, -1, 0.466385,-99) , 
3, 0.470805, 0, 0, 0.498678,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478159,-99) , 
3, 3.36617, 0, 0, 0.520438,-99) , 
NN(
0, 
0, 
-1, 1.10649, 1, -1, 0.421683,-99) , 
3, 2.74245, 0, 0, 0.442974,-99) , 
2, 0.817767, 1, 0, 0.475466,-99)    );
  // itree = 316
  fBoostWeights.push_back(0.0910348);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487101,-99) , 
2, -0.960269, 1, 0, 0.503916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239088,-99) , 
3, -1.87798, 0, 0, 0.495656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262728,-99) , 
0, 3.92229, 1, 0, 0.482684,-99)    );
  // itree = 317
  fBoostWeights.push_back(0.108609);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35536, 0, 1, 0.55919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477245,-99) , 
0, -0.971238, 1, 0, 0.497597,-99) , 
1, 0.585742, 1, 0, 0.5378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348486,-99) , 
0, 4.38122, 1, 0, 0.53111,-99)    );
  // itree = 318
  fBoostWeights.push_back(0.149271);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356422,-99) , 
0, 4.43409, 1, 0, 0.593394,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444788,-99) , 
2, 0.896381, 1, 0, 0.559606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416651,-99) , 
0, 0.217341, 1, 0, 0.447724,-99) , 
1, -0.783555, 1, 0, 0.470999,-99) , 
0, 3.56292, 0, 0, 0.483428,-99)    );
  // itree = 319
  fBoostWeights.push_back(0.145196);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.852308, 1, 1, 0.630118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363415,-99) , 
1, -1.63238, 0, 0, 0.502287,-99) , 
3, 0.660704, 0, 0, 0.564293,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445336,-99) , 
1, 1.52785, 1, 0, 0.507601,-99) , 
NN(
0, 
0, 
-1, 1.65766, 1, -1, 0.388287,-99) , 
1, 0.526566, 0, 0, 0.476952,-99) , 
1, 0.158148, 1, 0, 0.521931,-99)    );
  // itree = 320
  fBoostWeights.push_back(0.125043);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4761,-99) , 
0, 1.79561, 1, 0, 0.528511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432125,-99) , 
2, -0.957291, 1, 0, 0.470739,-99) , 
3, 0.296027, 0, 0, 0.504747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315435,-99) , 
3, 3.19376, 1, 0, 0.499562,-99)    );
  // itree = 321
  fBoostWeights.push_back(0.0702115);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0441543, 1, 1, 0.632419,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491324,-99) , 
0, -1.40284, 1, 0, 0.500102,-99) , 
2, -0.78558, 1, 0, 0.511224,-99) , 
NN(
0, 
0, 
-1, -1.79587, 0, -1, 0.351421,-99) , 
3, -1.37351, 0, 0, 0.499803,-99)    );
  // itree = 322
  fBoostWeights.push_back(0.180909);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43467,-99) , 
1, 1.29843, 1, 0, 0.569013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454441,-99) , 
1, -0.752482, 1, 0, 0.497601,-99) , 
1, 0.420004, 0, 0, 0.523703,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478749,-99) , 
3, -1.21061, 0, 0, 0.589533,-99) , 
NN(
0, 
0, 
-1, -1.47473, 1, -1, 0.387526,-99) , 
1, -0.609131, 1, 0, 0.436908,-99) , 
2, -0.0534979, 0, 0, 0.494211,-99)    );
  // itree = 323
  fBoostWeights.push_back(0.135262);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46432, 1, 1, 0.643285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409442,-99) , 
3, 0.0254139, 0, 0, 0.594678,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443907,-99) , 
3, -1.51141, 0, 0, 0.560161,-99) , 
NN(
0, 
0, 
-1, -0.12894, 0, -1, 0.450671,-99) , 
3, -0.587892, 1, 0, 0.468991,-99) , 
1, 1.26222, 0, 0, 0.485633,-99)    );
  // itree = 324
  fBoostWeights.push_back(0.127833);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.652803, 1, 1, 0.603414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232394,-99) , 
0, 4.43145, 1, 0, 0.506955,-99) , 
2, 0.503166, 1, 0, 0.543447,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492351,-99) , 
0, -2.6121, 0, 0, 0.525672,-99) , 
NN(
0, 
0, 
-1, -2.60977, 1, -1, 0.356888,-99) , 
1, -0.171694, 0, 0, 0.442771,-99) , 
3, -0.864953, 0, 0, 0.530858,-99)    );
  // itree = 325
  fBoostWeights.push_back(0.114869);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.28653, 0, 1, 0.542367,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314014,-99) , 
0, 1.40269, 1, 0, 0.392297,-99) , 
1, -1.53779, 0, 0, 0.532055,-99) , 
NN(
0, 
0, 
-1, -2.47538, 1, -1, 0.332181,-99) , 
3, -1.09741, 0, 0, 0.515905,-99)    );
  // itree = 326
  fBoostWeights.push_back(0.127611);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.95612, 1, 1, 0.630624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41252,-99) , 
3, -1.66686, 0, 0, 0.587886,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459071,-99) , 
3, 2.08167, 0, 0, 0.478675,-99) , 
1, 2.04644, 0, 0, 0.486574,-99) , 
0, -0.602658, 1, 0, 0.509199,-99)    );
  // itree = 327
  fBoostWeights.push_back(0.149468);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431725,-99) , 
1, 0.458483, 1, 0, 0.530874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385161,-99) , 
0, 1.88412, 0, 0, 0.433727,-99) , 
1, -1.01855, 0, 0, 0.505299,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407785,-99) , 
2, 0.821656, 0, 0, 0.440489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181806,-99) , 
0, 3.31314, 1, 0, 0.413042,-99) , 
1, 0.7085, 1, 0, 0.478892,-99)    );
  // itree = 328
  fBoostWeights.push_back(0.119998);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.10365, 1, 1, 0.697285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374113,-99) , 
3, -1.4312, 0, 0, 0.527497,-99) , 
3, 1.14325, 0, 0, 0.575061,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692699,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475198,-99) , 
3, 2.28264, 0, 0, 0.4894,-99) , 
NN(
0, 
0, 
-1, 3.02359, 0, -1, 0.363109,-99) , 
0, 3.59974, 1, 0, 0.477665,-99) , 
1, -0.541154, 1, 0, 0.502432,-99)    );
  // itree = 329
  fBoostWeights.push_back(0.11653);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12943, 1, 1, 0.547197,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432898,-99) , 
2, -0.462438, 1, 0, 0.48077,-99) , 
3, 0.676548, 0, 0, 0.509785,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421124,-99) , 
2, 2.27676, 1, 0, 0.503189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291521,-99) , 
3, 2.84541, 0, 0, 0.422439,-99) , 
0, 3.44754, 1, 0, 0.500018,-99)    );
  // itree = 330
  fBoostWeights.push_back(0.0888297);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460454,-99) , 
3, -1.49583, 0, 0, 0.575095,-99) , 
NN(
0, 
0, 
-1, -0.418131, 0, -1, 0.476729,-99) , 
0, -1.11069, 1, 0, 0.494532,-99) , 
NN(
0, 
0, 
-1, 2.08636, 1, -1, 0.349581,-99) , 
0, 3.72663, 1, 0, 0.485539,-99)    );
  // itree = 331
  fBoostWeights.push_back(0.153832);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.749879, 0, 1, 0.626576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398754,-99) , 
3, -1.35253, 0, 0, 0.496986,-99) , 
3, 0.347354, 0, 0, 0.521766,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618279,-99) , 
NN(
0, 
0, 
-1, 1.73279, 0, -1, 0.404511,-99) , 
2, 0.0748393, 1, 0, 0.421131,-99) , 
0, 0.711123, 1, 0, 0.466028,-99)    );
  // itree = 332
  fBoostWeights.push_back(0.0810095);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717288,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454115,-99) , 
3, 0.0990605, 0, 0, 0.573079,-99) , 
NN(
0, 
0, 
-1, -0.7452, 0, -1, 0.480369,-99) , 
1, -1.03672, 1, 0, 0.495238,-99) , 
1, 2.02606, 0, 0, 0.502553,-99)    );
  // itree = 333
  fBoostWeights.push_back(0.110122);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669466,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426909,-99) , 
0, 3.76305, 1, 0, 0.537033,-99) , 
NN(
0, 
0, 
-1, 1.8415, 1, -1, 0.460218,-99) , 
3, 1.37534, 0, 0, 0.486657,-99) , 
0, -3.02657, 1, 0, 0.494223,-99)    );
  // itree = 334
  fBoostWeights.push_back(0.0946894);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02276, 0, 1, 0.545579,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482972,-99) , 
0, 1.84054, 1, 0, 0.507632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278633,-99) , 
3, 0.941896, 0, 0, 0.489379,-99) , 
0, 1.24069, 1, 0, 0.520821,-99)    );
  // itree = 335
  fBoostWeights.push_back(0.0930141);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21462, 0, 1, 0.574907,-99) , 
NN(
0, 
0, 
-1, 0.687857, 1, -1, 0.479038,-99) , 
3, 1.20161, 0, 0, 0.511951,-99) , 
NN(
0, 
0, 
-1, 4.31708, 1, -1, 0.352973,-99) , 
0, 3.72663, 1, 0, 0.501765,-99)    );
  // itree = 336
  fBoostWeights.push_back(0.104473);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.859021, 0, 1, 0.627487,-99) , 
NN(
NN(
0, 
0, 
-1, 2.42317, 0, 1, 0.524838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251095,-99) , 
3, -0.487372, 0, 0, 0.511941,-99) , 
0, -1.23471, 1, 0, 0.532834,-99)    );
  // itree = 337
  fBoostWeights.push_back(0.0877878);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642884,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491452,-99) , 
1, -0.140547, 1, 0, 0.515545,-99) , 
2, -0.332874, 1, 0, 0.525733,-99) , 
NN(
NN(
0, 
0, 
-1, 1.13643, 1, 1, 0.584243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345192,-99) , 
0, -1.49752, 1, 0, 0.433783,-99) , 
1, 0.585742, 0, 0, 0.481734,-99) , 
2, -0.569616, 0, 0, 0.516473,-99)    );
  // itree = 338
  fBoostWeights.push_back(0.149946);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477908,-99) , 
2, 0.90718, 0, 0, 0.65762,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436408,-99) , 
2, 2.08414, 0, 0, 0.475976,-99) , 
3, 1.51325, 1, 0, 0.534647,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49244,-99) , 
3, 0.197975, 0, 0, 0.511442,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400485,-99) , 
2, 0.0250589, 1, 0, 0.423472,-99) , 
2, -0.0952939, 1, 0, 0.473992,-99) , 
2, 0.729595, 0, 0, 0.49948,-99)    );
  // itree = 339
  fBoostWeights.push_back(0.0871315);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42236, 0, 1, 0.532945,-99) , 
NN(
0, 
0, 
-1, 4.55673, 1, -1, 0.366711,-99) , 
0, 3.44754, 1, 0, 0.515532,-99)    );
  // itree = 340
  fBoostWeights.push_back(0.114999);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484614,-99) , 
1, -0.0951661, 1, 0, 0.624349,-99) , 
NN(
0, 
0, 
-1, 1.33033, 0, 1, 0.536785,-99) , 
1, -0.0177271, 1, 0, 0.547202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553755,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430502,-99) , 
1, -1.29308, 1, 0, 0.463751,-99) , 
2, -0.914322, 1, 0, 0.479362,-99) , 
1, -0.222879, 0, 0, 0.520356,-99)    );
  // itree = 341
  fBoostWeights.push_back(0.0975533);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.235021, 0, 1, 0.62284,-99) , 
NN(
NN(
0, 
0, 
-1, 2.16056, 0, 1, 0.52827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422364,-99) , 
3, 1.49638, 1, 0, 0.467135,-99) , 
2, 1.30903, 1, 0, 0.516395,-99) , 
3, 2.75934, 0, 0, 0.526844,-99)    );
  // itree = 342
  fBoostWeights.push_back(0.0904542);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691678,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444362,-99) , 
1, 0.600608, 1, 0, 0.491031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348875,-99) , 
2, 2.33997, 1, 0, 0.48327,-99) , 
2, -2.00027, 1, 0, 0.493676,-99)    );
  // itree = 343
  fBoostWeights.push_back(0.0947996);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19209, 0, 1, 0.601385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497349,-99) , 
3, 0.278103, 0, 0, 0.573802,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240731,-99) , 
2, -1.8546, 0, 0, 0.502012,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363629,-99) , 
3, 2.86695, 0, 0, 0.424552,-99) , 
2, 1.539, 1, 0, 0.485599,-99) , 
1, 1.29294, 0, 0, 0.496849,-99)    );
  // itree = 344
  fBoostWeights.push_back(0.156079);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466184,-99) , 
1, -0.895176, 0, 0, 0.531746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419293,-99) , 
1, 1.84447, 0, 0, 0.438748,-99) , 
1, 0.0289722, 1, 0, 0.476193,-99) , 
NN(
0, 
0, 
-1, 0.687228, 0, -1, 0.357328,-99) , 
1, -1.35835, 0, 0, 0.464401,-99)    );
  // itree = 345
  fBoostWeights.push_back(0.168657);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482858,-99) , 
3, 2.18804, 0, 0, 0.515375,-99) , 
NN(
0, 
0, 
-1, 1.00493, 1, -1, 0.353236,-99) , 
0, -1.21842, 0, 0, 0.489926,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41059,-99) , 
1, -1.43536, 1, 0, 0.425087,-99) , 
NN(
0, 
0, 
-1, 0.30332, 0, -1, 0.309429,-99) , 
1, -1.62052, 0, 0, 0.411693,-99) , 
1, 0.237199, 0, 0, 0.446707,-99)    );
  // itree = 346
  fBoostWeights.push_back(0.129055);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0312661, 0, 1, 0.617656,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475967,-99) , 
3, 0.958498, 0, 0, 0.50257,-99) , 
1, 1.25401, 0, 0, 0.51801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577766,-99) , 
NN(
0, 
0, 
-1, 0.880741, 1, -1, 0.323979,-99) , 
1, -0.62344, 1, 0, 0.393331,-99) , 
0, 2.7768, 1, 0, 0.496065,-99)    );
  // itree = 347
  fBoostWeights.push_back(0.11998);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.750793, 1, 1, 0.582359,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478401,-99) , 
3, 2.51237, 0, 0, 0.493388,-99) , 
1, 0.307057, 0, 0, 0.52986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265144,-99) , 
2, 2.5672, 1, 0, 0.520421,-99)    );
  // itree = 348
  fBoostWeights.push_back(0.0717734);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717787,-99) , 
NN(
NN(
0, 
0, 
-1, 2.82731, 0, 1, 0.521264,-99) , 
NN(
0, 
0, 
-1, 1.07083, 1, -1, 0.383366,-99) , 
1, 1.61873, 1, 0, 0.510977,-99) , 
2, 2.77604, 0, 0, 0.519107,-99)    );
  // itree = 349
  fBoostWeights.push_back(0.169173);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.903468, 1, 1, 0.595171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406851,-99) , 
1, -0.505315, 0, 0, 0.473269,-99) , 
2, 1.58212, 1, 0, 0.567765,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483346,-99) , 
0, 0.529767, 1, 0, 0.522599,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367925,-99) , 
0, -2.03223, 1, 0, 0.404089,-99) , 
2, 0.111202, 0, 0, 0.473468,-99) , 
1, 0.0767317, 1, 0, 0.522077,-99)    );
  // itree = 350
  fBoostWeights.push_back(0.117199);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447279,-99) , 
1, 0.741009, 1, 0, 0.541889,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466869,-99) , 
1, 0.891731, 0, 0, 0.485625,-99) , 
2, 0.340279, 0, 0, 0.516514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310854,-99) , 
1, 2.08419, 1, 0, 0.51106,-99)    );
  // itree = 351
  fBoostWeights.push_back(0.115746);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460429,-99) , 
2, -0.109265, 0, 0, 0.622684,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378022,-99) , 
2, 2.19741, 1, 0, 0.514825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421549,-99) , 
3, -0.291484, 1, 0, 0.448344,-99) , 
1, 0.293655, 1, 0, 0.487041,-99) , 
1, 1.6637, 0, 0, 0.495344,-99)    );
  // itree = 352
  fBoostWeights.push_back(0.184305);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4588, 1, 1, 0.595908,-99) , 
NN(
0, 
0, 
-1, -1.05032, 0, -1, 0.423429,-99) , 
2, -0.742066, 0, 0, 0.571237,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368516,-99) , 
3, -1.59087, 0, 0, 0.529074,-99) , 
NN(
0, 
0, 
-1, -0.155005, 1, -1, 0.327274,-99) , 
0, 1.97047, 1, 0, 0.467294,-99) , 
1, 0.24368, 0, 0, 0.513609,-99)    );
  // itree = 353
  fBoostWeights.push_back(0.126196);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789517,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442081,-99) , 
1, 1.01915, 1, 0, 0.514106,-99) , 
2, 2.36092, 0, 0, 0.531762,-99) , 
NN(
0, 
0, 
-1, -0.323303, 1, -1, 0.44544,-99) , 
1, -0.140547, 0, 0, 0.496728,-99)    );
  // itree = 354
  fBoostWeights.push_back(0.121619);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491626,-99) , 
1, 0.599356, 1, 0, 0.552886,-99) , 
0, 0.788258, 1, 0, 0.564833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578249,-99) , 
NN(
0, 
0, 
-1, 0.0405198, 0, -1, 0.451801,-99) , 
1, -1.69666, 1, 0, 0.462887,-99) , 
3, 0.660714, 0, 0, 0.513739,-99)    );
  // itree = 355
  fBoostWeights.push_back(0.108329);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.330446, 0, 1, 0.572573,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409303,-99) , 
1, -0.642221, 0, 0, 0.490886,-99) , 
2, -0.307301, 1, 0, 0.514373,-99) , 
NN(
0, 
0, 
-1, 4.36094, 1, -1, 0.328071,-99) , 
0, 3.82707, 1, 0, 0.501124,-99)    );
  // itree = 356
  fBoostWeights.push_back(0.167258);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.145017, 1, 1, 0.553246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339575,-99) , 
3, -2.19006, 0, 0, 0.542142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492521,-99) , 
0, 4.0753, 1, 0, 0.573612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37045,-99) , 
1, -1.0903, 1, 0, 0.392195,-99) , 
0, 3.4673, 0, 0, 0.435946,-99) , 
0, 1.34675, 1, 0, 0.492795,-99)    );
  // itree = 357
  fBoostWeights.push_back(0.0950131);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591703,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316309,-99) , 
0, 4.00933, 1, 0, 0.483998,-99) , 
NN(
0, 
0, 
-1, 0.239402, 1, -1, 0.42039,-99) , 
3, 0.510023, 0, 0, 0.455785,-99) , 
0, -3.02657, 1, 0, 0.461818,-99)    );
  // itree = 358
  fBoostWeights.push_back(0.160086);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.637388, 1, 1, 0.562713,-99) , 
NN(
0, 
0, 
-1, -0.803896, 0, -1, 0.430377,-99) , 
3, -0.261783, 0, 0, 0.496237,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434524,-99) , 
1, 0.274441, 0, 0, 0.546826,-99) , 
NN(
0, 
0, 
-1, 1.33347, 1, -1, 0.412946,-99) , 
0, 3.85944, 0, 0, 0.430665,-99) , 
2, 0.433093, 1, 0, 0.460865,-99)    );
  // itree = 359
  fBoostWeights.push_back(0.0931024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470156,-99) , 
2, -1.49679, 1, 0, 0.479771,-99) , 
1, -1.2415, 1, 0, 0.486985,-99) , 
NN(
0, 
0, 
-1, -1.836, 1, -1, 0.384168,-99) , 
1, -1.4795, 0, 0, 0.478897,-99)    );
  // itree = 360
  fBoostWeights.push_back(0.177878);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.671461, 1, 1, 0.566496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374362,-99) , 
3, -1.09081, 0, 0, 0.552549,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436653,-99) , 
0, 0.0994007, 1, 0, 0.482463,-99) , 
NN(
0, 
0, 
-1, -0.772021, 1, -1, 0.338807,-99) , 
2, -0.0876524, 0, 0, 0.433273,-99) , 
1, -0.222879, 0, 0, 0.504948,-99)    );
  // itree = 361
  fBoostWeights.push_back(0.0891655);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384635,-99) , 
2, -1.49703, 0, 0, 0.538972,-99) , 
NN(
0, 
0, 
-1, 0.452559, 1, -1, 0.4826,-99) , 
1, 0.540064, 0, 0, 0.505735,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359669,-99) , 
3, 1.09634, 1, 0, 0.461765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289421,-99) , 
3, -0.617708, 0, 0, 0.427454,-99) , 
1, -1.20374, 0, 0, 0.495879,-99)    );
  // itree = 362
  fBoostWeights.push_back(0.128708);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49072, 0, 1, 0.550975,-99) , 
NN(
0, 
0, 
-1, -1.44609, 1, -1, 0.408516,-99) , 
1, -1.12614, 0, 0, 0.532856,-99) , 
NN(
0, 
0, 
-1, -1.74516, 0, -1, 0.361217,-99) , 
3, -1.09741, 0, 0, 0.516505,-99)    );
  // itree = 363
  fBoostWeights.push_back(0.140497);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04562, 1, 1, 0.573633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43414,-99) , 
1, 0.803192, 0, 0, 0.550846,-99) , 
NN(
NN(
0, 
0, 
-1, 1.03045, 0, 1, 0.537711,-99) , 
NN(
0, 
0, 
-1, 1.12457, 0, -1, 0.401703,-99) , 
1, -0.353718, 1, 0, 0.468131,-99) , 
1, 0.676124, 0, 0, 0.492641,-99)    );
  // itree = 364
  fBoostWeights.push_back(0.157431);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470695,-99) , 
0, 4.05105, 1, 0, 0.619755,-99) , 
NN(
0, 
0, 
-1, 1.71115, 1, -1, 0.437295,-99) , 
1, 0.491041, 1, 0, 0.546408,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444688,-99) , 
3, -1.19537, 0, 0, 0.517035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331862,-99) , 
3, 0.682746, 0, 0, 0.42887,-99) , 
0, 0.0832496, 1, 0, 0.473304,-99) , 
3, 1.45309, 0, 0, 0.496729,-99)    );
  // itree = 365
  fBoostWeights.push_back(0.134005);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.716614, 1, 1, 0.607811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69972,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447375,-99) , 
2, 2.75575, 0, 0, 0.454302,-99) , 
1, -1.92504, 1, 0, 0.463593,-99) , 
2, -1.05254, 1, 0, 0.479934,-99)    );
  // itree = 366
  fBoostWeights.push_back(0.110307);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668782,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436555,-99) , 
0, 3.20563, 1, 0, 0.497544,-99) , 
2, 1.7483, 1, 0, 0.557215,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470703,-99) , 
2, 0.88318, 0, 0, 0.48475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373646,-99) , 
0, 2.77557, 1, 0, 0.477741,-99) , 
2, 1.50224, 0, 0, 0.495154,-99)    );
  // itree = 367
  fBoostWeights.push_back(0.134616);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.81288, 1, 1, 0.585151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47494,-99) , 
3, -1.73909, 0, 0, 0.571967,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456844,-99) , 
0, 0.180043, 1, 0, 0.469471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286053,-99) , 
3, 0.0368887, 0, 0, 0.455971,-99) , 
2, -0.103661, 1, 0, 0.492184,-99)    );
  // itree = 368
  fBoostWeights.push_back(0.147616);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.01044, 1, 1, 0.561506,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40012,-99) , 
1, 1.4174, 0, 0, 0.450406,-99) , 
0, -2.20475, 1, 0, 0.469759,-99) , 
1, 0.600608, 1, 0, 0.530362,-99)    );
  // itree = 369
  fBoostWeights.push_back(0.0901111);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488336,-99) , 
0, 2.87764, 1, 0, 0.620584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387433,-99) , 
2, 2.31163, 0, 0, 0.485957,-99) , 
2, 1.98, 1, 0, 0.560351,-99) , 
NN(
0, 
0, 
-1, 1.99163, 1, -1, 0.4727,-99) , 
3, 1.81596, 0, 0, 0.491543,-99)    );
  // itree = 370
  fBoostWeights.push_back(0.140405);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334655,-99) , 
2, -0.233325, 1, 0, 0.599429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446383,-99) , 
3, -0.0570325, 0, 0, 0.507013,-99) , 
1, 0.0102893, 1, 0, 0.550204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482612,-99) , 
0, 0.414314, 1, 0, 0.500322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363746,-99) , 
3, 0.0939702, 0, 0, 0.487885,-99) , 
2, -0.00319363, 1, 0, 0.51054,-99)    );
  // itree = 371
  fBoostWeights.push_back(0.125764);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31094, 0, 1, 0.546343,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284301,-99) , 
3, 2.92861, 0, 0, 0.408623,-99) , 
3, 2.44437, 1, 0, 0.529941,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626388,-99) , 
NN(
0, 
0, 
-1, 0.692136, 1, -1, 0.423397,-99) , 
3, 2.15376, 0, 0, 0.450951,-99) , 
1, -0.609131, 0, 0, 0.508336,-99)    );
  // itree = 372
  fBoostWeights.push_back(0.125985);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46997,-99) , 
0, 1.32074, 1, 0, 0.522103,-99) , 
NN(
0, 
0, 
-1, 2.04031, 1, -1, 0.306351,-99) , 
1, 1.70838, 1, 0, 0.510005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19324,-99) , 
0, 4.29394, 1, 0, 0.501564,-99)    );
  // itree = 373
  fBoostWeights.push_back(0.142419);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.23217, 1, 1, 0.614395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408099,-99) , 
2, 0.617963, 0, 0, 0.485627,-99) , 
1, -1.41138, 0, 0, 0.566756,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459068,-99) , 
2, 1.10272, 1, 0, 0.512764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399064,-99) , 
2, -0.454502, 1, 0, 0.453715,-99) , 
0, 0.628662, 0, 0, 0.488818,-99) , 
1, -0.6651, 1, 0, 0.50878,-99)    );
  // itree = 374
  fBoostWeights.push_back(0.195004);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.975059, 1, 1, 0.616129,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417478,-99) , 
1, -0.91687, 1, 0, 0.547539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408158,-99) , 
1, 1.33564, 0, 0, 0.431748,-99) , 
1, -0.770134, 1, 0, 0.457892,-99) , 
3, 1.60749, 0, 0, 0.505152,-99)    );
  // itree = 375
  fBoostWeights.push_back(0.116581);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.816901, 0, 1, 0.568692,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408124,-99) , 
0, 2.28008, 0, 0, 0.480572,-99) , 
0, 1.7089, 1, 0, 0.520323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525328,-99) , 
NN(
0, 
0, 
-1, -1.80813, 1, -1, 0.404805,-99) , 
3, -0.392392, 0, 0, 0.428383,-99) , 
3, -0.135109, 0, 0, 0.493659,-99)    );
  // itree = 376
  fBoostWeights.push_back(0.162608);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.00423745, 1, 1, 0.564767,-99) , 
NN(
0, 
0, 
-1, 1.10925, 0, -1, 0.4281,-99) , 
1, 1.15845, 1, 0, 0.542735,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445168,-99) , 
0, -2.72346, 0, 0, 0.574524,-99) , 
NN(
0, 
0, 
-1, -0.696409, 0, -1, 0.400404,-99) , 
0, -1.8187, 1, 0, 0.44944,-99) , 
3, 0.119685, 0, 0, 0.510413,-99)    );
  // itree = 377
  fBoostWeights.push_back(0.148849);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477892,-99) , 
3, -1.30281, 0, 0, 0.62403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329553,-99) , 
0, -1.6576, 1, 0, 0.450314,-99) , 
1, -0.323188, 0, 0, 0.560367,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449986,-99) , 
0, -0.463454, 1, 0, 0.464744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304208,-99) , 
1, -1.67996, 0, 0, 0.454619,-99) , 
2, -0.562552, 1, 0, 0.475085,-99)    );
  // itree = 378
  fBoostWeights.push_back(0.107442);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679291,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471659,-99) , 
0, 2.39515, 1, 0, 0.534273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377434,-99) , 
0, 0.632146, 1, 0, 0.488583,-99) , 
3, 0.850977, 0, 0, 0.509968,-99) , 
1, -1.91975, 1, 0, 0.517028,-99)    );
  // itree = 379
  fBoostWeights.push_back(0.111634);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773562,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447119,-99) , 
2, 2.14657, 1, 0, 0.55555,-99) , 
NN(
0, 
0, 
-1, 1.1063, 1, -1, 0.468706,-99) , 
3, 1.33199, 0, 0, 0.499296,-99) , 
2, 2.72568, 0, 0, 0.510565,-99)    );
  // itree = 380
  fBoostWeights.push_back(0.113443);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17578, 1, 1, 0.580207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417267,-99) , 
2, 2.66469, 1, 0, 0.563039,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443614,-99) , 
1, -0.289325, 1, 0, 0.475536,-99) , 
1, 1.61873, 0, 0, 0.483571,-99) , 
3, 1.28198, 0, 0, 0.513394,-99)    );
  // itree = 381
  fBoostWeights.push_back(0.121458);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42064, 0, 1, 0.646518,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480628,-99) , 
1, -0.585635, 1, 0, 0.505526,-99) , 
2, 0.811748, 1, 0, 0.526331,-99) , 
NN(
NN(
0, 
0, 
-1, -0.941956, 1, 1, 0.548037,-99) , 
NN(
0, 
0, 
-1, 0.0580357, 0, -1, 0.417484,-99) , 
2, -0.218432, 1, 0, 0.475175,-99) , 
3, 1.13138, 0, 0, 0.496026,-99)    );
  // itree = 382
  fBoostWeights.push_back(0.0950515);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732122,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438031,-99) , 
1, -0.133445, 1, 0, 0.577722,-99) , 
2, -1.4313, 0, 0, 0.63794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477864,-99) , 
1, -0.541154, 1, 0, 0.494051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311593,-99) , 
0, -1.6268, 0, 0, 0.48631,-99) , 
0, -2.0844, 1, 0, 0.502146,-99)    );
  // itree = 383
  fBoostWeights.push_back(0.107733);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.55768, 0, 1, 0.552791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380015,-99) , 
3, 3.12769, 1, 0, 0.545957,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471506,-99) , 
0, -2.54333, 1, 0, 0.48741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362964,-99) , 
2, -1.80324, 0, 0, 0.472269,-99) , 
3, 0.101414, 0, 0, 0.523011,-99)    );
  // itree = 384
  fBoostWeights.push_back(0.0798578);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622843,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482756,-99) , 
3, -0.513104, 1, 0, 0.491409,-99) , 
NN(
0, 
0, 
-1, -1.59588, 1, -1, 0.381736,-99) , 
3, -0.777468, 0, 0, 0.477857,-99) , 
2, -1.82943, 1, 0, 0.484749,-99)    );
  // itree = 385
  fBoostWeights.push_back(0.135641);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335307,-99) , 
0, 3.94056, 1, 0, 0.532605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441596,-99) , 
2, -1.5776, 1, 0, 0.461545,-99) , 
3, 0.262665, 0, 0, 0.506051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586766,-99) , 
NN(
0, 
0, 
-1, 1.78232, 0, -1, 0.347305,-99) , 
0, -1.19112, 1, 0, 0.392371,-99) , 
1, -1.19786, 0, 0, 0.490873,-99)    );
  // itree = 386
  fBoostWeights.push_back(0.0898164);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488903,-99) , 
3, 0.822759, 0, 0, 0.518122,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395056,-99) , 
2, 1.96817, 1, 0, 0.43818,-99) , 
2, 1.71639, 1, 0, 0.504828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333177,-99) , 
1, 2.09463, 1, 0, 0.499596,-99)    );
  // itree = 387
  fBoostWeights.push_back(0.13957);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.912674, 0, 1, 0.565723,-99) , 
NN(
NN(
0, 
0, 
-1, 3.13466, 1, 1, 0.599359,-99) , 
NN(
0, 
0, 
-1, 2.51316, 1, -1, 0.429108,-99) , 
3, 2.76795, 0, 0, 0.471049,-99) , 
2, 1.20636, 1, 0, 0.53765,-99)    );
  // itree = 388
  fBoostWeights.push_back(0.1293);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459502,-99) , 
3, -1.07836, 0, 0, 0.682074,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498107,-99) , 
2, -0.960222, 1, 0, 0.542229,-99) , 
1, 0.549205, 0, 0, 0.581813,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340861,-99) , 
0, 0.388542, 0, 0, 0.506645,-99) , 
NN(
0, 
0, 
-1, 1.77323, 0, -1, 0.318032,-99) , 
1, 1.36272, 1, 0, 0.48555,-99) , 
0, 0.0405602, 1, 0, 0.517585,-99)    );
  // itree = 389
  fBoostWeights.push_back(0.075202);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.09929, 1, 1, 0.62888,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482667,-99) , 
1, 1.26981, 0, 0, 0.493303,-99) , 
1, -1.76789, 1, 0, 0.500833,-99) , 
NN(
0, 
0, 
-1, 2.13288, 0, -1, 0.310873,-99) , 
0, 3.81421, 1, 0, 0.490416,-99)    );
  // itree = 390
  fBoostWeights.push_back(0.126801);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463036,-99) , 
1, -1.5066, 0, 0, 0.60134,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258315,-99) , 
1, -0.237412, 0, 0, 0.482727,-99) , 
1, -0.453398, 1, 0, 0.520328,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462105,-99) , 
3, 2.37749, 0, 0, 0.484612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346724,-99) , 
0, 4.08534, 1, 0, 0.474882,-99) , 
0, 0.634597, 1, 0, 0.494546,-99)    );
  // itree = 391
  fBoostWeights.push_back(0.150725);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479795,-99) , 
1, 0.486188, 0, 0, 0.60655,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456703,-99) , 
0, 0.0989493, 1, 0, 0.531679,-99) , 
3, 1.27655, 0, 0, 0.561015,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469517,-99) , 
0, -0.0246049, 1, 0, 0.49556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377254,-99) , 
2, -1.53371, 0, 0, 0.48646,-99) , 
1, -0.222879, 0, 0, 0.532469,-99)    );
  // itree = 392
  fBoostWeights.push_back(0.126679);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.983242, 0, 1, 0.556698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377486,-99) , 
3, 2.04737, 0, 0, 0.476102,-99) , 
0, 2.11939, 1, 0, 0.503014,-99) , 
0, 1.85781, 1, 0, 0.53994,-99)    );
  // itree = 393
  fBoostWeights.push_back(0.0839963);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651129,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431772,-99) , 
3, -1.07571, 0, 0, 0.515576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359365,-99) , 
0, 3.9059, 1, 0, 0.508589,-99) , 
3, 3.36925, 0, 0, 0.514102,-99)    );
  // itree = 394
  fBoostWeights.push_back(0.132061);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.53629, 0, 1, 0.600793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438794,-99) , 
0, 3.93532, 1, 0, 0.567568,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493797,-99) , 
1, -0.151103, 0, 0, 0.519943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403104,-99) , 
0, -1.57186, 1, 0, 0.424331,-99) , 
1, 0.246589, 1, 0, 0.477038,-99) , 
3, 1.77444, 0, 0, 0.498945,-99)    );
  // itree = 395
  fBoostWeights.push_back(0.168215);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40931,-99) , 
3, 1.6203, 1, 0, 0.613392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436559,-99) , 
2, -0.372431, 1, 0, 0.502017,-99) , 
3, 0.464766, 0, 0, 0.539927,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485148,-99) , 
1, -0.121587, 0, 0, 0.564497,-99) , 
NN(
0, 
0, 
-1, -0.328404, 0, -1, 0.418713,-99) , 
0, 3.59876, 0, 0, 0.467095,-99) , 
0, 2.02582, 1, 0, 0.518369,-99)    );
  // itree = 396
  fBoostWeights.push_back(0.155425);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484681,-99) , 
1, 0.600608, 1, 0, 0.542531,-99) , 
NN(
0, 
0, 
-1, 1.96488, 0, -1, 0.434796,-99) , 
2, 1.5889, 1, 0, 0.520106,-99) , 
NN(
0, 
0, 
-1, -1.70046, 1, -1, 0.291554,-99) , 
3, -0.73012, 0, 0, 0.48775,-99)    );
  // itree = 397
  fBoostWeights.push_back(0.148237);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.111875, 1, 1, 0.605411,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469436,-99) , 
2, 0.951641, 1, 0, 0.502838,-99) , 
0, 2.05335, 1, 0, 0.540485,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395704,-99) , 
3, -0.68294, 0, 0, 0.490603,-99) , 
NN(
0, 
0, 
-1, 0.667085, 1, -1, 0.371343,-99) , 
0, 0.719501, 1, 0, 0.46796,-99) , 
3, 0.969707, 0, 0, 0.499733,-99)    );
  // itree = 398
  fBoostWeights.push_back(0.070667);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.18481, 1, 1, 0.539046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501288,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346301,-99) , 
3, -0.548867, 0, 0, 0.479748,-99) , 
1, -0.291557, 1, 0, 0.50193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251208,-99) , 
2, -1.86573, 0, 0, 0.494408,-99)    );
  // itree = 399
  fBoostWeights.push_back(0.159396);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381074,-99) , 
0, -1.79788, 1, 0, 0.486915,-99) , 
2, -0.414908, 0, 0, 0.558086,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428378,-99) , 
3, 2.50402, 1, 0, 0.484052,-99) , 
NN(
0, 
0, 
-1, 0.0961895, 1, -1, 0.414752,-99) , 
3, 1.63495, 0, 0, 0.440724,-99) , 
0, -1.03312, 1, 0, 0.462699,-99)    );
  // itree = 400
  fBoostWeights.push_back(0.162808);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482009,-99) , 
3, 2.85803, 0, 0, 0.565894,-99) , 
1, -0.492097, 1, 0, 0.613655,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4972,-99) , 
3, 1.74286, 1, 0, 0.572945,-99) , 
NN(
0, 
0, 
-1, 1.36642, 1, -1, 0.430715,-99) , 
2, 1.44073, 0, 0, 0.445783,-99) , 
3, 2.14308, 0, 0, 0.476517,-99)    );
  // itree = 401
  fBoostWeights.push_back(0.0653393);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.272657, 0, 1, 0.572952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486971,-99) , 
1, 1.58367, 0, 0, 0.495994,-99) , 
0, -0.925382, 1, 0, 0.508002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364881,-99) , 
3, -1.59439, 0, 0, 0.501985,-99)    );
  // itree = 402
  fBoostWeights.push_back(0.0937118);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719626,-99) , 
NN(
NN(
0, 
0, 
-1, -2.80147, 1, 1, 0.533528,-99) , 
NN(
0, 
0, 
-1, 1.17933, 1, -1, 0.433612,-99) , 
1, -0.895139, 0, 0, 0.519515,-99) , 
1, -1.92949, 1, 0, 0.528979,-99)    );
  // itree = 403
  fBoostWeights.push_back(0.137152);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496482,-99) , 
1, 1.2513, 1, 0, 0.650854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359612,-99) , 
1, 0.0275435, 1, 0, 0.522258,-99) , 
1, 0.401414, 0, 0, 0.581245,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464056,-99) , 
0, 1.89077, 0, 0, 0.590344,-99) , 
NN(
0, 
0, 
-1, 1.31216, 1, -1, 0.453631,-99) , 
3, 1.43868, 0, 0, 0.465756,-99) , 
3, 1.81596, 0, 0, 0.49287,-99)    );
  // itree = 404
  fBoostWeights.push_back(0.122455);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.441953, 0, 1, 0.699108,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489749,-99) , 
1, -0.10539, 0, 0, 0.536174,-99) , 
1, 1.38062, 0, 0, 0.553932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570618,-99) , 
NN(
0, 
0, 
-1, 0.418306, 0, -1, 0.443492,-99) , 
2, 2.46263, 0, 0, 0.456567,-99) , 
0, 1.34675, 1, 0, 0.511448,-99)    );
  // itree = 405
  fBoostWeights.push_back(0.0978385);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.668836, 1, 1, 0.538216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359702,-99) , 
2, 2.56977, 1, 0, 0.531991,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354842,-99) , 
2, 0.111202, 0, 0, 0.444297,-99) , 
1, 1.36178, 1, 0, 0.521966,-99)    );
  // itree = 406
  fBoostWeights.push_back(0.126551);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.14912, 1, 1, 0.594324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48077,-99) , 
0, -1.30548, 1, 0, 0.514623,-99) , 
2, 0.843676, 0, 0, 0.547016,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471177,-99) , 
1, 0.949412, 1, 0, 0.52799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294658,-99) , 
1, 0.372333, 1, 0, 0.451592,-99) , 
1, 0.57046, 0, 0, 0.491885,-99) , 
1, -0.259227, 1, 0, 0.51267,-99)    );
  // itree = 407
  fBoostWeights.push_back(0.171804);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29943, 1, 1, 0.658471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457335,-99) , 
3, -0.304384, 0, 0, 0.602427,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437773,-99) , 
3, -0.144556, 0, 0, 0.614736,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436587,-99) , 
2, 1.9931, 0, 0, 0.452751,-99) , 
1, 1.28334, 0, 0, 0.475754,-99) , 
1, -1.0472, 1, 0, 0.491854,-99)    );
  // itree = 408
  fBoostWeights.push_back(0.163566);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486742,-99) , 
2, 1.32093, 1, 0, 0.641105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400749,-99) , 
0, 2.86792, 1, 0, 0.50934,-99) , 
1, 0.634736, 1, 0, 0.554423,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447485,-99) , 
1, -0.685588, 0, 0, 0.499662,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23506,-99) , 
1, 0.0653467, 1, 0, 0.342483,-99) , 
1, -0.0179449, 1, 0, 0.476077,-99) , 
1, 0.157336, 0, 0, 0.5146,-99)    );
  // itree = 409
  fBoostWeights.push_back(0.0920832);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.957336, 1, 1, 0.529215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404485,-99) , 
1, -1.88627, 0, 0, 0.521173,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44082,-99) , 
3, -0.502144, 1, 0, 0.46953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23716,-99) , 
3, 2.5186, 1, 0, 0.442784,-99) , 
1, 0.889902, 1, 0, 0.503383,-99)    );
  // itree = 410
  fBoostWeights.push_back(0.0898061);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.41248, 0, 1, 0.595809,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427591,-99) , 
3, 0.257805, 0, 0, 0.503161,-99) , 
0, -0.615757, 1, 0, 0.520507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375498,-99) , 
3, -1.80839, 0, 0, 0.514654,-99)    );
  // itree = 411
  fBoostWeights.push_back(0.122152);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.267, 0, 1, 0.579831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455407,-99) , 
1, -0.876828, 1, 0, 0.491462,-99) , 
2, -0.606118, 0, 0, 0.548604,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488468,-99) , 
3, 1.52221, 1, 0, 0.506686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370271,-99) , 
3, 0.984807, 0, 0, 0.488354,-99) , 
2, 0.779872, 1, 0, 0.525283,-99)    );
  // itree = 412
  fBoostWeights.push_back(0.0972865);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.762711, 1, 1, 0.540308,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315974,-99) , 
0, -1.57325, 1, 0, 0.455038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296928,-99) , 
1, 0.549205, 1, 0, 0.407789,-99) , 
3, -0.681783, 0, 0, 0.52245,-99)    );
  // itree = 413
  fBoostWeights.push_back(0.174937);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420717,-99) , 
3, -0.65878, 0, 0, 0.563348,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364071,-99) , 
2, 1.98371, 0, 0, 0.416199,-99) , 
2, 0.982694, 1, 0, 0.509862,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436086,-99) , 
2, -0.711562, 1, 0, 0.451231,-99) , 
NN(
0, 
0, 
-1, -0.376889, 0, -1, 0.332702,-99) , 
1, -0.285702, 0, 0, 0.438866,-99) , 
1, -0.47598, 1, 0, 0.461575,-99)    );
  // itree = 414
  fBoostWeights.push_back(0.108855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482979,-99) , 
3, 0.25205, 0, 0, 0.544408,-99) , 
0, -2.25273, 1, 0, 0.556262,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492274,-99) , 
2, -0.386499, 0, 0, 0.537697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423597,-99) , 
3, 1.08352, 0, 0, 0.47289,-99) , 
0, -0.602658, 1, 0, 0.488749,-99) , 
1, 0.360265, 0, 0, 0.516256,-99)    );
  // itree = 415
  fBoostWeights.push_back(0.153169);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.841123, 0, 1, 0.606115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341725,-99) , 
1, 0.316082, 1, 0, 0.455839,-99) , 
0, 3.57201, 1, 0, 0.56329,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33921,-99) , 
3, -1.82919, 0, 0, 0.527904,-99) , 
NN(
0, 
0, 
-1, -0.509551, 0, -1, 0.439327,-99) , 
0, -1.57186, 1, 0, 0.454083,-99) , 
3, 1.60825, 0, 0, 0.484178,-99)    );
  // itree = 416
  fBoostWeights.push_back(0.154812);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30009, 0, 1, 0.556019,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390488,-99) , 
1, 0.765799, 0, 0, 0.432,-99) , 
0, 2.32829, 1, 0, 0.522818,-99) , 
NN(
0, 
0, 
-1, 0.395137, 0, -1, 0.321004,-99) , 
1, -1.44722, 0, 0, 0.506428,-99)    );
  // itree = 417
  fBoostWeights.push_back(0.0842953);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93857, 0, 1, 0.517761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359123,-99) , 
2, -1.67023, 0, 0, 0.508629,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389633,-99) , 
2, 2.30771, 1, 0, 0.499057,-99) , 
NN(
0, 
0, 
-1, 1.93103, 1, -1, 0.378821,-99) , 
3, 2.22506, 0, 0, 0.446977,-99) , 
0, 2.32829, 1, 0, 0.492681,-99)    );
  // itree = 418
  fBoostWeights.push_back(0.153736);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.428643, 0, 1, 0.61244,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479388,-99) , 
3, 1.21862, 0, 0, 0.499237,-99) , 
1, -0.160567, 1, 0, 0.547142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4335,-99) , 
1, 1.49419, 1, 0, 0.57615,-99) , 
NN(
0, 
0, 
-1, 1.82713, 0, -1, 0.405501,-99) , 
1, 0.190888, 0, 0, 0.478266,-99) , 
0, 2.14845, 1, 0, 0.528556,-99)    );
  // itree = 419
  fBoostWeights.push_back(0.127897);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.1364, 1, 1, 0.577163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441055,-99) , 
3, -1.70976, 0, 0, 0.560746,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441186,-99) , 
2, 0.950001, 0, 0, 0.485117,-99) , 
NN(
0, 
0, 
-1, 2.60798, 0, -1, 0.367444,-99) , 
2, 2.21561, 1, 0, 0.474816,-99) , 
3, 0.24633, 1, 0, 0.507116,-99)    );
  // itree = 420
  fBoostWeights.push_back(0.139037);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.377057, 0, 1, 0.607226,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456908,-99) , 
1, 1.25069, 0, 0, 0.477743,-99) , 
0, -0.676148, 1, 0, 0.500659,-99) , 
NN(
0, 
0, 
-1, 0.441016, 0, -1, 0.323726,-99) , 
2, -1.47706, 0, 0, 0.489678,-99)    );
  // itree = 421
  fBoostWeights.push_back(0.122518);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479516,-99) , 
2, 0.504571, 1, 0, 0.512217,-99) , 
1, -1.59723, 1, 0, 0.522537,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407509,-99) , 
3, -1.94928, 0, 0, 0.517487,-99) , 
NN(
0, 
0, 
-1, -1.18505, 0, -1, 0.348773,-99) , 
2, -1.37014, 1, 0, 0.412775,-99) , 
3, -0.511252, 0, 0, 0.502872,-99)    );
  // itree = 422
  fBoostWeights.push_back(0.159964);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0422974, 0, 1, 0.724387,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491995,-99) , 
2, -0.26572, 0, 0, 0.570585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43857,-99) , 
2, 1.03895, 0, 0, 0.461147,-99) , 
1, 0.794761, 1, 0, 0.541638,-99) , 
2, 2.48633, 0, 0, 0.552439,-99)    );
  // itree = 423
  fBoostWeights.push_back(0.0631261);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41589,-99) , 
2, 1.32272, 1, 0, 0.495663,-99) , 
3, 2.27575, 0, 0, 0.504622,-99) , 
NN(
0, 
0, 
-1, 1.74808, 1, -1, 0.399522,-99) , 
0, 3.36726, 1, 0, 0.493596,-99)    );
  // itree = 424
  fBoostWeights.push_back(0.170479);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422872,-99) , 
1, -0.663377, 1, 0, 0.685404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395837,-99) , 
1, 0.260907, 0, 0, 0.496294,-99) , 
1, -0.492214, 1, 0, 0.560821,-99) , 
NN(
0, 
0, 
-1, 4.43344, 1, -1, 0.469188,-99) , 
3, 0.789529, 1, 0, 0.518152,-99)    );
  // itree = 425
  fBoostWeights.push_back(0.132521);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.174328, 1, 1, 0.608364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33292,-99) , 
2, 2.62676, 1, 0, 0.529262,-99) , 
0, 1.24858, 1, 0, 0.547523,-99) , 
NN(
NN(
0, 
0, 
-1, -1.69653, 1, 1, 0.558216,-99) , 
NN(
0, 
0, 
-1, 1.65286, 1, -1, 0.425624,-99) , 
1, -0.941956, 1, 0, 0.449076,-99) , 
3, 0.262665, 0, 0, 0.509627,-99)    );
  // itree = 426
  fBoostWeights.push_back(0.0513874);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479987,-99) , 
3, -1.88431, 0, 0, 0.605078,-99) , 
NN(
0, 
0, 
-1, -0.90937, 0, -1, 0.484872,-99) , 
2, -1.50483, 1, 0, 0.492723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35093,-99) , 
0, 4.51992, 1, 0, 0.488897,-99)    );
  // itree = 427
  fBoostWeights.push_back(0.139508);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.601641, 1, 1, 0.546134,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434714,-99) , 
2, -0.000211103, 1, 0, 0.455023,-99) , 
1, 0.296887, 0, 0, 0.491305,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434393,-99) , 
2, -1.27651, 1, 0, 0.468789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308304,-99) , 
3, -0.357233, 1, 0, 0.429676,-99) , 
3, -0.0940813, 0, 0, 0.473905,-99)    );
  // itree = 428
  fBoostWeights.push_back(0.0978353);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 4.43487, 1, 1, 0.631674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469808,-99) , 
2, 0.524986, 1, 0, 0.506163,-99) , 
2, 2.18345, 0, 0, 0.51751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346204,-99) , 
3, -1.59453, 0, 0, 0.5088,-99)    );
  // itree = 429
  fBoostWeights.push_back(0.138166);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492744,-99) , 
1, 0.98566, 1, 0, 0.557739,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382974,-99) , 
1, 0.33177, 0, 0, 0.463572,-99) , 
2, 2.00634, 1, 0, 0.548184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599188,-99) , 
NN(
0, 
0, 
-1, -0.399646, 1, -1, 0.403494,-99) , 
1, 0.595536, 0, 0, 0.458203,-99) , 
3, -0.79257, 0, 0, 0.534616,-99)    );
  // itree = 430
  fBoostWeights.push_back(0.109392);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67836, 1, 1, 0.655096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471615,-99) , 
3, -0.353491, 0, 0, 0.50861,-99) , 
1, 1.38062, 0, 0, 0.523027,-99) , 
NN(
NN(
0, 
0, 
-1, 2.53541, 1, 1, 0.595503,-99) , 
NN(
0, 
0, 
-1, 2.00592, 0, -1, 0.436486,-99) , 
3, 2.93313, 0, 0, 0.457687,-99) , 
0, 1.36646, 1, 0, 0.495431,-99)    );
  // itree = 431
  fBoostWeights.push_back(0.111192);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39941,-99) , 
2, 1.25688, 1, 0, 0.5267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441189,-99) , 
2, 1.19126, 0, 0, 0.459286,-99) , 
1, 0.945061, 0, 0, 0.473903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318042,-99) , 
3, 2.83714, 1, 0, 0.389304,-99) , 
0, 3.68367, 1, 0, 0.468111,-99)    );
  // itree = 432
  fBoostWeights.push_back(0.135007);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -3.67021, 0, 1, 0.68182,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357603,-99) , 
0, 3.92808, 1, 0, 0.526076,-99) , 
NN(
0, 
0, 
-1, 0.915355, 1, -1, 0.44089,-99) , 
3, 0.907254, 0, 0, 0.482493,-99) , 
0, -2.92224, 1, 0, 0.493276,-99)    );
  // itree = 433
  fBoostWeights.push_back(0.11176);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0162803, 0, 1, 0.66831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463797,-99) , 
1, -1.05476, 0, 0, 0.53992,-99) , 
0, 1.8256, 1, 0, 0.622467,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490297,-99) , 
1, -0.376665, 0, 0, 0.622163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496477,-99) , 
0, -2.53151, 1, 0, 0.504418,-99) , 
1, -0.286637, 1, 0, 0.517525,-99) , 
1, -0.47598, 1, 0, 0.547281,-99)    );
  // itree = 434
  fBoostWeights.push_back(0.13147);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644309,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458397,-99) , 
1, -0.585236, 0, 0, 0.513944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437832,-99) , 
1, 1.47554, 0, 0, 0.459579,-99) , 
1, -0.0940963, 1, 0, 0.481772,-99) , 
1, -2.15414, 1, 0, 0.486375,-99)    );
  // itree = 435
  fBoostWeights.push_back(0.127741);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.251291, 0, 1, 0.676647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499189,-99) , 
1, 0.122903, 1, 0, 0.553832,-99) , 
3, 1.6282, 1, 0, 0.576695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482525,-99) , 
0, -0.0881587, 0, 0, 0.52353,-99) , 
NN(
0, 
0, 
-1, 0.980208, 0, -1, 0.38093,-99) , 
0, 1.26282, 1, 0, 0.500711,-99) , 
3, 1.3077, 0, 0, 0.528223,-99)    );
  // itree = 436
  fBoostWeights.push_back(0.141415);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05522, 0, 1, 0.651797,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458791,-99) , 
0, 2.01888, 0, 0, 0.511163,-99) , 
0, 1.46956, 1, 0, 0.550736,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443777,-99) , 
1, -0.505168, 0, 0, 0.532598,-99) , 
NN(
0, 
0, 
-1, -0.218796, 0, -1, 0.413781,-99) , 
3, -0.0887179, 1, 0, 0.483179,-99) , 
2, 0.337657, 0, 0, 0.519195,-99)    );
  // itree = 437
  fBoostWeights.push_back(0.134188);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493624,-99) , 
0, 2.81095, 1, 0, 0.557264,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388337,-99) , 
1, -1.99083, 1, 0, 0.444769,-99) , 
1, -1.33594, 0, 0, 0.545788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297781,-99) , 
2, 0.422296, 0, 0, 0.40613,-99) , 
1, 1.68967, 1, 0, 0.534943,-99)    );
  // itree = 438
  fBoostWeights.push_back(0.0624997);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.77661, 1, 1, 0.598309,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43,-99) , 
3, -1.71908, 0, 0, 0.590382,-99) , 
NN(
0, 
0, 
-1, -1.55783, 0, -1, 0.488022,-99) , 
0, -2.00784, 1, 0, 0.495285,-99) , 
1, -1.23334, 1, 0, 0.507693,-99)    );
  // itree = 439
  fBoostWeights.push_back(0.111756);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.386181, 0, 1, 0.672897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428584,-99) , 
2, -0.639373, 0, 0, 0.496657,-99) , 
1, -0.020627, 1, 0, 0.584992,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493802,-99) , 
0, 3.09526, 0, 0, 0.512408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323191,-99) , 
0, 4.00475, 1, 0, 0.502266,-99) , 
0, -0.686121, 1, 0, 0.522025,-99)    );
  // itree = 440
  fBoostWeights.push_back(0.162141);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496401,-99) , 
3, -0.776089, 0, 0, 0.585741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403634,-99) , 
2, 0.573713, 0, 0, 0.528451,-99) , 
2, 0.209801, 1, 0, 0.551466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278408,-99) , 
1, 2.05652, 0, 0, 0.411777,-99) , 
1, 1.718, 1, 0, 0.543367,-99)    );
  // itree = 441
  fBoostWeights.push_back(0.127044);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.550667, 1, 1, 0.554102,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456395,-99) , 
3, -1.15519, 0, 0, 0.550749,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422947,-99) , 
1, -0.645317, 1, 0, 0.447297,-99) , 
2, -1.07978, 1, 0, 0.480532,-99) , 
2, -0.148863, 0, 0, 0.531245,-99)    );
  // itree = 442
  fBoostWeights.push_back(0.0886988);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480625,-99) , 
0, -3.23868, 0, 0, 0.651505,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428779,-99) , 
3, 3.22286, 1, 0, 0.577981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379336,-99) , 
2, 1.37561, 1, 0, 0.489664,-99) , 
3, 2.17509, 0, 0, 0.505952,-99) , 
2, -1.4575, 1, 0, 0.517837,-99)    );
  // itree = 443
  fBoostWeights.push_back(0.0612385);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -3.58247, 0, 1, 0.653941,-99) , 
NN(
NN(
0, 
0, 
-1, 2.62716, 1, 1, 0.568884,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296901,-99) , 
2, 1.75425, 1, 0, 0.487171,-99) , 
3, 2.38336, 0, 0, 0.498637,-99) , 
0, -2.68497, 1, 0, 0.509118,-99)    );
  // itree = 444
  fBoostWeights.push_back(0.110067);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.619031, 1, 1, 0.693562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679336,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434642,-99) , 
2, 1.06965, 1, 0, 0.490297,-99) , 
3, 3.35257, 0, 0, 0.499077,-99) , 
2, -1.46585, 1, 0, 0.516541,-99)    );
  // itree = 445
  fBoostWeights.push_back(0.121595);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790961,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380483,-99) , 
1, 1.15845, 1, 0, 0.502627,-99) , 
0, 0.327101, 1, 0, 0.520615,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442727,-99) , 
1, 0.585742, 1, 0, 0.516179,-99) , 
NN(
0, 
0, 
-1, -0.126205, 0, -1, 0.390975,-99) , 
0, -0.685886, 1, 0, 0.464457,-99) , 
3, 0.262665, 0, 0, 0.499859,-99)    );
  // itree = 446
  fBoostWeights.push_back(0.106169);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493351,-99) , 
0, -0.335205, 0, 0, 0.627508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490447,-99) , 
0, -2.06479, 1, 0, 0.502598,-99) , 
1, -1.21085, 1, 0, 0.514724,-99) , 
NN(
0, 
0, 
-1, 0.94546, 0, -1, 0.41851,-99) , 
2, 0.774735, 1, 0, 0.472448,-99)    );
  // itree = 447
  fBoostWeights.push_back(0.155285);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472086,-99) , 
3, 2.78062, 1, 0, 0.665196,-99) , 
NN(
0, 
0, 
-1, 0.743399, 1, 1, 0.534658,-99) , 
3, 1.69732, 0, 0, 0.573559,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422571,-99) , 
3, -1.02292, 0, 0, 0.505513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393566,-99) , 
3, 2.58583, 0, 0, 0.425209,-99) , 
0, 0.636132, 1, 0, 0.460866,-99) , 
1, 0.606847, 0, 0, 0.498744,-99)    );
  // itree = 448
  fBoostWeights.push_back(0.177534);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447832,-99) , 
3, -1.80329, 0, 0, 0.561745,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412958,-99) , 
3, -0.27314, 1, 0, 0.422054,-99) , 
NN(
0, 
0, 
-1, -1.84576, 0, -1, 0.320039,-99) , 
3, -0.797349, 0, 0, 0.413847,-99) , 
2, -1.47706, 1, 0, 0.42447,-99)    );
  // itree = 449
  fBoostWeights.push_back(0.0879409);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -3.31992, 0, 1, 0.652479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482912,-99) , 
1, 0.478328, 1, 0, 0.598064,-99) , 
NN(
0, 
0, 
-1, 2.96336, 1, -1, 0.461781,-99) , 
0, -2.17846, 1, 0, 0.472632,-99)    );
  // itree = 450
  fBoostWeights.push_back(0.107844);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712325,-99) , 
NN(
NN(
0, 
0, 
-1, 1.74924, 1, 1, 0.53538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444786,-99) , 
2, -0.793683, 1, 0, 0.465775,-99) , 
3, 1.41476, 0, 0, 0.488951,-99) , 
1, 2.07327, 0, 0, 0.497456,-99)    );
  // itree = 451
  fBoostWeights.push_back(0.0585597);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.877657, 0, 1, 0.596061,-99) , 
NN(
NN(
0, 
0, 
-1, -2.75707, 1, 1, 0.510588,-99) , 
NN(
0, 
0, 
-1, -1.09106, 0, -1, 0.450861,-99) , 
1, 0.664305, 1, 0, 0.490309,-99) , 
1, -1.39121, 1, 0, 0.498445,-99)    );
  // itree = 452
  fBoostWeights.push_back(0.123414);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -3.62211, 0, 1, 0.653118,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370511,-99) , 
3, -0.851647, 0, 0, 0.540968,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418949,-99) , 
3, 0.969686, 0, 0, 0.458947,-99) , 
1, 0.0929281, 0, 0, 0.497801,-99) , 
0, -2.86752, 1, 0, 0.505989,-99)    );
  // itree = 453
  fBoostWeights.push_back(0.172607);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.17783, 1, 1, 0.573361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409195,-99) , 
3, 0.381274, 0, 0, 0.484706,-99) , 
1, -0.291557, 1, 0, 0.517095,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382554,-99) , 
1, 0.0406855, 0, 0, 0.48749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187083,-99) , 
3, 2.70576, 0, 0, 0.353216,-99) , 
0, 3.20875, 1, 0, 0.498048,-99)    );
  // itree = 454
  fBoostWeights.push_back(0.103462);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92724, 0, 1, 0.554049,-99) , 
NN(
0, 
0, 
-1, 2.16794, 1, -1, 0.469172,-99) , 
1, 0.7085, 1, 0, 0.529045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339216,-99) , 
2, 2.50753, 1, 0, 0.521793,-99)    );
  // itree = 455
  fBoostWeights.push_back(0.157274);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38864,-99) , 
3, -1.52217, 0, 0, 0.536048,-99) , 
3, 0.919529, 0, 0, 0.554635,-99) , 
NN(
NN(
0, 
0, 
-1, 1.63717, 1, 1, 0.594725,-99) , 
NN(
0, 
0, 
-1, 0.984172, 1, -1, 0.428992,-99) , 
1, 1.23678, 0, 0, 0.455674,-99) , 
0, 1.24069, 1, 0, 0.506597,-99)    );
  // itree = 456
  fBoostWeights.push_back(0.12792);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.813353, 0, 1, 0.616879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441016,-99) , 
3, 1.82852, 0, 0, 0.466477,-99) , 
2, -0.63648, 1, 0, 0.484463,-99) , 
NN(
0, 
0, 
-1, -1.81747, 1, -1, 0.378461,-99) , 
3, -1.37351, 0, 0, 0.476985,-99)    );
  // itree = 457
  fBoostWeights.push_back(0.109109);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.791801, 0, 1, 0.555092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462293,-99) , 
2, 1.65296, 0, 0, 0.487571,-99) , 
2, 0.34709, 1, 0, 0.51544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514363,-99) , 
NN(
0, 
0, 
-1, 2.08568, 1, -1, 0.337029,-99) , 
1, 1.61944, 1, 0, 0.397976,-99) , 
1, 1.36178, 1, 0, 0.5015,-99)    );
  // itree = 458
  fBoostWeights.push_back(0.144114);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390033,-99) , 
2, 1.59055, 1, 0, 0.565759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448591,-99) , 
3, 1.10362, 0, 0, 0.486922,-99) , 
1, -0.327478, 1, 0, 0.50535,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390517,-99) , 
3, 1.7719, 1, 0, 0.517693,-99) , 
NN(
0, 
0, 
-1, -0.237173, 0, -1, 0.346698,-99) , 
3, 0.660704, 0, 0, 0.426276,-99) , 
1, -0.959374, 0, 0, 0.492649,-99)    );
  // itree = 459
  fBoostWeights.push_back(0.166465);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479234,-99) , 
3, -2.24405, 0, 0, 0.64377,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468009,-99) , 
2, 1.50888, 1, 0, 0.520167,-99) , 
NN(
0, 
0, 
-1, -0.448687, 1, -1, 0.415262,-99) , 
2, 1.03205, 0, 0, 0.45219,-99) , 
0, -2.79938, 1, 0, 0.465454,-99)    );
  // itree = 460
  fBoostWeights.push_back(0.156196);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28883, 0, 1, 0.569904,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340652,-99) , 
3, 0.190387, 0, 0, 0.473152,-99) , 
1, 1.63468, 1, 0, 0.555528,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419641,-99) , 
2, -0.198669, 0, 0, 0.503046,-99) , 
NN(
0, 
0, 
-1, -0.923603, 1, -1, 0.332442,-99) , 
2, 1.72956, 1, 0, 0.473793,-99) , 
1, -0.160567, 0, 0, 0.523092,-99)    );
  // itree = 461
  fBoostWeights.push_back(0.121638);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.319453, 0, 1, 0.56469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331322,-99) , 
0, -0.909361, 0, 0, 0.454162,-99) , 
1, -0.818168, 0, 0, 0.541848,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497384,-99) , 
1, -0.577293, 1, 0, 0.523381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299765,-99) , 
3, 1.08651, 0, 0, 0.490815,-99) , 
0, 1.26014, 1, 0, 0.518196,-99)    );
  // itree = 462
  fBoostWeights.push_back(0.111303);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387866,-99) , 
0, -1.00913, 0, 0, 0.592889,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482666,-99) , 
0, 0.119203, 1, 0, 0.506454,-99) , 
1, -0.830196, 1, 0, 0.522165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284142,-99) , 
3, -1.59907, 0, 0, 0.512069,-99)    );
  // itree = 463
  fBoostWeights.push_back(0.100879);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431426,-99) , 
2, 0.525334, 0, 0, 0.525151,-99) , 
0, 0.137126, 1, 0, 0.538615,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478746,-99) , 
3, -0.707674, 0, 0, 0.520762,-99) , 
NN(
0, 
0, 
-1, -0.731835, 0, -1, 0.45452,-99) , 
2, -0.692825, 1, 0, 0.480215,-99) , 
2, 0.332397, 0, 0, 0.512224,-99)    );
  // itree = 464
  fBoostWeights.push_back(0.176243);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.514304, 1, 1, 0.581731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331645,-99) , 
2, -1.53164, 1, 0, 0.491685,-99) , 
2, -1.17308, 0, 0, 0.571319,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381242,-99) , 
0, 3.56814, 0, 0, 0.455254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240578,-99) , 
1, -0.808173, 0, 0, 0.414002,-99) , 
0, 2.93334, 1, 0, 0.546366,-99)    );
  // itree = 465
  fBoostWeights.push_back(0.090813);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.29331, 1, 1, 0.666463,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422244,-99) , 
0, 4.18338, 1, 0, 0.564271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483155,-99) , 
2, -1.92586, 1, 0, 0.488646,-99) , 
3, 2.41698, 0, 0, 0.498598,-99) , 
1, -1.30233, 1, 0, 0.515091,-99)    );
  // itree = 466
  fBoostWeights.push_back(0.104636);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368777,-99) , 
0, 3.88646, 1, 0, 0.549103,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484258,-99) , 
1, -1.14252, 1, 0, 0.498793,-99) , 
3, 0.808059, 0, 0, 0.520748,-99) , 
NN(
0, 
0, 
-1, 2.85238, 0, -1, 0.375361,-99) , 
2, 2.27771, 1, 0, 0.511358,-99)    );
  // itree = 467
  fBoostWeights.push_back(0.0895049);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.52298, 0, 1, 0.628222,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435842,-99) , 
0, 1.90929, 1, 0, 0.503167,-99) , 
3, 2.49257, 0, 0, 0.51235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322881,-99) , 
0, 4.33374, 1, 0, 0.50676,-99)    );
  // itree = 468
  fBoostWeights.push_back(0.0911388);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490627,-99) , 
0, -1.49209, 1, 0, 0.574933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471399,-99) , 
1, -1.83478, 1, 0, 0.478673,-99) , 
2, -0.651091, 1, 0, 0.492937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316535,-99) , 
2, -1.83866, 0, 0, 0.487767,-99)    );
  // itree = 469
  fBoostWeights.push_back(0.135556);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.641379, 1, 1, 0.56349,-99) , 
NN(
0, 
0, 
-1, 3.0459, 0, -1, 0.348464,-99) , 
3, 2.45264, 1, 0, 0.533955,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458636,-99) , 
3, 1.99868, 0, 0, 0.479093,-99) , 
NN(
0, 
0, 
-1, -0.121654, 1, -1, 0.349337,-99) , 
3, -0.780879, 0, 0, 0.460029,-99) , 
1, 0.360265, 0, 0, 0.489843,-99)    );
  // itree = 470
  fBoostWeights.push_back(0.166022);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43374,-99) , 
1, -1.51077, 0, 0, 0.547213,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355732,-99) , 
0, -0.175971, 1, 0, 0.457648,-99) , 
1, 1.32213, 1, 0, 0.536014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621079,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353569,-99) , 
1, 1.23812, 0, 0, 0.391543,-99) , 
1, -0.460499, 1, 0, 0.435853,-99) , 
3, 1.77993, 1, 0, 0.512745,-99)    );
  // itree = 471
  fBoostWeights.push_back(0.132122);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590097,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454217,-99) , 
0, 0.197129, 1, 0, 0.47614,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388966,-99) , 
0, -2.52673, 1, 0, 0.423902,-99) , 
3, -0.164876, 0, 0, 0.462814,-99) , 
1, -1.65817, 1, 0, 0.468644,-99)    );
  // itree = 472
  fBoostWeights.push_back(0.172275);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390192,-99) , 
1, 1.05746, 1, 0, 0.563292,-99) , 
NN(
0, 
0, 
-1, -0.385656, 0, -1, 0.409496,-99) , 
1, 1.32213, 1, 0, 0.543838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277505,-99) , 
2, 2.5672, 1, 0, 0.534755,-99)    );
  // itree = 473
  fBoostWeights.push_back(0.128747);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.140035, 0, 1, 0.769605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321262,-99) , 
1, -0.958498, 0, 0, 0.493181,-99) , 
0, 2.45262, 1, 0, 0.56059,-99) , 
NN(
NN(
0, 
0, 
-1, 1.28874, 1, -1, 0.471431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31949,-99) , 
0, -3.12471, 1, 0, 0.376236,-99) , 
3, -0.966202, 0, 0, 0.45478,-99) , 
3, 1.52918, 0, 0, 0.484469,-99)    );
  // itree = 474
  fBoostWeights.push_back(0.17361);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.571157, 0, 1, 0.665896,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431686,-99) , 
0, 2.1418, 1, 0, 0.526436,-99) , 
2, 2.15825, 0, 0, 0.543652,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411299,-99) , 
3, -0.579045, 0, 0, 0.519726,-99) , 
NN(
0, 
0, 
-1, 0.238849, 1, -1, 0.42577,-99) , 
1, 0.455131, 0, 0, 0.456516,-99) , 
3, 0.240476, 0, 0, 0.513191,-99)    );
  // itree = 475
  fBoostWeights.push_back(0.0956876);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692778,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478342,-99) , 
1, 0.952171, 0, 0, 0.496238,-99) , 
0, -1.56728, 1, 0, 0.503853,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343616,-99) , 
1, -0.165041, 1, 0, 0.456561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244518,-99) , 
3, -1.96444, 0, 0, 0.389882,-99) , 
3, -1.13232, 0, 0, 0.493468,-99)    );
  // itree = 476
  fBoostWeights.push_back(0.11222);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468148,-99) , 
0, 1.08718, 0, 0, 0.650607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48045,-99) , 
0, -2.42377, 1, 0, 0.496982,-99) , 
0, 0.853116, 0, 0, 0.517649,-99) , 
NN(
0, 
0, 
-1, 1.78639, 1, -1, 0.436677,-99) , 
0, 1.34675, 1, 0, 0.482333,-99)    );
  // itree = 477
  fBoostWeights.push_back(0.0895873);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08091, 0, 1, 0.538148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412033,-99) , 
2, 2.502, 1, 0, 0.53152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312816,-99) , 
3, -2.12703, 0, 0, 0.525684,-99)    );
  // itree = 478
  fBoostWeights.push_back(0.119182);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490591,-99) , 
3, 3.30754, 1, 0, 0.646798,-99) , 
NN(
NN(
0, 
0, 
-1, -1.31434, 1, 1, 0.607624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442075,-99) , 
2, 0.782124, 1, 0, 0.496689,-99) , 
1, -0.851532, 1, 0, 0.51595,-99) , 
2, 2.12668, 0, 0, 0.526541,-99)    );
  // itree = 479
  fBoostWeights.push_back(0.114235);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15161, 0, 1, 0.541338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259749,-99) , 
1, 0.113804, 0, 0, 0.37027,-99) , 
2, 2.18459, 1, 0, 0.52819,-99) , 
NN(
0, 
0, 
-1, -2.29668, 0, -1, 0.339741,-99) , 
3, -1.18029, 0, 0, 0.513978,-99)    );
  // itree = 480
  fBoostWeights.push_back(0.112324);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496853,-99) , 
3, 0.234306, 0, 0, 0.648702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349068,-99) , 
3, -2.24645, 0, 0, 0.508447,-99) , 
3, 0.0329901, 0, 0, 0.538099,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485085,-99) , 
1, 0.0159052, 0, 0, 0.570897,-99) , 
NN(
0, 
0, 
-1, 1.34737, 0, -1, 0.453228,-99) , 
2, 0.271376, 1, 0, 0.472756,-99) , 
0, 0.344153, 1, 0, 0.498492,-99)    );
  // itree = 481
  fBoostWeights.push_back(0.0816693);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490759,-99) , 
2, 2.70875, 0, 0, 0.496031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306877,-99) , 
3, -1.29063, 0, 0, 0.486148,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350745,-99) , 
3, 0.861771, 0, 0, 0.430735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255441,-99) , 
1, -1.32886, 1, 0, 0.38197,-99) , 
1, -1.20374, 0, 0, 0.471355,-99)    );
  // itree = 482
  fBoostWeights.push_back(0.12228);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699298,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461166,-99) , 
3, 3.48066, 0, 0, 0.502869,-99) , 
2, 1.77205, 1, 0, 0.566283,-99) , 
NN(
0, 
0, 
-1, 1.32016, 1, -1, 0.446682,-99) , 
3, 2.19923, 0, 0, 0.46414,-99)    );
  // itree = 483
  fBoostWeights.push_back(0.187404);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363178,-99) , 
0, 3.82722, 1, 0, 0.569107,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416898,-99) , 
1, -0.0253214, 0, 0, 0.451134,-99) , 
3, -0.219646, 0, 0, 0.539639,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438172,-99) , 
1, 1.64144, 1, 0, 0.520695,-99) , 
NN(
0, 
0, 
-1, 1.13616, 1, -1, 0.386927,-99) , 
1, 1.3295, 0, 0, 0.434191,-99) , 
1, 0.652165, 1, 0, 0.505343,-99)    );
  // itree = 484
  fBoostWeights.push_back(0.103854);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.443615, 0, 1, 0.689342,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421274,-99) , 
1, -1.37263, 1, 0, 0.521209,-99) , 
1, -1.11485, 0, 0, 0.569671,-99) , 
NN(
NN(
0, 
0, 
-1, 3.3265, 1, 1, 0.579119,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375549,-99) , 
2, 0.846032, 1, 0, 0.472795,-99) , 
2, 1.47382, 0, 0, 0.492215,-99) , 
1, -0.830196, 1, 0, 0.507376,-99)    );
  // itree = 485
  fBoostWeights.push_back(0.0966753);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.18672, 0, 1, 0.541361,-99) , 
NN(
0, 
0, 
-1, -1.03195, 1, -1, 0.450439,-99) , 
2, -0.608291, 0, 0, 0.52497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358744,-99) , 
1, -1.71471, 0, 0, 0.515937,-99)    );
  // itree = 486
  fBoostWeights.push_back(0.103698);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683654,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399001,-99) , 
2, -1.93707, 0, 0, 0.580083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458358,-99) , 
1, -0.609131, 1, 0, 0.476348,-99) , 
2, -1.20399, 1, 0, 0.486448,-99) , 
3, 3.53655, 0, 0, 0.492267,-99)    );
  // itree = 487
  fBoostWeights.push_back(0.145459);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.194309, 0, 1, 0.682449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495909,-99) , 
1, 0.113804, 1, 0, 0.543414,-99) , 
0, 2.00973, 1, 0, 0.566375,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453418,-99) , 
3, -0.942046, 0, 0, 0.51349,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352224,-99) , 
2, 0.138777, 1, 0, 0.403019,-99) , 
0, 0.774123, 1, 0, 0.478327,-99) , 
3, 1.41476, 0, 0, 0.506568,-99)    );
  // itree = 488
  fBoostWeights.push_back(0.139525);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.529084, 0, 1, 0.667023,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429089,-99) , 
1, -1.16362, 1, 0, 0.527595,-99) , 
1, -0.867413, 0, 0, 0.578694,-99) , 
NN(
NN(
0, 
0, 
-1, -1.46163, 0, 1, 0.64443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411667,-99) , 
1, 0.330581, 0, 0, 0.47367,-99) , 
0, -1.79763, 1, 0, 0.487574,-99) , 
1, -0.541154, 1, 0, 0.511762,-99)    );
  // itree = 489
  fBoostWeights.push_back(0.126842);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.326267, 1, 1, 0.60357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479579,-99) , 
1, -0.432346, 0, 0, 0.575456,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43753,-99) , 
1, -0.162592, 0, 0, 0.495364,-99) , 
NN(
0, 
0, 
-1, -0.0327532, 1, -1, 0.372756,-99) , 
2, 1.09288, 1, 0, 0.476208,-99) , 
3, 1.91257, 0, 0, 0.495895,-99)    );
  // itree = 490
  fBoostWeights.push_back(0.169253);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491343,-99) , 
1, 1.05144, 1, 0, 0.568215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332705,-99) , 
1, -0.75846, 1, 0, 0.477211,-99) , 
1, -0.43731, 0, 0, 0.538991,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395593,-99) , 
2, -1.28797, 0, 0, 0.457789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237289,-99) , 
2, -1.79388, 0, 0, 0.386969,-99) , 
2, -1.03433, 0, 0, 0.522141,-99)    );
  // itree = 491
  fBoostWeights.push_back(0.157465);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06714, 1, 1, 0.606825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465838,-99) , 
0, 0.486339, 0, 0, 0.510182,-99) , 
1, 0.935877, 0, 0, 0.528565,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394437,-99) , 
0, 3.40966, 1, 0, 0.476994,-99) , 
NN(
0, 
0, 
-1, 2.18787, 0, -1, 0.350176,-99) , 
1, -0.311495, 1, 0, 0.400437,-99) , 
3, 1.77444, 1, 0, 0.496233,-99)    );
  // itree = 492
  fBoostWeights.push_back(0.165702);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.535348, 0, 1, 0.560475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298533,-99) , 
1, -2.06104, 0, 0, 0.540571,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499486,-99) , 
0, 0.28665, 1, 0, 0.547637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405949,-99) , 
2, -1.73407, 1, 0, 0.414152,-99) , 
1, 1.50213, 0, 0, 0.430291,-99) , 
1, -0.279425, 1, 0, 0.46986,-99)    );
  // itree = 493
  fBoostWeights.push_back(0.123932);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.18974, 0, 1, 0.55714,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334802,-99) , 
0, 1.47467, 1, 0, 0.491702,-99) , 
3, 1.33717, 0, 0, 0.516765,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47684,-99) , 
3, -0.608291, 0, 0, 0.514018,-99) , 
NN(
0, 
0, 
-1, 0.974468, 0, -1, 0.390893,-99) , 
2, -0.0353229, 1, 0, 0.430067,-99) , 
1, -0.429901, 0, 0, 0.487754,-99)    );
  // itree = 494
  fBoostWeights.push_back(0.139446);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.23433, 0, 1, 0.632216,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2691,-99) , 
2, -1.09059, 0, 0, 0.386453,-99) , 
1, 0.413593, 1, 0, 0.545894,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465371,-99) , 
0, 0.215382, 1, 0, 0.48443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343751,-99) , 
3, -0.153762, 0, 0, 0.470199,-99) , 
0, -1.03312, 1, 0, 0.483995,-99)    );
  // itree = 495
  fBoostWeights.push_back(0.110938);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44745, 1, 1, 0.567964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463314,-99) , 
0, -0.744437, 1, 0, 0.489371,-99) , 
2, 1.03876, 0, 0, 0.511066,-99) , 
NN(
0, 
0, 
-1, 2.2351, 0, -1, 0.365275,-99) , 
2, 2.02773, 1, 0, 0.495585,-99)    );
  // itree = 496
  fBoostWeights.push_back(0.0865923);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431438,-99) , 
3, -1.30135, 0, 0, 0.573146,-99) , 
NN(
0, 
0, 
-1, -1.28894, 0, -1, 0.476977,-99) , 
2, -1.01003, 1, 0, 0.487955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2633,-99) , 
1, 2.10144, 1, 0, 0.480761,-99)    );
  // itree = 497
  fBoostWeights.push_back(0.135645);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.312184, 1, 1, 0.582082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360625,-99) , 
0, 0.828953, 0, 0, 0.497512,-99) , 
2, 0.700043, 1, 0, 0.532123,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441212,-99) , 
0, -2.62867, 1, 0, 0.464474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212624,-99) , 
0, -0.240707, 1, 0, 0.424253,-99) , 
3, 0.0413172, 0, 0, 0.498545,-99)    );
  // itree = 498
  fBoostWeights.push_back(0.121211);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324477,-99) , 
0, 3.29728, 1, 0, 0.575705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48465,-99) , 
0, -1.09765, 1, 0, 0.503332,-99) , 
1, 0.555069, 0, 0, 0.527371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295256,-99) , 
0, -3.16774, 0, 0, 0.519574,-99)    );
  // itree = 499
  fBoostWeights.push_back(0.0666334);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661752,-99) , 
NN(
NN(
0, 
0, 
-1, 0.129035, 1, 1, 0.592414,-99) , 
NN(
0, 
0, 
-1, 3.32294, 1, -1, 0.475888,-99) , 
1, -1.44004, 1, 0, 0.484639,-99) , 
3, 3.4406, 0, 0, 0.490021,-99)    );
  // itree = 500
  fBoostWeights.push_back(0.0793176);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.24065, 0, 1, 0.669053,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455556,-99) , 
3, 0.625535, 0, 0, 0.488046,-99) , 
1, -2.1549, 1, 0, 0.492604,-99) , 
1, 1.70838, 0, 0, 0.502418,-99)    );
  // itree = 501
  fBoostWeights.push_back(0.101523);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470466,-99) , 
1, 0.355289, 1, 0, 0.539214,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408841,-99) , 
0, 1.31715, 0, 0, 0.483054,-99) , 
0, 0.304167, 1, 0, 0.505133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305711,-99) , 
0, 4.53707, 1, 0, 0.498861,-99)    );
  // itree = 502
  fBoostWeights.push_back(0.131349);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49447,-99) , 
1, 0.696463, 1, 0, 0.558827,-99) , 
NN(
0, 
0, 
-1, -1.21358, 1, -1, 0.428715,-99) , 
3, -0.589694, 0, 0, 0.538326,-99) , 
NN(
NN(
0, 
0, 
-1, -2.1272, 1, 1, 0.559564,-99) , 
NN(
0, 
0, 
-1, 3.13388, 1, -1, 0.432411,-99) , 
1, -1.07409, 1, 0, 0.473737,-99) , 
1, -0.132895, 0, 0, 0.512285,-99)    );
  // itree = 503
  fBoostWeights.push_back(0.0930229);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.01347, 0, 1, 0.653556,-99) , 
NN(
NN(
0, 
0, 
-1, 0.20449, 0, 1, 0.669728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407361,-99) , 
2, 1.2531, 1, 0, 0.48053,-99) , 
2, 2.62844, 0, 0, 0.492009,-99) , 
2, -1.49679, 1, 0, 0.506229,-99)    );
  // itree = 504
  fBoostWeights.push_back(0.16839);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.18192, 0, 1, 0.579146,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362503,-99) , 
3, 1.72907, 0, 0, 0.485963,-99) , 
0, 1.89776, 1, 0, 0.542088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518353,-99) , 
NN(
0, 
0, 
-1, 0.626645, 0, -1, 0.329817,-99) , 
1, -0.43731, 1, 0, 0.375187,-99) , 
2, -0.608291, 0, 0, 0.510803,-99)    );
  // itree = 505
  fBoostWeights.push_back(0.094006);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437541,-99) , 
0, 2.14206, 1, 0, 0.567629,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349183,-99) , 
3, -1.21175, 0, 0, 0.493424,-99) , 
1, 0.280446, 1, 0, 0.519638,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341281,-99) , 
2, -0.602678, 0, 0, 0.473653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256622,-99) , 
2, 2.12668, 1, 0, 0.447406,-99) , 
1, -0.47598, 0, 0, 0.498463,-99)    );
  // itree = 506
  fBoostWeights.push_back(0.136242);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0443009, 0, 1, 0.636753,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460698,-99) , 
1, -0.371891, 1, 0, 0.491652,-99) , 
1, 0.867055, 0, 0, 0.525542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283909,-99) , 
1, 1.8877, 1, 0, 0.512808,-99)    );
  // itree = 507
  fBoostWeights.push_back(0.118955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455402,-99) , 
0, 4.55706, 1, 0, 0.59681,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410941,-99) , 
0, -3.53239, 0, 0, 0.541885,-99) , 
NN(
0, 
0, 
-1, 0.211094, 0, -1, 0.447852,-99) , 
0, -0.187527, 1, 0, 0.476355,-99) , 
3, 2.85149, 0, 0, 0.484731,-99)    );
  // itree = 508
  fBoostWeights.push_back(0.138576);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477041,-99) , 
1, 0.31161, 1, 0, 0.517237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332138,-99) , 
3, -1.37351, 0, 0, 0.507294,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57808,-99) , 
NN(
0, 
0, 
-1, -1.76299, 1, -1, 0.246109,-99) , 
3, -0.196044, 1, 0, 0.358945,-99) , 
1, -1.23334, 0, 0, 0.486135,-99)    );
  // itree = 509
  fBoostWeights.push_back(0.0990156);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.11453, 1, 1, 0.531073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429113,-99) , 
2, -0.94052, 1, 0, 0.452737,-99) , 
1, -0.531234, 0, 0, 0.506956,-99) , 
NN(
0, 
0, 
-1, 0.0694153, 0, -1, 0.377345,-99) , 
1, 1.6637, 1, 0, 0.498139,-99)    );
  // itree = 510
  fBoostWeights.push_back(0.134903);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364783,-99) , 
0, 3.89595, 1, 0, 0.58286,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404305,-99) , 
2, 0.461149, 1, 0, 0.475004,-99) , 
3, 1.33199, 0, 0, 0.508789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155098,-99) , 
3, 3.19565, 0, 0, 0.357652,-99) , 
2, 2.4325, 1, 0, 0.499134,-99)    );
  // itree = 511
  fBoostWeights.push_back(0.120084);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441906,-99) , 
3, 1.55071, 1, 0, 0.511321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33129,-99) , 
0, -2.83524, 0, 0, 0.504457,-99) , 
NN(
0, 
0, 
-1, -2.06094, 1, -1, 0.312188,-99) , 
1, -1.67996, 0, 0, 0.493666,-99)    );
  // itree = 512
  fBoostWeights.push_back(0.111274);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.526735, 1, 1, 0.644092,-99) , 
NN(
0, 
0, 
-1, -1.18216, 0, -1, 0.452335,-99) , 
3, 2.73745, 0, 0, 0.467732,-99)    );
  // itree = 513
  fBoostWeights.push_back(0.104305);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.31316, 1, 1, 0.596378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350775,-99) , 
3, -2.06927, 0, 0, 0.562572,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481553,-99) , 
2, 0.386708, 1, 0, 0.501019,-99) , 
NN(
0, 
0, 
-1, -0.0101802, 1, -1, 0.402463,-99) , 
3, -0.0355842, 0, 0, 0.487191,-99) , 
2, -0.53349, 1, 0, 0.502815,-99)    );
  // itree = 514
  fBoostWeights.push_back(0.0978875);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492324,-99) , 
3, 1.04799, 0, 0, 0.525225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321228,-99) , 
2, 2.29204, 1, 0, 0.514501,-99) , 
NN(
0, 
0, 
-1, -0.941956, 1, -1, 0.397871,-99) , 
3, -0.892014, 0, 0, 0.50029,-99)    );
  // itree = 515
  fBoostWeights.push_back(0.0887356);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43979,-99) , 
2, -0.0647492, 1, 0, 0.506939,-99) , 
2, 1.06199, 0, 0, 0.545546,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328888,-99) , 
0, 3.94763, 1, 0, 0.494842,-99) , 
NN(
0, 
0, 
-1, 0.806393, 1, -1, 0.446509,-99) , 
3, 0.433353, 0, 0, 0.474181,-99) , 
1, 1.32213, 0, 0, 0.483755,-99)    );
  // itree = 516
  fBoostWeights.push_back(0.140469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.405981, 1, 1, 0.641458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473927,-99) , 
3, 0.599758, 0, 0, 0.52746,-99) , 
1, -0.67817, 1, 0, 0.545815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533935,-99) , 
NN(
0, 
0, 
-1, -0.71583, 1, -1, 0.341608,-99) , 
0, 1.01882, 0, 0, 0.415116,-99) , 
1, -1.36971, 0, 0, 0.532409,-99)    );
  // itree = 517
  fBoostWeights.push_back(0.111212);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482428,-99) , 
1, 1.03452, 1, 0, 0.661998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473343,-99) , 
1, -0.157311, 0, 0, 0.606229,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46573,-99) , 
1, -0.520319, 0, 0, 0.515041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375774,-99) , 
0, 2.75783, 1, 0, 0.503629,-99) , 
3, 2.41698, 0, 0, 0.518166,-99)    );
  // itree = 518
  fBoostWeights.push_back(0.153763);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483949,-99) , 
0, -0.233727, 1, 0, 0.623867,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393979,-99) , 
1, 0.234725, 1, 0, 0.472239,-99) , 
0, -0.926218, 0, 0, 0.540364,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469796,-99) , 
0, 3.09284, 1, 0, 0.530635,-99) , 
NN(
0, 
0, 
-1, -0.534295, 0, -1, 0.432934,-99) , 
0, 2.11745, 0, 0, 0.474526,-99) , 
2, -0.121499, 1, 0, 0.495871,-99)    );
  // itree = 519
  fBoostWeights.push_back(0.0595377);
  fForest.push_back( 
NN(
0, 
0, 
-1, 1.36178, 1, -1, 0.470266,-99)    );
  // itree = 520
  fBoostWeights.push_back(0.137421);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.43968, 1, 1, 0.555779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676687,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347822,-99) , 
0, -1.70821, 1, 0, 0.427652,-99) , 
3, -0.134581, 0, 0, 0.452616,-99) , 
0, -0.492332, 0, 0, 0.530055,-99)    );
  // itree = 521
  fBoostWeights.push_back(0.133691);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.616774, 0, 1, 0.648964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450494,-99) , 
3, 1.12218, 1, 0, 0.482693,-99) , 
2, 0.453331, 1, 0, 0.55705,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428122,-99) , 
1, 0.841771, 1, 0, 0.558571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446897,-99) , 
2, 1.76506, 0, 0, 0.462787,-99) , 
2, -0.988091, 1, 0, 0.473313,-99) , 
1, -0.760003, 1, 0, 0.490869,-99)    );
  // itree = 522
  fBoostWeights.push_back(0.15769);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437481,-99) , 
1, -1.20001, 0, 0, 0.563675,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416917,-99) , 
2, -1.00815, 1, 0, 0.464754,-99) , 
3, -0.0845751, 0, 0, 0.517469,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439726,-99) , 
3, 2.55818, 1, 0, 0.513226,-99) , 
NN(
0, 
0, 
-1, 2.61296, 1, -1, 0.409566,-99) , 
3, 2.16321, 0, 0, 0.455028,-99) , 
3, 1.29819, 1, 0, 0.494356,-99)    );
  // itree = 523
  fBoostWeights.push_back(0.10947);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791371,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471674,-99) , 
0, 0.333268, 1, 0, 0.506606,-99) , 
2, 2.95026, 0, 0, 0.514941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234375,-99) , 
1, 2.07327, 1, 0, 0.506949,-99)    );
  // itree = 524
  fBoostWeights.push_back(0.12816);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682335,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441047,-99) , 
1, -0.244685, 1, 0, 0.519562,-99) , 
3, 3.60158, 0, 0, 0.560621,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430428,-99) , 
1, 0.156842, 0, 0, 0.470851,-99) , 
NN(
0, 
0, 
-1, 1.71816, 0, -1, 0.408608,-99) , 
0, 1.86141, 1, 0, 0.453286,-99) , 
3, 2.61144, 0, 0, 0.464004,-99)    );
  // itree = 525
  fBoostWeights.push_back(0.117072);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.60948, 1, 1, 0.62834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484176,-99) , 
3, 1.17074, 0, 0, 0.500705,-99) , 
0, 1.79989, 0, 0, 0.527969,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374902,-99) , 
3, 2.31965, 0, 0, 0.452904,-99) , 
NN(
0, 
0, 
-1, 4.07849, 0, -1, 0.354752,-99) , 
2, 2.01334, 1, 0, 0.402672,-99) , 
0, 2.93334, 1, 0, 0.51163,-99)    );
  // itree = 526
  fBoostWeights.push_back(0.124544);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495884,-99) , 
2, -1.6568, 1, 0, 0.563887,-99) , 
2, -0.596034, 0, 0, 0.616727,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483814,-99) , 
0, 1.1594, 0, 0, 0.540899,-99) , 
NN(
0, 
0, 
-1, 1.05823, 0, -1, 0.456333,-99) , 
1, 0.652165, 1, 0, 0.516962,-99) , 
0, -1.79763, 1, 0, 0.530235,-99)    );
  // itree = 527
  fBoostWeights.push_back(0.145606);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47214,-99) , 
0, 1.40999, 0, 0, 0.558532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411175,-99) , 
2, 1.08792, 1, 0, 0.48958,-99) , 
1, 0.761602, 0, 0, 0.510528,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282075,-99) , 
3, -2.00228, 0, 0, 0.434369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252467,-99) , 
0, -2.32123, 1, 0, 0.378599,-99) , 
3, -1.09741, 0, 0, 0.496726,-99)    );
  // itree = 528
  fBoostWeights.push_back(0.147588);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.193014, 0, 1, 0.698239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439469,-99) , 
3, -0.72407, 0, 0, 0.543235,-99) , 
1, -0.0194323, 1, 0, 0.565065,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460013,-99) , 
3, -0.442863, 1, 0, 0.478678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346599,-99) , 
3, -0.986975, 0, 0, 0.465495,-99) , 
1, -0.222879, 0, 0, 0.53029,-99)    );
  // itree = 529
  fBoostWeights.push_back(0.162171);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480889,-99) , 
0, 3.22664, 1, 0, 0.546648,-99) , 
1, -0.62344, 1, 0, 0.580679,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391867,-99) , 
3, -1.31608, 0, 0, 0.539011,-99) , 
NN(
0, 
0, 
-1, 1.55967, 1, -1, 0.424248,-99) , 
2, 0.303978, 1, 0, 0.48285,-99) , 
3, 1.91587, 0, 0, 0.501434,-99)    );
  // itree = 530
  fBoostWeights.push_back(0.148859);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459038,-99) , 
1, -1.4974, 0, 0, 0.601169,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330901,-99) , 
1, -0.967367, 1, 0, 0.416586,-99) , 
2, -0.474822, 0, 0, 0.559642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491628,-99) , 
1, 1.44475, 0, 0, 0.516432,-99) , 
NN(
0, 
0, 
-1, 0.950789, 0, -1, 0.425889,-99) , 
0, 0.69392, 1, 0, 0.466193,-99) , 
1, -0.336206, 1, 0, 0.498837,-99)    );
  // itree = 531
  fBoostWeights.push_back(0.0737018);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.81032, 1, 1, 0.686477,-99) , 
NN(
NN(
0, 
0, 
-1, 0.789153, 1, 1, 0.53336,-99) , 
NN(
0, 
0, 
-1, 1.8178, 1, -1, 0.480578,-99) , 
3, 1.46467, 0, 0, 0.495715,-99) , 
1, -1.30233, 1, 0, 0.51135,-99)    );
  // itree = 532
  fBoostWeights.push_back(0.1526);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.995379, 1, 1, 0.711432,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364276,-99) , 
0, -1.05234, 0, 0, 0.549705,-99) , 
1, 1.16933, 1, 0, 0.605208,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45844,-99) , 
3, -1.44706, 0, 0, 0.58423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308407,-99) , 
3, -0.421114, 0, 0, 0.507577,-99) , 
0, -1.19346, 1, 0, 0.52109,-99) , 
1, 0.834462, 0, 0, 0.543086,-99)    );
  // itree = 533
  fBoostWeights.push_back(0.0865453);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631815,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361395,-99) , 
3, 2.14468, 1, 0, 0.48108,-99) , 
NN(
0, 
0, 
-1, 1.07048, 0, -1, 0.358508,-99) , 
1, -1.071, 0, 0, 0.46849,-99) , 
1, -1.83478, 1, 0, 0.476278,-99)    );
  // itree = 534
  fBoostWeights.push_back(0.174946);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.656729, 1, 1, 0.575109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392,-99) , 
0, 3.72663, 1, 0, 0.564174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438791,-99) , 
1, 1.14641, 1, 0, 0.500788,-99) , 
NN(
0, 
0, 
-1, 0.00497055, 0, -1, 0.365939,-99) , 
1, 0.75472, 0, 0, 0.451013,-99) , 
1, 0.296887, 1, 0, 0.513126,-99)    );
  // itree = 535
  fBoostWeights.push_back(0.147994);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425628,-99) , 
1, 0.81585, 0, 0, 0.573871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412993,-99) , 
0, 1.7117, 0, 0, 0.465497,-99) , 
1, 1.30461, 1, 0, 0.531963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575217,-99) , 
NN(
0, 
0, 
-1, 1.64442, 1, -1, 0.433631,-99) , 
1, -1.68402, 1, 0, 0.442559,-99) , 
1, 0.663985, 0, 0, 0.467904,-99)    );
  // itree = 536
  fBoostWeights.push_back(0.130986);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491756,-99) , 
3, 0.704117, 0, 0, 0.547865,-99) , 
NN(
0, 
0, 
-1, 3.87303, 1, -1, 0.441915,-99) , 
3, 2.05595, 1, 0, 0.527724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241225,-99) , 
0, -2.88357, 1, 0, 0.377063,-99) , 
3, -1.09741, 0, 0, 0.513504,-99)    );
  // itree = 537
  fBoostWeights.push_back(0.127994);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.06794, 0, 1, 0.651357,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364341,-99) , 
3, -1.92265, 0, 0, 0.453376,-99) , 
3, -1.49583, 0, 0, 0.592383,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49893,-99) , 
3, 0.49012, 0, 0, 0.563105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342144,-99) , 
3, 0.911874, 0, 0, 0.488036,-99) , 
0, 0.988971, 1, 0, 0.515455,-99) , 
0, -0.908987, 1, 0, 0.532382,-99)    );
  // itree = 538
  fBoostWeights.push_back(0.13189);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0192756, 0, 1, 0.581826,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461021,-99) , 
2, 0.888125, 0, 0, 0.510906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305686,-99) , 
0, 4.29327, 1, 0, 0.501084,-99) , 
0, 0.553464, 1, 0, 0.535907,-99)    );
  // itree = 539
  fBoostWeights.push_back(0.170774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.511975, 0, 1, 0.686829,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266845,-99) , 
3, -1.95485, 0, 0, 0.46445,-99) , 
3, -0.704994, 0, 0, 0.555914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389338,-99) , 
0, 4.47495, 1, 0, 0.575742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423506,-99) , 
2, -0.044573, 1, 0, 0.443778,-99) , 
3, 2.2776, 0, 0, 0.468755,-99) , 
0, -0.486891, 1, 0, 0.490524,-99)    );
  // itree = 540
  fBoostWeights.push_back(0.146093);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483622,-99) , 
1, -0.346536, 0, 0, 0.606334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472388,-99) , 
1, 1.28421, 0, 0, 0.4918,-99) , 
0, 0.39302, 1, 0, 0.512698,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483033,-99) , 
1, 0.223543, 1, 0, 0.535746,-99) , 
NN(
0, 
0, 
-1, -1.49173, 1, -1, 0.377898,-99) , 
3, 0.0124767, 0, 0, 0.407241,-99) , 
2, -0.113448, 0, 0, 0.478557,-99)    );
  // itree = 541
  fBoostWeights.push_back(0.112071);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2069, 0, 1, 0.547962,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343915,-99) , 
3, 1.80164, 0, 0, 0.47984,-99) , 
0, 2.02582, 1, 0, 0.528522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245006,-99) , 
1, 2.10144, 1, 0, 0.519891,-99)    );
  // itree = 542
  fBoostWeights.push_back(0.177045);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482772,-99) , 
2, 0.0820521, 0, 0, 0.584611,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437943,-99) , 
3, 2.90005, 0, 0, 0.465136,-99) , 
0, 1.81875, 1, 0, 0.534013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459688,-99) , 
3, -0.135904, 1, 0, 0.528289,-99) , 
NN(
0, 
0, 
-1, -0.990459, 1, -1, 0.389553,-99) , 
3, -0.548704, 0, 0, 0.432971,-99) , 
2, -0.562552, 0, 0, 0.513855,-99)    );
  // itree = 543
  fBoostWeights.push_back(0.142673);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.27089, 0, 1, 0.567932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458417,-99) , 
2, -1.44256, 1, 0, 0.491716,-99) , 
1, 0.70029, 1, 0, 0.544133,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444354,-99) , 
1, -1.01607, 1, 0, 0.472399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261412,-99) , 
2, 2.67514, 1, 0, 0.454742,-99) , 
2, 1.07405, 1, 0, 0.516632,-99)    );
  // itree = 544
  fBoostWeights.push_back(0.180543);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.883803, 0, 1, 0.572418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353548,-99) , 
0, 3.04435, 1, 0, 0.420732,-99) , 
2, 1.79981, 1, 0, 0.542342,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410779,-99) , 
3, -0.0590187, 0, 0, 0.446044,-99) , 
NN(
0, 
0, 
-1, 0.0973013, 1, -1, 0.342126,-99) , 
2, -0.356231, 1, 0, 0.417525,-99) , 
2, -0.121499, 0, 0, 0.497654,-99)    );
  // itree = 545
  fBoostWeights.push_back(0.152212);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422015,-99) , 
3, 2.77337, 1, 0, 0.552391,-99) , 
NN(
0, 
0, 
-1, 1.42068, 0, -1, 0.387673,-99) , 
1, -1.4795, 0, 0, 0.537739,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409905,-99) , 
1, 0.54741, 0, 0, 0.440802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340151,-99) , 
1, 1.32213, 1, 0, 0.425174,-99) , 
3, -0.0940813, 0, 0, 0.50564,-99)    );
  // itree = 546
  fBoostWeights.push_back(0.0867274);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89629, 0, 1, 0.603724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445206,-99) , 
0, 4.52549, 1, 0, 0.578178,-99) , 
NN(
NN(
0, 
0, 
-1, -1.16036, 1, 1, 0.597082,-99) , 
NN(
0, 
0, 
-1, -0.776679, 0, -1, 0.475397,-99) , 
0, -2.1665, 1, 0, 0.488697,-99) , 
0, 2.93334, 0, 0, 0.503862,-99)    );
  // itree = 547
  fBoostWeights.push_back(0.123289);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758214,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464512,-99) , 
0, 0.392528, 1, 0, 0.491615,-99) , 
1, -1.68292, 1, 0, 0.5036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321894,-99) , 
2, -1.20365, 1, 0, 0.445659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209697,-99) , 
2, -1.85948, 0, 0, 0.361005,-99) , 
3, -1.14659, 0, 0, 0.490094,-99)    );
  // itree = 548
  fBoostWeights.push_back(0.0606347);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 4.53346, 0, 1, 0.599696,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492364,-99) , 
2, 1.54814, 0, 0, 0.50165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370967,-99) , 
0, 2.98711, 1, 0, 0.493667,-99) , 
0, 3.59609, 0, 0, 0.504243,-99)    );
  // itree = 549
  fBoostWeights.push_back(0.0486754);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626215,-99) , 
NN(
NN(
0, 
0, 
-1, -1.15077, 1, 1, 0.517989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429385,-99) , 
1, 1.78462, 1, 0, 0.513262,-99) , 
2, 2.57327, 0, 0, 0.517037,-99)    );
  // itree = 550
  fBoostWeights.push_back(0.0919427);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440158,-99) , 
2, -1.24711, 1, 0, 0.615653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463861,-99) , 
2, -1.97884, 0, 0, 0.580418,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454015,-99) , 
1, 0.79899, 1, 0, 0.50104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362169,-99) , 
3, -0.733911, 0, 0, 0.492545,-99) , 
2, -1.01773, 1, 0, 0.504242,-99)    );
  // itree = 551
  fBoostWeights.push_back(0.117307);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658556,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462609,-99) , 
0, -0.117748, 0, 0, 0.512817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40924,-99) , 
3, 1.88395, 0, 0, 0.448863,-99) , 
0, 1.22809, 1, 0, 0.48259,-99) , 
3, 3.36925, 0, 0, 0.487454,-99)    );
  // itree = 552
  fBoostWeights.push_back(0.0878016);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468822,-99) , 
1, -1.20474, 0, 0, 0.550632,-99) , 
1, -1.93669, 1, 0, 0.566346,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48936,-99) , 
2, -0.960494, 1, 0, 0.500092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300137,-99) , 
3, -1.25682, 0, 0, 0.491745,-99) , 
1, -0.413667, 1, 0, 0.513901,-99)    );
  // itree = 553
  fBoostWeights.push_back(0.127218);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.64759, 0, 1, 0.608797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402529,-99) , 
1, 1.30438, 1, 0, 0.582751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322993,-99) , 
2, 0.422807, 0, 0, 0.486108,-99) , 
3, 0.253658, 1, 0, 0.505546,-99) , 
2, 0.229718, 1, 0, 0.537701,-99)    );
  // itree = 554
  fBoostWeights.push_back(0.0850509);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499975,-99) , 
0, 0.767138, 1, 0, 0.524364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41072,-99) , 
2, -1.15601, 1, 0, 0.473923,-99) , 
3, -0.320999, 0, 0, 0.514975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370452,-99) , 
0, -2.80334, 0, 0, 0.508274,-99)    );
  // itree = 555
  fBoostWeights.push_back(0.102941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.976047, 0, 1, 0.615738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459399,-99) , 
0, 1.97871, 1, 0, 0.527833,-99) , 
1, 1.04338, 1, 0, 0.555486,-99) , 
NN(
NN(
0, 
0, 
-1, -1.4817, 0, 1, 0.592667,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440921,-99) , 
0, 1.35859, 0, 0, 0.469976,-99) , 
0, -1.49093, 1, 0, 0.487877,-99) , 
1, 0.664075, 0, 0, 0.508141,-99)    );
  // itree = 556
  fBoostWeights.push_back(0.0867046);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69495,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446128,-99) , 
3, -1.9408, 0, 0, 0.523179,-99) , 
2, -1.41916, 0, 0, 0.590787,-99) , 
NN(
NN(
0, 
0, 
-1, 2.7506, 0, 1, 0.541511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321153,-99) , 
0, 0.902448, 1, 0, 0.474742,-99) , 
0, 1.19238, 0, 0, 0.510563,-99) , 
0, -1.82279, 1, 0, 0.518692,-99)    );
  // itree = 557
  fBoostWeights.push_back(0.126571);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.918662, 0, 1, 0.628034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444451,-99) , 
3, -0.617105, 0, 0, 0.531213,-99) , 
2, -1.23181, 1, 0, 0.58013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42818,-99) , 
2, 0.788543, 1, 0, 0.462678,-99) , 
NN(
0, 
0, 
-1, -0.163864, 0, -1, 0.373319,-99) , 
3, -0.190329, 0, 0, 0.452828,-99) , 
2, -0.600492, 1, 0, 0.476299,-99)    );
  // itree = 558
  fBoostWeights.push_back(0.0929272);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.00429, 0, 1, 0.652136,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422553,-99) , 
0, 2.02037, 1, 0, 0.484555,-99) , 
1, -1.57729, 1, 0, 0.494679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266244,-99) , 
2, -1.93205, 0, 0, 0.487942,-99)    );
  // itree = 559
  fBoostWeights.push_back(0.1241);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.80547, 0, 1, 0.588114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347993,-99) , 
0, 4.33282, 0, 0, 0.450803,-99) , 
2, 2.22906, 1, 0, 0.537445,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445984,-99) , 
1, 0.220021, 1, 0, 0.481063,-99) , 
NN(
0, 
0, 
-1, 2.31271, 1, -1, 0.370565,-99) , 
2, 1.06209, 1, 0, 0.459286,-99) , 
3, 2.11136, 0, 0, 0.474184,-99)    );
  // itree = 560
  fBoostWeights.push_back(0.137617);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56303, 1, 1, 0.640187,-99) , 
NN(
0, 
0, 
-1, 2.13684, 0, -1, 0.427931,-99) , 
0, 1.64308, 1, 0, 0.558612,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476709,-99) , 
3, 1.59085, 1, 0, 0.531716,-99) , 
NN(
0, 
0, 
-1, 0.652371, 1, -1, 0.450294,-99) , 
3, 0.850977, 0, 0, 0.48717,-99) , 
1, 0.967789, 0, 0, 0.503744,-99)    );
  // itree = 561
  fBoostWeights.push_back(0.130021);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494788,-99) , 
2, -0.747643, 0, 0, 0.575649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474531,-99) , 
1, 1.43396, 0, 0, 0.49911,-99) , 
2, -0.293255, 1, 0, 0.521873,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485019,-99) , 
2, -1.23196, 0, 0, 0.556713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391391,-99) , 
3, 1.34876, 0, 0, 0.438071,-99) , 
2, -0.600492, 1, 0, 0.455858,-99) , 
1, 0.274022, 0, 0, 0.485488,-99)    );
  // itree = 562
  fBoostWeights.push_back(0.12451);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441869,-99) , 
1, -0.728406, 0, 0, 0.533419,-99) , 
3, 3.36998, 0, 0, 0.547218,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475728,-99) , 
3, 0.606584, 0, 0, 0.492646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218535,-99) , 
2, 0.433723, 0, 0, 0.360308,-99) , 
0, 1.26282, 1, 0, 0.466129,-99) , 
3, 1.29819, 0, 0, 0.494979,-99)    );
  // itree = 563
  fBoostWeights.push_back(0.0540806);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652484,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303296,-99) , 
3, -1.73411, 0, 0, 0.50579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369155,-99) , 
0, 3.87264, 1, 0, 0.501153,-99) , 
0, 4.51992, 0, 0, 0.506419,-99)    );
  // itree = 564
  fBoostWeights.push_back(0.109134);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.920378, 1, 1, 0.59984,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4818,-99) , 
0, -0.757188, 1, 0, 0.509984,-99) , 
2, 0.660962, 0, 0, 0.52626,-99) , 
NN(
NN(
0, 
0, 
-1, 2.13657, 1, 1, 0.543819,-99) , 
NN(
0, 
0, 
-1, 0.966946, 1, -1, 0.399318,-99) , 
3, 1.98333, 0, 0, 0.472379,-99) , 
0, 1.55239, 1, 0, 0.506258,-99)    );
  // itree = 565
  fBoostWeights.push_back(0.0736309);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690991,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414294,-99) , 
3, -1.07667, 0, 0, 0.505179,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338453,-99) , 
1, 0.231562, 0, 0, 0.397215,-99) , 
2, 1.90886, 1, 0, 0.494878,-99) , 
3, 3.36925, 0, 0, 0.49994,-99)    );
  // itree = 566
  fBoostWeights.push_back(0.111418);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434225,-99) , 
2, 0.668551, 1, 0, 0.52838,-99) , 
3, 1.52692, 0, 0, 0.588269,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432803,-99) , 
3, 0.551664, 0, 0, 0.473222,-99) , 
NN(
0, 
0, 
-1, 2.96052, 1, -1, 0.351434,-99) , 
2, 2.06987, 1, 0, 0.464096,-99) , 
1, -1.18118, 1, 0, 0.4788,-99)    );
  // itree = 567
  fBoostWeights.push_back(0.172914);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.721077, 0, 1, 0.604702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212685,-99) , 
0, -2.8071, 1, 0, 0.388269,-99) , 
3, -1.245, 0, 0, 0.539562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615262,-99) , 
NN(
0, 
0, 
-1, 1.02583, 1, -1, 0.424964,-99) , 
0, 4.41439, 0, 0, 0.436069,-99) , 
0, -0.639403, 1, 0, 0.46082,-99)    );
  // itree = 568
  fBoostWeights.push_back(0.0968918);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20273, 0, 1, 0.669246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425095,-99) , 
0, 2.871, 1, 0, 0.555841,-99) , 
0, -0.889098, 1, 0, 0.582758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667963,-99) , 
NN(
0, 
0, 
-1, -1.5582, 0, -1, 0.479601,-99) , 
1, -1.94414, 1, 0, 0.487963,-99) , 
1, 0.753098, 0, 0, 0.514493,-99)    );
  // itree = 569
  fBoostWeights.push_back(0.136843);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29307, 1, 1, 0.611637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414077,-99) , 
1, 0.503001, 1, 0, 0.506687,-99) , 
1, 1.25069, 0, 0, 0.519247,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441433,-99) , 
3, 0.46923, 0, 0, 0.456766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27566,-99) , 
0, 1.21777, 1, 0, 0.439472,-99) , 
2, 0.269531, 0, 0, 0.485266,-99)    );
  // itree = 570
  fBoostWeights.push_back(0.153251);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.68703, 1, 1, 0.541511,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383175,-99) , 
2, 1.76396, 0, 0, 0.495465,-99) , 
NN(
0, 
0, 
-1, 3.86056, 1, -1, 0.336023,-99) , 
1, 0.627706, 0, 0, 0.383249,-99) , 
0, 2.02582, 1, 0, 0.493012,-99)    );
  // itree = 571
  fBoostWeights.push_back(0.187652);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444557,-99) , 
0, 3.16621, 1, 0, 0.582153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369214,-99) , 
2, -0.673696, 1, 0, 0.447916,-99) , 
3, 0.264602, 0, 0, 0.524562,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441337,-99) , 
3, 2.85301, 0, 0, 0.456963,-99) , 
NN(
0, 
0, 
-1, -1.1889, 0, -1, 0.313957,-99) , 
3, -0.72407, 0, 0, 0.438818,-99) , 
1, -0.0762474, 1, 0, 0.477368,-99)    );
  // itree = 572
  fBoostWeights.push_back(0.0814168);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.95035, 0, 1, 0.523538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295683,-99) , 
2, 2.10122, 0, 0, 0.392303,-99) , 
0, 3.45067, 1, 0, 0.511784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267659,-99) , 
2, 2.5672, 1, 0, 0.504862,-99)    );
  // itree = 573
  fBoostWeights.push_back(0.183877);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488654,-99) , 
3, -2.06491, 0, 0, 0.651015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404862,-99) , 
3, -0.76451, 0, 0, 0.541028,-99) , 
0, -2.44469, 1, 0, 0.558944,-99) , 
NN(
NN(
0, 
0, 
-1, -1.66984, 1, 1, 0.582519,-99) , 
NN(
0, 
0, 
-1, 1.02229, 0, -1, 0.412579,-99) , 
1, -1.12422, 1, 0, 0.434732,-99) , 
2, 0.280208, 1, 0, 0.491823,-99)    );
  // itree = 574
  fBoostWeights.push_back(0.149679);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49904, 1, 1, 0.590181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339837,-99) , 
0, 2.93095, 1, 0, 0.511299,-99) , 
1, 0.687509, 1, 0, 0.55275,-99) , 
NN(
NN(
0, 
0, 
-1, 4.12036, 0, 1, 0.54982,-99) , 
NN(
0, 
0, 
-1, -1.57867, 0, -1, 0.425883,-99) , 
3, 2.09348, 0, 0, 0.44482,-99) , 
1, -0.163811, 0, 0, 0.505769,-99)    );
  // itree = 575
  fBoostWeights.push_back(0.127728);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499515,-99) , 
0, 3.00845, 1, 0, 0.563346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415149,-99) , 
3, 1.10499, 0, 0, 0.546834,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468092,-99) , 
1, -1.30912, 1, 0, 0.480546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277417,-99) , 
0, 0.866707, 1, 0, 0.452811,-99) , 
3, 0.909244, 0, 0, 0.493751,-99)    );
  // itree = 576
  fBoostWeights.push_back(0.158455);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.771184, 1, 1, 0.5946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435984,-99) , 
1, 0.379866, 1, 0, 0.509838,-99) , 
2, 0.183123, 0, 0, 0.548742,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336541,-99) , 
2, 2.65235, 1, 0, 0.506779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276226,-99) , 
3, 1.70996, 0, 0, 0.459944,-99) , 
2, 1.41494, 1, 0, 0.528832,-99)    );
  // itree = 577
  fBoostWeights.push_back(0.17892);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63717, 1, 1, 0.608835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415808,-99) , 
3, 3.04377, 0, 0, 0.461487,-99) , 
2, 1.41092, 1, 0, 0.537699,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421229,-99) , 
2, 0.137261, 1, 0, 0.505793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247514,-99) , 
2, 0.681668, 1, 0, 0.467723,-99) , 
3, 0.970692, 0, 0, 0.499499,-99)    );
  // itree = 578
  fBoostWeights.push_back(0.133576);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.21495, 0, 1, 0.630868,-99) , 
NN(
0, 
0, 
-1, -0.654475, 0, -1, 0.446966,-99) , 
0, -1.33435, 1, 0, 0.465633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31518,-99) , 
3, -1.59907, 0, 0, 0.459003,-99)    );
  // itree = 579
  fBoostWeights.push_back(0.111848);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468228,-99) , 
0, -3.33557, 0, 0, 0.621876,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464767,-99) , 
1, 0.413095, 0, 0, 0.495265,-99) , 
NN(
0, 
0, 
-1, 0.92553, 1, -1, 0.399042,-99) , 
1, 1.41108, 1, 0, 0.485173,-99) , 
0, -2.45724, 1, 0, 0.495182,-99)    );
  // itree = 580
  fBoostWeights.push_back(0.131636);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406295,-99) , 
3, -1.33639, 0, 0, 0.518528,-99) , 
2, 0.139221, 0, 0, 0.554972,-99) , 
NN(
NN(
0, 
0, 
-1, 0.234304, 1, 1, 0.580897,-99) , 
NN(
0, 
0, 
-1, 1.68661, 1, -1, 0.458771,-99) , 
3, 2.11797, 0, 0, 0.488651,-99) , 
0, -0.256518, 1, 0, 0.508093,-99)    );
  // itree = 581
  fBoostWeights.push_back(0.119243);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482675,-99) , 
0, 2.33606, 1, 0, 0.54108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314022,-99) , 
3, -1.88206, 0, 0, 0.533151,-99) , 
NN(
0, 
0, 
-1, 1.3122, 0, -1, 0.362282,-99) , 
1, 1.70838, 1, 0, 0.523368,-99)    );
  // itree = 582
  fBoostWeights.push_back(0.0854399);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.43223, 0, 1, 0.702686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260556,-99) , 
2, 2.49004, 1, 0, 0.496184,-99) , 
0, -0.860112, 1, 0, 0.512485,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382137,-99) , 
1, -0.023903, 1, 0, 0.453093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265732,-99) , 
2, -0.836872, 1, 0, 0.394286,-99) , 
3, -0.796968, 0, 0, 0.494033,-99)    );
  // itree = 583
  fBoostWeights.push_back(0.118018);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.883007, 1, 1, 0.654466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320613,-99) , 
3, -0.183076, 0, 0, 0.507015,-99) , 
0, -1.48008, 1, 0, 0.52685,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434812,-99) , 
1, -0.242391, 1, 0, 0.496161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342821,-99) , 
3, -1.18029, 0, 0, 0.482854,-99) , 
1, 0.156278, 0, 0, 0.503938,-99)    );
  // itree = 584
  fBoostWeights.push_back(0.108039);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.17104, 1, 1, 0.532989,-99) , 
NN(
0, 
0, 
-1, -1.23298, 1, -1, 0.425392,-99) , 
3, -0.687832, 0, 0, 0.515329,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556882,-99) , 
NN(
0, 
0, 
-1, 1.30681, 0, -1, 0.391444,-99) , 
2, -0.731595, 1, 0, 0.420371,-99) , 
1, 0.967789, 1, 0, 0.493077,-99)    );
  // itree = 585
  fBoostWeights.push_back(0.130467);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.151991, 0, 1, 0.595307,-99) , 
NN(
0, 
0, 
-1, 2.10003, 1, -1, 0.467642,-99) , 
2, 0.404176, 1, 0, 0.528146,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427309,-99) , 
3, 1.1752, 0, 0, 0.466639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195724,-99) , 
0, -2.25051, 0, 0, 0.448833,-99) , 
1, -0.163811, 1, 0, 0.479638,-99)    );
  // itree = 586
  fBoostWeights.push_back(0.120115);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436862,-99) , 
2, -0.607805, 0, 0, 0.549982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299263,-99) , 
1, 0.763938, 0, 0, 0.470483,-99) , 
1, 0.600608, 1, 0, 0.522166,-99) , 
NN(
0, 
0, 
-1, 0.127898, 1, -1, 0.349411,-99) , 
2, -1.44612, 0, 0, 0.510824,-99)    );
  // itree = 587
  fBoostWeights.push_back(0.126887);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444831,-99) , 
1, -1.08985, 0, 0, 0.576836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438961,-99) , 
0, 2.70656, 1, 0, 0.479097,-99) , 
1, -0.510073, 1, 0, 0.504169,-99) , 
NN(
0, 
0, 
-1, 1.20409, 1, -1, 0.442817,-99) , 
3, 1.73714, 0, 0, 0.458471,-99)    );
  // itree = 588
  fBoostWeights.push_back(0.109959);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382297,-99) , 
2, 2.37732, 1, 0, 0.528542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449783,-99) , 
0, -1.61088, 1, 0, 0.476636,-99) , 
2, 0.285987, 0, 0, 0.505646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526689,-99) , 
NN(
0, 
0, 
-1, 1.26707, 0, -1, 0.394785,-99) , 
2, 1.34628, 0, 0, 0.425959,-99) , 
1, 1.05674, 1, 0, 0.490336,-99)    );
  // itree = 589
  fBoostWeights.push_back(0.116767);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499927,-99) , 
3, 0.165545, 0, 0, 0.672048,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384608,-99) , 
1, -1.18118, 0, 0, 0.523997,-99) , 
3, -0.00253857, 0, 0, 0.565782,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632218,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415806,-99) , 
3, 1.00431, 0, 0, 0.486328,-99) , 
2, 2.79024, 0, 0, 0.49424,-99) , 
0, 0.45556, 1, 0, 0.52203,-99)    );
  // itree = 590
  fBoostWeights.push_back(0.194593);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.592443, 1, 1, 0.574244,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388156,-99) , 
3, -0.065942, 0, 0, 0.441635,-99) , 
1, -0.222879, 0, 0, 0.520106,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436012,-99) , 
1, -0.605712, 1, 0, 0.471252,-99) , 
NN(
0, 
0, 
-1, -0.267714, 0, -1, 0.358116,-99) , 
3, 1.78407, 0, 0, 0.408972,-99) , 
0, 0.905658, 1, 0, 0.461039,-99)    );
  // itree = 591
  fBoostWeights.push_back(0.160571);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.460001, 0, 1, 0.571149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351408,-99) , 
2, -0.256342, 1, 0, 0.431347,-99) , 
1, 1.36178, 1, 0, 0.554126,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457386,-99) , 
0, 2.86382, 1, 0, 0.508934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279029,-99) , 
3, 1.46027, 0, 0, 0.463791,-99) , 
0, 1.8256, 1, 0, 0.520442,-99)    );
  // itree = 592
  fBoostWeights.push_back(0.127416);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472732,-99) , 
1, -0.544748, 0, 0, 0.529808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373317,-99) , 
3, -0.564479, 0, 0, 0.519362,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420419,-99) , 
1, -0.679711, 1, 0, 0.465613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276506,-99) , 
3, -0.403745, 1, 0, 0.410742,-99) , 
2, -0.55292, 0, 0, 0.497057,-99)    );
  // itree = 593
  fBoostWeights.push_back(0.174406);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.285189, 0, 1, 0.584383,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462339,-99) , 
0, 0.764581, 1, 0, 0.481522,-99) , 
1, 0.0784065, 1, 0, 0.52876,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339912,-99) , 
3, -0.671471, 0, 0, 0.464318,-99) , 
NN(
0, 
0, 
-1, -0.661722, 1, -1, 0.367081,-99) , 
1, -0.0653764, 1, 0, 0.410146,-99) , 
3, 0.461824, 0, 0, 0.481369,-99)    );
  // itree = 594
  fBoostWeights.push_back(0.149834);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48374,-99) , 
0, 0.749226, 1, 0, 0.526639,-99) , 
NN(
0, 
0, 
-1, -1.37489, 0, -1, 0.441999,-99) , 
0, 0.255764, 0, 0, 0.480413,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442964,-99) , 
3, 3.26724, 1, 0, 0.529712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316503,-99) , 
1, 0.772852, 0, 0, 0.359541,-99) , 
3, 2.48451, 0, 0, 0.417651,-99) , 
2, 1.16871, 1, 0, 0.460826,-99)    );
  // itree = 595
  fBoostWeights.push_back(0.112359);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0620386, 1, 1, 0.581404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429637,-99) , 
2, 1.68008, 1, 0, 0.56023,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452841,-99) , 
1, 0.452993, 1, 0, 0.484627,-99) , 
NN(
0, 
0, 
-1, -0.473767, 0, -1, 0.378128,-99) , 
1, -0.388416, 0, 0, 0.474538,-99) , 
1, -0.609131, 1, 0, 0.498636,-99)    );
  // itree = 596
  fBoostWeights.push_back(0.0671231);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.49673, 0, 1, 0.619456,-99) , 
NN(
NN(
0, 
0, 
-1, 2.07026, 0, 1, 0.609568,-99) , 
NN(
0, 
0, 
-1, 3.6413, 1, -1, 0.478269,-99) , 
1, 1.74237, 0, 0, 0.486736,-99) , 
3, 2.85149, 0, 0, 0.495552,-99)    );
  // itree = 597
  fBoostWeights.push_back(0.0976311);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68873, 0, 1, 0.66368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44261,-99) , 
1, 1.94696, 1, 0, 0.587744,-99) , 
NN(
NN(
0, 
0, 
-1, 0.96077, 0, 1, 0.543509,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438611,-99) , 
3, 1.12153, 0, 0, 0.476121,-99) , 
2, -0.600492, 1, 0, 0.489483,-99) , 
1, 1.45754, 0, 0, 0.498476,-99)    );
  // itree = 598
  fBoostWeights.push_back(0.105585);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489753,-99) , 
0, 2.13388, 1, 0, 0.606918,-99) , 
NN(
0, 
0, 
-1, 4.39278, 1, -1, 0.469763,-99) , 
1, 1.41108, 0, 0, 0.485149,-99) , 
NN(
0, 
0, 
-1, -2.33458, 0, -1, 0.326843,-99) , 
2, -1.05284, 0, 0, 0.469702,-99)    );
  // itree = 599
  fBoostWeights.push_back(0.17535);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413693,-99) , 
0, -2.05858, 0, 0, 0.580332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439424,-99) , 
3, 1.59289, 1, 0, 0.477202,-99) , 
2, 0.761195, 1, 0, 0.535922,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495594,-99) , 
1, -1.40711, 0, 0, 0.583726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396674,-99) , 
1, -1.68473, 1, 0, 0.418608,-99) , 
2, 1.22903, 0, 0, 0.466083,-99) , 
1, -0.541154, 0, 0, 0.515371,-99)    );
  // itree = 600
  fBoostWeights.push_back(0.121067);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0976875, 0, 1, 0.665883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358019,-99) , 
1, -1.12237, 0, 0, 0.505958,-99) , 
3, -0.480797, 0, 0, 0.573409,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331761,-99) , 
0, 4.46238, 1, 0, 0.515709,-99) , 
NN(
0, 
0, 
-1, -0.082923, 0, -1, 0.4007,-99) , 
3, 0.485182, 0, 0, 0.500568,-99) , 
0, 0.149794, 1, 0, 0.523387,-99)    );
  // itree = 601
  fBoostWeights.push_back(0.163172);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.343, 0, 1, 0.659115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451478,-99) , 
3, 1.72898, 0, 0, 0.524285,-99) , 
0, 0.367176, 1, 0, 0.57436,-99) , 
NN(
NN(
0, 
0, 
-1, -0.334731, 1, 1, 0.589538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425561,-99) , 
1, 0.763751, 0, 0, 0.435335,-99) , 
2, 2.15309, 0, 0, 0.447952,-99) , 
1, 0.99466, 0, 0, 0.475465,-99)    );
  // itree = 602
  fBoostWeights.push_back(0.121481);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.303978, 0, 1, 0.558304,-99) , 
NN(
NN(
0, 
0, 
-1, -0.0876677, 1, 1, 0.555957,-99) , 
NN(
0, 
0, 
-1, 1.53479, 1, -1, 0.434518,-99) , 
3, 2.56475, 0, 0, 0.463653,-99) , 
0, 1.36783, 1, 0, 0.516921,-99)    );
  // itree = 603
  fBoostWeights.push_back(0.113288);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09361, 0, 1, 0.540662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31064,-99) , 
1, 1.90552, 1, 0, 0.530911,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565907,-99) , 
NN(
0, 
0, 
-1, -0.287569, 0, -1, 0.386476,-99) , 
1, -1.93669, 1, 0, 0.421582,-99) , 
1, -0.921741, 0, 0, 0.512887,-99)    );
  // itree = 604
  fBoostWeights.push_back(0.106949);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475832,-99) , 
3, -0.210529, 1, 0, 0.485217,-99) , 
NN(
0, 
0, 
-1, -2.40172, 1, -1, 0.377309,-99) , 
3, -0.570584, 0, 0, 0.466428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.167784,-99) , 
3, 3.20474, 1, 0, 0.458732,-99)    );
  // itree = 605
  fBoostWeights.push_back(0.133271);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635997,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45206,-99) , 
3, -1.30135, 0, 0, 0.56567,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553853,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443914,-99) , 
3, 2.16727, 0, 0, 0.465665,-99) , 
2, -0.77692, 1, 0, 0.478693,-99) , 
1, 1.718, 0, 0, 0.486862,-99)    );
  // itree = 606
  fBoostWeights.push_back(0.15308);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.998556, 1, 1, 0.595459,-99) , 
NN(
0, 
0, 
-1, 3.07747, 1, -1, 0.44671,-99) , 
2, 1.10015, 1, 0, 0.510434,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433072,-99) , 
1, 1.15417, 0, 0, 0.45518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290497,-99) , 
1, 1.70838, 1, 0, 0.44228,-99) , 
2, 0.332397, 0, 0, 0.48021,-99)    );
  // itree = 607
  fBoostWeights.push_back(0.135125);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.855142, 1, 1, 0.649466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447281,-99) , 
2, 2.39043, 0, 0, 0.50895,-99) , 
2, 1.59304, 1, 0, 0.573892,-99) , 
NN(
NN(
0, 
0, 
-1, 0.620192, 0, 1, 0.525723,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390556,-99) , 
3, 0.952727, 1, 0, 0.429609,-99) , 
3, 0.791729, 1, 0, 0.500147,-99) , 
3, 1.45309, 0, 0, 0.522601,-99)    );
  // itree = 608
  fBoostWeights.push_back(0.0956527);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487286,-99) , 
1, -1.22506, 0, 0, 0.571281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338337,-99) , 
0, 3.87958, 1, 0, 0.492177,-99) , 
1, -0.410895, 1, 0, 0.515858,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402945,-99) , 
1, 1.21661, 1, 0, 0.468462,-99) , 
NN(
0, 
0, 
-1, 0.0566351, 1, -1, 0.360007,-99) , 
1, 0.571225, 0, 0, 0.402312,-99) , 
2, -0.617188, 0, 0, 0.494989,-99)    );
  // itree = 609
  fBoostWeights.push_back(0.120157);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425938,-99) , 
0, 0.0900253, 1, 0, 0.543403,-99) , 
0, 1.89103, 0, 0, 0.598667,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457741,-99) , 
3, 0.617153, 0, 0, 0.50127,-99) , 
0, -2.98962, 1, 0, 0.507454,-99) , 
1, -0.912483, 1, 0, 0.522691,-99)    );
  // itree = 610
  fBoostWeights.push_back(0.138661);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.160986, 1, 1, 0.552658,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340222,-99) , 
1, -0.193522, 0, 0, 0.449681,-99) , 
0, 2.85924, 1, 0, 0.522774,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398758,-99) , 
0, -2.88923, 0, 0, 0.568771,-99) , 
NN(
0, 
0, 
-1, -1.24588, 0, -1, 0.422759,-99) , 
0, -2.24598, 1, 0, 0.451724,-99) , 
3, 0.0958913, 0, 0, 0.499254,-99)    );
  // itree = 611
  fBoostWeights.push_back(0.148117);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.592624, 0, 1, 0.578791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32758,-99) , 
1, 0.0790163, 1, 0, 0.488205,-99) , 
3, -1.23105, 0, 0, 0.564507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459072,-99) , 
1, 0.0248927, 1, 0, 0.496451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270189,-99) , 
3, 0.857069, 0, 0, 0.474866,-99) , 
3, 0.660714, 1, 0, 0.517463,-99)    );
  // itree = 612
  fBoostWeights.push_back(0.1355);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396451,-99) , 
3, -1.96551, 0, 0, 0.583262,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448354,-99) , 
2, 1.42172, 0, 0, 0.46907,-99) , 
2, -0.736281, 1, 0, 0.487911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249146,-99) , 
2, 2.50146, 1, 0, 0.478924,-99)    );
  // itree = 613
  fBoostWeights.push_back(0.111532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.894985, 0, 1, 0.534774,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297607,-99) , 
3, 2.29129, 0, 0, 0.44353,-99) , 
0, 2.76614, 1, 0, 0.521169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347063,-99) , 
0, 3.92229, 1, 0, 0.511507,-99)    );
  // itree = 614
  fBoostWeights.push_back(0.169657);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.84489, 0, 1, 0.657472,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374019,-99) , 
2, 1.74974, 1, 0, 0.535877,-99) , 
1, -1.54304, 1, 0, 0.559605,-99) , 
NN(
NN(
0, 
0, 
-1, -2.85078, 1, 1, 0.61538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397768,-99) , 
3, 1.46586, 0, 0, 0.449041,-99) , 
3, -0.911842, 1, 0, 0.466653,-99) , 
1, -0.247217, 1, 0, 0.502042,-99)    );
  // itree = 615
  fBoostWeights.push_back(0.0781577);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497048,-99) , 
0, 3.14716, 0, 0, 0.505071,-99) , 
NN(
0, 
0, 
-1, -2.47538, 1, -1, 0.332237,-99) , 
3, -1.07223, 0, 0, 0.486048,-99) , 
NN(
0, 
0, 
-1, 0.473822, 1, -1, 0.304359,-99) , 
0, 3.81421, 1, 0, 0.473961,-99)    );
  // itree = 616
  fBoostWeights.push_back(0.0805437);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489951,-99) , 
3, -1.62128, 0, 0, 0.553502,-99) , 
NN(
0, 
0, 
-1, -0.156669, 0, -1, 0.467546,-99) , 
0, -1.98226, 1, 0, 0.474874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28261,-99) , 
0, 4.38122, 1, 0, 0.469726,-99)    );
  // itree = 617
  fBoostWeights.push_back(0.0798586);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730905,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496654,-99) , 
1, -1.40451, 1, 0, 0.51004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369969,-99) , 
1, -0.904068, 1, 0, 0.417445,-99) , 
0, -1.3079, 0, 0, 0.495358,-99) , 
1, 2.02302, 0, 0, 0.502024,-99)    );
  // itree = 618
  fBoostWeights.push_back(0.129453);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.689689, 1, 1, 0.547472,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41195,-99) , 
0, 3.61392, 0, 0, 0.462794,-99) , 
0, 2.38865, 1, 0, 0.521527,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580464,-99) , 
NN(
0, 
0, 
-1, -2.32475, 0, -1, 0.389292,-99) , 
0, -2.87171, 1, 0, 0.432618,-99) , 
3, -0.681783, 0, 0, 0.505653,-99)    );
  // itree = 619
  fBoostWeights.push_back(0.056007);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.10716, 1, 1, 0.517549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522599,-99) , 
NN(
0, 
0, 
-1, -1.58392, 0, -1, 0.314788,-99) , 
2, -2.12343, 1, 0, 0.373497,-99) , 
3, -1.17369, 0, 0, 0.505212,-99)    );
  // itree = 620
  fBoostWeights.push_back(0.120743);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699749,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46359,-99) , 
0, -1.50174, 1, 0, 0.516241,-99) , 
3, -0.0527389, 0, 0, 0.542852,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482858,-99) , 
1, -0.73235, 1, 0, 0.513216,-99) , 
NN(
0, 
0, 
-1, 0.840443, 1, -1, 0.432924,-99) , 
0, 1.64986, 0, 0, 0.474234,-99) , 
0, -0.239826, 1, 0, 0.493153,-99)    );
  // itree = 621
  fBoostWeights.push_back(0.137947);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.963233, 1, 1, 0.544788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372135,-99) , 
1, -0.705006, 1, 0, 0.400833,-99) , 
0, -0.709874, 0, 0, 0.509318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382626,-99) , 
0, 3.49253, 1, 0, 0.456688,-99) , 
NN(
0, 
0, 
-1, 2.8624, 0, -1, 0.329277,-99) , 
1, 0.318978, 1, 0, 0.406185,-99) , 
0, 2.59643, 1, 0, 0.486523,-99)    );
  // itree = 622
  fBoostWeights.push_back(0.157232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.188865, 0, 1, 0.739117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450442,-99) , 
0, -2.68497, 1, 0, 0.472077,-99) , 
1, -0.26126, 0, 0, 0.506755,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44175,-99) , 
3, -0.230563, 1, 0, 0.464586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300273,-99) , 
3, -1.09081, 0, 0, 0.454931,-99) , 
1, -0.0831057, 1, 0, 0.477322,-99)    );
  // itree = 623
  fBoostWeights.push_back(0.150211);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.02523, 0, 1, 0.666215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447082,-99) , 
1, 0.524921, 1, 0, 0.511699,-99) , 
0, -0.490607, 1, 0, 0.532436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422909,-99) , 
2, -1.70202, 0, 0, 0.480347,-99) , 
NN(
0, 
0, 
-1, 0.0552155, 1, -1, 0.308127,-99) , 
2, -1.16036, 1, 0, 0.392503,-99) , 
0, -1.35886, 0, 0, 0.5118,-99)    );
  // itree = 624
  fBoostWeights.push_back(0.109927);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.31524, 1, 1, 0.539332,-99) , 
NN(
0, 
0, 
-1, -1.30418, 0, -1, 0.40056,-99) , 
2, -1.04688, 0, 0, 0.525249,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575035,-99) , 
NN(
0, 
0, 
-1, 3.58843, 1, -1, 0.348955,-99) , 
2, 2.77909, 0, 0, 0.41524,-99) , 
2, 1.9471, 1, 0, 0.512956,-99)    );
  // itree = 625
  fBoostWeights.push_back(0.0977655);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.13094, 1, 1, 0.641064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460673,-99) , 
0, -3.52074, 1, 0, 0.488255,-99) , 
3, -1.49599, 0, 0, 0.579146,-99) , 
NN(
0, 
0, 
-1, 4.39512, 1, -1, 0.45863,-99) , 
0, -1.25772, 1, 0, 0.474961,-99)    );
  // itree = 626
  fBoostWeights.push_back(0.127671);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.268901, 1, 1, 0.562653,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496601,-99) , 
1, -1.00519, 0, 0, 0.520124,-99) , 
NN(
0, 
0, 
-1, -0.639139, 0, -1, 0.418846,-99) , 
1, -0.862599, 1, 0, 0.449947,-99) , 
1, 0.306557, 0, 0, 0.499892,-99)    );
  // itree = 627
  fBoostWeights.push_back(0.137306);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493228,-99) , 
1, -0.147132, 0, 0, 0.642353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417568,-99) , 
0, 0.283939, 1, 0, 0.480454,-99) , 
1, -0.245167, 0, 0, 0.508928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433629,-99) , 
3, 1.12884, 0, 0, 0.467763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360182,-99) , 
0, 3.49166, 1, 0, 0.460653,-99) , 
1, -0.0583898, 1, 0, 0.480977,-99)    );
  // itree = 628
  fBoostWeights.push_back(0.142237);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480194,-99) , 
0, 4.34036, 1, 0, 0.67899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457365,-99) , 
3, 2.65712, 0, 0, 0.613052,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492886,-99) , 
3, -1.43218, 0, 0, 0.591006,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44927,-99) , 
2, 0.735288, 1, 0, 0.50425,-99) , 
0, -0.994092, 1, 0, 0.522965,-99) , 
3, 2.41698, 0, 0, 0.535423,-99)    );
  // itree = 629
  fBoostWeights.push_back(0.115595);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5445, 1, 1, 0.607701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395934,-99) , 
1, 2.17011, 1, 0, 0.560319,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477035,-99) , 
0, 2.09605, 0, 0, 0.495717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380191,-99) , 
1, -0.918593, 1, 0, 0.426557,-99) , 
2, 1.60346, 1, 0, 0.482677,-99) , 
1, 1.29294, 0, 0, 0.491989,-99)    );
  // itree = 630
  fBoostWeights.push_back(0.114993);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.878972, 1, 1, 0.569338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33083,-99) , 
2, -0.0890864, 1, 0, 0.478503,-99) , 
0, -0.576788, 0, 0, 0.546675,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413363,-99) , 
2, 0.0942551, 0, 0, 0.476422,-99) , 
2, -1.15581, 1, 0, 0.492779,-99) , 
1, 0.220021, 1, 0, 0.521997,-99)    );
  // itree = 631
  fBoostWeights.push_back(0.125422);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493771,-99) , 
1, 0.664661, 1, 0, 0.549031,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451296,-99) , 
1, -2.06062, 1, 0, 0.465574,-99) , 
1, -0.219096, 0, 0, 0.512007,-99) , 
NN(
0, 
0, 
-1, 2.33968, 1, -1, 0.38071,-99) , 
1, 1.32873, 1, 0, 0.495985,-99)    );
  // itree = 632
  fBoostWeights.push_back(0.162068);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43542,-99) , 
1, -1.5551, 0, 0, 0.652369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493361,-99) , 
1, 1.05155, 0, 0, 0.533362,-99) , 
1, -0.43731, 1, 0, 0.573415,-99) , 
NN(
NN(
0, 
0, 
-1, 2.19832, 1, 1, 0.571254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393245,-99) , 
0, 1.21032, 1, 0, 0.466811,-99) , 
3, 1.68777, 0, 0, 0.514615,-99) , 
2, 0.326618, 1, 0, 0.540085,-99)    );
  // itree = 633
  fBoostWeights.push_back(0.0913314);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483039,-99) , 
3, -1.71794, 0, 0, 0.643949,-99) , 
NN(
0, 
0, 
-1, -0.570791, 0, -1, 0.482258,-99) , 
2, -1.18762, 1, 0, 0.497978,-99) , 
NN(
0, 
0, 
-1, 1.61211, 1, -1, 0.379427,-99) , 
0, 2.93334, 1, 0, 0.479144,-99)    );
  // itree = 634
  fBoostWeights.push_back(0.0985918);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.843653, 0, 1, 0.656302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338544,-99) , 
1, -0.263452, 0, 0, 0.484858,-99) , 
2, -1.14236, 0, 0, 0.58376,-99) , 
NN(
NN(
0, 
0, 
-1, 0.11605, 1, 1, 0.518232,-99) , 
NN(
0, 
0, 
-1, -0.31474, 1, -1, 0.401103,-99) , 
3, 0.0585678, 0, 0, 0.505941,-99) , 
0, -0.602658, 1, 0, 0.521568,-99)    );
  // itree = 635
  fBoostWeights.push_back(0.113939);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63556, 1, 1, 0.644934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476016,-99) , 
2, -0.202153, 1, 0, 0.504466,-99) , 
3, 2.0193, 0, 0, 0.522814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203202,-99) , 
0, 4.31708, 1, 0, 0.40246,-99) , 
0, 3.72663, 1, 0, 0.513957,-99)    );
  // itree = 636
  fBoostWeights.push_back(0.103333);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.174046, 1, 1, 0.540326,-99) , 
NN(
0, 
0, 
-1, 0.736794, 1, -1, 0.458549,-99) , 
3, 0.116026, 0, 0, 0.508255,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508582,-99) , 
NN(
0, 
0, 
-1, 4.08625, 0, -1, 0.334687,-99) , 
0, 3.48238, 1, 0, 0.384053,-99) , 
0, 3.03844, 1, 0, 0.491629,-99)    );
  // itree = 637
  fBoostWeights.push_back(0.144228);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.666621, 1, 1, 0.586837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392297,-99) , 
3, -1.56837, 0, 0, 0.567247,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45996,-99) , 
1, 0.755594, 0, 0, 0.484969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292432,-99) , 
0, 4.01186, 1, 0, 0.470312,-99) , 
2, 0.340279, 1, 0, 0.511718,-99)    );
  // itree = 638
  fBoostWeights.push_back(0.113196);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.8412, 0, 1, 0.637782,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429415,-99) , 
1, 0.421129, 0, 0, 0.593201,-99) , 
NN(
0, 
0, 
-1, 0.600608, 1, -1, 0.459715,-99) , 
2, 2.06856, 0, 0, 0.472018,-99) , 
2, -1.49556, 1, 0, 0.480987,-99)    );
  // itree = 639
  fBoostWeights.push_back(0.163693);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440959,-99) , 
1, 0.537118, 0, 0, 0.610071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321985,-99) , 
3, -1.05064, 0, 0, 0.527015,-99) , 
1, 0.425518, 0, 0, 0.543367,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608009,-99) , 
NN(
0, 
0, 
-1, 1.01548, 1, -1, 0.410197,-99) , 
1, 1.93103, 0, 0, 0.435603,-99) , 
1, 0.889902, 1, 0, 0.520104,-99)    );
  // itree = 640
  fBoostWeights.push_back(0.176977);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425806,-99) , 
2, 1.51077, 1, 0, 0.582565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404899,-99) , 
3, 1.48259, 0, 0, 0.472338,-99) , 
1, 1.14404, 1, 0, 0.54813,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478228,-99) , 
3, 1.42984, 1, 0, 0.538085,-99) , 
NN(
0, 
0, 
-1, 0.792415, 1, -1, 0.440095,-99) , 
2, 0.913177, 0, 0, 0.477887,-99) , 
1, -0.0100907, 0, 0, 0.514216,-99)    );
  // itree = 641
  fBoostWeights.push_back(0.11655);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477367,-99) , 
0, 2.26896, 1, 0, 0.578424,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405918,-99) , 
1, 0.114108, 1, 0, 0.517123,-99) , 
1, 0.292751, 0, 0, 0.537407,-99) , 
NN(
0, 
0, 
-1, 2.03113, 1, -1, 0.40941,-99) , 
1, 1.17699, 1, 0, 0.518321,-99)    );
  // itree = 642
  fBoostWeights.push_back(0.131817);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0559268, 1, 1, 0.605652,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372396,-99) , 
1, 0.83637, 1, 0, 0.51934,-99) , 
1, 1.09058, 0, 0, 0.536783,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483864,-99) , 
3, 2.95435, 1, 0, 0.560964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361001,-99) , 
2, 1.69318, 0, 0, 0.406741,-99) , 
0, 3.56122, 0, 0, 0.470579,-99) , 
0, 2.26267, 1, 0, 0.520166,-99)    );
  // itree = 643
  fBoostWeights.push_back(0.10051);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478163,-99) , 
2, -0.119616, 0, 0, 0.588916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473527,-99) , 
1, 1.43432, 0, 0, 0.488371,-99) , 
1, -0.921741, 1, 0, 0.503933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302871,-99) , 
2, -1.91397, 0, 0, 0.49797,-99)    );
  // itree = 644
  fBoostWeights.push_back(0.19969);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.664384, 1, 1, 0.591038,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374528,-99) , 
1, -0.952535, 1, 0, 0.451246,-99) , 
2, -0.397302, 0, 0, 0.558123,-99) , 
NN(
NN(
0, 
0, 
-1, -2.28104, 1, 1, 0.582507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395319,-99) , 
3, 2.92918, 0, 0, 0.41884,-99) , 
3, -0.291484, 1, 0, 0.445985,-99) , 
1, -0.0653764, 1, 0, 0.495017,-99)    );
  // itree = 645
  fBoostWeights.push_back(0.126578);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16554, 0, 1, 0.556975,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384255,-99) , 
2, -0.942541, 1, 0, 0.464892,-99) , 
3, -0.341093, 0, 0, 0.524775,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465794,-99) , 
2, 1.10757, 1, 0, 0.492213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340727,-99) , 
3, 1.20946, 0, 0, 0.466172,-99) , 
0, 1.4869, 1, 0, 0.500644,-99)    );
  // itree = 646
  fBoostWeights.push_back(0.129705);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89429, 1, 1, 0.603318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447612,-99) , 
3, -0.749701, 0, 0, 0.56687,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489419,-99) , 
0, 2.01847, 0, 0, 0.519788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329064,-99) , 
0, 0.134524, 1, 0, 0.403735,-99) , 
1, -0.234483, 0, 0, 0.491204,-99) , 
1, -0.851532, 1, 0, 0.503783,-99)    );
  // itree = 647
  fBoostWeights.push_back(0.163201);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.11567, 1, 1, 0.572056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306856,-99) , 
3, -1.77506, 0, 0, 0.558941,-99) , 
NN(
NN(
0, 
0, 
-1, 1.83619, 0, 1, 0.551307,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355182,-99) , 
0, 3.35146, 0, 0, 0.403476,-99) , 
1, 0.623353, 0, 0, 0.441408,-99) , 
2, 1.14745, 1, 0, 0.522325,-99)    );
  // itree = 648
  fBoostWeights.push_back(0.105575);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.48633, 0, 1, 0.540268,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608553,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333291,-99) , 
3, 1.47146, 0, 0, 0.390038,-99) , 
0, -1.19112, 1, 0, 0.433746,-99) , 
1, -1.03268, 0, 0, 0.522296,-99)    );
  // itree = 649
  fBoostWeights.push_back(0.15481);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92018, 0, 1, 0.593646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441971,-99) , 
3, -1.71049, 1, 0, 0.455593,-99) , 
3, 0.899631, 0, 0, 0.497032,-99) , 
NN(
0, 
0, 
-1, 0.652458, 0, -1, 0.405298,-99) , 
0, 2.59251, 1, 0, 0.476701,-99)    );
  // itree = 650
  fBoostWeights.push_back(0.144382);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5576, 0, 1, 0.583591,-99) , 
NN(
0, 
0, 
-1, 0.220752, 1, -1, 0.382908,-99) , 
0, 3.69083, 1, 0, 0.524011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460129,-99) , 
2, 1.11984, 0, 0, 0.475286,-99) , 
NN(
0, 
0, 
-1, 1.37207, 0, -1, 0.336538,-99) , 
0, 1.74665, 1, 0, 0.45862,-99) , 
3, 1.63723, 0, 0, 0.4757,-99)    );
  // itree = 651
  fBoostWeights.push_back(0.0608469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495791,-99) , 
2, -0.483633, 1, 0, 0.503001,-99) , 
3, -0.49981, 1, 0, 0.513729,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570675,-99) , 
NN(
0, 
0, 
-1, -1.38515, 0, -1, 0.410438,-99) , 
0, -2.96596, 1, 0, 0.449632,-99) , 
3, -0.772864, 0, 0, 0.504464,-99)    );
  // itree = 652
  fBoostWeights.push_back(0.121496);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.222339, 1, 1, 0.605126,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411211,-99) , 
3, 2.23027, 1, 0, 0.522495,-99) , 
1, 0.386635, 1, 0, 0.550379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62523,-99) , 
NN(
0, 
0, 
-1, -0.693658, 0, -1, 0.460791,-99) , 
0, -1.93147, 1, 0, 0.477593,-99) , 
1, -0.222879, 0, 0, 0.520686,-99)    );
  // itree = 653
  fBoostWeights.push_back(0.161065);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.123023, 1, 1, 0.62802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436843,-99) , 
2, -0.120918, 0, 0, 0.493302,-99) , 
1, -0.165018, 0, 0, 0.577831,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491382,-99) , 
2, 1.93462, 1, 0, 0.574196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399299,-99) , 
0, 2.18673, 1, 0, 0.466316,-99) , 
0, 3.60771, 0, 0, 0.485726,-99) , 
2, 0.38096, 1, 0, 0.526088,-99)    );
  // itree = 654
  fBoostWeights.push_back(0.139224);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442812,-99) , 
3, 0.257649, 0, 0, 0.536663,-99) , 
NN(
0, 
0, 
-1, 0.933752, 1, -1, 0.458542,-99) , 
1, 0.307057, 0, 0, 0.494798,-99) , 
NN(
0, 
0, 
-1, 2.6877, 0, -1, 0.355312,-99) , 
2, 1.90468, 1, 0, 0.480201,-99)    );
  // itree = 655
  fBoostWeights.push_back(0.0890097);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.54083, 1, 1, 0.63199,-99) , 
NN(
NN(
0, 
0, 
-1, 0.221581, 0, 1, 0.607306,-99) , 
NN(
0, 
0, 
-1, -0.995499, 0, -1, 0.47743,-99) , 
1, -1.44722, 1, 0, 0.486337,-99) , 
3, 2.26964, 0, 0, 0.508839,-99)    );
  // itree = 656
  fBoostWeights.push_back(0.156086);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481394,-99) , 
3, -0.814464, 0, 0, 0.596364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375765,-99) , 
0, 0.510204, 0, 0, 0.526407,-99) , 
0, 0.149794, 1, 0, 0.550416,-99) , 
NN(
0, 
0, 
-1, 0.703336, 1, -1, 0.367168,-99) , 
1, 1.53811, 1, 0, 0.533416,-99)    );
  // itree = 657
  fBoostWeights.push_back(0.162541);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29434, 1, 1, 0.603792,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462079,-99) , 
0, -0.727992, 1, 0, 0.517957,-99) , 
3, 0.285418, 0, 0, 0.54627,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447644,-99) , 
3, 1.53678, 1, 0, 0.485774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233475,-99) , 
3, 1.01833, 0, 0, 0.44908,-99) , 
2, 0.681903, 1, 0, 0.504726,-99)    );
  // itree = 658
  fBoostWeights.push_back(0.0995492);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49275,-99) , 
1, 0.544383, 0, 0, 0.597223,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490512,-99) , 
0, 3.18466, 1, 0, 0.568509,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453929,-99) , 
2, -0.332591, 1, 0, 0.467621,-99) , 
2, 1.8768, 0, 0, 0.480633,-99) , 
2, -1.44612, 1, 0, 0.488785,-99)    );
  // itree = 659
  fBoostWeights.push_back(0.104879);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47888,-99) , 
2, 0.730595, 1, 0, 0.520119,-99) , 
NN(
0, 
0, 
-1, -0.020666, 0, -1, 0.432994,-99) , 
1, 0.7085, 1, 0, 0.495784,-99) , 
0, -2.92224, 1, 0, 0.502995,-99)    );
  // itree = 660
  fBoostWeights.push_back(0.113627);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480663,-99) , 
3, -0.43012, 0, 0, 0.540688,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431355,-99) , 
1, 0.0120293, 1, 0, 0.475837,-99) , 
0, 0.922503, 1, 0, 0.506614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278403,-99) , 
3, -1.80839, 0, 0, 0.500006,-99)    );
  // itree = 661
  fBoostWeights.push_back(0.171255);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.742885, 0, 1, 0.599107,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359548,-99) , 
2, 0.971533, 1, 0, 0.496918,-99) , 
1, 1.25664, 1, 0, 0.568024,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463725,-99) , 
0, 2.73547, 1, 0, 0.576181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344462,-99) , 
2, 0.558529, 1, 0, 0.484139,-99) , 
3, 1.28198, 0, 0, 0.513749,-99) , 
1, 0.360265, 0, 0, 0.536632,-99)    );
  // itree = 662
  fBoostWeights.push_back(0.162509);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.40506, 0, 1, 0.622592,-99) , 
NN(
0, 
0, 
-1, -0.0138395, 1, -1, 0.478649,-99) , 
3, 2.94058, 1, 0, 0.584665,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420902,-99) , 
1, -0.0600526, 1, 0, 0.486879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314902,-99) , 
0, 1.3985, 0, 0, 0.425561,-99) , 
0, 0.575631, 1, 0, 0.457651,-99) , 
0, 2.73605, 0, 0, 0.481021,-99)    );
  // itree = 663
  fBoostWeights.push_back(0.0818909);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.699436, 0, 1, 0.539338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282896,-99) , 
1, 1.27645, 1, 0, 0.47249,-99) , 
0, 1.48672, 1, 0, 0.50994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325217,-99) , 
3, -1.73948, 0, 0, 0.504231,-99)    );
  // itree = 664
  fBoostWeights.push_back(0.13961);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.99105, 1, 1, 0.70598,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368568,-99) , 
3, 2.91082, 0, 0, 0.481284,-99) , 
0, 3.4529, 1, 0, 0.597676,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460148,-99) , 
1, -0.0762474, 0, 0, 0.506793,-99) , 
NN(
0, 
0, 
-1, 2.11622, 1, -1, 0.332071,-99) , 
2, 1.36018, 1, 0, 0.49119,-99) , 
2, 1.68008, 0, 0, 0.510143,-99)    );
  // itree = 665
  fBoostWeights.push_back(0.0805221);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.57729, 0, -1, 0.476431,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422723,-99) , 
2, 2.08725, 1, 0, 0.496541,-99) , 
NN(
0, 
0, 
-1, 2.67258, 0, -1, 0.347591,-99) , 
1, -0.0782764, 1, 0, 0.407675,-99) , 
2, 1.59064, 1, 0, 0.464717,-99)    );
  // itree = 666
  fBoostWeights.push_back(0.1506);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.72189, 0, 1, 0.667584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360229,-99) , 
3, 2.97909, 0, 0, 0.47283,-99) , 
1, 0.164353, 1, 0, 0.582476,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399498,-99) , 
1, 0.355289, 1, 0, 0.518279,-99) , 
NN(
0, 
0, 
-1, -0.625551, 0, -1, 0.443772,-99) , 
0, -1.70052, 1, 0, 0.452427,-99) , 
2, 1.67097, 0, 0, 0.473249,-99)    );
  // itree = 667
  fBoostWeights.push_back(0.100152);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45754, 0, 1, 0.538872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281754,-99) , 
3, -1.95919, 0, 0, 0.531108,-99) , 
NN(
0, 
0, 
-1, -0.114975, 0, -1, 0.373031,-99) , 
0, 3.72663, 1, 0, 0.520363,-99)    );
  // itree = 668
  fBoostWeights.push_back(0.0569349);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648369,-99) , 
NN(
NN(
0, 
0, 
-1, -0.851532, 1, 1, 0.519886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365943,-99) , 
0, 3.95674, 1, 0, 0.515023,-99) , 
2, 2.59748, 0, 0, 0.520303,-99)    );
  // itree = 669
  fBoostWeights.push_back(0.143908);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468803,-99) , 
2, 2.22799, 1, 0, 0.611606,-99) , 
3, 3.48848, 0, 0, 0.654148,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400227,-99) , 
1, 0.905713, 1, 0, 0.522174,-99) , 
NN(
0, 
0, 
-1, 0.249914, 0, -1, 0.454506,-99) , 
0, 0.798796, 1, 0, 0.490225,-99) , 
3, 2.50293, 0, 0, 0.509768,-99)    );
  // itree = 670
  fBoostWeights.push_back(0.136225);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490831,-99) , 
1, -0.510073, 1, 0, 0.510006,-99) , 
2, 2.82391, 0, 0, 0.518253,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390871,-99) , 
3, -1.83792, 0, 0, 0.468449,-99) , 
NN(
0, 
0, 
-1, -0.559926, 0, -1, 0.371979,-99) , 
0, -2.23943, 1, 0, 0.386301,-99) , 
0, 0.45556, 0, 0, 0.462999,-99)    );
  // itree = 671
  fBoostWeights.push_back(0.171235);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493569,-99) , 
2, 0.748804, 1, 0, 0.591499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465767,-99) , 
3, 0.0527968, 0, 0, 0.562773,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312967,-99) , 
2, 1.30336, 1, 0, 0.504198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424742,-99) , 
1, -0.635377, 1, 0, 0.433582,-99) , 
1, -0.733918, 1, 0, 0.448316,-99) , 
1, 1.32873, 0, 0, 0.463287,-99)    );
  // itree = 672
  fBoostWeights.push_back(0.145466);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.55947, 0, 1, 0.553928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398621,-99) , 
3, -0.718607, 0, 0, 0.455133,-99) , 
NN(
0, 
0, 
-1, 0.389405, 1, -1, 0.327769,-99) , 
0, -0.392529, 1, 0, 0.414068,-99) , 
2, -0.164042, 0, 0, 0.51253,-99)    );
  // itree = 673
  fBoostWeights.push_back(0.070574);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.83901, 0, 1, 0.528181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227948,-99) , 
3, 2.71262, 0, 0, 0.388265,-99) , 
2, 2.11909, 1, 0, 0.516737,-99)    );
  // itree = 674
  fBoostWeights.push_back(0.166689);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469841,-99) , 
0, -0.387431, 0, 0, 0.594711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385769,-99) , 
2, -0.620389, 1, 0, 0.493025,-99) , 
3, -0.14713, 0, 0, 0.522695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416526,-99) , 
1, -0.0583898, 1, 0, 0.46492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268087,-99) , 
3, 0.227427, 0, 0, 0.45073,-99) , 
0, 0.10252, 1, 0, 0.474961,-99)    );
  // itree = 675
  fBoostWeights.push_back(0.127268);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.17307, 1, 1, 0.662274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388593,-99) , 
3, 0.737309, 0, 0, 0.486483,-99) , 
0, 0.26214, 1, 0, 0.513984,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447555,-99) , 
0, -0.805971, 0, 0, 0.492652,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341185,-99) , 
0, -2.21431, 1, 0, 0.401697,-99) , 
1, 0.063023, 1, 0, 0.450761,-99) , 
3, -0.181625, 0, 0, 0.496234,-99)    );
  // itree = 676
  fBoostWeights.push_back(0.102673);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618987,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475699,-99) , 
3, 0.228221, 0, 0, 0.498718,-99) , 
NN(
0, 
0, 
-1, 1.49751, 0, -1, 0.445562,-99) , 
2, 0.047647, 1, 0, 0.463515,-99) , 
0, 4.58999, 0, 0, 0.46864,-99)    );
  // itree = 677
  fBoostWeights.push_back(0.0867274);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.971382, 0, 1, 0.64875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332775,-99) , 
0, 3.92858, 1, 0, 0.515907,-99) , 
2, -0.990989, 1, 0, 0.524627,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352588,-99) , 
3, -1.59439, 0, 0, 0.51744,-99)    );
  // itree = 678
  fBoostWeights.push_back(0.146688);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.23035, 0, 1, 0.568496,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415747,-99) , 
0, -3.18212, 1, 0, 0.478238,-99) , 
3, -1.28733, 0, 0, 0.555803,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345898,-99) , 
0, 4.01007, 1, 0, 0.542727,-99) , 
NN(
0, 
0, 
-1, 1.05184, 1, -1, 0.442534,-99) , 
3, 2.26493, 0, 0, 0.473751,-99) , 
2, 0.66976, 1, 0, 0.520212,-99)    );
  // itree = 679
  fBoostWeights.push_back(0.152738);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29753, 1, 1, 0.616488,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47031,-99) , 
2, 0.518932, 1, 0, 0.489371,-99) , 
1, 0.491041, 0, 0, 0.53529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409518,-99) , 
2, -1.21109, 1, 0, 0.432862,-99) , 
1, -1.38164, 1, 0, 0.44582,-99) , 
2, 0.326618, 0, 0, 0.497968,-99)    );
  // itree = 680
  fBoostWeights.push_back(0.102388);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652487,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468528,-99) , 
2, -0.403622, 1, 0, 0.490463,-99) , 
NN(
0, 
0, 
-1, -2.74578, 1, -1, 0.399907,-99) , 
3, -1.15309, 0, 0, 0.482667,-99) , 
3, 3.45606, 0, 0, 0.487354,-99)    );
  // itree = 681
  fBoostWeights.push_back(0.131931);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727911,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422679,-99) , 
2, -1.30065, 0, 0, 0.521399,-99) , 
2, 0.989411, 0, 0, 0.539076,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355089,-99) , 
0, 4.06698, 1, 0, 0.494767,-99) , 
NN(
0, 
0, 
-1, 1.10257, 0, -1, 0.404606,-99) , 
3, 1.68005, 0, 0, 0.457287,-99) , 
0, 1.34675, 1, 0, 0.501192,-99)    );
  // itree = 682
  fBoostWeights.push_back(0.145023);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436952,-99) , 
1, 0.563324, 1, 0, 0.586565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454958,-99) , 
3, 1.01754, 0, 0, 0.483518,-99) , 
1, 0.450516, 0, 0, 0.49669,-99) , 
NN(
NN(
0, 
0, 
-1, 1.0287, 1, 1, 0.554503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360244,-99) , 
2, -1.49416, 1, 0, 0.38206,-99) , 
0, 2.19831, 0, 0, 0.41983,-99) , 
1, 0.663985, 1, 0, 0.471728,-99)    );
  // itree = 683
  fBoostWeights.push_back(0.109403);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.542031,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449738,-99) , 
0, -1.11805, 1, 0, 0.495462,-99) , 
3, 0.625535, 0, 0, 0.519702,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450141,-99) , 
1, 1.76502, 0, 0, 0.506361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307819,-99) , 
0, 2.23546, 1, 0, 0.447215,-99) , 
1, 1.36272, 1, 0, 0.511909,-99)    );
  // itree = 684
  fBoostWeights.push_back(0.0752851);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.03145, 0, 1, 0.62196,-99) , 
NN(
0, 
0, 
-1, -0.0470096, 0, -1, 0.475314,-99) , 
0, -1.42157, 1, 0, 0.489518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372878,-99) , 
3, -1.80839, 0, 0, 0.485175,-99)    );
  // itree = 685
  fBoostWeights.push_back(0.0775601);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.41712, 1, 1, 0.530602,-99) , 
NN(
0, 
0, 
-1, -1.42707, 0, -1, 0.405374,-99) , 
2, -1.01773, 0, 0, 0.514758,-99)    );
  // itree = 686
  fBoostWeights.push_back(0.114);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.186537, 0, 1, 0.567128,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461932,-99) , 
1, 0.401202, 0, 0, 0.525819,-99) , 
NN(
0, 
0, 
-1, 1.21384, 0, -1, 0.45818,-99) , 
3, 0.945375, 1, 0, 0.477098,-99) , 
0, 0.143443, 1, 0, 0.509109,-99)    );
  // itree = 687
  fBoostWeights.push_back(0.0975093);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.139314, 0, 1, 0.572261,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403306,-99) , 
2, 2.24115, 1, 0, 0.498152,-99) , 
3, 0.584863, 1, 0, 0.52959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38602,-99) , 
3, -1.59907, 0, 0, 0.522554,-99)    );
  // itree = 688
  fBoostWeights.push_back(0.129386);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.204689, 0, 1, 0.552267,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458437,-99) , 
2, 1.622, 1, 0, 0.520538,-99) , 
NN(
0, 
0, 
-1, -0.337635, 1, -1, 0.385792,-99) , 
2, 0.562103, 0, 0, 0.476291,-99) , 
0, 0.0600484, 1, 0, 0.501905,-99)    );
  // itree = 689
  fBoostWeights.push_back(0.131577);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.10354, 1, 1, 0.599535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450671,-99) , 
1, 0.678491, 0, 0, 0.493043,-99) , 
2, -0.225016, 0, 0, 0.528541,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319531,-99) , 
0, 3.80859, 1, 0, 0.49016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316495,-99) , 
3, 0.491868, 0, 0, 0.46584,-99) , 
2, 0.283192, 1, 0, 0.493577,-99)    );
  // itree = 690
  fBoostWeights.push_back(0.102186);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473731,-99) , 
1, 0.882734, 1, 0, 0.584583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396457,-99) , 
3, -1.78098, 0, 0, 0.544107,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476026,-99) , 
0, 0.124495, 1, 0, 0.489697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343683,-99) , 
3, -0.262711, 0, 0, 0.477815,-99) , 
0, -1.1147, 1, 0, 0.490045,-99)    );
  // itree = 691
  fBoostWeights.push_back(0.0551646);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411764,-99) , 
2, 1.79361, 1, 0, 0.490081,-99) , 
0, 4.36839, 0, 0, 0.496153,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419157,-99) , 
2, -1.47123, 1, 0, 0.470885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26834,-99) , 
1, 0.0278957, 1, 0, 0.388097,-99) , 
3, -1.09081, 0, 0, 0.486103,-99)    );
  // itree = 692
  fBoostWeights.push_back(0.178663);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450733,-99) , 
3, 0.272974, 1, 0, 0.633327,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420774,-99) , 
2, -0.120988, 0, 0, 0.442902,-99) , 
3, -0.105079, 0, 0, 0.508573,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490359,-99) , 
2, 2.48304, 0, 0, 0.576852,-99) , 
NN(
0, 
0, 
-1, 1.64739, 1, -1, 0.427207,-99) , 
3, 2.7996, 0, 0, 0.443644,-99) , 
3, 0.461824, 1, 0, 0.469595,-99)    );
  // itree = 693
  fBoostWeights.push_back(0.138264);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.490323, 1, 1, 0.568512,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309951,-99) , 
1, 0.0278957, 1, 0, 0.462368,-99) , 
3, -0.776089, 0, 0, 0.532297,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463975,-99) , 
2, 1.18772, 0, 0, 0.5094,-99) , 
NN(
0, 
0, 
-1, 0.40671, 1, -1, 0.359581,-99) , 
0, 1.17247, 0, 0, 0.472386,-99) , 
2, 0.439105, 1, 0, 0.499988,-99)    );
  // itree = 694
  fBoostWeights.push_back(0.115573);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453734,-99) , 
3, 0.551281, 0, 0, 0.559299,-99) , 
NN(
0, 
0, 
-1, 3.72663, 1, -1, 0.482963,-99) , 
1, 0.241506, 0, 0, 0.517792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349932,-99) , 
1, 1.97524, 1, 0, 0.509969,-99)    );
  // itree = 695
  fBoostWeights.push_back(0.103636);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.35104, 1, 1, 0.573609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463222,-99) , 
1, -0.948643, 0, 0, 0.554021,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477601,-99) , 
2, 0.860561, 0, 0, 0.487086,-99) , 
NN(
0, 
0, 
-1, 0.189812, 1, -1, 0.36595,-99) , 
0, 1.82555, 1, 0, 0.469302,-99) , 
2, 1.16075, 0, 0, 0.494443,-99)    );
  // itree = 696
  fBoostWeights.push_back(0.1156);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474824,-99) , 
3, 1.84656, 1, 0, 0.529294,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350976,-99) , 
0, 1.36781, 1, 0, 0.435421,-99) , 
1, 1.00744, 1, 0, 0.509279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319625,-99) , 
3, -1.73948, 0, 0, 0.50262,-99)    );
  // itree = 697
  fBoostWeights.push_back(0.131533);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2759, 0, 1, 0.720033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338862,-99) , 
2, 2.43731, 1, 0, 0.525747,-99) , 
1, 0.638828, 0, 0, 0.599618,-99) , 
NN(
NN(
0, 
0, 
-1, -1.926, 0, 1, 0.606337,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428039,-99) , 
3, 0.43118, 0, 0, 0.466104,-99) , 
2, -1.59558, 1, 0, 0.477255,-99) , 
2, 1.54984, 0, 0, 0.504499,-99)    );
  // itree = 698
  fBoostWeights.push_back(0.13657);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52713, 1, 1, 0.664225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470914,-99) , 
2, -0.359336, 0, 0, 0.607089,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430691,-99) , 
0, -0.723087, 0, 0, 0.532112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443546,-99) , 
0, -2.14432, 1, 0, 0.456755,-99) , 
1, 0.00549461, 1, 0, 0.495344,-99) , 
1, 1.46771, 0, 0, 0.506677,-99)    );
  // itree = 699
  fBoostWeights.push_back(0.0652667);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.502076, 1, 1, 0.5231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289137,-99) , 
0, 4.25599, 1, 0, 0.516307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391933,-99) , 
0, -2.6197, 0, 0, 0.509996,-99)    );
  // itree = 700
  fBoostWeights.push_back(0.151052);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.064538, 0, 1, 0.60846,-99) , 
NN(
0, 
0, 
-1, -1.06945, 0, -1, 0.441497,-99) , 
1, 0.306557, 1, 0, 0.544792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498975,-99) , 
1, 0.357045, 1, 0, 0.584412,-99) , 
NN(
0, 
0, 
-1, -0.443083, 0, -1, 0.442565,-99) , 
0, 3.52937, 0, 0, 0.470572,-99) , 
0, 0.966579, 1, 0, 0.50433,-99)    );
  // itree = 701
  fBoostWeights.push_back(0.134929);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.687099, 0, 1, 0.55687,-99) , 
NN(
0, 
0, 
-1, -1.7768, 0, -1, 0.37675,-99) , 
1, -1.38164, 0, 0, 0.533322,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465787,-99) , 
2, 2.94505, 0, 0, 0.479109,-99) , 
NN(
0, 
0, 
-1, -0.504088, 0, -1, 0.302009,-99) , 
3, 0.935319, 0, 0, 0.450556,-99) , 
0, 0.711123, 1, 0, 0.486181,-99)    );
  // itree = 702
  fBoostWeights.push_back(0.141955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27556, 1, 1, 0.629178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454994,-99) , 
2, -1.05161, 0, 0, 0.535409,-99) , 
3, 0.255363, 0, 0, 0.597445,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614809,-99) , 
NN(
0, 
0, 
-1, 1.19126, 1, -1, 0.462015,-99) , 
3, 2.64893, 0, 0, 0.471893,-99) , 
1, 0.360265, 0, 0, 0.52476,-99)    );
  // itree = 703
  fBoostWeights.push_back(0.127137);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4259,-99) , 
1, 1.29247, 1, 0, 0.632738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36453,-99) , 
1, -0.679711, 0, 0, 0.562426,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464678,-99) , 
1, -1.39783, 0, 0, 0.563118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421449,-99) , 
1, -0.023278, 0, 0, 0.472017,-99) , 
1, -1.12422, 1, 0, 0.484657,-99) , 
2, -0.510447, 1, 0, 0.49924,-99)    );
  // itree = 704
  fBoostWeights.push_back(0.120846);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21438, 0, 1, 0.708539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449077,-99) , 
0, -0.561867, 1, 0, 0.500367,-99) , 
2, 1.62696, 0, 0, 0.548462,-99) , 
NN(
0, 
0, 
-1, 2.05056, 1, -1, 0.455867,-99) , 
1, 0.678491, 0, 0, 0.481743,-99)    );
  // itree = 705
  fBoostWeights.push_back(0.113865);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17439, 1, 1, 0.555696,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425353,-99) , 
3, 0.463861, 1, 0, 0.498334,-99) , 
3, 0.761598, 0, 0, 0.536464,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654033,-99) , 
NN(
0, 
0, 
-1, -0.373566, 1, -1, 0.441717,-99) , 
0, -3.68531, 1, 0, 0.465212,-99) , 
0, -0.431695, 0, 0, 0.517303,-99)    );
  // itree = 706
  fBoostWeights.push_back(0.0812615);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.823777, 0, 1, 0.606603,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494955,-99) , 
1, 2.04401, 0, 0, 0.507296,-99) , 
1, -0.545511, 1, 0, 0.530994,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320117,-99) , 
1, -1.28498, 0, 0, 0.482731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29883,-99) , 
1, 1.26222, 1, 0, 0.461529,-99) , 
3, -0.0172705, 0, 0, 0.512423,-99)    );
  // itree = 707
  fBoostWeights.push_back(0.126569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.623296, 0, 1, 0.544067,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278186,-99) , 
3, 2.49854, 0, 0, 0.46434,-99) , 
0, 2.86792, 1, 0, 0.533418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304923,-99) , 
2, 2.4889, 1, 0, 0.526042,-99)    );
  // itree = 708
  fBoostWeights.push_back(0.113849);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.902558, 1, 1, 0.533607,-99) , 
NN(
0, 
0, 
-1, 0.487117, 1, -1, 0.319479,-99) , 
1, -1.7091, 0, 0, 0.51617,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544547,-99) , 
NN(
0, 
0, 
-1, 1.26259, 0, -1, 0.397791,-99) , 
2, 1.34628, 0, 0, 0.425631,-99) , 
1, 0.905713, 1, 0, 0.494162,-99)    );
  // itree = 709
  fBoostWeights.push_back(0.154543);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492849,-99) , 
2, 1.14412, 1, 0, 0.541506,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391755,-99) , 
0, 0.878058, 1, 0, 0.475369,-99) , 
3, 1.47199, 0, 0, 0.502471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507003,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343616,-99) , 
1, 0.944635, 0, 0, 0.389896,-99) , 
1, -1.29869, 1, 0, 0.40822,-99) , 
3, -0.2551, 0, 0, 0.480054,-99)    );
  // itree = 710
  fBoostWeights.push_back(0.127715);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458603,-99) , 
0, 3.49955, 1, 0, 0.61389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400468,-99) , 
3, 2.27971, 1, 0, 0.473254,-99) , 
1, 0.183821, 1, 0, 0.55002,-99) , 
NN(
0, 
0, 
-1, 1.69952, 1, -1, 0.463964,-99) , 
2, 0.729595, 0, 0, 0.502117,-99)    );
  // itree = 711
  fBoostWeights.push_back(0.132513);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419334,-99) , 
3, -0.38477, 0, 0, 0.510118,-99) , 
NN(
0, 
0, 
-1, 1.94492, 1, -1, 0.433973,-99) , 
1, 0.277406, 1, 0, 0.475282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505728,-99) , 
NN(
0, 
0, 
-1, 2.84732, 1, -1, 0.317372,-99) , 
1, 0.600455, 0, 0, 0.375559,-99) , 
0, 3.16711, 1, 0, 0.463561,-99)    );
  // itree = 712
  fBoostWeights.push_back(0.109921);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702866,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467368,-99) , 
0, -3.88263, 1, 0, 0.5387,-99) , 
3, -1.60599, 0, 0, 0.615011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490343,-99) , 
3, 1.64384, 0, 0, 0.513652,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38372,-99) , 
2, -0.01427, 1, 0, 0.427534,-99) , 
1, 0.652165, 1, 0, 0.488217,-99) , 
0, -1.82641, 1, 0, 0.502436,-99)    );
  // itree = 713
  fBoostWeights.push_back(0.167727);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472611,-99) , 
1, 1.33767, 1, 0, 0.61283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468698,-99) , 
1, -1.27365, 0, 0, 0.592105,-99) , 
NN(
NN(
0, 
0, 
-1, 1.78639, 0, 1, 0.56869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408539,-99) , 
2, 0.260595, 1, 0, 0.450004,-99) , 
0, 1.44501, 0, 0, 0.518644,-99) , 
2, -0.106321, 1, 0, 0.540608,-99)    );
  // itree = 714
  fBoostWeights.push_back(0.0568892);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.87738, 1, 1, 0.638975,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346915,-99) , 
2, -1.7513, 0, 0, 0.497264,-99) , 
2, 1.75581, 0, 0, 0.512024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341933,-99) , 
0, 4.37924, 1, 0, 0.506157,-99)    );
  // itree = 715
  fBoostWeights.push_back(0.0750533);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.11635, 0, 1, 0.646961,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487402,-99) , 
0, -1.10404, 1, 0, 0.501186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363465,-99) , 
3, -1.04245, 0, 0, 0.494048,-99) , 
0, -2.69543, 1, 0, 0.50405,-99)    );
  // itree = 716
  fBoostWeights.push_back(0.139818);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.15008, 1, 1, 0.71985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452335,-99) , 
2, 0.40076, 0, 0, 0.524117,-99) , 
3, -1.20464, 1, 0, 0.551946,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418898,-99) , 
1, 2.2281, 1, 0, 0.551473,-99) , 
NN(
0, 
0, 
-1, 1.96384, 1, -1, 0.447618,-99) , 
1, 1.80254, 0, 0, 0.456102,-99) , 
1, -0.222879, 1, 0, 0.491959,-99)    );
  // itree = 717
  fBoostWeights.push_back(0.168262);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452302,-99) , 
1, -1.19139, 0, 0, 0.602333,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407881,-99) , 
1, 0.549205, 1, 0, 0.470851,-99) , 
3, 0.329074, 0, 0, 0.546758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526413,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317447,-99) , 
0, 4.46907, 0, 0, 0.386528,-99) , 
0, 2.83229, 1, 0, 0.437032,-99) , 
2, 1.60872, 1, 0, 0.527032,-99)    );
  // itree = 718
  fBoostWeights.push_back(0.147993);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489849,-99) , 
1, 1.01884, 0, 0, 0.572443,-99) , 
NN(
0, 
0, 
-1, 1.44445, 1, -1, 0.396681,-99) , 
1, 1.57943, 1, 0, 0.534879,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490132,-99) , 
3, 0.958458, 0, 0, 0.551161,-99) , 
NN(
0, 
0, 
-1, -0.225663, 0, -1, 0.432829,-99) , 
1, -1.57451, 1, 0, 0.444057,-99) , 
1, 0.600608, 0, 0, 0.47378,-99)    );
  // itree = 719
  fBoostWeights.push_back(0.0778246);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.332259, 1, 1, 0.534132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313459,-99) , 
3, -1.90371, 0, 0, 0.527323,-99)    );
  // itree = 720
  fBoostWeights.push_back(0.138115);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454322,-99) , 
1, 1.14986, 1, 0, 0.56306,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391344,-99) , 
0, 0.563653, 1, 0, 0.506571,-99) , 
3, 0.819245, 0, 0, 0.531903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535522,-99) , 
NN(
0, 
0, 
-1, 1.66755, 1, -1, 0.359756,-99) , 
3, 3.04299, 0, 0, 0.426159,-99) , 
0, 3.40407, 1, 0, 0.520904,-99)    );
  // itree = 721
  fBoostWeights.push_back(0.0932412);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471741,-99) , 
2, 0.324055, 1, 0, 0.506392,-99) , 
3, 2.78906, 0, 0, 0.514064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321063,-99) , 
2, 2.48633, 1, 0, 0.506711,-99)    );
  // itree = 722
  fBoostWeights.push_back(0.0967526);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.256948, 0, 1, 0.615786,-99) , 
NN(
NN(
0, 
0, 
-1, -1.77576, 1, 1, 0.53877,-99) , 
NN(
0, 
0, 
-1, 1.90291, 1, -1, 0.457102,-99) , 
1, -0.851532, 1, 0, 0.473495,-99) , 
3, 2.79007, 0, 0, 0.485378,-99)    );
  // itree = 723
  fBoostWeights.push_back(0.161541);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.404634, 1, 1, 0.588576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271863,-99) , 
3, -1.11695, 0, 0, 0.390935,-99) , 
2, -0.803742, 0, 0, 0.558408,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369163,-99) , 
1, -1.63758, 0, 0, 0.515164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367152,-99) , 
0, 1.18848, 0, 0, 0.43028,-99) , 
1, -0.380817, 1, 0, 0.474334,-99) , 
1, 0.400523, 0, 0, 0.50623,-99)    );
  // itree = 724
  fBoostWeights.push_back(0.161596);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394906,-99) , 
1, -0.516098, 0, 0, 0.563772,-99) , 
NN(
0, 
0, 
-1, -0.876828, 0, -1, 0.474163,-99) , 
0, 0.689842, 0, 0, 0.509493,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385118,-99) , 
3, 2.29648, 1, 0, 0.452962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292228,-99) , 
3, 1.84417, 0, 0, 0.413618,-99) , 
0, 2.16858, 1, 0, 0.483647,-99)    );
  // itree = 725
  fBoostWeights.push_back(0.192796);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455237,-99) , 
1, 0.0718745, 0, 0, 0.562316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349717,-99) , 
2, 0.919811, 1, 0, 0.464054,-99) , 
1, 1.0077, 1, 0, 0.528195,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416038,-99) , 
3, -1.13771, 0, 0, 0.580209,-99) , 
NN(
0, 
0, 
-1, 0.191111, 0, -1, 0.397257,-99) , 
0, -0.698875, 1, 0, 0.437066,-99) , 
1, -0.150743, 0, 0, 0.490718,-99)    );
  // itree = 726
  fBoostWeights.push_back(0.101795);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734666,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418833,-99) , 
3, -1.75071, 0, 0, 0.522272,-99) , 
3, -0.836655, 0, 0, 0.591152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609469,-99) , 
NN(
0, 
0, 
-1, 0.164106, 0, -1, 0.465563,-99) , 
1, -1.67597, 1, 0, 0.473008,-99) , 
0, -1.06764, 1, 0, 0.490476,-99)    );
  // itree = 727
  fBoostWeights.push_back(0.191662);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.97294, 1, 1, 0.606559,-99) , 
NN(
0, 
0, 
-1, 1.15177, 0, -1, 0.448238,-99) , 
0, 2.55732, 1, 0, 0.550792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413197,-99) , 
3, -0.628962, 0, 0, 0.473651,-99) , 
NN(
0, 
0, 
-1, 0.0275238, 0, -1, 0.381539,-99) , 
0, -0.685886, 1, 0, 0.435902,-99) , 
3, 0.262665, 0, 0, 0.507469,-99)    );
  // itree = 728
  fBoostWeights.push_back(0.135311);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725878,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470706,-99) , 
3, 2.87534, 1, 0, 0.594319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354015,-99) , 
0, 1.6977, 1, 0, 0.493258,-99) , 
3, 1.73223, 0, 0, 0.516458,-99) , 
2, -1.86573, 1, 0, 0.52561,-99)    );
  // itree = 729
  fBoostWeights.push_back(0.108539);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490377,-99) , 
0, 0.392528, 1, 0, 0.527464,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304832,-99) , 
0, -2.30437, 1, 0, 0.43545,-99) , 
3, -1.09081, 0, 0, 0.516962,-99) , 
NN(
0, 
0, 
-1, 0.814305, 1, -1, 0.352117,-99) , 
1, 1.718, 1, 0, 0.50779,-99)    );
  // itree = 730
  fBoostWeights.push_back(0.0753516);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53916, 1, 1, 0.611812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419707,-99) , 
1, 0.787846, 1, 0, 0.498694,-99) , 
1, 1.26351, 0, 0, 0.507918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353607,-99) , 
1, 1.78639, 1, 0, 0.500419,-99)    );
  // itree = 731
  fBoostWeights.push_back(0.0858429);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447463,-99) , 
1, -0.125701, 1, 0, 0.597484,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471419,-99) , 
3, 3.2323, 1, 0, 0.566673,-99) , 
NN(
0, 
0, 
-1, 1.65712, 1, -1, 0.469585,-99) , 
3, 2.38336, 0, 0, 0.481343,-99) , 
0, -2.6197, 1, 0, 0.488106,-99)    );
  // itree = 732
  fBoostWeights.push_back(0.114008);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.3757, 1, 1, 0.538263,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374461,-99) , 
2, -0.910267, 1, 0, 0.461135,-99) , 
3, -0.356397, 0, 0, 0.520863,-99) , 
NN(
NN(
0, 
0, 
-1, 1.57059, 1, 1, 0.539977,-99) , 
NN(
0, 
0, 
-1, 0.35213, 0, -1, 0.406362,-99) , 
2, -0.258583, 1, 0, 0.446329,-99) , 
1, 0.981195, 1, 0, 0.504986,-99)    );
  // itree = 733
  fBoostWeights.push_back(0.0875315);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48753,-99) , 
3, 1.37582, 0, 0, 0.511959,-99) , 
2, -0.383261, 1, 0, 0.526002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534714,-99) , 
NN(
0, 
0, 
-1, -0.82103, 1, -1, 0.426096,-99) , 
1, -0.636927, 1, 0, 0.450073,-99) , 
2, -0.612693, 0, 0, 0.512236,-99)    );
  // itree = 734
  fBoostWeights.push_back(0.165993);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473659,-99) , 
1, -0.185851, 0, 0, 0.540943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361355,-99) , 
1, 0.0751783, 1, 0, 0.470099,-99) , 
2, 1.2647, 1, 0, 0.515912,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434289,-99) , 
1, -1.32682, 1, 0, 0.460452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265709,-99) , 
2, -0.102041, 1, 0, 0.431107,-99) , 
3, -0.148335, 0, 0, 0.494139,-99)    );
  // itree = 735
  fBoostWeights.push_back(0.151803);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.726, 0, 1, 0.62359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187247,-99) , 
0, 4.72151, 1, 0, 0.571727,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469169,-99) , 
2, -0.343573, 0, 0, 0.526104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343186,-99) , 
2, 1.3586, 1, 0, 0.443335,-99) , 
2, 1.08907, 1, 0, 0.510438,-99) , 
3, 1.91587, 0, 0, 0.523736,-99)    );
  // itree = 736
  fBoostWeights.push_back(0.105318);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -3.26689, 0, 1, 0.605921,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464529,-99) , 
2, 2.05023, 0, 0, 0.473677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274571,-99) , 
2, 2.59241, 1, 0, 0.466242,-99) , 
0, -2.11097, 1, 0, 0.4792,-99)    );
  // itree = 737
  fBoostWeights.push_back(0.103576);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482135,-99) , 
0, 2.50199, 1, 0, 0.581712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491806,-99) , 
1, 0.546708, 0, 0, 0.500901,-99) , 
1, -1.121, 1, 0, 0.516345,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4579,-99) , 
3, 0.421338, 0, 0, 0.491584,-99) , 
NN(
0, 
0, 
-1, 1.77011, 0, -1, 0.347386,-99) , 
3, 1.0254, 1, 0, 0.424629,-99) , 
1, 0.63106, 1, 0, 0.488295,-99)    );
  // itree = 738
  fBoostWeights.push_back(0.146113);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488092,-99) , 
0, 1.37882, 1, 0, 0.570957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266146,-99) , 
0, -3.32881, 0, 0, 0.557423,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473507,-99) , 
0, 2.67305, 0, 0, 0.504519,-99) , 
NN(
0, 
0, 
-1, 4.1035, 0, -1, 0.386679,-99) , 
0, 3.49955, 1, 0, 0.480029,-99) , 
2, 0.779872, 1, 0, 0.523819,-99)    );
  // itree = 739
  fBoostWeights.push_back(0.172953);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.709096, 0, 1, 0.585533,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432819,-99) , 
1, 0.806698, 0, 0, 0.485756,-99) , 
3, 1.61466, 1, 0, 0.545044,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427174,-99) , 
0, -3.38835, 0, 0, 0.56338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396833,-99) , 
2, -0.970333, 1, 0, 0.438408,-99) , 
0, -2.51478, 1, 0, 0.473326,-99) , 
3, -0.241457, 0, 0, 0.528233,-99)    );
  // itree = 740
  fBoostWeights.push_back(0.115274);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96611, 1, 1, 0.651312,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259878,-99) , 
3, 2.47749, 0, 0, 0.528983,-99) , 
2, 1.64085, 1, 0, 0.58991,-99) , 
NN(
NN(
0, 
0, 
-1, -1.48306, 1, 1, 0.515019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283704,-99) , 
3, -1.96807, 0, 0, 0.506919,-99) , 
0, 2.14845, 0, 0, 0.530303,-99)    );
  // itree = 741
  fBoostWeights.push_back(0.154678);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776095,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411084,-99) , 
1, -0.867863, 0, 0, 0.547635,-99) , 
3, 1.52003, 1, 0, 0.588576,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467982,-99) , 
3, 0.681353, 0, 0, 0.500682,-99) , 
NN(
0, 
0, 
-1, 0.764502, 0, -1, 0.414582,-99) , 
1, 0.600608, 1, 0, 0.46967,-99) , 
2, 1.16075, 0, 0, 0.505355,-99)    );
  // itree = 742
  fBoostWeights.push_back(0.137065);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.51, 0, 1, 0.570805,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444121,-99) , 
0, -1.12155, 0, 0, 0.523913,-99) , 
NN(
0, 
0, 
-1, -0.443083, 0, -1, 0.428529,-99) , 
0, 0.72437, 1, 0, 0.481999,-99) , 
3, 1.91257, 0, 0, 0.500315,-99)    );
  // itree = 743
  fBoostWeights.push_back(0.176515);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75396, 0, 1, 0.654949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300829,-99) , 
2, 2.31485, 0, 0, 0.458708,-99) , 
2, 1.98915, 1, 0, 0.561996,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447861,-99) , 
0, 1.3283, 1, 0, 0.538161,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370135,-99) , 
2, 0.0276193, 1, 0, 0.424124,-99) , 
1, 0.24368, 0, 0, 0.475638,-99) , 
2, 1.60872, 0, 0, 0.49109,-99)    );
  // itree = 744
  fBoostWeights.push_back(0.130399);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818295,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324403,-99) , 
2, 1.9878, 1, 0, 0.510537,-99) , 
NN(
0, 
0, 
-1, 0.742267, 0, -1, 0.43797,-99) , 
1, -0.0309272, 1, 0, 0.471483,-99) , 
1, -2.0635, 1, 0, 0.483723,-99)    );
  // itree = 745
  fBoostWeights.push_back(0.141002);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434977,-99) , 
0, 0.968497, 0, 0, 0.544602,-99) , 
NN(
0, 
0, 
-1, -0.843778, 0, -1, 0.4671,-99) , 
0, 1.8018, 1, 0, 0.498784,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465149,-99) , 
0, -1.70326, 0, 0, 0.507703,-99) , 
NN(
0, 
0, 
-1, 0.0184201, 0, -1, 0.401664,-99) , 
0, -1.34003, 1, 0, 0.436987,-99) , 
0, 0.45556, 0, 0, 0.47324,-99)    );
  // itree = 746
  fBoostWeights.push_back(0.118393);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.64943, 1, 1, 0.637717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475906,-99) , 
1, 1.54291, 0, 0, 0.520881,-99) , 
1, 0.0669036, 1, 0, 0.568657,-99) , 
NN(
NN(
0, 
0, 
-1, -0.632486, 0, 1, 0.569084,-99) , 
NN(
0, 
0, 
-1, -0.135756, 0, -1, 0.459666,-99) , 
2, -0.409991, 1, 0, 0.491935,-99) , 
3, 1.8106, 0, 0, 0.510407,-99)    );
  // itree = 747
  fBoostWeights.push_back(0.139562);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477152,-99) , 
3, 2.98675, 1, 0, 0.599933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408181,-99) , 
0, 2.93109, 0, 0, 0.453077,-99) , 
1, 0.908702, 1, 0, 0.560545,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438874,-99) , 
2, 0.643034, 1, 0, 0.483588,-99) , 
NN(
0, 
0, 
-1, -0.102477, 1, -1, 0.430938,-99) , 
2, 0.147814, 0, 0, 0.455722,-99) , 
3, 1.45309, 0, 0, 0.485898,-99)    );
  // itree = 748
  fBoostWeights.push_back(0.190838);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475962,-99) , 
0, 2.58771, 1, 0, 0.643189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318329,-99) , 
0, 1.05364, 1, 0, 0.520069,-99) , 
3, 0.965138, 0, 0, 0.557606,-99) , 
NN(
NN(
0, 
0, 
-1, 1.89383, 0, 1, 0.592891,-99) , 
NN(
0, 
0, 
-1, 3.389, 1, -1, 0.377707,-99) , 
1, 0.514877, 0, 0, 0.449659,-99) , 
2, 1.26051, 1, 0, 0.531702,-99)    );
  // itree = 749
  fBoostWeights.push_back(0.0874735);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436082,-99) , 
0, -1.85705, 1, 0, 0.54571,-99) , 
0, -1.49693, 0, 0, 0.597593,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288306,-99) , 
0, 4.23519, 1, 0, 0.498443,-99) , 
NN(
0, 
0, 
-1, -0.216912, 0, -1, 0.392333,-99) , 
3, 0.0613674, 0, 0, 0.48248,-99) , 
0, -1.1147, 1, 0, 0.501443,-99)    );
  // itree = 750
  fBoostWeights.push_back(0.116331);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432118,-99) , 
0, -0.53236, 0, 0, 0.556568,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463491,-99) , 
3, 0.191183, 1, 0, 0.489148,-99) , 
1, -0.367828, 1, 0, 0.508351,-99) , 
NN(
0, 
0, 
-1, 0.186546, 0, -1, 0.387207,-99) , 
1, -1.57017, 0, 0, 0.501447,-99)    );
  // itree = 751
  fBoostWeights.push_back(0.1536);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485983,-99) , 
1, 0.795009, 1, 0, 0.605576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441818,-99) , 
0, 1.82837, 1, 0, 0.53004,-99) , 
3, 1.97401, 0, 0, 0.547172,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4247,-99) , 
0, -1.03701, 0, 0, 0.533099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276939,-99) , 
0, 2.93334, 1, 0, 0.482102,-99) , 
1, -0.520319, 0, 0, 0.529661,-99)    );
  // itree = 752
  fBoostWeights.push_back(0.140388);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483876,-99) , 
2, 0.624151, 0, 0, 0.570716,-99) , 
NN(
0, 
0, 
-1, 2.2244, 0, -1, 0.432887,-99) , 
0, 2.73113, 1, 0, 0.518565,-99) , 
NN(
0, 
0, 
-1, -1.0472, 0, -1, 0.435414,-99) , 
3, 0.780429, 0, 0, 0.476487,-99)    );
  // itree = 753
  fBoostWeights.push_back(0.106375);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483575,-99) , 
0, 4.47346, 1, 0, 0.631695,-99) , 
NN(
NN(
0, 
0, 
-1, 0.88271, 0, 1, 0.542245,-99) , 
NN(
0, 
0, 
-1, -0.0772102, 0, -1, 0.455385,-99) , 
2, -0.0235369, 1, 0, 0.488906,-99) , 
0, 3.59888, 0, 0, 0.502158,-99)    );
  // itree = 754
  fBoostWeights.push_back(0.119856);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455372,-99) , 
2, 2.41923, 1, 0, 0.636119,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491842,-99) , 
1, 0.585742, 1, 0, 0.534883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239671,-99) , 
2, 1.59927, 1, 0, 0.416396,-99) , 
0, 2.89126, 1, 0, 0.525789,-99) , 
3, 2.69494, 0, 0, 0.534994,-99)    );
  // itree = 755
  fBoostWeights.push_back(0.107685);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442968,-99) , 
1, -1.0669, 0, 0, 0.525598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378368,-99) , 
1, 2.12296, 1, 0, 0.519789,-99) , 
NN(
0, 
0, 
-1, -2.56778, 1, -1, 0.355569,-99) , 
3, -1.07126, 0, 0, 0.503867,-99)    );
  // itree = 756
  fBoostWeights.push_back(0.052648);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.07612, 0, 1, 0.520452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269741,-99) , 
2, -1.92602, 0, 0, 0.513464,-99)    );
  // itree = 757
  fBoostWeights.push_back(0.125911);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.202122, 1, 1, 0.616049,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374541,-99) , 
1, 1.3548, 0, 0, 0.439209,-99) , 
2, 0.996081, 1, 0, 0.564665,-99) , 
NN(
NN(
0, 
0, 
-1, 2.46883, 0, 1, 0.672326,-99) , 
NN(
0, 
0, 
-1, 1.58865, 1, -1, 0.468228,-99) , 
0, 3.72663, 0, 0, 0.486067,-99) , 
1, 0.736794, 0, 0, 0.508408,-99)    );
  // itree = 758
  fBoostWeights.push_back(0.120936);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.70125, 0, 1, 0.65875,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661627,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49101,-99) , 
0, 1.24015, 1, 0, 0.535219,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399487,-99) , 
3, -0.0723161, 1, 0, 0.456433,-99) , 
2, 0.457717, 0, 0, 0.492147,-99) , 
3, 2.69494, 0, 0, 0.509234,-99)    );
  // itree = 759
  fBoostWeights.push_back(0.08295);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.242447, 0, 1, 0.622716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476703,-99) , 
1, -1.40499, 1, 0, 0.573361,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498515,-99) , 
1, 1.32737, 1, 0, 0.546106,-99) , 
NN(
0, 
0, 
-1, 0.793928, 0, -1, 0.467885,-99) , 
1, 1.13003, 0, 0, 0.483446,-99) , 
1, -1.1474, 1, 0, 0.493553,-99)    );
  // itree = 760
  fBoostWeights.push_back(0.13273);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432137,-99) , 
0, -1.1842, 0, 0, 0.546295,-99) , 
0, -2.67671, 1, 0, 0.552673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423821,-99) , 
2, -1.76606, 0, 0, 0.547459,-99)    );
  // itree = 761
  fBoostWeights.push_back(0.129529);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.613224, 0, 1, 0.714985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374607,-99) , 
3, -1.24114, 0, 0, 0.537909,-99) , 
0, -2.80581, 1, 0, 0.6286,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484337,-99) , 
2, 0.486038, 1, 0, 0.508928,-99) , 
NN(
0, 
0, 
-1, -0.129332, 1, -1, 0.415904,-99) , 
2, 0.107256, 0, 0, 0.481111,-99) , 
2, -1.13833, 1, 0, 0.497251,-99)    );
  // itree = 762
  fBoostWeights.push_back(0.1169);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492462,-99) , 
3, 1.14653, 0, 0, 0.521639,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3483,-99) , 
2, -0.134376, 1, 0, 0.398957,-99) , 
1, -1.04566, 0, 0, 0.502975,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366932,-99) , 
3, 2.66948, 0, 0, 0.453215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245361,-99) , 
2, 2.43938, 1, 0, 0.404086,-99) , 
2, 1.67097, 1, 0, 0.488142,-99)    );
  // itree = 763
  fBoostWeights.push_back(0.165611);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42139, 0, 1, 0.571752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397362,-99) , 
0, 3.83364, 1, 0, 0.556025,-99) , 
NN(
NN(
0, 
0, 
-1, 0.024324, 0, 1, 0.586167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41732,-99) , 
2, -1.89347, 1, 0, 0.441466,-99) , 
1, 0.804402, 0, 0, 0.469388,-99) , 
3, 0.599758, 0, 0, 0.515672,-99)    );
  // itree = 764
  fBoostWeights.push_back(0.0880565);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466729,-99) , 
2, -0.760602, 0, 0, 0.548398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4748,-99) , 
1, -1.93676, 1, 0, 0.482192,-99) , 
0, -1.03312, 1, 0, 0.493672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346833,-99) , 
1, 2.12296, 1, 0, 0.489499,-99)    );
  // itree = 765
  fBoostWeights.push_back(0.145501);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76532,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364416,-99) , 
2, 2.42993, 1, 0, 0.551168,-99) , 
NN(
0, 
0, 
-1, 1.41138, 1, -1, 0.434286,-99) , 
1, -0.871753, 0, 0, 0.533787,-99) , 
1, -1.91975, 1, 0, 0.543215,-99)    );
  // itree = 766
  fBoostWeights.push_back(0.0770795);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 4.6466, 1, 1, 0.645176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411159,-99) , 
2, 2.00736, 1, 0, 0.541296,-99) , 
3, 2.68477, 0, 0, 0.59177,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473351,-99) , 
2, -2.0275, 0, 0, 0.612035,-99) , 
NN(
0, 
0, 
-1, -1.05474, 0, -1, 0.489184,-99) , 
2, -1.52248, 1, 0, 0.500227,-99) , 
2, 1.67482, 0, 0, 0.514606,-99)    );
  // itree = 767
  fBoostWeights.push_back(0.0558674);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.93819, 0, 1, 0.63733,-99) , 
NN(
NN(
0, 
0, 
-1, 0.298381, 0, 1, 0.567826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371661,-99) , 
1, 1.17246, 1, 0, 0.497662,-99) , 
1, 1.42236, 0, 0, 0.504733,-99) , 
3, 2.64893, 0, 0, 0.51695,-99)    );
  // itree = 768
  fBoostWeights.push_back(0.159762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.53523, 1, 1, 0.643246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415073,-99) , 
0, -0.358546, 1, 0, 0.518639,-99) , 
3, 0.280487, 0, 0, 0.54804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427811,-99) , 
1, -1.16238, 1, 0, 0.447615,-99) , 
3, 3.54408, 0, 0, 0.462312,-99) , 
2, 0.340279, 1, 0, 0.497874,-99)    );
  // itree = 769
  fBoostWeights.push_back(0.122641);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.680002, 1, 1, 0.540344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428874,-99) , 
2, 1.45303, 0, 0, 0.458879,-99) , 
1, 0.600608, 1, 0, 0.512734,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39309,-99) , 
2, -1.06018, 0, 0, 0.432225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289119,-99) , 
3, -0.859443, 1, 0, 0.395687,-99) , 
0, -1.35886, 0, 0, 0.496434,-99)    );
  // itree = 770
  fBoostWeights.push_back(0.0909151);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32778, 0, 1, 0.538649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328098,-99) , 
3, 1.7289, 0, 0, 0.470115,-99) , 
2, 1.3608, 1, 0, 0.520722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316114,-99) , 
3, -1.66559, 0, 0, 0.510901,-99)    );
  // itree = 771
  fBoostWeights.push_back(0.138175);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412283,-99) , 
2, 2.14475, 1, 0, 0.543326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414876,-99) , 
3, 1.23606, 1, 0, 0.472922,-99) , 
1, 0.220021, 1, 0, 0.509597,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311556,-99) , 
2, -1.8248, 0, 0, 0.47296,-99) , 
NN(
0, 
0, 
-1, -0.831488, 0, -1, 0.348906,-99) , 
0, -1.46396, 1, 0, 0.421609,-99) , 
3, -0.356397, 0, 0, 0.491152,-99)    );
  // itree = 772
  fBoostWeights.push_back(0.0796015);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.90187, 1, 1, 0.608417,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471761,-99) , 
3, 1.9529, 0, 0, 0.482792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331187,-99) , 
0, 4.45129, 1, 0, 0.478481,-99) , 
1, 1.56643, 0, 0, 0.488299,-99)    );
  // itree = 773
  fBoostWeights.push_back(0.0861376);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637152,-99) , 
NN(
NN(
0, 
0, 
-1, 0.0955015, 1, 1, 0.624114,-99) , 
NN(
0, 
0, 
-1, -0.4281, 0, -1, 0.465816,-99) , 
0, -2.55324, 1, 0, 0.474942,-99) , 
1, -1.82139, 1, 0, 0.480904,-99)    );
  // itree = 774
  fBoostWeights.push_back(0.0895374);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448123,-99) , 
1, -0.347148, 0, 0, 0.489481,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38909,-99) , 
0, -2.24598, 1, 0, 0.421736,-99) , 
3, -0.242867, 0, 0, 0.472512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260167,-99) , 
0, 4.38122, 1, 0, 0.466963,-99)    );
  // itree = 775
  fBoostWeights.push_back(0.0706542);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.4889, 0, 1, 0.520116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273743,-99) , 
3, -0.29574, 0, 0, 0.427999,-99) , 
1, -1.23596, 0, 0, 0.508425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320731,-99) , 
1, 2.16623, 1, 0, 0.50273,-99)    );
  // itree = 776
  fBoostWeights.push_back(0.128314);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.30863, 0, 1, 0.527315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352338,-99) , 
1, 1.68226, 1, 0, 0.51634,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377823,-99) , 
0, 2.61669, 1, 0, 0.452011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284488,-99) , 
2, 1.32724, 0, 0, 0.411372,-99) , 
2, 1.17933, 1, 0, 0.487475,-99)    );
  // itree = 777
  fBoostWeights.push_back(0.130222);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.24429, 1, 1, 0.697427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48444,-99) , 
2, 2.58902, 1, 0, 0.619953,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446645,-99) , 
3, -0.982431, 0, 0, 0.531078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415228,-99) , 
1, 0.652458, 0, 0, 0.458363,-99) , 
0, 1.93223, 1, 0, 0.512309,-99) , 
2, 2.06042, 0, 0, 0.522973,-99)    );
  // itree = 778
  fBoostWeights.push_back(0.0747018);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.11405, 1, 1, 0.605362,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445273,-99) , 
3, -0.0313067, 0, 0, 0.573752,-99) , 
NN(
0, 
0, 
-1, -0.786664, 0, -1, 0.475122,-99) , 
1, -1.39535, 1, 0, 0.483496,-99) , 
1, 1.79429, 0, 0, 0.49108,-99)    );
  // itree = 779
  fBoostWeights.push_back(0.117382);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.4732, 1, 1, 0.557641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456697,-99) , 
1, -1.53827, 1, 0, 0.470779,-99) , 
2, 0.281292, 1, 0, 0.502868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268189,-99) , 
3, -1.90371, 0, 0, 0.496138,-99)    );
  // itree = 780
  fBoostWeights.push_back(0.165709);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454474,-99) , 
1, -1.16031, 0, 0, 0.578332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365173,-99) , 
2, 0.795203, 0, 0, 0.554191,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459565,-99) , 
3, 0.950589, 0, 0, 0.47997,-99) , 
NN(
0, 
0, 
-1, 1.52922, 1, -1, 0.386689,-99) , 
1, 0.340784, 1, 0, 0.444818,-99) , 
3, 1.29819, 0, 0, 0.487345,-99)    );
  // itree = 781
  fBoostWeights.push_back(0.121605);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.08005, 0, 1, 0.657401,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487255,-99) , 
1, -0.177153, 1, 0, 0.517402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388302,-99) , 
0, -1.3586, 1, 0, 0.426637,-99) , 
1, -0.783555, 0, 0, 0.49918,-99) , 
2, 2.11909, 0, 0, 0.512665,-99)    );
  // itree = 782
  fBoostWeights.push_back(0.122155);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.35009, 1, 1, 0.64807,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436898,-99) , 
3, -0.0569638, 0, 0, 0.519718,-99) , 
1, -1.56222, 0, 0, 0.582222,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429062,-99) , 
0, 3.80978, 1, 0, 0.523684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425014,-99) , 
0, 0.00677238, 1, 0, 0.46201,-99) , 
3, 1.8106, 0, 0, 0.476121,-99) , 
1, -1.15969, 1, 0, 0.48843,-99)    );
  // itree = 783
  fBoostWeights.push_back(0.122765);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408911,-99) , 
0, -0.98777, 1, 0, 0.592197,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454404,-99) , 
0, 1.9506, 0, 0, 0.483141,-99) , 
0, -0.737621, 1, 0, 0.494511,-99) , 
NN(
0, 
0, 
-1, -2.48695, 1, -1, 0.378409,-99) , 
3, -1.00523, 0, 0, 0.479447,-99)    );
  // itree = 784
  fBoostWeights.push_back(0.103623);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.927398, 0, 1, 0.598654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443603,-99) , 
1, -0.0583317, 0, 0, 0.504107,-99) , 
1, -0.651031, 1, 0, 0.520957,-99) , 
NN(
0, 
0, 
-1, 0.163579, 1, -1, 0.388685,-99) , 
1, -1.62958, 0, 0, 0.513591,-99)    );
  // itree = 785
  fBoostWeights.push_back(0.15068);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0841, 1, 1, 0.696232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411313,-99) , 
1, -0.347148, 0, 0, 0.50612,-99) , 
0, 1.64442, 1, 0, 0.548982,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371618,-99) , 
1, 0.881818, 1, 0, 0.480662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364515,-99) , 
0, 0.633724, 1, 0, 0.460235,-99) , 
3, 0.780429, 0, 0, 0.502494,-99)    );
  // itree = 786
  fBoostWeights.push_back(0.108272);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3608, 1, 1, 0.569968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438423,-99) , 
3, -1.67274, 0, 0, 0.561373,-99) , 
NN(
NN(
0, 
0, 
-1, -1.17763, 0, 1, 0.580429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438433,-99) , 
0, 1.40002, 0, 0, 0.479793,-99) , 
0, -1.5403, 1, 0, 0.489369,-99) , 
1, -0.0762474, 1, 0, 0.518494,-99)    );
  // itree = 787
  fBoostWeights.push_back(0.205899);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.818631, 1, 1, 0.727867,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464389,-99) , 
0, -1.87761, 1, 0, 0.514114,-99) , 
3, 0.790666, 0, 0, 0.548185,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391813,-99) , 
0, 2.01769, 0, 0, 0.506631,-99) , 
NN(
0, 
0, 
-1, 0.113353, 1, -1, 0.381924,-99) , 
2, 1.3786, 1, 0, 0.444617,-99) , 
0, 1.4869, 1, 0, 0.502521,-99)    );
  // itree = 788
  fBoostWeights.push_back(0.174014);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.673211, 0, 1, 0.581714,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38404,-99) , 
2, 1.89083, 0, 0, 0.478901,-99) , 
0, 2.99665, 1, 0, 0.562922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59996,-99) , 
NN(
0, 
0, 
-1, -1.12956, 0, -1, 0.407176,-99) , 
0, -3.00103, 1, 0, 0.455494,-99) , 
3, -0.663823, 0, 0, 0.544677,-99)    );
  // itree = 789
  fBoostWeights.push_back(0.166163);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416512,-99) , 
1, -1.09048, 0, 0, 0.539035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300626,-99) , 
3, -1.59863, 0, 0, 0.52108,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422573,-99) , 
1, -0.385122, 1, 0, 0.463102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2636,-99) , 
1, 1.43363, 1, 0, 0.431064,-99) , 
0, 1.43306, 1, 0, 0.483177,-99)    );
  // itree = 790
  fBoostWeights.push_back(0.122519);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460986,-99) , 
0, 0.420895, 0, 0, 0.497851,-99) , 
NN(
0, 
0, 
-1, 3.0703, 0, -1, 0.413311,-99) , 
0, 2.29484, 1, 0, 0.474303,-99) , 
NN(
0, 
0, 
-1, -0.334711, 1, -1, 0.312193,-99) , 
0, -2.6197, 0, 0, 0.463797,-99)    );
  // itree = 791
  fBoostWeights.push_back(0.0973661);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36218, 0, 1, 0.607149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453833,-99) , 
1, -1.92539, 0, 0, 0.572588,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488348,-99) , 
0, 4.40818, 0, 0, 0.494553,-99) , 
NN(
0, 
0, 
-1, -0.0554087, 0, -1, 0.399329,-99) , 
1, -0.176642, 0, 0, 0.471662,-99) , 
1, -0.760003, 1, 0, 0.492439,-99)    );
  // itree = 792
  fBoostWeights.push_back(0.105878);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424579,-99) , 
1, -0.931515, 0, 0, 0.608011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352031,-99) , 
1, 1.23195, 1, 0, 0.57264,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489929,-99) , 
3, 2.19248, 0, 0, 0.508506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372978,-99) , 
0, 4.27586, 1, 0, 0.501644,-99) , 
2, -0.482275, 1, 0, 0.51714,-99)    );
  // itree = 793
  fBoostWeights.push_back(0.138712);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.447711, 0, 1, 0.585631,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430327,-99) , 
1, 0.234725, 0, 0, 0.497205,-99) , 
3, -1.05893, 0, 0, 0.565246,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482977,-99) , 
0, 1.67591, 1, 0, 0.508672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343043,-99) , 
1, 0.628554, 1, 0, 0.441884,-99) , 
2, 0.703968, 0, 0, 0.493055,-99) , 
3, 0.758749, 1, 0, 0.529948,-99)    );
  // itree = 794
  fBoostWeights.push_back(0.163523);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446561,-99) , 
2, -0.565159, 0, 0, 0.522317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329697,-99) , 
3, 2.3758, 0, 0, 0.434538,-99) , 
2, 1.68008, 1, 0, 0.506828,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319718,-99) , 
2, 1.53407, 1, 0, 0.519496,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285302,-99) , 
2, 1.01497, 0, 0, 0.386692,-99) , 
1, 1.06044, 0, 0, 0.46545,-99) , 
1, 0.652165, 1, 0, 0.492858,-99)    );
  // itree = 795
  fBoostWeights.push_back(0.167547);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.474641, 0, 1, 0.559601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340005,-99) , 
1, -0.605811, 1, 0, 0.409684,-99) , 
0, 3.49955, 1, 0, 0.529918,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474561,-99) , 
0, -0.724123, 0, 0, 0.52164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374011,-99) , 
0, -0.840447, 1, 0, 0.417172,-99) , 
2, -0.436798, 1, 0, 0.465222,-99) , 
2, 0.332397, 0, 0, 0.500525,-99)    );
  // itree = 796
  fBoostWeights.push_back(0.116597);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491069,-99) , 
3, 2.46803, 1, 0, 0.617765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423179,-99) , 
2, -0.0400525, 1, 0, 0.49768,-99) , 
2, 1.08654, 0, 0, 0.541205,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496412,-99) , 
3, 2.35306, 0, 0, 0.518454,-99) , 
NN(
0, 
0, 
-1, 1.8313, 1, -1, 0.442635,-99) , 
1, -0.562183, 1, 0, 0.465174,-99) , 
1, 0.998635, 0, 0, 0.480396,-99)    );
  // itree = 797
  fBoostWeights.push_back(0.13155);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.38164, 1, 1, 0.545883,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444779,-99) , 
1, 0.157336, 1, 0, 0.498911,-99) , 
NN(
0, 
0, 
-1, -0.256271, 1, -1, 0.368138,-99) , 
3, 1.3388, 0, 0, 0.455939,-99) , 
0, 0.904123, 1, 0, 0.499775,-99)    );
  // itree = 798
  fBoostWeights.push_back(0.0767789);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.421129, 1, 1, 0.57354,-99) , 
NN(
NN(
0, 
0, 
-1, 2.09274, 1, 1, 0.614511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442024,-99) , 
1, 0.369198, 1, 0, 0.485145,-99) , 
1, 1.68226, 0, 0, 0.493473,-99) , 
3, 2.41698, 0, 0, 0.502564,-99)    );
  // itree = 799
  fBoostWeights.push_back(0.0628378);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82071, 1, 1, 0.576989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256025,-99) , 
0, 2.82267, 1, 0, 0.493134,-99) , 
3, 2.30353, 0, 0, 0.502322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352532,-99) , 
2, 2.50146, 1, 0, 0.496457,-99)    );
  // itree = 800
  fBoostWeights.push_back(0.117444);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42598,-99) , 
0, 4.68128, 1, 0, 0.589848,-99) , 
NN(
0, 
0, 
-1, 0, 1, 1, 0.506047,-99) , 
0, 2.82467, 0, 0, 0.56322,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488914,-99) , 
1, -1.87597, 0, 0, 0.566603,-99) , 
NN(
0, 
0, 
-1, -0.948191, 0, -1, 0.448861,-99) , 
1, -1.41195, 1, 0, 0.457336,-99) , 
2, 1.47382, 0, 0, 0.476925,-99)    );
  // itree = 801
  fBoostWeights.push_back(0.139598);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481332,-99) , 
3, -0.0389203, 0, 0, 0.52561,-99) , 
3, 1.27912, 0, 0, 0.544038,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667388,-99) , 
NN(
0, 
0, 
-1, 1.22748, 0, -1, 0.432168,-99) , 
2, 2.65568, 0, 0, 0.453243,-99) , 
2, 0.779872, 1, 0, 0.505504,-99)    );
  // itree = 802
  fBoostWeights.push_back(0.13463);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459338,-99) , 
1, 1.26914, 1, 0, 0.58711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420326,-99) , 
1, -0.729728, 0, 0, 0.548722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446409,-99) , 
1, -0.681732, 1, 0, 0.46962,-99) , 
1, 1.78415, 0, 0, 0.477459,-99) , 
0, -0.684245, 1, 0, 0.493032,-99)    );
  // itree = 803
  fBoostWeights.push_back(0.141532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.6133, 0, 1, 0.583141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405592,-99) , 
1, -1.02358, 1, 0, 0.488353,-99) , 
1, -0.42717, 0, 0, 0.555019,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467502,-99) , 
2, -0.862691, 1, 0, 0.48976,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359128,-99) , 
0, -0.954855, 1, 0, 0.398923,-99) , 
1, 0.745516, 1, 0, 0.461798,-99) , 
2, 1.22735, 0, 0, 0.486894,-99)    );
  // itree = 804
  fBoostWeights.push_back(0.144193);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.332456, 0, 1, 0.656099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404827,-99) , 
0, -1.46283, 1, 0, 0.502949,-99) , 
2, -0.574969, 0, 0, 0.566009,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45944,-99) , 
0, 2.13147, 0, 0, 0.494244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257635,-99) , 
1, -1.67317, 0, 0, 0.481275,-99) , 
2, -0.106321, 1, 0, 0.506194,-99)    );
  // itree = 805
  fBoostWeights.push_back(0.159206);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439493,-99) , 
1, 1.14986, 1, 0, 0.608584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516853,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358222,-99) , 
2, 0.491536, 1, 0, 0.498764,-99) , 
3, 0.498045, 0, 0, 0.539097,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409639,-99) , 
1, 0.952257, 1, 0, 0.497256,-99) , 
NN(
0, 
0, 
-1, 1.40811, 0, -1, 0.394187,-99) , 
1, 0.514877, 0, 0, 0.431733,-99) , 
2, 1.1143, 1, 0, 0.506262,-99)    );
  // itree = 806
  fBoostWeights.push_back(0.142486);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.64361, 1, 1, 0.619541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43293,-99) , 
1, 0.122903, 1, 0, 0.479128,-99) , 
2, 1.95798, 1, 0, 0.590418,-99) , 
NN(
0, 
0, 
-1, -2.00137, 0, -1, 0.453913,-99) , 
2, 0.648837, 0, 0, 0.513698,-99)    );
  // itree = 807
  fBoostWeights.push_back(0.0940018);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.830677, 0, 1, 0.538333,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343099,-99) , 
0, 0.979578, 0, 0, 0.451697,-99) , 
1, 1.33837, 1, 0, 0.528151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394417,-99) , 
2, 2.5672, 1, 0, 0.522868,-99)    );
  // itree = 808
  fBoostWeights.push_back(0.196706);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415003,-99) , 
1, 0.65144, 0, 0, 0.576142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369602,-99) , 
1, 1.95497, 1, 0, 0.557587,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391929,-99) , 
3, 1.66887, 1, 0, 0.564269,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396303,-99) , 
3, 2.00208, 0, 0, 0.420718,-99) , 
1, -1.19462, 1, 0, 0.447675,-99) , 
1, 0.585742, 0, 0, 0.485051,-99)    );
  // itree = 809
  fBoostWeights.push_back(0.151608);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.654161, 0, 1, 0.548067,-99) , 
NN(
0, 
0, 
-1, 3.07314, 1, -1, 0.390167,-99) , 
2, 1.60346, 1, 0, 0.525414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703948,-99) , 
NN(
0, 
0, 
-1, 0.199351, 0, -1, 0.38818,-99) , 
1, -2.26458, 1, 0, 0.41567,-99) , 
1, -0.609131, 0, 0, 0.493491,-99)    );
  // itree = 810
  fBoostWeights.push_back(0.0787348);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477766,-99) , 
3, 1.86815, 0, 0, 0.491751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324773,-99) , 
0, 4.20376, 1, 0, 0.484671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282546,-99) , 
3, -1.97353, 0, 0, 0.478736,-99)    );
  // itree = 811
  fBoostWeights.push_back(0.0894386);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452428,-99) , 
1, 0.462232, 0, 0, 0.475159,-99) , 
3, -0.934938, 1, 0, 0.480528,-99) , 
NN(
0, 
0, 
-1, -0.175047, 1, -1, 0.380068,-99) , 
0, -2.17846, 0, 0, 0.471332,-99)    );
  // itree = 812
  fBoostWeights.push_back(0.111266);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.506432, 0, 1, 0.63165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364556,-99) , 
3, -1.85146, 0, 0, 0.595382,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482144,-99) , 
1, 1.16706, 0, 0, 0.493856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332986,-99) , 
1, 1.718, 1, 0, 0.48531,-99) , 
0, -0.604534, 1, 0, 0.509609,-99)    );
  // itree = 813
  fBoostWeights.push_back(0.141453);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59436, 1, 1, 0.658764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472758,-99) , 
1, -0.494972, 1, 0, 0.502309,-99) , 
2, 0.948605, 0, 0, 0.532234,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359744,-99) , 
0, 2.94022, 1, 0, 0.415923,-99) , 
3, 3.3808, 0, 0, 0.440571,-99) , 
0, 2.44251, 1, 0, 0.51201,-99)    );
  // itree = 814
  fBoostWeights.push_back(0.0886991);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66572,-99) , 
NN(
NN(
0, 
0, 
-1, -0.324288, 0, 1, 0.544131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506643,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419073,-99) , 
1, 0.67229, 0, 0, 0.473976,-99) , 
1, 0.0296327, 1, 0, 0.508022,-99) , 
0, 4.45129, 0, 0, 0.514417,-99)    );
  // itree = 815
  fBoostWeights.push_back(0.12253);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419054,-99) , 
0, 4.34669, 1, 0, 0.619202,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352077,-99) , 
1, 1.43949, 1, 0, 0.495545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39765,-99) , 
1, -1.99645, 1, 0, 0.420888,-99) , 
1, -0.783555, 0, 0, 0.480261,-99) , 
0, 3.59609, 0, 0, 0.492516,-99)    );
  // itree = 816
  fBoostWeights.push_back(0.117233);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.284291, 1, 1, 0.671779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436025,-99) , 
0, -0.959195, 1, 0, 0.508061,-99) , 
2, 0.33875, 0, 0, 0.531587,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471062,-99) , 
1, -0.568013, 1, 0, 0.530379,-99) , 
NN(
0, 
0, 
-1, -0.256271, 0, -1, 0.461578,-99) , 
3, 2.28513, 0, 0, 0.474794,-99) , 
0, 0.219191, 1, 0, 0.497375,-99)    );
  // itree = 817
  fBoostWeights.push_back(0.0704978);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491683,-99) , 
3, 1.43427, 0, 0, 0.512377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372715,-99) , 
3, 3.01393, 1, 0, 0.506972,-99) , 
NN(
0, 
0, 
-1, -1.60808, 1, -1, 0.391937,-99) , 
3, -1.13232, 0, 0, 0.496789,-99)    );
  // itree = 818
  fBoostWeights.push_back(0.0845568);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328019,-99) , 
2, -1.699, 0, 0, 0.509713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300688,-99) , 
2, 2.53593, 1, 0, 0.501726,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379575,-99) , 
1, 2.08679, 1, 0, 0.454837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274633,-99) , 
1, 1.66924, 0, 0, 0.383781,-99) , 
1, 1.37829, 1, 0, 0.488649,-99)    );
  // itree = 819
  fBoostWeights.push_back(0.108599);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.763982, 1, 1, 0.652156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383917,-99) , 
1, 0.355289, 0, 0, 0.44047,-99) , 
3, -1.29303, 0, 0, 0.570419,-99) , 
NN(
NN(
0, 
0, 
-1, 4.6421, 1, 1, 0.625165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404222,-99) , 
0, 2.2617, 1, 0, 0.476326,-99) , 
0, 3.96038, 0, 0, 0.488346,-99) , 
2, -0.569616, 1, 0, 0.503243,-99)    );
  // itree = 820
  fBoostWeights.push_back(0.130865);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.41511, 1, 1, 0.766833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479694,-99) , 
2, 0.715784, 1, 0, 0.506249,-99) , 
0, 0.197129, 1, 0, 0.532578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390051,-99) , 
1, -1.18118, 1, 0, 0.409613,-99) , 
2, -0.186212, 0, 0, 0.436099,-99) , 
3, -0.0338118, 0, 0, 0.503439,-99)    );
  // itree = 821
  fBoostWeights.push_back(0.0986063);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.369324, 1, 1, 0.52359,-99) , 
NN(
0, 
0, 
-1, -0.836872, 1, -1, 0.439454,-99) , 
3, -0.792049, 0, 0, 0.509707,-99) , 
NN(
0, 
0, 
-1, 1.31886, 1, -1, 0.394269,-99) , 
0, 2.26267, 1, 0, 0.480172,-99)    );
  // itree = 822
  fBoostWeights.push_back(0.0945103);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367667,-99) , 
0, 2.15305, 1, 0, 0.558073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477399,-99) , 
3, 2.76154, 0, 0, 0.488289,-99) , 
1, 1.2562, 0, 0, 0.497495,-99) , 
NN(
0, 
0, 
-1, -2.02913, 0, -1, 0.385733,-99) , 
1, -1.72915, 0, 0, 0.49136,-99)    );
  // itree = 823
  fBoostWeights.push_back(0.140276);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663755,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460632,-99) , 
3, 0.255584, 0, 0, 0.515501,-99) , 
NN(
0, 
0, 
-1, 2.21401, 1, -1, 0.421099,-99) , 
2, 1.07669, 1, 0, 0.48691,-99) , 
3, 3.26988, 0, 0, 0.492964,-99)    );
  // itree = 824
  fBoostWeights.push_back(0.125867);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.143838, 1, 1, 0.603727,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453097,-99) , 
0, -0.0644309, 1, 0, 0.53151,-99) , 
3, 0.342726, 0, 0, 0.546085,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474456,-99) , 
2, 1.16865, 1, 0, 0.509298,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299432,-99) , 
2, 0.488018, 1, 0, 0.424712,-99) , 
2, 0.651059, 0, 0, 0.490366,-99) , 
2, 0.269531, 1, 0, 0.513763,-99)    );
  // itree = 825
  fBoostWeights.push_back(0.118232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0386419, 1, 1, 0.51951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359981,-99) , 
2, -0.896885, 1, 0, 0.447095,-99) , 
3, -0.225146, 0, 0, 0.502034,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338301,-99) , 
3, 0.810493, 0, 0, 0.448402,-99) , 
NN(
0, 
0, 
-1, 1.46226, 0, -1, 0.297132,-99) , 
1, 1.23288, 0, 0, 0.38304,-99) , 
1, 0.935877, 1, 0, 0.476409,-99)    );
  // itree = 826
  fBoostWeights.push_back(0.128566);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445786,-99) , 
3, -1.499, 0, 0, 0.573501,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473393,-99) , 
3, 0.946401, 0, 0, 0.514334,-99) , 
2, -0.379061, 1, 0, 0.53008,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383204,-99) , 
2, 2.33489, 1, 0, 0.493028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365688,-99) , 
0, 3.54493, 0, 0, 0.437781,-99) , 
0, 2.90547, 1, 0, 0.51588,-99)    );
  // itree = 827
  fBoostWeights.push_back(0.0519847);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660223,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495088,-99) , 
1, 1.26566, 0, 0, 0.500971,-99) , 
NN(
0, 
0, 
-1, 0.786702, 1, -1, 0.392139,-99) , 
1, 1.43195, 1, 0, 0.490092,-99) , 
1, -1.91975, 1, 0, 0.497094,-99)    );
  // itree = 828
  fBoostWeights.push_back(0.0836226);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.906669, 1, 1, 0.524842,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367,-99) , 
0, -1.93856, 1, 0, 0.439152,-99) , 
3, -0.665141, 0, 0, 0.514662,-99) , 
NN(
0, 
0, 
-1, -0.268018, 1, -1, 0.368747,-99) , 
3, -1.59907, 0, 0, 0.506446,-99)    );
  // itree = 829
  fBoostWeights.push_back(0.166401);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472437,-99) , 
0, -0.354021, 1, 0, 0.512973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355285,-99) , 
2, -0.956668, 1, 0, 0.436996,-99) , 
3, -0.403708, 0, 0, 0.482146,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435875,-99) , 
0, 1.60125, 1, 0, 0.455937,-99) , 
NN(
0, 
0, 
-1, 0.469482, 0, -1, 0.295845,-99) , 
3, 1.17243, 0, 0, 0.415789,-99) , 
0, 0.942347, 1, 0, 0.450423,-99)    );
  // itree = 830
  fBoostWeights.push_back(0.106707);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.66159, 1, 1, 0.672938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416479,-99) , 
3, -1.98729, 0, 0, 0.626476,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489802,-99) , 
2, 1.77526, 1, 0, 0.570561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389987,-99) , 
3, -0.241969, 0, 0, 0.489938,-99) , 
0, 2.52443, 0, 0, 0.51139,-99) , 
0, -1.35886, 1, 0, 0.527488,-99)    );
  // itree = 831
  fBoostWeights.push_back(0.139776);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.02586, 1, 1, 0.565889,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421846,-99) , 
1, -1.97494, 1, 0, 0.458111,-99) , 
1, -0.976999, 0, 0, 0.534565,-99) , 
NN(
NN(
0, 
0, 
-1, 0.886137, 1, 1, 0.584659,-99) , 
NN(
0, 
0, 
-1, 1.42283, 1, -1, 0.434343,-99) , 
2, 1.74769, 0, 0, 0.454799,-99) , 
1, 0.220021, 1, 0, 0.495891,-99)    );
  // itree = 832
  fBoostWeights.push_back(0.0768056);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64807,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45775,-99) , 
0, 1.6999, 1, 0, 0.505223,-99) , 
2, 2.11988, 0, 0, 0.511042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402833,-99) , 
2, 2.48633, 1, 0, 0.506861,-99)    );
  // itree = 833
  fBoostWeights.push_back(0.190568);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344935,-99) , 
1, -1.83505, 0, 0, 0.639483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456268,-99) , 
2, 0.266665, 0, 0, 0.501715,-99) , 
1, -0.729728, 1, 0, 0.538073,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44355,-99) , 
1, -0.556274, 1, 0, 0.490121,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37721,-99) , 
2, 0.699111, 1, 0, 0.407822,-99) , 
3, 1.98889, 0, 0, 0.452041,-99) , 
3, 1.29819, 1, 0, 0.507505,-99)    );
  // itree = 834
  fBoostWeights.push_back(0.125739);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.58182, 0, 1, 0.658013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468493,-99) , 
3, 0.35216, 1, 0, 0.503584,-99) , 
NN(
0, 
0, 
-1, -3.02445, 1, -1, 0.377468,-99) , 
3, -1.12778, 0, 0, 0.491792,-99) , 
3, 2.7543, 0, 0, 0.505018,-99)    );
  // itree = 835
  fBoostWeights.push_back(0.0938101);
  fForest.push_back( 
NN(
0, 
0, 
-1, 2.35729, 0, 1, 0.546768,-99)    );
  // itree = 836
  fBoostWeights.push_back(0.118626);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0986895, 1, 1, 0.585371,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352727,-99) , 
2, 2.20372, 0, 0, 0.450186,-99) , 
0, 3.69267, 1, 0, 0.559429,-99) , 
NN(
NN(
0, 
0, 
-1, -3.64078, 0, 1, 0.61391,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469389,-99) , 
2, 1.11751, 0, 0, 0.48094,-99) , 
2, -1.65972, 1, 0, 0.491775,-99) , 
0, 1.69243, 0, 0, 0.516664,-99)    );
  // itree = 837
  fBoostWeights.push_back(0.127514);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.859936, 1, 1, 0.686524,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414081,-99) , 
0, -1.75382, 1, 0, 0.554521,-99) , 
3, -0.669487, 0, 0, 0.597066,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39188,-99) , 
0, 4.01319, 1, 0, 0.562098,-99) , 
NN(
0, 
0, 
-1, 1.83425, 1, -1, 0.468056,-99) , 
0, 2.70954, 0, 0, 0.489179,-99) , 
2, -0.569616, 1, 0, 0.506862,-99)    );
  // itree = 838
  fBoostWeights.push_back(0.141015);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.66725, 0, 1, 0.638234,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418991,-99) , 
3, 0.164106, 0, 0, 0.512553,-99) , 
0, -1.27204, 1, 0, 0.538675,-99) , 
NN(
NN(
0, 
0, 
-1, 2.06013, 1, 1, 0.565783,-99) , 
NN(
0, 
0, 
-1, -1.22992, 0, -1, 0.423612,-99) , 
0, 2.01847, 0, 0, 0.462211,-99) , 
1, 0.163373, 1, 0, 0.501023,-99)    );
  // itree = 839
  fBoostWeights.push_back(0.0969849);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.16452, 0, 1, 0.650302,-99) , 
NN(
NN(
0, 
0, 
-1, 1.0872, 0, 1, 0.525826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425506,-99) , 
1, -0.504077, 1, 0, 0.456187,-99) , 
3, 1.11007, 1, 0, 0.498995,-99) , 
1, 1.64705, 0, 0, 0.510957,-99)    );
  // itree = 840
  fBoostWeights.push_back(0.126056);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454675,-99) , 
2, 1.04097, 0, 0, 0.577215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401174,-99) , 
2, 2.02543, 0, 0, 0.467835,-99) , 
0, 2.92178, 1, 0, 0.534944,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476856,-99) , 
3, -1.9793, 0, 0, 0.546058,-99) , 
NN(
0, 
0, 
-1, 1.94632, 1, -1, 0.458311,-99) , 
0, -2.49545, 1, 0, 0.468166,-99) , 
2, 0.823039, 0, 0, 0.493968,-99)    );
  // itree = 841
  fBoostWeights.push_back(0.116331);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.718292, 1, 1, 0.59409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355039,-99) , 
3, -1.0263, 0, 0, 0.572723,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455218,-99) , 
1, -0.229806, 0, 0, 0.482722,-99) , 
1, -1.86135, 1, 0, 0.491728,-99) , 
1, 0.585742, 0, 0, 0.517889,-99)    );
  // itree = 842
  fBoostWeights.push_back(0.128879);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454509,-99) , 
3, -0.244331, 0, 0, 0.523038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370515,-99) , 
0, 3.29119, 1, 0, 0.514811,-99) , 
NN(
0, 
0, 
-1, 2.61403, 0, -1, 0.336005,-99) , 
2, 2.07697, 1, 0, 0.497209,-99)    );
  // itree = 843
  fBoostWeights.push_back(0.0816235);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492124,-99) , 
2, 1.02963, 0, 0, 0.517929,-99) , 
NN(
0, 
0, 
-1, 0.79899, 1, -1, 0.439744,-99) , 
2, 1.64373, 1, 0, 0.506077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319974,-99) , 
3, -1.60672, 0, 0, 0.498477,-99)    );
  // itree = 844
  fBoostWeights.push_back(0.140208);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.334034, 1, 1, 0.571737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400299,-99) , 
0, -2.31235, 1, 0, 0.487252,-99) , 
3, -0.776989, 0, 0, 0.544096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372034,-99) , 
3, 1.40955, 0, 0, 0.45248,-99) , 
0, 0.0483412, 1, 0, 0.469613,-99) , 
2, 0.285987, 1, 0, 0.501389,-99)    );
  // itree = 845
  fBoostWeights.push_back(0.124465);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487071,-99) , 
1, 0.738876, 1, 0, 0.552585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30419,-99) , 
3, 0.722989, 1, 0, 0.490341,-99) , 
1, 0.170681, 0, 0, 0.520375,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414459,-99) , 
3, 2.37533, 0, 0, 0.441688,-99) , 
1, 1.63343, 0, 0, 0.453416,-99) , 
2, 0.674897, 1, 0, 0.492136,-99)    );
  // itree = 846
  fBoostWeights.push_back(0.158354);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470095,-99) , 
2, -0.33307, 1, 0, 0.605351,-99) , 
NN(
0, 
0, 
-1, -0.790266, 1, -1, 0.427038,-99) , 
0, -2.4601, 0, 0, 0.568276,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464349,-99) , 
2, 1.13635, 1, 0, 0.510611,-99) , 
NN(
0, 
0, 
-1, -0.465201, 0, -1, 0.419423,-99) , 
2, 0.635146, 0, 0, 0.477027,-99) , 
2, -0.188154, 1, 0, 0.503228,-99)    );
  // itree = 847
  fBoostWeights.push_back(0.0963932);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.307501, 0, 1, 0.618115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486344,-99) , 
3, 2.32907, 0, 0, 0.501997,-99) , 
0, -0.990281, 1, 0, 0.511839,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579159,-99) , 
NN(
0, 
0, 
-1, -1.53566, 1, -1, 0.363248,-99) , 
1, -0.941956, 1, 0, 0.405209,-99) , 
2, -0.703618, 0, 0, 0.494448,-99)    );
  // itree = 848
  fBoostWeights.push_back(0.0963153);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.512725, 1, 1, 0.624573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385072,-99) , 
2, -0.60558, 0, 0, 0.575423,-99) , 
NN(
NN(
0, 
0, 
-1, 0.271022, 0, 1, 0.608681,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444119,-99) , 
1, 0.173561, 1, 0, 0.484947,-99) , 
0, 3.72663, 0, 0, 0.495424,-99) , 
1, 1.08047, 0, 0, 0.50971,-99)    );
  // itree = 849
  fBoostWeights.push_back(0.141824);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.08465, 1, 1, 0.609433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469636,-99) , 
1, 0.329091, 0, 0, 0.531907,-99) , 
1, -0.540892, 1, 0, 0.545966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531083,-99) , 
NN(
0, 
0, 
-1, -1.57451, 0, -1, 0.382287,-99) , 
1, -1.93789, 1, 0, 0.422984,-99) , 
1, -1.30233, 0, 0, 0.532676,-99)    );
   return;
};
 
// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}
   inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
   {
      // classifier response value
      double retval = 0;

      // classifier response, sanity check first
      if (!IsStatusClean()) {
         std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                   << " because status is dirty" << std::endl;
         retval = 0;
      }
      else {
         if (IsNormalised()) {
            // normalise variables
            std::vector<double> iV;
            iV.reserve(inputValues.size());
            int ivar = 0;
            for (std::vector<double>::const_iterator varIt = inputValues.begin();
                 varIt != inputValues.end(); varIt++, ivar++) {
               iV.push_back(NormVariable( *varIt, fVmin[ivar], fVmax[ivar] ));
            }
            retval = GetMvaValue__( iV );
         }
         else {
            retval = GetMvaValue__( inputValues );
         }
      }

      return retval;
   }
