#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "installer.h"

static struct stat statbuf;

int bin;
int man;

static void diesys(const char* msg)
{
  fprintf(stderr, "installer error: %s:\n  %s\n", msg,
	  sys_errlist[errno]);
  exit(1);
}

static void diefsys(const char* msg, const char* filename)
{
  fprintf(stderr, "installer error: %s '%s':\n  %s\n", msg, filename,
	  sys_errlist[errno]);
  exit(1);
}

static void warn(const char* subdir, const char* filename, const char* msg)
{
  printf("instcheck warning: File '%s%s%s' %s.\n",
	 subdir ? subdir : "", subdir ? "/" : "", filename, msg);
}

static void testmode(int dir, const char* subdir, const char* filename,
		     unsigned uid, unsigned gid, unsigned mode, unsigned type)
{
  if (fchdir(dir) == -1)
    diesys("Could not change base directory");
  if (subdir && chdir(subdir) == -1)
    return;
  if (stat(filename, &statbuf) == -1) {
    if (errno == ENOENT)
      warn(subdir, filename, "is missing");
    else
      diefsys("Could not stat file", filename);
  }
  if ((statbuf.st_mode & S_IFMT) != type)
    warn(subdir, filename, "is the wrong type of file");
  if (uid != (unsigned)-1 && statbuf.st_uid != uid)
    warn(subdir, filename, "has wrong owner");
  if (gid != (unsigned)-1 && statbuf.st_gid != gid)
    warn(subdir, filename, "has wrong group");
  if ((statbuf.st_mode & 07777) != mode)
    warn(subdir, filename, "has wrong permissions");
}

void c(int dir, const char* subdir, const char* filename,
       unsigned uid, unsigned gid, unsigned mode)
{
  testmode(dir, subdir, filename, uid, gid, mode, S_IFREG);
}

void d(int dir, const char* subdir,
       unsigned uid, unsigned gid, unsigned mode)
{
  testmode(dir, 0, subdir, uid, gid, mode, S_IFDIR);
}

int opendir(const char* dir)
{
  int fd;
  if (chdir(dir) == -1)
    diefsys("Could not change directory to", dir);
  if ((fd = open(".", O_RDONLY)) == -1)
    diefsys("Could not open directory", dir);
  return fd;
}

int opensubdir(int dir, const char* subdir)
{
  if (fchdir(dir) == -1)
    diesys("Could not change base directory in opensubdir");
  return opendir(subdir);
}

int main(void)
{
  insthier();
  return 0;
}
