\page Examplefield03 Example  field03

 Example of tracking in magnetic field where field associated
 to selected logical volumes varies.

 A global and a local magnetic field are defined in
 the  F03DetectorConstruction::ConstructSDandField() method in the
 F03DetectorConstruction class using the G4FieldBuilder class.
 The local magnetic field is set to the "Radiator" volume.

 The interactive commands, under the /field directory, are created with
 the instantiation of G4FieldBuilder in the F03DetectorConstruction constructor,

## GEOMETRY DEFINITION

 The "Absorber" is a solid made of a given material.

 Three parameters define the absorber :
 - the material of the absorber,
	- the thickness of an absorber,
 - the transverse size of the absorber (the input face is a square).

 The volume "World" contains the "Absorber".
 In this test the parameters of the "World" can be changed , too.

 A transverse global uniform magnetic field can be applied.
 In addition, the "Radiator" volume, which is placed in geometry next
 to the absorber, has a local magnetic field.

 The default geometry is constructed in F03DetectorConstruction class,
 but all the parameters can be changed via
 the commands defined in the F03DetectorMessenger class.

## AN EVENT : THE PRIMARY GENERATOR

 The primary kinematic consists of a single particle which hits the
 absorber perpendicular to the input face. The type of the particle
 and its energy are set in the F03PrimaryGeneratorAction class, and can
 be changed via the G4 build-in commands of G4ParticleGun class (see
 the macros provided with this example).

 It is also possible to change the position of the primary particle vertex
 or activate its randomization via the commands defined in  the
 F01PrimaryGeneratorMessenger class.

 A RUN is a set of events.

## DETECTOR RESPONSE


 A HIT is a record, event per event , of all the
 informations needed to simulate and analyse the detector response.

 In this example a F03CalorHit is defined as a set of 2 informations:
 - the total energy deposit in the absorber,
 - the total tracklength of all charged particles in the absorber,

 Therefore  the absorber is declared
 'sensitive detector' (SD), see F03CalorimeterSD, which means they can contribute to the hit.


### PHYSICS LIST

 The particle's type and the physic processes which will be available
 in this example are set in the FTFP_BERT physics list. This physics list
 requires data files for electromagnetic and hadronic processes.
 See more on installation of the datasets in Geant4 Installation Guide,

## HOW TO START ?

 - Execute field03 in 'batch' mode from macro files e.g.
```
% ./field03 field03.in
```

 - Execute field03 in 'interactive' mode with visualization e.g.
```
% ./field03
....
Idle> /run/beamOn 1
....
```
