#!/bin/bash
# Licensed under the Universal Permissive License v 1.0 as shown at
# http://oss.oracle.com/licenses/upl.
#
# This is expected to fail on systems where the CTF was built
# with dwarf2ctf.  We can determine this with nothing more than
# objdump, because the CTF version number differs.
#
# Alas objdump cannot read vmlinux.ctfa of this vintage on its
# own: we must embed it into an ELF file ourselves.  Worse yet,
# objdump might be too old to read CTF at all: in this case, just
# skip the test, since we can't possibly tell what it was
# generated by.

if ! ${OBJDUMP} --ctf=.ctf --ctf-parent=shared_ctf /bin/true > /dev/null 2>&1 && \
    LANG=C ${OBJDUMP} --ctf=.ctf --ctf-parent=shared_ctf /bin/true 2>&1 | \
    grep 'unrecognized option' > /dev/null 2>&1; then
    exit 2
fi

ctfa=$tmpdir/vmlinux.ctfa
trap "rm -f $ctfa" EXIT ERR

${OBJCOPY} --add-section=.ctf=/lib/modules/$(uname -r)/kernel/vmlinux.ctfa /bin/true $ctfa

${OBJDUMP} --ctf=.ctf --ctf-parent=shared_ctf $ctfa |\
    gawk '/Version: 3/ { exit 1; } /Version: / { exit 0; }'
