﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/athena/model/WorkGroupState.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace Athena {
namespace Model {
namespace WorkGroupStateMapper {

static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");

WorkGroupState GetWorkGroupStateForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ENABLED_HASH) {
    return WorkGroupState::ENABLED;
  } else if (hashCode == DISABLED_HASH) {
    return WorkGroupState::DISABLED;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<WorkGroupState>(hashCode);
  }

  return WorkGroupState::NOT_SET;
}

Aws::String GetNameForWorkGroupState(WorkGroupState enumValue) {
  switch (enumValue) {
    case WorkGroupState::NOT_SET:
      return {};
    case WorkGroupState::ENABLED:
      return "ENABLED";
    case WorkGroupState::DISABLED:
      return "DISABLED";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace WorkGroupStateMapper
}  // namespace Model
}  // namespace Athena
}  // namespace Aws
