// generated by diplomat-tool
import { LocaleFallbackPriority } from "./LocaleFallbackPriority.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * Collection of configurations for the ICU4X fallback algorithm.
 *
 * See the [Rust documentation for `LocaleFallbackConfig`](https://docs.rs/icu/latest/icu/locale/fallback/struct.LocaleFallbackConfig.html) for more information.
 */


export class LocaleFallbackConfig {
    #priority;
    get priority() {
        return this.#priority;
    }
    set priority(value){
        this.#priority = value;
    }
    /** Create `LocaleFallbackConfig` from an object that contains all of `LocaleFallbackConfig`s fields.
    * Optional fields do not need to be included in the provided object.
    */
    static fromFields(structObj) {
        return new LocaleFallbackConfig(structObj);
    }

    #internalConstructor(structObj) {
        if (typeof structObj !== "object") {
            throw new Error("LocaleFallbackConfig's constructor takes an object of LocaleFallbackConfig's fields.");
        }

        if ("priority" in structObj) {
            this.#priority = structObj.priority;
        } else {
            throw new Error("Missing required field priority.");
        }

        return this;
    }

    // Return this struct in FFI function friendly format.
    // Returns an array that can be expanded with spread syntax (...)
    _intoFFI(
        functionCleanupArena,
        appendArrayMap
    ) {
        return [this.#priority.ffiValue]
    }

    static _fromSuppliedValue(internalConstructor, obj) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("_fromSuppliedValue cannot be called externally.");
        }

        if (obj instanceof LocaleFallbackConfig) {
            return obj;
        }

        return LocaleFallbackConfig.fromFields(obj);
    }

    _writeToArrayBuffer(
        arrayBuffer,
        offset,
        functionCleanupArena,
        appendArrayMap
    ) {
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, this.#priority.ffiValue, Int32Array);
    }

    // This struct contains borrowed fields, so this takes in a list of
    // "edges" corresponding to where each lifetime's data may have been borrowed from
    // and passes it down to individual fields containing the borrow.
    // This method does not attempt to handle any dependencies between lifetimes, the caller
    // should handle this when constructing edge arrays.
    static _fromFFI(internalConstructor, ptr) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("LocaleFallbackConfig._fromFFI is not meant to be called externally. Please use the default constructor.");
        }
        let structObj = {};
        const priorityDeref = diplomatRuntime.enumDiscriminant(wasm, ptr);
        structObj.priority = new LocaleFallbackPriority(diplomatRuntime.internalConstructor, priorityDeref);

        return new LocaleFallbackConfig(structObj);
    }


    constructor(structObj) {
        return this.#internalConstructor(...arguments)
    }
}