/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.HashMap;
import java.util.Map;

public abstract class ModName
implements ACL2Backed {
    public static final ACL2Object KEYWORD_VL_CORETYPE = ACL2Object.valueOf("KEYWORD", "VL-CORETYPE");
    public static final ACL2Object KEYWORD_GATE = ACL2Object.valueOf("KEWWORD", "GATE");
    private static final Map<ACL2Object, ModName> INTERN = new HashMap<ACL2Object, ModName>();

    public boolean isString() {
        return false;
    }

    public boolean isCoretype() {
        return false;
    }

    public boolean isGate() {
        return false;
    }

    public static ModName valueOf(String name) {
        return ModName.fromACL2(ACL2Object.valueOf(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModName fromACL2(ACL2Object o) {
        Map<ACL2Object, ModName> map = INTERN;
        synchronized (map) {
            ModName mn = INTERN.get(o);
            if (mn == null) {
                mn = ACL2.stringp(o).bool() ? new StringImpl(o.stringValueExact()) : new MiscImpl(o);
                INTERN.put(o, mn);
            }
            return mn;
        }
    }

    public abstract String toLispString();

    private static class StringImpl
    extends ModName {
        private final String s;

        StringImpl(String s) {
            this.s = s;
        }

        @Override
        public ACL2Object getACL2Object() {
            return ACL2.honscopy(ACL2Object.valueOf(this.s));
        }

        @Override
        public boolean isString() {
            return true;
        }

        public int hashCode() {
            return ACL2Object.hashCodeOf(this.s);
        }

        public boolean equals(Object o) {
            return o instanceof StringImpl && this.s.equals(((StringImpl)o).s);
        }

        public String toString() {
            return this.s;
        }

        @Override
        public String toLispString() {
            return "\"" + this.s + "\"";
        }
    }

    private static class MiscImpl
    extends ModName {
        private ACL2Object impl;

        MiscImpl(ACL2Object impl) {
            if (ACL2.stringp(impl).bool() || impl.equals(ACL2.NIL)) {
                throw new IllegalArgumentException();
            }
            this.impl = impl;
        }

        @Override
        public ACL2Object getACL2Object() {
            return ACL2.honscopy(this.impl);
        }

        @Override
        public boolean isCoretype() {
            return ACL2.car(this.impl).equals(ACL2Object.valueOf("KEYWORD", "VL-CORETYPE"));
        }

        @Override
        public boolean isGate() {
            return ACL2.car(this.impl).equals(ACL2Object.valueOf("KEYWORD", "GATE"));
        }

        public int hashCode() {
            return this.impl.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MiscImpl && this.impl.equals(((MiscImpl)o).impl);
        }

        public String toString() {
            return "'" + this.impl.rep();
        }

        @Override
        public String toLispString() {
            return "'" + this.impl.rep();
        }
    }
}

