/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.ExecProcess;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.LogicSettable;
import com.sun.electric.tool.simulation.test.NanosimJtagSubchainTester;
import com.sun.electric.tool.simulation.test.NanosimJtagTester;
import com.sun.electric.tool.simulation.test.NanosimLogicSettable;
import com.sun.electric.tool.simulation.test.SimulationModel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NanosimModel
extends SimulationModel {
    protected static final boolean DEBUG = false;
    protected final List jtagTesters;
    protected final List logicSettables;
    protected double simTime = 0.0;
    protected double vdd = 0.0;
    protected double timeStep;
    protected final HashMap nodesToSet = new HashMap();
    protected boolean assuraRCXNetlist = false;
    protected boolean starRCXTNetlist = false;
    protected static final Pattern patSimTime = Pattern.compile("The simulation time is\\s+: ([0-9\\.]+) ns");
    protected static final Pattern getSimTime_tres = Pattern.compile("The engine time resolution is\\s+: ([0-9\\.]+) ns");
    protected static final Pattern patNodeInfo = Pattern.compile("Node status of (.*?)\\((\\d+)\\): (.*?) \\(([0-9\\.\\-]+) V\\)");
    protected static final Pattern patNodeInfo2 = Pattern.compile("Node status of (.*?)\\((\\d+)\\): (\\d+)");

    public NanosimModel() {
        super("Nanosim", "quit", "ERROR", "");
        this.jtagTesters = new ArrayList();
        this.logicSettables = new ArrayList();
    }

    @Override
    public JtagTester createJtagTester(String tckName, String tmsName, String trstbName, String tdiName, String tdobName) {
        if (this.isProcessRunning()) {
            System.out.println("Error: JtagTester test device must be created before process is started.");
            return null;
        }
        NanosimJtagTester tester = new NanosimJtagTester(this, tckName, tmsName, trstbName, tdiName, tdobName);
        this.jtagTesters.add(tester);
        return tester;
    }

    @Override
    public JtagTester createJtagSubchainTester(String jtagInBus, String jtagOutBus) {
        if (this.isProcessRunning()) {
            System.out.println("Error: JtagTester test device must be created before process is started.");
            return null;
        }
        NanosimJtagSubchainTester tester = new NanosimJtagSubchainTester(this, jtagInBus, jtagOutBus);
        this.jtagTesters.add(tester);
        return tester;
    }

    @Override
    public JtagTester createJtagSubchainTester(String phi2, String phi1, String write, String read, String sin, String sout) {
        if (this.isProcessRunning()) {
            System.out.println("Error: JtagTester test device must be created before process is started.");
            return null;
        }
        NanosimJtagSubchainTester tester = new NanosimJtagSubchainTester(this, phi2, phi1, write, read, sin, sout);
        this.jtagTesters.add(tester);
        return tester;
    }

    @Override
    public LogicSettable createLogicSettable(String portName) {
        if (this.isProcessRunning()) {
            System.out.println("Error: LogicSettable test device must be created before process is started.");
            return null;
        }
        NanosimLogicSettable ls = new NanosimLogicSettable(this, portName);
        this.logicSettables.add(ls);
        return ls;
    }

    @Override
    public LogicSettable createLogicSettable(List portNames) {
        if (portNames == null || portNames.size() < 1) {
            System.out.println("Error: createLogicSettable given null or empty list of ports");
            return null;
        }
        System.out.println("Error: createLogicSettable(List) is not supported by Nanosim, only using first port " + portNames.get(0));
        return new NanosimLogicSettable(this, (String)portNames.get(0));
    }

    @Override
    public void disableNode(String node) {
        this.issueCommand("force_node_v v=0 no=" + node);
        this.waitNS(this.timeStep);
    }

    @Override
    public void enableNode(String node) {
        this.issueCommand("rel_node_v no=" + node);
        this.waitNS(this.timeStep);
    }

    @Override
    public double getSimulationTime() {
        return this.simTime;
    }

    @Override
    boolean start_(String command, String simFile, int recordSim) {
        StringBuffer buf;
        boolean found;
        block13: {
            BufferedReader reader;
            PipedOutputStream ostream = new PipedOutputStream();
            try {
                PipedInputStream istream = new PipedInputStream(ostream);
                reader = new BufferedReader(new InputStreamReader(istream));
            }
            catch (IOException e) {
                System.out.println("Unable to create pipe to process output: " + e.getMessage());
                return false;
            }
            String[] commands = new String[]{command, "--version"};
            ExecProcess process = new ExecProcess(commands, null, null, ostream, ostream);
            process.start();
            found = false;
            String version = null;
            buf = new StringBuffer();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] args;
                    buf.append(line + "\n");
                    if (found || (args = line.split("\\s+")).length < 4 || !args[1].equals("Version")) continue;
                    version = args[3];
                    this.setPrompt("Ver " + version + " >");
                    found = true;
                }
                reader.close();
            }
            catch (IOException e) {
                if (found) break block13;
                System.out.println("Error determining nanosim version: " + e.getMessage());
                System.out.println(buf);
                return false;
            }
        }
        if (!found) {
            System.out.println("Error determining nanosim version");
            System.out.println(buf);
            return false;
        }
        try {
            String line;
            BufferedReader freader = new BufferedReader(new FileReader(simFile));
            for (int i = 0; i < 20 && (line = freader.readLine()) != null; ++i) {
                if (line.matches("\\*  PROGRAM .*?assura.*")) {
                    this.assuraRCXNetlist = true;
                    System.out.println("Info: Running on Assura extracted netlist, will replace all '.' in net names with '/'");
                    break;
                }
                if (!line.matches("\\*|PROGRAM .*?Star-RCXT.*")) continue;
                this.starRCXTNetlist = true;
                System.out.println("Info: Running on Star-RCXT extracted netlist, will replace all '.x' in net names with '/'");
                break;
            }
            freader.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        String cmd = command + " -n " + simFile + " -i -t 90071s -o " + simFile;
        if (!this.startProcess(cmd, null, null, simFile + ".run")) {
            return false;
        }
        this.vdd = this.getNodeVoltage("vdd");
        this.timeStep = this.getSimTres();
        for (NanosimLogicSettable ls : this.logicSettables) {
            if (ls.init()) continue;
            System.out.println("LogicSettable initialization failed, aborting.");
            return false;
        }
        for (JtagTester tester : this.jtagTesters) {
            tester.reset();
        }
        return true;
    }

    @Override
    public double getVdd() {
        return this.vdd;
    }

    @Override
    public void wait(float seconds) {
        this.waitNS((double)seconds * 1.0E9);
    }

    @Override
    public void waitNS(double nanoseconds) {
        this.waitNS(nanoseconds, true);
    }

    protected void waitNS(double nanoseconds, boolean applyVoltages) {
        if (applyVoltages) {
            this.applyVoltages();
        }
        if (nanoseconds < this.timeStep) {
            System.out.println("Warning: cannot run simulator in increments less than time step (currently " + this.timeStep + " ns), setting it to " + this.timeStep + " ns");
            nanoseconds = this.timeStep;
        }
        nanoseconds = (double)((int)(nanoseconds / this.timeStep)) * this.timeStep;
        double stopTime = this.simTime + nanoseconds;
        this.issueCommand("set_time_break " + stopTime + "ns");
        this.issueCommand("cont_sim");
        this.simTime = stopTime;
    }

    @Override
    public void waitPS(double ps) {
        this.waitNS(ps / 1000.0);
    }

    @Override
    public double getTimeNS() {
        return this.simTime;
    }

    protected double getSimTres() {
        this.issueCommand("get_sim_time");
        StringBuffer buf = this.getLastCommandOutput();
        Matcher m = getSimTime_tres.matcher(buf);
        if (m.find()) {
            try {
                double d = Double.parseDouble(m.group(1));
                return d;
            }
            catch (NumberFormatException e) {
                System.out.println("Error converting string to double in " + m.group(0) + ": " + e.getMessage());
            }
        }
        double d = 0.01;
        System.out.println("Cannot determine time step, using default of " + d + " ns");
        return d;
    }

    @Override
    public void setNodeState(String node, int state) {
        node = node.toLowerCase();
        if (state != 0 && state != 1) {
            System.out.println("Illegal state passed to setNodeState: " + state + ". Expected 0 or 1.");
            return;
        }
        this.setNodeVoltage(node, (double)state * this.vdd);
    }

    public void setNodeVoltage(String node, double voltage) {
        node = node.toLowerCase();
        this.nodesToSet.put(node, voltage);
    }

    protected void applyVoltages() {
        this.releaseNodes(new ArrayList(this.nodesToSet.keySet()));
        for (Map.Entry entry : this.nodesToSet.entrySet()) {
            String node = (String)entry.getKey();
            Double voltage = (Double)entry.getValue();
            if (this.assuraRCXNetlist) {
                node = node.replaceAll("\\.", "/");
            } else if (this.starRCXTNetlist) {
                if (node.startsWith("x")) {
                    node = node.substring(1);
                }
                node = node.replaceAll("\\.x?", "/");
            }
            this.issueCommand("force_node_v v=" + voltage + " no=" + node);
        }
        this.nodesToSet.clear();
        this.waitNS(this.timeStep, false);
    }

    @Override
    public void releaseNodes(List nodes) {
        int nodesReleased = 0;
        for (int i = 0; nodesReleased < nodes.size() && i < 10; ++i) {
            nodesReleased = 0;
            boolean releasedIssued = false;
            for (String node : nodes) {
                if (this.assuraRCXNetlist) {
                    node = node.replaceAll("\\.", "/");
                } else if (this.starRCXTNetlist) {
                    if (node.startsWith("x")) {
                        node = node.substring(1);
                    }
                    node = node.replaceAll("\\.x?", "/");
                }
                this.issueCommand("get_node_info detail=on " + node);
                StringBuffer output = this.getLastCommandOutput();
                if (output.indexOf("IS_FORCED: 1") != -1) {
                    this.issueCommand("rel_node_v no=" + node);
                    releasedIssued = true;
                    continue;
                }
                ++nodesReleased;
            }
            if (!releasedIssued) continue;
            this.waitNS(this.timeStep, false);
        }
    }

    List getNodeVoltages(List nodes) {
        return this.getNodeInfo(nodes, false);
    }

    List getNodeStates(List nodes) {
        return this.getNodeInfo(nodes, true);
    }

    @Override
    public int getNodeState(String node) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(node);
        List vals = this.getNodeInfo(list, true);
        if (vals != null && vals.size() > 0) {
            return ((Number)vals.get(0)).intValue();
        }
        return -1;
    }

    public double getNodeVoltage(String node) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(node);
        List vals = this.getNodeInfo(list, false);
        if (vals != null && vals.size() > 0) {
            return (Double)vals.get(0);
        }
        return -1.0;
    }

    protected List getNodeInfo(List nodes, boolean returnState) {
        if (this.nodesToSet.size() > 0) {
            this.applyVoltages();
        }
        if (this.assuraRCXNetlist || this.starRCXTNetlist) {
            ArrayList<String> nodesfixed = new ArrayList<String>();
            for (String node : nodes) {
                if (this.assuraRCXNetlist) {
                    node = node.replaceAll("\\.", "/");
                } else if (this.starRCXTNetlist) {
                    if (node.startsWith("x")) {
                        node = node.substring(1);
                    }
                    node = node.replaceAll("\\.x?", "/");
                }
                nodesfixed.add(node);
            }
            nodes = nodesfixed;
        }
        ArrayList<String> nodeslc = new ArrayList<String>();
        StringBuffer cmd = new StringBuffer();
        cmd.append("get_node_info ");
        for (String node : nodes) {
            node = node.toLowerCase();
            nodeslc.add(node);
            cmd.append(node + " ");
        }
        nodes = nodeslc;
        this.issueCommand(cmd.toString());
        StringBuffer result = this.getLastCommandOutput();
        String[] results = result.toString().trim().split("\n");
        ArrayList<Double> voltages = new ArrayList<Double>();
        ArrayList<Integer> states = new ArrayList<Integer>();
        int nodeIndex = 0;
        for (int i = 0; i < results.length; ++i) {
            Integer state;
            if (!results[i].startsWith("Node status")) continue;
            Matcher m = patNodeInfo.matcher(results[i]);
            Matcher m2 = patNodeInfo2.matcher(results[i]);
            String node = (String)nodes.get(nodeIndex);
            if (m.find()) {
                Double voltage;
                if (m.group(3).equals("1")) {
                    state = 1;
                } else if (m.group(3).equals("0")) {
                    state = 0;
                } else if (m.group(3).equals("U")) {
                    state = -2;
                } else {
                    System.out.println("Uknown state of " + node + ": " + m.group(3) + ", setting it to -1 (Undefined)");
                    state = -1;
                }
                try {
                    voltage = Double.valueOf(m.group(4));
                }
                catch (NumberFormatException e) {
                    System.out.println("Error on get_info_node: NumberFormatException converting node " + node + " state/voltage (" + m.group(3) + "/" + m.group(4) + ") to integer/double");
                    return null;
                }
                voltages.add(voltage);
                states.add(state);
                ++nodeIndex;
                continue;
            }
            if (!m2.find() || !returnState) continue;
            if (!m2.group(1).equals(node)) {
                System.out.println("Error on get_info_node: expected info for node " + node + " but got info for node " + m.group(1));
                return null;
            }
            if (m2.group(3).equals("1")) {
                state = 1;
            } else if (m2.group(3).equals("0")) {
                state = 0;
            } else if (m2.group(3).equals("U")) {
                state = -2;
            } else {
                System.out.println("Uknown state of " + node + ": " + m2.group(3) + ", setting it to -1 (Undefined)");
                state = -1;
            }
            states.add(state);
            ++nodeIndex;
        }
        if (returnState) {
            return states;
        }
        return voltages;
    }

    public void reportNodeIC(double time) {
        this.issueCommand("report_node_ic all " + time + "ns");
    }

    public void reportNodeIC() {
        this.issueCommand("report_node_ic all");
    }

    public static void main(String[] args) {
        NanosimModel nm = new NanosimModel();
        nm.start("nanosim", "sim.spi", 0);
        nm.issueCommand("get_sim_time");
        nm.finish();
    }
}

