--
-- This file is part of TALER
-- Copyright (C) 2023 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE donau_sign_keys
  (dsk_serial BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,donau_pub BYTEA PRIMARY KEY CHECK (LENGTH(donau_pub)=32)
  ,valid_from INT8 NOT NULL
  ,expire_sign INT8 NOT NULL
  ,expire_legal INT8 NOT NULL
  );
COMMENT ON TABLE donau_sign_keys
  IS 'Table with all Donau EdDSA signing keys.';
COMMENT ON COLUMN donau_sign_keys.donau_pub
  IS 'Donau EdDSA public key.';
COMMENT ON COLUMN donau_sign_keys.valid_from
  IS 'Time when this signing key will first be used to sign messages.';
COMMENT ON COLUMN donau_sign_keys.expire_sign
  IS 'Time when this signing key will no longer be used to sign.';
COMMENT ON COLUMN donau_sign_keys.expire_legal
  IS 'Time when this signing key legally expires.';
