Script for fixing expoted Weblate content
------------

This script was created to convert exported files by weblate in xliff format.
The files en.xliff and de.xliff was provided, imported into weblate, translated and then weblate produced the file gnu-taler-taler-wallet-ios-es.xlf.

Comparing those file it will be noted that the result from weblate has a slightly different content.

The script "fix-weblate-format.js" takes the file, reads the "trans-unit" xml elements which id starts with "TalerWallet1/" and converts into an xml element similar to the original files.


Requirements
-----

install nodejs (https://nodejs.org/)
install pnpm (https://pnpm.io/installation)

Building
--------

Install dependecies

$ pnpm install 

Example of fixing French XLIFF
------------------------------

The script only take the XLIFF file exported by Weblate as first parameter and the lang of the language source as a second parameter.

For example:

$ node fix-weblate-format.js gnu-taler-taler-wallet-ios-fr.xlf fr > converted-fr-without-untranslated.xliff

For help

$ node fix-weblate-format.js

USAGE: node fix-weblate-format.js <file> <lang>

file: location of the XLIFF file exported by weblate
lang: 2 char lang code like 'es' 'en' 'fr' of the XLIFF file


