/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { strings } from "./i18n/strings.js";

const keys = Object.keys(strings);
type Actions = "SHOW_STATS" | "SHOW_MISSING" | "SUGGEST";
const options = process.argv.reduce(
  (prev, arg, idx, arr) => {
    if (arg === "--missing") {
      prev.ACTION = "SHOW_MISSING";
    }
    if (arg === "--lang") {
      prev.lang = idx + 1 < arr.length ? arr[idx + 1] : undefined;
    }
    if (arg === "--suggest") {
      prev.ACTION = "SUGGEST";
    }
    return prev;
  },
  {
    ACTION: "SHOW_STATS" as Actions,
    lang: undefined as string | undefined,
  },
);

switch (options.ACTION) {
  case "SHOW_MISSING": {
    keys.forEach((key) => {
      if (options.lang && options.lang !== key) {
        return;
      }
      const msgs = Object.entries(
        strings[key].locale_data.messages as Record<string, string[]>,
      );
      let empty = msgs.filter(([key, value]) => {
        if (!value || !value.length || !value[0]) return true;
        return false;
      });
      empty.forEach((msg) => {
        console.log(msg[0]);
      });
    });
    break;
  }
  case "SUGGEST": {
    keys.forEach((key) => {
      if (options.lang && options.lang !== key) {
        return;
      }
      // const content = fs.readFileSync(`./src/i18n/${key}.po`).toString("utf-8")
      const content = `#: src/Application.tsx:208
#, c-format
msgid "checking compatibility with server..."
msgstr ""

#: src/Application.tsx:217
#, fuzzy, c-format
msgid "Contacting the server failed"
msgstr "No se pudo aceder al servidor"

#: src/Application.tsx:229
#, c-format
msgid "The server version is not supported"
msgstr ""

#: src/Application.tsx:230
#, c-format
msgid "Supported version \"%1$s\", server version \"%2$s\"."
msgstr ""
`
      const msgs = Object.entries(
        strings[key].locale_data.messages as Record<string, string[]>,
      );
      let empty = msgs.filter(([key, value]) => {
        if (!value || !value.length || !value[0]) return true;
        return false;
      });
      empty.forEach((msg) => {
        const search = new RegExp(`\n\n(#.*\n)+msgid "${msg[0]}"\nmsgstr .*\n\n`,"gm");
        const res = search.exec(content)
        if (res) {
          console.log(res[0].trim())
        }
      });

    })
    break;
  }
  case "SHOW_STATS": {
    keys.forEach((key) => {
      const com = strings[key].completeness as number;
      const msgs = Object.entries(
        strings[key].locale_data.messages as Record<string, string[]>,
      );
      const empty = msgs.filter(([key, value]) => {
        if (!value || !value.length || !value[0]) return true;
        return false;
      }).length;
      console.log(
        ` * ${key}: ${com.toLocaleString(undefined, {
          minimumIntegerDigits: 2,
        })}% ${(msgs.length - empty).toLocaleString(undefined, {
          minimumIntegerDigits: 3,
        })} of ${msgs.length}`,
      );
    });
    break;
  }
  default: {
    throw Error(`unknown action: ${options.ACTION}`);
  }
}
