/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { Logger } from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { createWalletDaemonWithClient } from "../harness/environments.js";
import { GlobalTestState } from "../harness/harness.js";

const logger = new Logger("test-wallet-bban.ts");

/**
 * Test how the wallet handles an expired denomination.
 */
export async function runWalletBbanTest(t: GlobalTestState) {
  const { walletClient } = await createWalletDaemonWithClient(t, {
    name: "wallet",
  });

  {
    const res = await walletClient.call(
      WalletApiOperation.ConvertIbanPaytoToAccountField,
      {
        paytoUri: "payto://iban/HU30162000031000163100000000",
      },
    );
    console.log(res);
    t.assertDeepEqual(res.type, "bban");
    t.assertDeepEqual(res.value, "1620000310001631");
  }

  {
    const res = await walletClient.call(
      WalletApiOperation.ConvertIbanPaytoToAccountField,
      {
        paytoUri: "payto://iban/HU30162000031000163100000000",
      },
    );
    console.log(res);
    t.assertDeepEqual(res.type, "bban");
    t.assertDeepEqual(res.value, "1620000310001631");
  }
  {
    const res = await walletClient.call(
      WalletApiOperation.ConvertIbanPaytoToAccountField,
      {
        paytoUri: "payto://iban/DE74100500009492290003",
      },
    );
    console.log(res);
    t.assertDeepEqual(res.type, "iban");
    t.assertDeepEqual(res.value, "DE74100500009492290003");
  }

  {
    const res = await walletClient.call(
      WalletApiOperation.ConvertIbanAccountFieldToPayto,
      {
        value: "DE741005000",
        currency: "EUR",
      },
    );
    t.assertDeepEqual(res.ok, false);
  }

  {
    const res = await walletClient.call(
      WalletApiOperation.ConvertIbanAccountFieldToPayto,
      {
        value: "DE74100500009492290003",
        currency: "EUR",
      },
    );
    t.assertDeepEqual(res.ok, true);
    t.assertDeepEqual(res.paytoUri, "payto://iban/DE74100500009492290003");
  }

  {
    const res = await walletClient.call(
      WalletApiOperation.ConvertIbanAccountFieldToPayto,
      {
        value: "1620000310001631",
        currency: "HUF",
      },
    );
    t.assertDeepEqual(res.ok, true);
    t.assertDeepEqual(
      res.paytoUri,
      "payto://iban/HU30162000031000163100000000",
    );
  }

  {
    const res = await walletClient.call(
      WalletApiOperation.ConvertIbanAccountFieldToPayto,
      {
        value: "16200003-10001631",
        currency: "HUF",
      },
    );
    t.assertDeepEqual(res.ok, true);
    t.assertDeepEqual(
      res.paytoUri,
      "payto://iban/HU30162000031000163100000000",
    );
  }
}

runWalletBbanTest.suites = ["wallet"];
