/*
 This file is part of GNU Taler
 (C) 2019 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * @author Florian Dold <dold@taler.net>
 */

/**
 * Imports.
 */
import { codecForAmountString } from "./amounts.js";
import {
  Codec,
  buildCodecForObject,
  codecForString,
  codecOptional,
} from "./codec.js";
import { AmountString } from "./types-taler-common.js";

/**
 * Status of a reserve.
 *
 * Schema type for the exchange's response to "/reserve/status".
 */
export interface ReserveStatus {
  /**
   * Balance left in the reserve.
   */
  balance: AmountString;

  /**
   * Full payto URI of the bank account that
   * (most recently) funded this reserve.
   * Useful as a hint for deposit operations for wallets.
   * Missing if this reserve was only filled via P2P merges.
   * @since protocol **v23**.
   */
  last_origin?: string;
}

export const codecForReserveStatus = (): Codec<ReserveStatus> =>
  buildCodecForObject<ReserveStatus>()
    .property("balance", codecForAmountString())
    .property("last_origin", codecOptional(codecForString()))
    .build("ReserveStatus");
