/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 * @author Nic Eigel
 */

import { createContext, h, VNode } from "preact";
import { useContext } from "preact/hooks";
import { useBackendURL } from "../hooks/index.js";

interface BackendContextType {
  url: string;
}

const BackendContext = createContext<BackendContextType>({
  url: "",
});

export const BackendContextProvider = ({
  children,
  defaultUrl,
}: {
  children: any;
  defaultUrl?: string;
}): VNode => {
  const [url] = useBackendURL(defaultUrl);

  return h(BackendContext.Provider, {
    value: {
      url,
    },
    children,
  });
};

export const useBackendContext = (): BackendContextType =>
  useContext(BackendContext);

interface BackendTokenType {
  token: string;
}

const BackendTokenContext = createContext<BackendTokenType>({} as any);

export const BackendTokenContextProvider = BackendTokenContext.Provider;

export const useBackendTokenContext = (): BackendTokenType =>
  useContext(BackendTokenContext);
