
export interface StringsType {
  domain: string;
  lang: string;
  completeness: number;
  'plural_forms': string;
  locale_data: {
    messages: Record<string, unknown>;
  };
};
export const strings: Record<string,StringsType> = {};

strings['uk'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;",
        "lang": "uk"
      },
      "Operation failed, please report": [
        "Операція не вдалася, будь ласка, повідомте про це"
      ],
      "Request timeout": [
        "Тайм-аут запиту"
      ],
      "Request throttled": [
        "Запит затримується"
      ],
      "Malformed response": [
        "Некоректна відповідь"
      ],
      "Network error": [
        "Мережева помилка"
      ],
      "Unexpected request error": [
        "Неочікувана помилка запиту"
      ],
      "Unexpected error": [
        "Неочікувана помилка"
      ],
      "An IBAN consists of capital letters and numbers only": [
        "IBAN повинен містити лише великі літери та цифри"
      ],
      "IBAN numbers have more that 4 digits": [
        "Номера IBAN зазвичай мають більше 4-ьох цифр"
      ],
      "IBAN numbers have less that 34 digits": [
        "Номера IBAN зазвичай мають менше 34-ьох цифр"
      ],
      "IBAN country code not found": [
        "Код країни IBAN не знайдено"
      ],
      "IBAN number is not valid, checksum is wrong": [
        "Номер IBAN не коректний, контрольна сума не сходиться"
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        ""
      ],
      "Required": [
        "обовʼязково"
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        "Потрібна автентифікація"
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        "ім'я користувача облікового запису"
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        "Операція не вдалася."
      ],
      "Multi-factor authentication required": [
        "Потрібна автентифікація"
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        ""
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        "Недостатньо прав для виконання операції."
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        ""
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        "Не вдалося створити зняття готівки"
      ],
      "The bank configuration does not support cashout operations.": [
        "Конфігурація банку не підтримує операції зі зняття готівки."
      ],
      "Close": [
        "Закрити"
      ],
      "Cashout is disabled": [
        "Зняття готівки створено"
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "The server didn't understand the request.": [
        "Цей сервер не підтримує двофакторну автентифікацію."
      ],
      "The amount is too small": [
        "Паролі не збігаються"
      ],
      "Conversion is not implemented.": [
        "Зняття готівки не реалізовано"
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        "Цей ідентифікатор облікового запису вже зайнятий."
      ],
      "The currency is not supported": [
        "Зняття готівки не підтримується"
      ],
      "Invalid": [
        "недійсно"
      ],
      "Amount needs to be higher": [
        "повинна бути вищою через комісії"
      ],
      "Balance is not enough": [
        "недостатній баланс"
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        ""
      ],
      "The total transfer to the destination will be zero": [
        "загальна сума переказу на місці призначення буде нульовою"
      ],
      "Cashout created": [
        "Зняття готівки створено"
      ],
      "Second factor authentication required.": [
        "Потрібна автентифікація"
      ],
      "Account not found": [
        "Обліковий запис не знайдено"
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        "Виявлено повторний запит, перевірте, чи була операція успішною, або спробуйте ще раз."
      ],
      "The conversion rate was applied incorrectly": [
        "Курс обміну було застосовано неправильно"
      ],
      "The account does not have sufficient funds": [
        "На рахунку недостатньо коштів"
      ],
      "Missing cashout URI in the profile": [
        "Відсутній URI зняття готівки в профілі"
      ],
      "The amount is below the minimum amount permitted.": [
        ""
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        "Не вдалося надіслати повідомлення з підтвердженням, спробуйте пізніше або зверніться до адміністратора."
      ],
      "The server doesn't support the current TAN channel.": [
        "Цей сервер не підтримує двофакторну автентифікацію."
      ],
      "Create cashout.": [
        "Створити обліковий запис"
      ],
      "Cashout": [
        "Виплати готівкою"
      ],
      "Conversion rate": [
        "Обмінний курс"
      ],
      "Balance": [
        "Баланс"
      ],
      "Fee": [
        "Комісія"
      ],
      "To account": [
        "На рахунок"
      ],
      "Legal name": [
        ""
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        ""
      ],
      "Unable to cashout": [
        "Не вдалося створити зняття готівки"
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        "Перш ніж здійснити зняття готівки, вам потрібно заповнити свій профіль"
      ],
      "Transfer subject": [
        "Призначення переказу"
      ],
      "Currency": [
        ""
      ],
      "Send %1$s": [
        ""
      ],
      "Receive %1$s": [
        "Вітаємо, %1$s"
      ],
      "Amount": [
        "Сума"
      ],
      "Total cost": [
        "Загальна вартість"
      ],
      "Balance left": [
        "Залишок балансу"
      ],
      "Before fee": [
        "Комісія до"
      ],
      "Total cashout transfer": [
        "Загальна сума зняття готівки"
      ],
      "Not valid": [
        "недійсний"
      ],
      "Does not follow the pattern": [
        "не відповідає шаблону"
      ],
      "The wire transfer was successfully completed!": [
        "Банківський переказ завершено!"
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        "Запит недійсний або payto://-URI використовує неприпустимі функції."
      ],
      "Not enough permission to complete the operation.": [
        "Недостатньо прав для виконання операції."
      ],
      "The bank administrator cannot be the transfer creditor.": [
        ""
      ],
      "The destination account \"%1$s\" was not found.": [
        "Обліковий запис призначення \"%1$s\" не знайдено."
      ],
      "The origin and the destination of the transfer can't be the same.": [
        "Джерело та місце призначення переказу не можуть бути однаковими."
      ],
      "Your balance is not sufficient for the operation.": [
        "Ваш баланс недостатній для виконання операції."
      ],
      "The origin account \"%1$s\" was not found.": [
        "Обліковий запис джерела \"%1$s\" не знайдено."
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        ""
      ],
      "A second factor authentication is required.": [
        "Увімкнути двофакторну автентифікацію"
      ],
      "Confirm wire transfer.": [
        "Банківський переказ"
      ],
      "Input wire transfer detail": [
        "Деталі банківського переказу"
      ],
      "Using a form": [
        "Використовуючи форму"
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        ""
      ],
      "QR code": [
        "Відправити код"
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        ""
      ],
      "Recipient": [
        "Одержувач"
      ],
      "ID of the recipient's account": [
        "IBAN рахунку одержувача"
      ],
      "username": [
        "Імʼя користувача"
      ],
      "IBAN of the recipient's account": [
        "IBAN рахунку одержувача"
      ],
      "Subject": [
        "Призначення"
      ],
      "Some text to identify the transfer": [
        "текст для ідентифікації переказу"
      ],
      "Amount to transfer": [
        "сума для переказу"
      ],
      "Payto URI:": [
        "payto URI:"
      ],
      "Uniform resource identifier of the target account": [
        "уніфікований ідентифікатор ресурсу цільового рахунку"
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://x-taler-bank/[oператор банку]/[pахунок одержувача]?message=[причина платежу]&amount=[%1$s:X.Y]"
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://iban/[iban одержувача]?message=[причина платежу]&amount=[%1$s:X.Y]"
      ],
      "The maximum amount for a wire transfer is %1$s": [
        ""
      ],
      "Cost": [
        ""
      ],
      "Send": [
        "Здійснити переказ"
      ],
      "Only \"x-taler-bank\" target are supported": [
        "підтримуються лише цілі \"IBAN\""
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        ""
      ],
      "Account name is missing": [
        "Оновлення облікового запису"
      ],
      "Only \"IBAN\" target are supported": [
        "підтримуються лише цілі \"IBAN\""
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        "використовуйте параметр \"amount\", щоб вказати суму для переказу"
      ],
      "The \"amount\" parameter is not valid": [
        "сума недійсна"
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        "використовуйте параметр \"message\", щоб вказати довідковий текст для переказу"
      ],
      "The only currency allowed is \"%1$s\"": [
        ""
      ],
      "You cannot transfer an amount of zero.": [
        "Ви не можете переказати суму, що дорівнює нулю."
      ],
      "The balance is not sufficient": [
        "На рахунку недостатньо коштів"
      ],
      "Please enter a longer subject": [
        "Призначення переказу"
      ],
      "Show withdrawal confirmation": [
        "Показати підтвердження зняття коштів"
      ],
      "Withdraw without setting amount": [
        ""
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        "Спочатку показати, як встановити гаманець"
      ],
      "Currently, the bank is not accepting new registrations!": [
        "Наразі банк не приймає нові реєстрації!"
      ],
      "The name is missing": [
        ""
      ],
      "Missing username": [
        "Відсутнє ім'я користувача"
      ],
      "Missing password": [
        "Відсутній пароль"
      ],
      "The password should be longer than 8 letters": [
        "має бути більшим за 0"
      ],
      "The passwords do not match": [
        "Паролі не збігаються"
      ],
      "Server replied with invalid phone or email.": [
        "Сервер відповів, що номер телефону або електронна пошта недійсні."
      ],
      "You are not authorised to create this account.": [
        "Недостатньо прав для створення цього облікового запису."
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        "Реєстрація відключена, оскільки банк вичерпав бонусний кредит."
      ],
      "That username can't be used because is reserved.": [
        "Це ім'я користувача не можна використовувати, оскільки воно зарезервоване."
      ],
      "That username is already taken.": [
        "Це ім'я користувача вже зайняте."
      ],
      "That account ID is already taken.": [
        "Цей ідентифікатор облікового запису вже зайнятий."
      ],
      "No information for the selected authentication channel.": [
        "Немає інформації про обраний канал автентифікації."
      ],
      "Authentication channel is not supported.": [
        "Канал автентифікації не підтримується."
      ],
      "Only an administrator is allowed to set the debt limit.": [
        "Лише адміністратору дозволено встановлювати ліміт боргу."
      ],
      "Only the administrator can change the conversion rate.": [
        "Лише системний адміністратор може створювати рахунки."
      ],
      "The conversion rate class doesn't exist.": [
        "Курс обміну було застосовано неправильно"
      ],
      "Only admin can create accounts with second factor authentication.": [
        "Лише адміністратор може створювати облікові записи з двофакторною автентифікацією."
      ],
      "The password is too short. Can't have less than 8 characters.": [
        "має бути більшим за 0"
      ],
      "The password is too long. Can't have more than 64 characters.": [
        "має бути більшим за 0"
      ],
      "Account registration": [
        "Реєстрація облікового запису"
      ],
      "Login username": [
        "ім'я користувача"
      ],
      "Password": [
        "Пароль"
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        ""
      ],
      "Repeat password": [
        "Повторіть пароль"
      ],
      "Full name": [
        ""
      ],
      "Register": [
        "Реєстрація"
      ],
      "Create a random temporary user": [
        "Створити випадкового тимчасового користувача"
      ],
      "You have no permission to this account.": [
        "Недостатньо прав для видалення облікового запису."
      ],
      "Wrong credentials for \"%1$s\"": [
        "Неправильні облікові дані для \"%1$s\""
      ],
      "Account login.": [
        "Оновлення облікового запису"
      ],
      "Session expired": [
        "Термін дії операції закінчився."
      ],
      "Username": [
        "Імʼя користувача"
      ],
      "Password of the account": [
        "пароль облікового запису"
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        "Увійти"
      ],
      "Transactions history": [
        ""
      ],
      "No transactions yet.": [
        "Транзакцій поки що немає."
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        ""
      ],
      "Date": [
        "Дата"
      ],
      "Counterpart": [
        "Контррахунок"
      ],
      "sent": [
        "відправлено"
      ],
      "received": [
        "отримано"
      ],
      "Invalid value": [
        "недійсне значення"
      ],
      "to": [
        "до"
      ],
      "from": [
        "від"
      ],
      "First page": [
        "Перша сторінка"
      ],
      "Next": [
        "Далі"
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        "Виведення коштів було скасовано раніше і не може бути підтверджено"
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        "Операцію зняття коштів не можна підтвердити, доки гаманець не прийме транзакцію."
      ],
      "The operation ID is invalid.": [
        "Ідентифікатор операції недійсний."
      ],
      "The operation was not found.": [
        "Операцію не знайдено."
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        ""
      ],
      "The bank requires a bank account which has not been specified yet.": [
        ""
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        "Очікування операції зняття коштів"
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        "Операція резервування була підтверджена раніше і не може бути скасована"
      ],
      "Complete withdrawal.": [
        "Підтвердити операцію зняття коштів"
      ],
      "Confirm the withdrawal operation": [
        "Підтвердити операцію зняття коштів"
      ],
      "Wire transfer details": [
        "Деталі банківського переказу"
      ],
      "Payment Service Provider's account number": [
        "Обліковий запис оператора обмінного пункту Taler"
      ],
      "Payment Service Provider's name": [
        "Обліковий запис оператора обмінного пункту Taler"
      ],
      "Payment Service Provider's account bank hostname": [
        "Обліковий запис оператора обмінного пункту Taler"
      ],
      "Payment Service Provider's account id": [
        "Обліковий запис оператора обмінного пункту Taler"
      ],
      "Payment Service Provider's account address": [
        "Обліковий запис оператора обмінного пункту Taler"
      ],
      "No amount has yet been determined.": [
        ""
      ],
      "Transfer": [
        "Переказати"
      ],
      "Authentication required": [
        "Потрібна автентифікація"
      ],
      "This operation was created with another username": [
        "Ця операція була створена з іншим іменем користувача"
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        "Операція резервування була підтверджена раніше і не може бути скасована"
      ],
      "Wire transfer completed!": [
        "Банківський переказ завершено!"
      ],
      "Confirm withdrawal.": [
        "Підтвердити операцію зняття коштів"
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        "Не авторизовано для виконання операції, можливо, сесія закінчилася або пароль було змінено."
      ],
      "The operation was rejected due to insufficient funds.": [
        "Операцію було відхилено через недостатність коштів."
      ],
      "Withdrawal confirmed": [
        "Зняття коштів підтверджено"
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        "Банківський переказ до оператора Taler було ініційовано. Незабаром ви отримаєте запитану суму у ваш гаманець Taler."
      ],
      "Do not show this again": [
        "Більше не показувати це"
      ],
      "If you have a Taler wallet installed on this device": [
        "Якщо на цьому пристрої встановлено гаманець Taler"
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        "Ви побачите деталі операції у вашомугаманці, включаючи комісії (якщо є). Якщо у вас його ще немає, ви можете встановити його, дотримуючись інструкцій у"
      ],
      "on this page": [
        "цій сторонці"
      ],
      "Withdraw": [
        "Зняття коштів"
      ],
      "In case you have a Taler wallet on another device": [
        "Або якщо у вас є гаманець на іншому пристрої"
      ],
      "Scan the QR below to start the withdrawal.": [
        "Скануйте QR-код нижче, щоб розпочати зняття коштів."
      ],
      "There is an operation already pending": [
        "Операція вже існує"
      ],
      "Complete the operation in": [
        "Завершіть або скасуйте операцію в"
      ],
      "this page": [
        "цій сторонці"
      ],
      "The server replied with an invalid taler://withdraw URI": [
        "Сервер відповів недійсним URI для зняття коштів"
      ],
      "Withdraw URI: %1$s": [
        "URI для зняття коштів: %1$s"
      ],
      "The operation was rejected due to insufficient funds": [
        "Операцію було відхилено через брак коштів"
      ],
      "Current balance is %1$s": [
        ""
      ],
      "You can withdraw up to %1$s": [
        ""
      ],
      "Continue": [
        "Продовжити"
      ],
      "Use your Taler wallet": [
        "Підготуйте свій гаманець"
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        "Після використання вашого гаманця Вам потрібно буде підтвердити або скасувати операцію на цьому сайті."
      ],
      "You need a Taler wallet": [
        "Вам потрібен гаманець GNU Taler"
      ],
      "If you don't have one yet you can follow the instruction in": [
        "Якщо у вас його ще немає, ви можете дотримуватися інструкцій у"
      ],
      "Send money": [
        "Надіслати гроші"
      ],
      "to a Taler wallet": [
        "до гаманця %1$s"
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        "Зніміть цифрові гроші у Ваш мобільний гаманець або розширення браузера"
      ],
      "to another bank account": [
        "на інший банківський рахунок"
      ],
      "Make a wire transfer to an account with known bank account number.": [
        "Здійсніть банківський переказ на рахунок із відомим номером банківського рахунку."
      ],
      "This is a demo": [
        "Це демонстраційний банк"
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        "Ця частина демонстрації показує, як працював би банк, що безпосередньо підтримує Taler. Окрім використання вашого власного банківського рахунку, ви також можете переглянути історію транзакцій деяких %1$s."
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        "Ця частина демонстрації показує, як працював би банк, що безпосередньо підтримує Taler."
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        "Внутрішня помилка, будь ласка, повідомте про це."
      ],
      "Preferences": [
        "Налаштування"
      ],
      "Welcome": [
        "Вітаємо"
      ],
      "Welcome, %1$s": [
        "Вітаємо, %1$s"
      ],
      "No enough permission to access the conversion rate list.": [
        "Недостатньо прав для виконання операції."
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        "Зняття готівки не реалізовано"
      ],
      "Conversion rate classes": [
        "Обмінний курс"
      ],
      "Create conversion rate class": [
        "Обмінний курс"
      ],
      "No conversion rate class": [
        "Обмінний курс"
      ],
      "Name": [
        "Назва"
      ],
      "Description": [
        "Показати демо опис"
      ],
      "Cashin": [
        "Поповнення готівкою"
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        "Оберіть розділ"
      ],
      "Details": [
        "Деталі"
      ],
      "Delete": [
        "Видалити"
      ],
      "Credentials": [
        "Облікові дані"
      ],
      "Cashouts": [
        "Зняття готівки"
      ],
      "Conversion": [
        "Обмінний курс"
      ],
      "only admin can setup conversion": [
        "Лише системний адміністратор може створювати рахунки."
      ],
      "Wrong credentials": [
        "Неправильні облікові дані для \"%1$s\""
      ],
      "Conversion is disabled": [
        "Обмінний курс"
      ],
      "Config cashout": [
        "Виплати готівкою"
      ],
      "Config cashin": [
        "Поповнення готівкою"
      ],
      "Bad ratios": [
        ""
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        ""
      ],
      "Initial amount": [
        "Максимальна сума зняття"
      ],
      "Use it to test how the conversion will affect the amount.": [
        ""
      ],
      "Sending to this bank": [
        ""
      ],
      "Converted": [
        "Обмінний курс"
      ],
      "Cashin after fee": [
        ""
      ],
      "Sending from this bank": [
        ""
      ],
      "Cashout after fee": [
        "Зняття готівки створено"
      ],
      "Bad configuration": [
        ""
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        ""
      ],
      "Update": [
        "Оновити"
      ],
      "Rnvalid": [
        "недійсно"
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        ""
      ],
      "Only cashout operation above this threshold will be allowed.": [
        ""
      ],
      "Ratio": [
        ""
      ],
      "Conversion ratio between currencies": [
        "Обмінний курс"
      ],
      "Example conversion": [
        ""
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        ""
      ],
      "Tiny amount": [
        "На рахунок"
      ],
      "Rounding mode": [
        ""
      ],
      "Zero": [
        ""
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        ""
      ],
      "Up": [
        ""
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        ""
      ],
      "Nearest": [
        ""
      ],
      "Amount will be round to the closest possible value.": [
        ""
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        ""
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        ""
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        ""
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        ""
      ],
      "Amount to be deducted before amount is credited.": [
        ""
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "Unauthorized": [
        "Ім'я користувача не знайдено"
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        "Зняття готівки не реалізовано"
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        "Зняття готівки не реалізовано"
      ],
      "The name of the conversion is already used.": [
        "Операція вже існує"
      ],
      "Conversion rate class": [
        "Обмінний курс"
      ],
      "Accounts": [
        "Рахунки"
      ],
      "Test": [
        ""
      ],
      "Users": [
        "Імʼя користувача"
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        "Ви збираєтеся видалити обліковий запис"
      ],
      "This step can't be undone.": [
        "Цей крок не можна скасувати."
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        "Рахунок"
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        "Дії"
      ],
      "Remove": [
        "видалити"
      ],
      "Add": [
        ""
      ],
      "Conversion rate name": [
        "Обмінний курс"
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        "Обмінний курс"
      ],
      "The rights to change the account are not sufficient": [
        "Недостатньо прав для зміни облікового запису"
      ],
      "New conversion rate class": [
        "Обмінний курс"
      ],
      "Create": [
        "Створити"
      ],
      "History of public accounts": [
        "Історія публічних рахунків"
      ],
      "Make a wire transfer": [
        "Здійснити банківський переказ"
      ],
      "Scan the QR code below to start the withdrawal.": [
        "Скануйте QR-код нижче, щоб розпочати зняття коштів."
      ],
      "Operation aborted": [
        "Операцію скасовано"
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        "Банківський переказ на рахунок оператора Taler Exchange було скасовано, ваш баланс не постраждав."
      ],
      "Go to your wallet now": [
        "Перейти до гаманця зараз"
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        "Операція позначена як 'вибрана', але деякий крок у процесі зняття коштів не вдалося виконати"
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        "Ідентифікатор зняття коштів не знайдено, обліковий запис не вибрано або вибраний обліковий запис недійсний."
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        "Є ідентифікація зняття коштів, але обліковий запис не вибрано або вибраний обліковий запис недійсний."
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        "Обліковий запис вибрано, але ідентифікацію зняття коштів не знайдено."
      ],
      "Operation not found": [
        "Операцію не знайдено"
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        "Ця операція невідома серверу. Ідентифікатор операції неправильний або сервер видалив інформацію про операцію до її завершення."
      ],
      "Continue to dashboard": [
        "Перейти до панелі керування"
      ],
      "The Withdrawal URI is not valid": [
        "URI для зняття коштів недійсний"
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        ""
      ],
      "Latest cashouts": [
        "Останні зняття готівки"
      ],
      "Created": [
        "Створено"
      ],
      "Total debit": [
        "Загальний дебет"
      ],
      "Total credit": [
        "Загальний кредит"
      ],
      "Cashout for account %1$s": [
        "Зняття готівки для облікового запису %1$s"
      ],
      "Doesn't have the pattern of an email": [
        "він не відповідає шаблону електронної пошти"
      ],
      "Should start with +": [
        "повинен починатися з +"
      ],
      "A phone number consists of numbers only": [
        "номер телефону повинен містити лише цифри"
      ],
      "Account ID for authentication": [
        "Двофакторна автентифікація"
      ],
      "Name of the account holder": [
        "ім'я користувача облікового запису"
      ],
      "Internal account": [
        "на інший банківський рахунок"
      ],
      "If this field is empty, a random account ID will be assigned": [
        "якщо порожньо, буде призначено випадковий номер рахунку"
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        ""
      ],
      "Email": [
        "Email"
      ],
      "To be used when second factor authentication is enabled": [
        "Увімкнути двофакторну автентифікацію"
      ],
      "Phone": [
        "Телефон"
      ],
      "Enable second factor authentication": [
        "Увімкнути двофакторну автентифікацію"
      ],
      "Using email": [
        "Використовуючи email"
      ],
      "Add an email in your profile to enable this option": [
        "додайте електронну пошту у вашому профілі, щоб увімкнути цю опцію"
      ],
      "Using SMS": [
        "Використовуючи SMS"
      ],
      "Add a phone number in your profile to enable this option": [
        "додайте номер телефону у вашому профілі, щоб увімкнути цю опцію"
      ],
      "Cashout account": [
        "Відсутній рахунок для зняття готівки"
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        "номер рахунку, на який будуть відправлені гроші при знятті готівки"
      ],
      "Max debt": [
        "Максимальний борг"
      ],
      "How much the balance can go below zero.": [
        ""
      ],
      "Is this account public?": [
        "Цей обліковий запис є публічним?"
      ],
      "Public accounts have their balance publicly accessible": [
        "публічні рахунки мають публічно доступний баланс"
      ],
      "Does this account belong to a Payment Service Provider?": [
        "Цей обліковий запис є публічним?"
      ],
      "Account updated": [
        "Рахунок оновлено"
      ],
      "The username was not found": [
        "Ім'я користувача не знайдено"
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        "Ви не можете змінити юридичне ім'я, будь ласка, зверніться до адміністратора вашого облікового запису."
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        "Ви не можете змінити ліміт боргу, будь ласка, зверніться до адміністратора вашого облікового запису."
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        "Ви не можете змінити адресу зняття готівки, будь ласка, зверніться до адміністратора вашого облікового запису."
      ],
      "Update account information.": [
        "Очікування операції видалення облікового запису"
      ],
      "Account \"%1$s\"": [
        "Рахунок \"%1$s\""
      ],
      "Removed": [
        "видалити"
      ],
      "This account can't be used.": [
        "Цей крок не можна скасувати."
      ],
      "Change details": [
        "Зміна реквізитів"
      ],
      "Merchant integration": [
        "Реєстрація облікового запису"
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        ""
      ],
      "Account type": [
        "Видалення облікового запису"
      ],
      "Method to use for wire transfer.": [
        "Здійснити банківський переказ"
      ],
      "IBAN": [
        ""
      ],
      "International Bank Account Number.": [
        ""
      ],
      "Account name": [
        "Оновлення облікового запису"
      ],
      "Bank host where the service is located.": [
        ""
      ],
      "Bank account identifier for wire transfers.": [
        "ідентифікація облікового запису для банківського переказу"
      ],
      "Address": [
        ""
      ],
      "Owner's name": [
        "Імʼя користувача"
      ],
      "Legal name of the person holding the account.": [
        "ім'я особи, якій належить обліковий запис"
      ],
      "Account info URL": [
        "Обліковий запис не знайдено"
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        ""
      ],
      "Repeated password doesn't match": [
        "пароль не співпадає"
      ],
      "Password changed": [
        "Пароль змінено"
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        "Немає прав для зміни пароля, можливо, сеанс недійсний."
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        "Вам потрібно надати старий пароль. Якщо у вас його немає, зверніться до адміністратора вашого облікового запису."
      ],
      "Your current password doesn't match, can't change to a new password.": [
        "Ваш поточний пароль не збігається, не вдалося змінити на новий пароль."
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        "Оновити пароль"
      ],
      "Update password": [
        "Оновити пароль"
      ],
      "Current password": [
        "Поточний пароль"
      ],
      "Your current password, for security": [
        "ваш поточний пароль, для безпеки"
      ],
      "New password": [
        "Новий пароль"
      ],
      "Type it again": [
        "Введіть його ще раз"
      ],
      "Repeat the same password": [
        "повторіть той самий пароль"
      ],
      "Change": [
        "Змінити"
      ],
      "Create account": [
        "Створити обліковий запис"
      ],
      "Actions": [
        "Дії"
      ],
      "Unknown": [
        "невідомо"
      ],
      "Change password": [
        "змінити пароль"
      ],
      "Querying for the current stats failed": [
        ""
      ],
      "The request parameters are wrong": [
        ""
      ],
      "The user is unauthorized": [
        "Ім'я користувача не знайдено"
      ],
      "Querying for the previous stats failed": [
        ""
      ],
      "Transaction volume report": [
        ""
      ],
      "Last hour": [
        "Остання година"
      ],
      "Previous day": [
        ""
      ],
      "Last month": [
        "Останній місяць"
      ],
      "Last year": [
        "Останній рік"
      ],
      "Last Year": [
        "Попередній рік"
      ],
      "Trading volume from %1$s to %2$s": [
        "Обсяг торгів на %1$s порівняно з %2$s"
      ],
      "Transferred from an external account to an account in this bank.": [
        ""
      ],
      "Transferred from an account in this bank to an external account.": [
        "Здійсніть банківський переказ на рахунок із відомим номером банківського рахунку."
      ],
      "Payin": [
        "Внесення коштів"
      ],
      "Transferred from an account to a Taler exchange.": [
        ""
      ],
      "Payout": [
        "Виплата"
      ],
      "Transferred from a Taler exchange to another account.": [
        "Обліковий запис оператора обмінного пункту Taler"
      ],
      "Download stats as CSV": [
        "завантажити статистику у форматі CSV"
      ],
      "previous": [
        ""
      ],
      "Decreased by": [
        "Зменшилось на"
      ],
      "Increased by": [
        "Збільшилось на"
      ],
      "Account created with password \"%1$s\".": [
        ""
      ],
      "Server replied that phone or email is invalid": [
        "Сервер відповів, що номер телефону або електронна пошта недійсні"
      ],
      "The rights to perform the operation are not sufficient": [
        "Недостатньо прав для виконання операції"
      ],
      "Account username is already taken": [
        "Ім'я користувача облікового запису вже зайнято"
      ],
      "Account ID is already taken": [
        "Ідентифікатор облікового запису вже зайнятий"
      ],
      "Bank ran out of bonus credit.": [
        "У банку закінчився бонусний кредит."
      ],
      "Account username can't be used because is reserved": [
        "Ім'я користувача облікового запису не можна використовувати, оскільки воно зарезервоване"
      ],
      "Can't create accounts": [
        "Не вдається створити рахунки"
      ],
      "Only system admin can create accounts.": [
        "Лише системний адміністратор може створювати рахунки."
      ],
      "New bank account": [
        "Новий бізнес рахунок"
      ],
      "only admin can download stats": [
        "Лише системний адміністратор може створювати рахунки."
      ],
      "Download bank stats": [
        "Завантажити статистику банку"
      ],
      "Include hour metric": [
        "Включити часову метрику"
      ],
      "Include day metric": [
        "Включити добову метрику"
      ],
      "Include month metric": [
        "Включити місячну метрику"
      ],
      "Include year metric": [
        "Включити річну метрику"
      ],
      "Include table header": [
        "Включити заголовок таблиці"
      ],
      "Add previous metric for compare": [
        "Додати попередню метрику для порівняння"
      ],
      "Fail on first error": [
        "Збій на першій помилці"
      ],
      "Download": [
        "Завантажити"
      ],
      "downloading... %1$s": [
        "завантаження...%1$s"
      ],
      "Download completed": [
        "Завантаження завершено"
      ],
      "Click here to save the file in your computer.": [
        "натисніть тут, щоб зберегти файл на вашому комп'ютері"
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        "Не вдається видалити обліковий запис"
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        "Обліковий запис не можна видалити, поки на ньому є баланс. Спочатку переконайтеся, що власник зробив повне зняття коштів."
      ],
      "Name doesn't match": [
        "ім'я не збігається"
      ],
      "Account removed": [
        "Обліковий запис видалено"
      ],
      "No enough permission to delete the account.": [
        "Недостатньо прав для видалення облікового запису."
      ],
      "The username was not found.": [
        "Ім'я користувача не знайдено."
      ],
      "Can't delete a reserved username.": [
        "Не можна видалити зарезервоване ім'я користувача."
      ],
      "Can't delete an account with balance different than zero.": [
        "Не можна видалити обліковий запис з балансом, відмінним від нуля."
      ],
      "Remove account.": [
        "На рахунок"
      ],
      "You are going to remove the account": [
        "Ви збираєтеся видалити обліковий запис"
      ],
      "Deleting account \"%1$s\"": [
        "Видалення рахунку \"%1$s\""
      ],
      "Verification": [
        "Підтвердження"
      ],
      "Enter the account name that is going to be deleted": [
        "введіть ім'я рахунку, який буде видалено"
      ],
      "Cashout id should be a number": [
        "ідентифікатор зняття готівки повинен бути числом"
      ],
      "This cashout not found. Maybe already aborted.": [
        "Це зняття готівки не знайдено. Можливо, його вже скасовано."
      ],
      "Cashout detail": [
        "Деталі зняття готівки"
      ],
      "Debited": [
        "Дебетовано"
      ],
      "Transferred": [
        "Переказати"
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        "Ласкаво просимо до %1$s!"
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;",
  "lang": "uk",
  "completeness": 73
};

strings['ru'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;",
        "lang": "ru"
      },
      "Operation failed, please report": [
        "Не удалось выполнить операцию, сообщите об этом"
      ],
      "Request timeout": [
        "Тайм-аут запроса"
      ],
      "Request throttled": [
        "Запрос замедлен"
      ],
      "Malformed response": [
        "Неправильный ответ"
      ],
      "Network error": [
        "Ошибка сети"
      ],
      "Unexpected request error": [
        "Неожиданная ошибка запроса"
      ],
      "Unexpected error": [
        "Непредвиденная ошибка"
      ],
      "An IBAN consists of capital letters and numbers only": [
        "IBAN должен состоять только из прописных букв и цифр"
      ],
      "IBAN numbers have more that 4 digits": [
        "Номера IBAN обычно содержат более 4 цифр"
      ],
      "IBAN numbers have less that 34 digits": [
        "Номера IBAN обычно содержат менее 34 цифр"
      ],
      "IBAN country code not found": [
        "Код страны IBAN не найден"
      ],
      "IBAN number is not valid, checksum is wrong": [
        "Номер IBAN недействителен, контрольная сумма неверна"
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        ""
      ],
      "Required": [
        "обязательно"
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        "Требуется аутентификация"
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        "имя пользователя счёта"
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        ""
      ],
      "Multi-factor authentication required": [
        "Требуется аутентификация"
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        ""
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        "Не хватает разрешения для завершения операции."
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        "Отмена"
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        "Не удается создать выплату"
      ],
      "The bank configuration does not support cashout operations.": [
        "Конфигурация банка не поддерживает операции выплаты."
      ],
      "Close": [
        "Закрыть"
      ],
      "Cashout is disabled": [
        "Выплата создана"
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "The server didn't understand the request.": [
        "Этот сервер не поддерживает двухфакторную аутентификацию."
      ],
      "The amount is too small": [
        "Пароль слишком длинный."
      ],
      "Conversion is not implemented.": [
        "Обналичка не реализована"
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        "Этот идентификатор счёта уже занят."
      ],
      "The currency is not supported": [
        "Выплаты не поддерживаются"
      ],
      "Invalid": [
        "недействительно"
      ],
      "Amount needs to be higher": [
        "должна быть выше из-за комиссий"
      ],
      "Balance is not enough": [
        "Недостаточно средств на балансе"
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        ""
      ],
      "The total transfer to the destination will be zero": [
        "общая сумма перевода в назначенее будет равна нулю"
      ],
      "Cashout created": [
        "Выплата создана"
      ],
      "Second factor authentication required.": [
        "Требуется аутентификация"
      ],
      "Account not found": [
        "Учётная запись не найдена"
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        "Обнаружен дубликат запроса, проверьте, успешно ли выполнена операция, или повторите попытку."
      ],
      "The conversion rate was applied incorrectly": [
        "Неправильно применен курс конвертации"
      ],
      "The account does not have sufficient funds": [
        "На счете недостаточно средств"
      ],
      "Missing cashout URI in the profile": [
        "Отсутствующий URI вылат в профиле"
      ],
      "The amount is below the minimum amount permitted.": [
        ""
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        "Не удалось отправить сообщение с подтверждением, повторите попытку позже или обратитесь к администратору."
      ],
      "The server doesn't support the current TAN channel.": [
        "Этот сервер не поддерживает двухфакторную аутентификацию."
      ],
      "Create cashout.": [
        "Создать учётную запись"
      ],
      "Cashout": [
        "Выплата"
      ],
      "Conversion rate": [
        "Обменный курс"
      ],
      "Balance": [
        "Баланс"
      ],
      "Fee": [
        "Комиссия"
      ],
      "To account": [
        "На счёт"
      ],
      "Legal name": [
        ""
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        ""
      ],
      "Unable to cashout": [
        "Не удается создать выплату"
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        "Перед тем, как сделать выплату, вам необходимо заполнить свой профиль"
      ],
      "Transfer subject": [
        "Причина перевода"
      ],
      "Currency": [
        ""
      ],
      "Send %1$s": [
        "Отправить %1$s"
      ],
      "Receive %1$s": [
        "Получить %1$s"
      ],
      "Amount": [
        "Сумма"
      ],
      "Total cost": [
        "Общая стоимость"
      ],
      "Balance left": [
        "Остаток баланса"
      ],
      "Before fee": [
        "Комиссия до"
      ],
      "Total cashout transfer": [
        "Общий сумма перевода выплаты"
      ],
      "Not valid": [
        "недопустимый"
      ],
      "Does not follow the pattern": [
        "не следует шаблону"
      ],
      "The wire transfer was successfully completed!": [
        "Отправка перевода завершена!"
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        "Запрос был неверным или payto://-URI использовал недопустимую функциональность."
      ],
      "Not enough permission to complete the operation.": [
        "Не хватает разрешения для завершения операции."
      ],
      "The bank administrator cannot be the transfer creditor.": [
        ""
      ],
      "The destination account \"%1$s\" was not found.": [
        "Целевой счет \"%1$s\" не найден."
      ],
      "The origin and the destination of the transfer can't be the same.": [
        "Пункт отправления и пункт назначения перевода не могут совпадать."
      ],
      "Your balance is not sufficient for the operation.": [
        "Вашего баланса недостаточно для проведения операции."
      ],
      "The origin account \"%1$s\" was not found.": [
        "Исходный аккаунт \"%1$s\" не найден."
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        ""
      ],
      "A second factor authentication is required.": [
        "Включите двухфакторную аутентификацию"
      ],
      "Confirm wire transfer.": [
        "Перевод"
      ],
      "Input wire transfer detail": [
        "Детали банковского перевода"
      ],
      "Using a form": [
        "Используя форму"
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        ""
      ],
      "QR code": [
        "Отправить код"
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        ""
      ],
      "Recipient": [
        "Получатель"
      ],
      "ID of the recipient's account": [
        "IBAN счета получателя"
      ],
      "username": [
        "Имя пользователя"
      ],
      "IBAN of the recipient's account": [
        "IBAN счета получателя"
      ],
      "Subject": [
        "Причина"
      ],
      "Some text to identify the transfer": [
        "какой-то текст для идентификации перевода"
      ],
      "Amount to transfer": [
        "сумма для перевода"
      ],
      "Payto URI:": [
        "payto URI:"
      ],
      "Uniform resource identifier of the target account": [
        "унифицированный идентификатор ресурса целевой учетной записи"
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://x-taler-bank/[oператор банка]/[cчет получателя]?message=[причина платежа]&amount=[%1$s:X.Y]"
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://iban/[iban получателя]?message=[причина платежа]&amount=[%1$s:X.Y]"
      ],
      "The maximum amount for a wire transfer is %1$s": [
        ""
      ],
      "Cost": [
        ""
      ],
      "Send": [
        "Осуществить перевод"
      ],
      "Only \"x-taler-bank\" target are supported": [
        "поддерживаются только \"IBAN\""
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        ""
      ],
      "Account name is missing": [
        "Обновление счёта"
      ],
      "Only \"IBAN\" target are supported": [
        "поддерживаются только \"IBAN\""
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        "Используйте параметр \"Сумма\" для указания суммы перевода"
      ],
      "The \"amount\" parameter is not valid": [
        "сумма не является действительной"
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        "используйте параметр \"message\" для текста причины перевода"
      ],
      "The only currency allowed is \"%1$s\"": [
        ""
      ],
      "You cannot transfer an amount of zero.": [
        ""
      ],
      "The balance is not sufficient": [
        "На счете недостаточно средств"
      ],
      "Please enter a longer subject": [
        "Причина перевода"
      ],
      "Show withdrawal confirmation": [
        "Показать подтверждение вывода средств"
      ],
      "Withdraw without setting amount": [
        ""
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        "Сначала показать как установить кошелёк"
      ],
      "Currently, the bank is not accepting new registrations!": [
        "В настоящее время банк не принимает новые регистрации!"
      ],
      "The name is missing": [
        ""
      ],
      "Missing username": [
        "Отсутствует имя пользователя"
      ],
      "Missing password": [
        "Отсутствует пароль"
      ],
      "The password should be longer than 8 letters": [
        "должно быть больше 0"
      ],
      "The passwords do not match": [
        "Пароли не совпадают"
      ],
      "Server replied with invalid phone or email.": [
        "Сервер ответил что телефон или электронной почта недействительны."
      ],
      "You are not authorised to create this account.": [
        "Недостаточно разрешений для создания этого счёта."
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        "Регистрация отключена, так как в банке закончился бонусный кредит."
      ],
      "That username can't be used because is reserved.": [
        "Это имя пользователя не может быть использовано, так как оно зарезервировано."
      ],
      "That username is already taken.": [
        "Это имя пользователя уже используется."
      ],
      "That account ID is already taken.": [
        "Этот идентификатор счёта уже занят."
      ],
      "No information for the selected authentication channel.": [
        "Нет информации о выбранном канале аутентификации."
      ],
      "Authentication channel is not supported.": [
        "Канал аутентификации не поддерживается."
      ],
      "Only an administrator is allowed to set the debt limit.": [
        "Только администратор может установить лимит задолженности."
      ],
      "Only the administrator can change the conversion rate.": [
        ""
      ],
      "The conversion rate class doesn't exist.": [
        "Неправильно применен курс конвертации"
      ],
      "Only admin can create accounts with second factor authentication.": [
        "Только администратор может создавать учетные записи со второй аутентификацией."
      ],
      "The password is too short. Can't have less than 8 characters.": [
        "должно быть больше 0"
      ],
      "The password is too long. Can't have more than 64 characters.": [
        "должно быть больше 0"
      ],
      "Account registration": [
        "Регистрация счёта"
      ],
      "Login username": [
        "Имя Пользователя"
      ],
      "Password": [
        "Пароль"
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        ""
      ],
      "Repeat password": [
        "Повторите Пароль"
      ],
      "Full name": [
        ""
      ],
      "Register": [
        "Регистрация"
      ],
      "Create a random temporary user": [
        "Создать случайного временного пользователя"
      ],
      "You have no permission to this account.": [
        "Недостаточно разрешений для создания этого счёта."
      ],
      "Wrong credentials for \"%1$s\"": [
        "Неверные учетные данные для «%1$s» ‎"
      ],
      "Account login.": [
        "Обновление счёта"
      ],
      "Session expired": [
        ""
      ],
      "Username": [
        "Имя пользователя"
      ],
      "Password of the account": [
        "пароль от счёта"
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        "Войти"
      ],
      "Transactions history": [
        ""
      ],
      "No transactions yet.": [
        "Транзакций пока нет."
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        ""
      ],
      "Date": [
        "Дата"
      ],
      "Counterpart": [
        "Контрасчет"
      ],
      "sent": [
        "отправлено"
      ],
      "received": [
        "получено"
      ],
      "Invalid value": [
        "Недопустимое значение"
      ],
      "to": [
        "к"
      ],
      "from": [
        "от"
      ],
      "First page": [
        "Первая страница"
      ],
      "Next": [
        "Далее"
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        "Вывод средств был прерван ранее и не может быть подтвержден"
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        "Операция по выводу средств не может быть подтверждена до того как кошёлек примет транзакцию."
      ],
      "The operation ID is invalid.": [
        "Идентификатор операции недействителен."
      ],
      "The operation was not found.": [
        "Операция не найдена."
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        ""
      ],
      "The bank requires a bank account which has not been specified yet.": [
        ""
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        "Ожидание операции вывода средств"
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        "Резервная операция была подтверждена ранее и не может быть прервана"
      ],
      "Complete withdrawal.": [
        "Подтвердите операцию вывода"
      ],
      "Confirm the withdrawal operation": [
        "Подтвердите операцию вывода"
      ],
      "Wire transfer details": [
        "Детали банковского перевода"
      ],
      "Payment Service Provider's account number": [
        "Счет оператора Обменника Taler"
      ],
      "Payment Service Provider's name": [
        "Счет оператора Обменника Taler"
      ],
      "Payment Service Provider's account bank hostname": [
        "Счет оператора Обменника Taler"
      ],
      "Payment Service Provider's account id": [
        "Счет оператора Обменника Taler"
      ],
      "Payment Service Provider's account address": [
        "Счет оператора Обменника Taler"
      ],
      "No amount has yet been determined.": [
        ""
      ],
      "Transfer": [
        "Перевести"
      ],
      "Authentication required": [
        "Требуется аутентификация"
      ],
      "This operation was created with another username": [
        "Эта операция была создана с другим именем пользователя"
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        "Резервная операция была подтверждена ранее и не может быть прервана"
      ],
      "Wire transfer completed!": [
        "Отправка перевода завершена!"
      ],
      "Confirm withdrawal.": [
        "Подтвердите операцию вывода"
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        "Неавторизированное выполнение операции, возможно истек сеанс или изменён пароль."
      ],
      "The operation was rejected due to insufficient funds.": [
        "Операция отклонена из-за нехватки средств."
      ],
      "Withdrawal confirmed": [
        "Вывод подтверждён"
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        "Инициирован банковский перевод оператору Taler. Вскоре вы получите запрошенную сумму на свой кошелёк Taler."
      ],
      "Do not show this again": [
        "Не показывать снова"
      ],
      "If you have a Taler wallet installed on this device": [
        "Если в этом устройстве установлен кошелёк Taler"
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        "Вы увидите подробности операции в своем кошельке, включая комиссию (если применимо). Если у вас его еще нет, вы можете установить его следуя инструкциям на"
      ],
      "on this page": [
        "этой странице"
      ],
      "Withdraw": [
        "Снять средства"
      ],
      "In case you have a Taler wallet on another device": [
        "Или если у вас есть кошелёк в другом устройстве"
      ],
      "Scan the QR below to start the withdrawal.": [
        "Отсканируйте QR-код ниже чтобы начать вывод средств."
      ],
      "There is an operation already pending": [
        "Операция уже идет"
      ],
      "Complete the operation in": [
        "Завершите или отмените операцию в"
      ],
      "this page": [
        "этой странице"
      ],
      "The server replied with an invalid taler://withdraw URI": [
        "Сервер ответил с недопустимым URI вывода"
      ],
      "Withdraw URI: %1$s": [
        "URI вывода: %1$s"
      ],
      "The operation was rejected due to insufficient funds": [
        "Операция отклонена из-за нехватки средств."
      ],
      "Current balance is %1$s": [
        ""
      ],
      "You can withdraw up to %1$s": [
        ""
      ],
      "Continue": [
        "Продолжить"
      ],
      "Use your Taler wallet": [
        "Подготовьте свой кошелёк"
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        "После использования кошелька вам нужно будет подтвердить или отменить операцию на этом сайте."
      ],
      "You need a Taler wallet": [
        "Вам нужен кошелёк Taler"
      ],
      "If you don't have one yet you can follow the instruction in": [
        "Если у вас его еще нет, вы можете следовать инструкциям на"
      ],
      "Send money": [
        "Отправить деньги"
      ],
      "to a Taler wallet": [
        "на кошелек Taler"
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        "Выводите цифровые деньги на свой мобильный кошелёк или расширение для браузера"
      ],
      "to another bank account": [
        "на другой банковский счет"
      ],
      "Make a wire transfer to an account with known bank account number.": [
        "Сделайте банковский перевод на счет с известным номером банковского счета."
      ],
      "This is a demo": [
        "Это демо-банк"
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        "В этой части демонстрации показано как будет работать банк поддерживающий Taler напрямую. Помимо использования собственного банковского счёта, вы также можете просмотреть историю транзакций некоторых %1$s."
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        "В этой части демонстрации показано как будет работать банк поддерживающий Taler напрямую."
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        "Внутренняя ошибка, пожалуйста, сообщите."
      ],
      "Preferences": [
        "Настройки"
      ],
      "Welcome": [
        "Добро пожаловать"
      ],
      "Welcome, %1$s": [
        "Добро пожаловать, %1$s"
      ],
      "No enough permission to access the conversion rate list.": [
        "Не хватает разрешения для завершения операции."
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        "Обналичка не реализована"
      ],
      "Conversion rate classes": [
        "Обменный курс"
      ],
      "Create conversion rate class": [
        "Обменный курс"
      ],
      "No conversion rate class": [
        "Обменный курс"
      ],
      "Name": [
        "Название"
      ],
      "Description": [
        "Показать описание демо"
      ],
      "Cashin": [
        "Внесения"
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        "Выберите раздел"
      ],
      "Details": [
        "Подробности"
      ],
      "Delete": [
        "Удалить"
      ],
      "Credentials": [
        "Учетные данные"
      ],
      "Cashouts": [
        "Выплаты"
      ],
      "Conversion": [
        "Обменный курс"
      ],
      "only admin can setup conversion": [
        ""
      ],
      "Wrong credentials": [
        "Неверные учетные данные для «%1$s» ‎"
      ],
      "Conversion is disabled": [
        "Обменный курс"
      ],
      "Config cashout": [
        "Выплата"
      ],
      "Config cashin": [
        "Внесения"
      ],
      "Bad ratios": [
        ""
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        ""
      ],
      "Initial amount": [
        "Максимальная сумма вывода"
      ],
      "Use it to test how the conversion will affect the amount.": [
        ""
      ],
      "Sending to this bank": [
        ""
      ],
      "Converted": [
        "Обменный курс"
      ],
      "Cashin after fee": [
        ""
      ],
      "Sending from this bank": [
        ""
      ],
      "Cashout after fee": [
        "Выплата создана"
      ],
      "Bad configuration": [
        ""
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        ""
      ],
      "Update": [
        "Обновить"
      ],
      "Rnvalid": [
        "недействительно"
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        ""
      ],
      "Only cashout operation above this threshold will be allowed.": [
        ""
      ],
      "Ratio": [
        ""
      ],
      "Conversion ratio between currencies": [
        "Обменный курс"
      ],
      "Example conversion": [
        ""
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        ""
      ],
      "Tiny amount": [
        "На счёт"
      ],
      "Rounding mode": [
        ""
      ],
      "Zero": [
        ""
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        ""
      ],
      "Up": [
        ""
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        ""
      ],
      "Nearest": [
        ""
      ],
      "Amount will be round to the closest possible value.": [
        ""
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        ""
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        ""
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        ""
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        ""
      ],
      "Amount to be deducted before amount is credited.": [
        ""
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "Unauthorized": [
        "Имя пользователя не найдено"
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        "Обналичка не реализована"
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        "Обналичка не реализована"
      ],
      "The name of the conversion is already used.": [
        "Операция уже идет"
      ],
      "Conversion rate class": [
        "Обменный курс"
      ],
      "Accounts": [
        "Счета"
      ],
      "Test": [
        ""
      ],
      "Users": [
        "Имя пользователя"
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        ""
      ],
      "This step can't be undone.": [
        ""
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        "Счёт"
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        "Действия"
      ],
      "Remove": [
        "удалить"
      ],
      "Add": [
        ""
      ],
      "Conversion rate name": [
        "Обменный курс"
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        "Обменный курс"
      ],
      "The rights to change the account are not sufficient": [
        "Недостаточно прав на изменение счёта"
      ],
      "New conversion rate class": [
        "Обменный курс"
      ],
      "Create": [
        "Создать"
      ],
      "History of public accounts": [
        "История публичных счетов"
      ],
      "Make a wire transfer": [
        "Сделать банковский перевод"
      ],
      "Scan the QR code below to start the withdrawal.": [
        "Отсканируйте QR-код ниже чтобы начать вывод средств."
      ],
      "Operation aborted": [
        "Операция прервана"
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        "Банковский перевод на счет оператора Обменника Taler был прерван, ваш баланс не пострадал."
      ],
      "Go to your wallet now": [
        "Перейти в кошелек"
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        "Операция помечена как «выбранная», но какой-то шаг в выводе средств не удался"
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        "Есть идентификатор вывода средств, но счёт не был выбран или выбранный счёт недействителен."
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        "Есть идентификатор вывода средств, но счёт не был выбран или выбранный счёт недействителен."
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        "Счёт выбран, но идентификатор вывода средств не найден."
      ],
      "Operation not found": [
        ""
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        ""
      ],
      "Continue to dashboard": [
        ""
      ],
      "The Withdrawal URI is not valid": [
        "URI вывода недействителен"
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        ""
      ],
      "Latest cashouts": [
        "Последние обналички"
      ],
      "Created": [
        "Создано"
      ],
      "Total debit": [
        "Всего дебет"
      ],
      "Total credit": [
        "Итого кредит"
      ],
      "Cashout for account %1$s": [
        "Выплата для аккаунта %1$s"
      ],
      "Doesn't have the pattern of an email": [
        "У него нет шаблона электронного письма"
      ],
      "Should start with +": [
        "должен начинаться с +"
      ],
      "A phone number consists of numbers only": [
        "Номер телефона не может иметь ничего, кроме цифр"
      ],
      "Account ID for authentication": [
        "Двухфакторная аутентификация"
      ],
      "Name of the account holder": [
        "имя пользователя счёта"
      ],
      "Internal account": [
        "на другой банковский счет"
      ],
      "If this field is empty, a random account ID will be assigned": [
        "Если пусто, будет присвоен случайный номер счета"
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        ""
      ],
      "Email": [
        "Email"
      ],
      "To be used when second factor authentication is enabled": [
        "Включите двухфакторную аутентификацию"
      ],
      "Phone": [
        "Телефон"
      ],
      "Enable second factor authentication": [
        "Включите двухфакторную аутентификацию"
      ],
      "Using email": [
        "Используя email"
      ],
      "Add an email in your profile to enable this option": [
        "Добавьте адрес электронной почты в свой профиль, чтобы включить эту опцию"
      ],
      "Using SMS": [
        "Используя SMS"
      ],
      "Add a phone number in your profile to enable this option": [
        "Добавьте номер телефона в свой профиль, чтобы включить эту опцию"
      ],
      "Cashout account": [
        "Нет счёта для выплат"
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        "номер счета, на который будут отправлены деньги при выводе средств"
      ],
      "Max debt": [
        "Максимальная задолженность"
      ],
      "How much the balance can go below zero.": [
        ""
      ],
      "Is this account public?": [
        "Является ли этот счёт общедоступным?"
      ],
      "Public accounts have their balance publicly accessible": [
        "Баланс публичных счётов находится в открытом доступе"
      ],
      "Does this account belong to a Payment Service Provider?": [
        "Является ли этот счёт общедоступным?"
      ],
      "Account updated": [
        "Счёт обновлён"
      ],
      "The username was not found": [
        "Имя пользователя не найдено"
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        "Вы не можете изменить официальное имя, обратитесь к администратору вашей учетной записи."
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        "Вы не можете изменить лимит задолженности, обратитесь к администратору аккаунта."
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        "Вы не можете изменить адрес для вывода средств, пожалуйста, свяжитесь с администратором вашего аккаунта."
      ],
      "Update account information.": [
        "Ожидание операции удаления счёта"
      ],
      "Account \"%1$s\"": [
        "Счет \"%1$s\""
      ],
      "Removed": [
        "удалить"
      ],
      "This account can't be used.": [
        ""
      ],
      "Change details": [
        "Изменение реквизитов"
      ],
      "Merchant integration": [
        "Регистрация счёта"
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        ""
      ],
      "Account type": [
        "Удаление счёта"
      ],
      "Method to use for wire transfer.": [
        "Сделать банковский перевод"
      ],
      "IBAN": [
        ""
      ],
      "International Bank Account Number.": [
        ""
      ],
      "Account name": [
        "Обновление счёта"
      ],
      "Bank host where the service is located.": [
        ""
      ],
      "Bank account identifier for wire transfers.": [
        "Идентификация счета для банковского перевода"
      ],
      "Address": [
        ""
      ],
      "Owner's name": [
        "Имя пользователя"
      ],
      "Legal name of the person holding the account.": [
        "имя владельца счёта"
      ],
      "Account info URL": [
        "Учётная запись не найдена"
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        ""
      ],
      "Repeated password doesn't match": [
        "пароль не совпадает"
      ],
      "Password changed": [
        "Пароль изменен"
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        ""
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        ""
      ],
      "Your current password doesn't match, can't change to a new password.": [
        ""
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        "Обновить пароль"
      ],
      "Update password": [
        "Обновить пароль"
      ],
      "Current password": [
        "Текущий пароль"
      ],
      "Your current password, for security": [
        ""
      ],
      "New password": [
        "Новый пароль"
      ],
      "Type it again": [
        "Введите его ещё раз"
      ],
      "Repeat the same password": [
        "повторите этот же пароль"
      ],
      "Change": [
        "Изменить"
      ],
      "Create account": [
        "Создать учётную запись"
      ],
      "Actions": [
        "Действия"
      ],
      "Unknown": [
        "неизвестно"
      ],
      "Change password": [
        "изменить пароль"
      ],
      "Querying for the current stats failed": [
        ""
      ],
      "The request parameters are wrong": [
        ""
      ],
      "The user is unauthorized": [
        "Имя пользователя не найдено"
      ],
      "Querying for the previous stats failed": [
        ""
      ],
      "Transaction volume report": [
        ""
      ],
      "Last hour": [
        "Последний час"
      ],
      "Previous day": [
        ""
      ],
      "Last month": [
        "Последний месяц"
      ],
      "Last year": [
        "Последний год"
      ],
      "Last Year": [
        "Прошлый год"
      ],
      "Trading volume from %1$s to %2$s": [
        "Объем торгов на %1$s по сравнению с %2$s"
      ],
      "Transferred from an external account to an account in this bank.": [
        ""
      ],
      "Transferred from an account in this bank to an external account.": [
        "Сделайте банковский перевод на счет с известным номером банковского счета."
      ],
      "Payin": [
        "Отплата"
      ],
      "Transferred from an account to a Taler exchange.": [
        ""
      ],
      "Payout": [
        "Выплата"
      ],
      "Transferred from a Taler exchange to another account.": [
        "Счет оператора Обменника Taler"
      ],
      "Download stats as CSV": [
        "скачать статистику в формате CSV"
      ],
      "previous": [
        ""
      ],
      "Decreased by": [
        "Уменьшилось на"
      ],
      "Increased by": [
        "Увеличение на"
      ],
      "Account created with password \"%1$s\".": [
        ""
      ],
      "Server replied that phone or email is invalid": [
        ""
      ],
      "The rights to perform the operation are not sufficient": [
        ""
      ],
      "Account username is already taken": [
        ""
      ],
      "Account ID is already taken": [
        "Этот идентификатор счёта уже занят."
      ],
      "Bank ran out of bonus credit.": [
        ""
      ],
      "Account username can't be used because is reserved": [
        ""
      ],
      "Can't create accounts": [
        ""
      ],
      "Only system admin can create accounts.": [
        ""
      ],
      "New bank account": [
        "Новый бизнес счёт"
      ],
      "only admin can download stats": [
        ""
      ],
      "Download bank stats": [
        "Скачивать статистику банка"
      ],
      "Include hour metric": [
        "Включить часовую метрику"
      ],
      "Include day metric": [
        "Включить дневную метрику"
      ],
      "Include month metric": [
        "Включить месячную метрику"
      ],
      "Include year metric": [
        "Включить годовую метрику"
      ],
      "Include table header": [
        "Включить заголовок таблицы"
      ],
      "Add previous metric for compare": [
        "Добавить предыдущую метрику для сравнения"
      ],
      "Fail on first error": [
        "Сбой при первой ошибке"
      ],
      "Download": [
        "Скачивать"
      ],
      "downloading... %1$s": [
        "скачивание... %1$s"
      ],
      "Download completed": [
        "Скачивание завершено"
      ],
      "Click here to save the file in your computer.": [
        "Нажмите здесь, чтобы сохранить файл на своем компьютере"
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        ""
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        ""
      ],
      "Name doesn't match": [
        "пароль не совпадает"
      ],
      "Account removed": [
        ""
      ],
      "No enough permission to delete the account.": [
        ""
      ],
      "The username was not found.": [
        ""
      ],
      "Can't delete a reserved username.": [
        ""
      ],
      "Can't delete an account with balance different than zero.": [
        ""
      ],
      "Remove account.": [
        "На счёт"
      ],
      "You are going to remove the account": [
        ""
      ],
      "Deleting account \"%1$s\"": [
        "Удаление счёта \"%1$s\""
      ],
      "Verification": [
        "Проверка"
      ],
      "Enter the account name that is going to be deleted": [
        ""
      ],
      "Cashout id should be a number": [
        ""
      ],
      "This cashout not found. Maybe already aborted.": [
        ""
      ],
      "Cashout detail": [
        "Подробности обналичивания"
      ],
      "Debited": [
        "Дебетировано"
      ],
      "Transferred": [
        "Перевести"
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        "Добро пожаловать в %1$s!"
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;",
  "lang": "ru",
  "completeness": 66
};

strings['it'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=2; plural=n != 1;",
        "lang": "it"
      },
      "Operation failed, please report": [
        "Registrazione"
      ],
      "Request timeout": [
        ""
      ],
      "Request throttled": [
        ""
      ],
      "Malformed response": [
        ""
      ],
      "Network error": [
        ""
      ],
      "Unexpected request error": [
        ""
      ],
      "Unexpected error": [
        ""
      ],
      "An IBAN consists of capital letters and numbers only": [
        ""
      ],
      "IBAN numbers have more that 4 digits": [
        ""
      ],
      "IBAN numbers have less that 34 digits": [
        ""
      ],
      "IBAN country code not found": [
        ""
      ],
      "IBAN number is not valid, checksum is wrong": [
        ""
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        ""
      ],
      "Required": [
        ""
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        ""
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        "Trasferisci fondi a un altro conto di questa banca:"
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        "Operazione non riuscita."
      ],
      "Multi-factor authentication required": [
        ""
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        ""
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        "La banca sta creando l'operazione..."
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        ""
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        ""
      ],
      "The bank configuration does not support cashout operations.": [
        ""
      ],
      "Close": [
        ""
      ],
      "Cashout is disabled": [
        ""
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "The server didn't understand the request.": [
        ""
      ],
      "The amount is too small": [
        "Questo ritiro è stato annullato!"
      ],
      "Conversion is not implemented.": [
        ""
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        ""
      ],
      "The currency is not supported": [
        ""
      ],
      "Invalid": [
        ""
      ],
      "Amount needs to be higher": [
        "Somma da ritirare"
      ],
      "Balance is not enough": [
        ""
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        ""
      ],
      "The total transfer to the destination will be zero": [
        ""
      ],
      "Cashout created": [
        ""
      ],
      "Second factor authentication required.": [
        ""
      ],
      "Account not found": [
        ""
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        ""
      ],
      "The conversion rate was applied incorrectly": [
        ""
      ],
      "The account does not have sufficient funds": [
        ""
      ],
      "Missing cashout URI in the profile": [
        ""
      ],
      "The amount is below the minimum amount permitted.": [
        ""
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        ""
      ],
      "The server doesn't support the current TAN channel.": [
        ""
      ],
      "Create cashout.": [
        "Ultime transazioni:"
      ],
      "Cashout": [
        ""
      ],
      "Conversion rate": [
        ""
      ],
      "Balance": [
        ""
      ],
      "Fee": [
        ""
      ],
      "To account": [
        "Al conto"
      ],
      "Legal name": [
        ""
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        ""
      ],
      "Unable to cashout": [
        "Ultime transazioni:"
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        ""
      ],
      "Transfer subject": [
        "Trasferisci fondi a un altro conto di questa banca:"
      ],
      "Currency": [
        ""
      ],
      "Send %1$s": [
        ""
      ],
      "Receive %1$s": [
        ""
      ],
      "Amount": [
        "Importo"
      ],
      "Total cost": [
        ""
      ],
      "Balance left": [
        ""
      ],
      "Before fee": [
        ""
      ],
      "Total cashout transfer": [
        ""
      ],
      "Not valid": [
        ""
      ],
      "Does not follow the pattern": [
        ""
      ],
      "The wire transfer was successfully completed!": [
        "Il bonifico bancario è stato completato con successo!"
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        ""
      ],
      "Not enough permission to complete the operation.": [
        "La banca sta creando l'operazione..."
      ],
      "The bank administrator cannot be the transfer creditor.": [
        ""
      ],
      "The destination account \"%1$s\" was not found.": [
        "Lista conti pubblici non trovata."
      ],
      "The origin and the destination of the transfer can't be the same.": [
        ""
      ],
      "Your balance is not sufficient for the operation.": [
        ""
      ],
      "The origin account \"%1$s\" was not found.": [
        "Lista conti pubblici non trovata."
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        ""
      ],
      "A second factor authentication is required.": [
        ""
      ],
      "Confirm wire transfer.": [
        "Bonifico"
      ],
      "Input wire transfer detail": [
        "Inserite qui i dettagli del bonifico"
      ],
      "Using a form": [
        ""
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        ""
      ],
      "QR code": [
        ""
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        ""
      ],
      "Recipient": [
        ""
      ],
      "ID of the recipient's account": [
        "Storico dei conti pubblici"
      ],
      "username": [
        ""
      ],
      "IBAN of the recipient's account": [
        ""
      ],
      "Subject": [
        "Soggetto"
      ],
      "Some text to identify the transfer": [
        ""
      ],
      "Amount to transfer": [
        "Somma da trasferire"
      ],
      "Payto URI:": [
        ""
      ],
      "Uniform resource identifier of the target account": [
        ""
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        ""
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        ""
      ],
      "The maximum amount for a wire transfer is %1$s": [
        ""
      ],
      "Cost": [
        ""
      ],
      "Send": [
        ""
      ],
      "Only \"x-taler-bank\" target are supported": [
        ""
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        ""
      ],
      "Account name is missing": [
        "Importo"
      ],
      "Only \"IBAN\" target are supported": [
        ""
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        ""
      ],
      "The \"amount\" parameter is not valid": [
        "Questo ritiro è stato annullato!"
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        ""
      ],
      "The only currency allowed is \"%1$s\"": [
        ""
      ],
      "You cannot transfer an amount of zero.": [
        ""
      ],
      "The balance is not sufficient": [
        ""
      ],
      "Please enter a longer subject": [
        "Trasferisci fondi a un altro conto di questa banca:"
      ],
      "Show withdrawal confirmation": [
        "Questo ritiro è stato annullato!"
      ],
      "Withdraw without setting amount": [
        ""
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        ""
      ],
      "Currently, the bank is not accepting new registrations!": [
        ""
      ],
      "The name is missing": [
        ""
      ],
      "Missing username": [
        ""
      ],
      "Missing password": [
        ""
      ],
      "The password should be longer than 8 letters": [
        ""
      ],
      "The passwords do not match": [
        ""
      ],
      "Server replied with invalid phone or email.": [
        ""
      ],
      "You are not authorised to create this account.": [
        ""
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        ""
      ],
      "That username can't be used because is reserved.": [
        ""
      ],
      "That username is already taken.": [
        ""
      ],
      "That account ID is already taken.": [
        ""
      ],
      "No information for the selected authentication channel.": [
        ""
      ],
      "Authentication channel is not supported.": [
        ""
      ],
      "Only an administrator is allowed to set the debt limit.": [
        ""
      ],
      "Only the administrator can change the conversion rate.": [
        ""
      ],
      "The conversion rate class doesn't exist.": [
        ""
      ],
      "Only admin can create accounts with second factor authentication.": [
        ""
      ],
      "The password is too short. Can't have less than 8 characters.": [
        ""
      ],
      "The password is too long. Can't have more than 64 characters.": [
        ""
      ],
      "Account registration": [
        ""
      ],
      "Login username": [
        ""
      ],
      "Password": [
        ""
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        ""
      ],
      "Repeat password": [
        ""
      ],
      "Full name": [
        ""
      ],
      "Register": [
        "Registrati"
      ],
      "Create a random temporary user": [
        ""
      ],
      "You have no permission to this account.": [
        "La banca sta creando l'operazione..."
      ],
      "Wrong credentials for \"%1$s\"": [
        "Credenziali invalide."
      ],
      "Account login.": [
        "Importo"
      ],
      "Session expired": [
        ""
      ],
      "Username": [
        ""
      ],
      "Password of the account": [
        "Password dell'account"
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        ""
      ],
      "Transactions history": [
        ""
      ],
      "No transactions yet.": [
        "Ancora nessuna transazione."
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        ""
      ],
      "Date": [
        "Data"
      ],
      "Counterpart": [
        "Conto corrente"
      ],
      "sent": [
        ""
      ],
      "received": [
        ""
      ],
      "Invalid value": [
        ""
      ],
      "to": [
        ""
      ],
      "from": [
        ""
      ],
      "First page": [
        ""
      ],
      "Next": [
        ""
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        ""
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        ""
      ],
      "The operation ID is invalid.": [
        "L'ID dell'operazione non è valido."
      ],
      "The operation was not found.": [
        "L'operazione non è stata trovata."
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        ""
      ],
      "The bank requires a bank account which has not been specified yet.": [
        ""
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        "L'operazione non è stata trovata."
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        ""
      ],
      "Complete withdrawal.": [
        "Conferma il ritiro"
      ],
      "Confirm the withdrawal operation": [
        "Conferma il ritiro"
      ],
      "Wire transfer details": [
        "Bonifico"
      ],
      "Payment Service Provider's account number": [
        ""
      ],
      "Payment Service Provider's name": [
        ""
      ],
      "Payment Service Provider's account bank hostname": [
        ""
      ],
      "Payment Service Provider's account id": [
        ""
      ],
      "Payment Service Provider's account address": [
        ""
      ],
      "No amount has yet been determined.": [
        ""
      ],
      "Transfer": [
        ""
      ],
      "Authentication required": [
        ""
      ],
      "This operation was created with another username": [
        "Lista conti pubblici non trovata."
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        ""
      ],
      "Wire transfer completed!": [
        "Bonifico"
      ],
      "Confirm withdrawal.": [
        "Conferma il ritiro"
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        ""
      ],
      "The operation was rejected due to insufficient funds.": [
        ""
      ],
      "Withdrawal confirmed": [
        "Questo ritiro è stato annullato!"
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        ""
      ],
      "Do not show this again": [
        ""
      ],
      "If you have a Taler wallet installed on this device": [
        ""
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        ""
      ],
      "on this page": [
        ""
      ],
      "Withdraw": [
        "Prelevare"
      ],
      "In case you have a Taler wallet on another device": [
        ""
      ],
      "Scan the QR below to start the withdrawal.": [
        "Chiudi il ritiro Taler"
      ],
      "There is an operation already pending": [
        "Questo ritiro è stato annullato!"
      ],
      "Complete the operation in": [
        "Conferma il ritiro"
      ],
      "this page": [
        ""
      ],
      "The server replied with an invalid taler://withdraw URI": [
        ""
      ],
      "Withdraw URI: %1$s": [
        "Withdraw URI: %1$s"
      ],
      "The operation was rejected due to insufficient funds": [
        ""
      ],
      "Current balance is %1$s": [
        ""
      ],
      "You can withdraw up to %1$s": [
        ""
      ],
      "Continue": [
        ""
      ],
      "Use your Taler wallet": [
        ""
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        ""
      ],
      "You need a Taler wallet": [
        "Ritira contante nel portafoglio Taler"
      ],
      "If you don't have one yet you can follow the instruction in": [
        ""
      ],
      "Send money": [
        ""
      ],
      "to a Taler wallet": [
        "Ritira contante nel portafoglio Taler"
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        ""
      ],
      "to another bank account": [
        "Trasferisci fondi a un altro conto di questa banca:"
      ],
      "Make a wire transfer to an account with known bank account number.": [
        ""
      ],
      "This is a demo": [
        ""
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        ""
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        ""
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        "Registrazione"
      ],
      "Preferences": [
        ""
      ],
      "Welcome": [
        ""
      ],
      "Welcome, %1$s": [
        ""
      ],
      "No enough permission to access the conversion rate list.": [
        "La banca sta creando l'operazione..."
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        ""
      ],
      "Conversion rate classes": [
        "Cambio"
      ],
      "Create conversion rate class": [
        ""
      ],
      "No conversion rate class": [
        ""
      ],
      "Name": [
        ""
      ],
      "Description": [
        ""
      ],
      "Cashin": [
        ""
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        ""
      ],
      "Details": [
        ""
      ],
      "Delete": [
        ""
      ],
      "Credentials": [
        "Credenziali"
      ],
      "Cashouts": [
        "Incassi (Cashout)"
      ],
      "Conversion": [
        "Cambio"
      ],
      "only admin can setup conversion": [
        ""
      ],
      "Wrong credentials": [
        "Credenziali invalide."
      ],
      "Conversion is disabled": [
        ""
      ],
      "Config cashout": [
        "Ultime transazioni:"
      ],
      "Config cashin": [
        ""
      ],
      "Bad ratios": [
        ""
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        ""
      ],
      "Initial amount": [
        "Questo ritiro è stato annullato!"
      ],
      "Use it to test how the conversion will affect the amount.": [
        ""
      ],
      "Sending to this bank": [
        ""
      ],
      "Converted": [
        ""
      ],
      "Cashin after fee": [
        ""
      ],
      "Sending from this bank": [
        ""
      ],
      "Cashout after fee": [
        ""
      ],
      "Bad configuration": [
        ""
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        ""
      ],
      "Update": [
        ""
      ],
      "Rnvalid": [
        ""
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        ""
      ],
      "Only cashout operation above this threshold will be allowed.": [
        ""
      ],
      "Ratio": [
        ""
      ],
      "Conversion ratio between currencies": [
        ""
      ],
      "Example conversion": [
        ""
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        ""
      ],
      "Tiny amount": [
        "Al conto"
      ],
      "Rounding mode": [
        ""
      ],
      "Zero": [
        ""
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        ""
      ],
      "Up": [
        ""
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        ""
      ],
      "Nearest": [
        ""
      ],
      "Amount will be round to the closest possible value.": [
        ""
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        ""
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        ""
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        ""
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        ""
      ],
      "Amount to be deducted before amount is credited.": [
        ""
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "Unauthorized": [
        ""
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        ""
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        ""
      ],
      "The name of the conversion is already used.": [
        "Questo ritiro è stato annullato!"
      ],
      "Conversion rate class": [
        "Cambio"
      ],
      "Accounts": [
        "Importo"
      ],
      "Test": [
        ""
      ],
      "Users": [
        ""
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        ""
      ],
      "This step can't be undone.": [
        ""
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        "Conto"
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        ""
      ],
      "Remove": [
        ""
      ],
      "Add": [
        "indirizzo Payto"
      ],
      "Conversion rate name": [
        "Cambio"
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        ""
      ],
      "The rights to change the account are not sufficient": [
        ""
      ],
      "New conversion rate class": [
        ""
      ],
      "Create": [
        ""
      ],
      "History of public accounts": [
        "Storico dei conti pubblici"
      ],
      "Make a wire transfer": [
        "Chiudi il bonifico"
      ],
      "Scan the QR code below to start the withdrawal.": [
        "Chiudi il ritiro Taler"
      ],
      "Operation aborted": [
        ""
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        ""
      ],
      "Go to your wallet now": [
        ""
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        ""
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        ""
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        ""
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        ""
      ],
      "Operation not found": [
        ""
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        ""
      ],
      "Continue to dashboard": [
        ""
      ],
      "The Withdrawal URI is not valid": [
        "Questo ritiro è stato annullato!"
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        ""
      ],
      "Latest cashouts": [
        "Ultime transazioni:"
      ],
      "Created": [
        ""
      ],
      "Total debit": [
        ""
      ],
      "Total credit": [
        ""
      ],
      "Cashout for account %1$s": [
        ""
      ],
      "Doesn't have the pattern of an email": [
        ""
      ],
      "Should start with +": [
        ""
      ],
      "A phone number consists of numbers only": [
        ""
      ],
      "Account ID for authentication": [
        ""
      ],
      "Name of the account holder": [
        "Nome del titolare del conto corrente bancario"
      ],
      "Internal account": [
        "Conto interno"
      ],
      "If this field is empty, a random account ID will be assigned": [
        ""
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        ""
      ],
      "Email": [
        ""
      ],
      "To be used when second factor authentication is enabled": [
        ""
      ],
      "Phone": [
        ""
      ],
      "Enable second factor authentication": [
        ""
      ],
      "Using email": [
        ""
      ],
      "Add an email in your profile to enable this option": [
        ""
      ],
      "Using SMS": [
        ""
      ],
      "Add a phone number in your profile to enable this option": [
        ""
      ],
      "Cashout account": [
        "Conto di incasso"
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        ""
      ],
      "Max debt": [
        ""
      ],
      "How much the balance can go below zero.": [
        ""
      ],
      "Is this account public?": [
        ""
      ],
      "Public accounts have their balance publicly accessible": [
        ""
      ],
      "Does this account belong to a Payment Service Provider?": [
        ""
      ],
      "Account updated": [
        ""
      ],
      "The username was not found": [
        ""
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        ""
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        ""
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        ""
      ],
      "Update account information.": [
        "Aggiornamento dei valori del conto"
      ],
      "Account \"%1$s\"": [
        ""
      ],
      "Removed": [
        ""
      ],
      "This account can't be used.": [
        ""
      ],
      "Change details": [
        ""
      ],
      "Merchant integration": [
        ""
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        ""
      ],
      "Account type": [
        "Importo"
      ],
      "Method to use for wire transfer.": [
        "Chiudi il bonifico"
      ],
      "IBAN": [
        ""
      ],
      "International Bank Account Number.": [
        ""
      ],
      "Account name": [
        "Importo"
      ],
      "Bank host where the service is located.": [
        ""
      ],
      "Bank account identifier for wire transfers.": [
        ""
      ],
      "Address": [
        "indirizzo Payto"
      ],
      "Owner's name": [
        ""
      ],
      "Legal name of the person holding the account.": [
        ""
      ],
      "Account info URL": [
        "Lista conti pubblici non trovata."
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        ""
      ],
      "Repeated password doesn't match": [
        ""
      ],
      "Password changed": [
        ""
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        ""
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        ""
      ],
      "Your current password doesn't match, can't change to a new password.": [
        ""
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        "Aggiornamento dei valori del conto"
      ],
      "Update password": [
        ""
      ],
      "Current password": [
        ""
      ],
      "Your current password, for security": [
        ""
      ],
      "New password": [
        ""
      ],
      "Type it again": [
        ""
      ],
      "Repeat the same password": [
        ""
      ],
      "Change": [
        ""
      ],
      "Create account": [
        ""
      ],
      "Actions": [
        ""
      ],
      "Unknown": [
        ""
      ],
      "Change password": [
        ""
      ],
      "Querying for the current stats failed": [
        ""
      ],
      "The request parameters are wrong": [
        ""
      ],
      "The user is unauthorized": [
        ""
      ],
      "Querying for the previous stats failed": [
        ""
      ],
      "Transaction volume report": [
        ""
      ],
      "Last hour": [
        ""
      ],
      "Previous day": [
        ""
      ],
      "Last month": [
        ""
      ],
      "Last year": [
        ""
      ],
      "Last Year": [
        ""
      ],
      "Trading volume from %1$s to %2$s": [
        ""
      ],
      "Transferred from an external account to an account in this bank.": [
        ""
      ],
      "Transferred from an account in this bank to an external account.": [
        ""
      ],
      "Payin": [
        ""
      ],
      "Transferred from an account to a Taler exchange.": [
        ""
      ],
      "Payout": [
        ""
      ],
      "Transferred from a Taler exchange to another account.": [
        ""
      ],
      "Download stats as CSV": [
        ""
      ],
      "previous": [
        ""
      ],
      "Decreased by": [
        ""
      ],
      "Increased by": [
        ""
      ],
      "Account created with password \"%1$s\".": [
        ""
      ],
      "Server replied that phone or email is invalid": [
        ""
      ],
      "The rights to perform the operation are not sufficient": [
        ""
      ],
      "Account username is already taken": [
        ""
      ],
      "Account ID is already taken": [
        ""
      ],
      "Bank ran out of bonus credit.": [
        ""
      ],
      "Account username can't be used because is reserved": [
        ""
      ],
      "Can't create accounts": [
        ""
      ],
      "Only system admin can create accounts.": [
        ""
      ],
      "New bank account": [
        "Trasferisci fondi a un altro conto di questa banca:"
      ],
      "only admin can download stats": [
        ""
      ],
      "Download bank stats": [
        ""
      ],
      "Include hour metric": [
        ""
      ],
      "Include day metric": [
        ""
      ],
      "Include month metric": [
        ""
      ],
      "Include year metric": [
        ""
      ],
      "Include table header": [
        ""
      ],
      "Add previous metric for compare": [
        ""
      ],
      "Fail on first error": [
        ""
      ],
      "Download": [
        ""
      ],
      "downloading... %1$s": [
        ""
      ],
      "Download completed": [
        ""
      ],
      "Click here to save the file in your computer.": [
        ""
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        ""
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        ""
      ],
      "Name doesn't match": [
        ""
      ],
      "Account removed": [
        ""
      ],
      "No enough permission to delete the account.": [
        ""
      ],
      "The username was not found.": [
        ""
      ],
      "Can't delete a reserved username.": [
        ""
      ],
      "Can't delete an account with balance different than zero.": [
        ""
      ],
      "Remove account.": [
        "Al conto"
      ],
      "You are going to remove the account": [
        ""
      ],
      "Deleting account \"%1$s\"": [
        ""
      ],
      "Verification": [
        ""
      ],
      "Enter the account name that is going to be deleted": [
        ""
      ],
      "Cashout id should be a number": [
        ""
      ],
      "This cashout not found. Maybe already aborted.": [
        ""
      ],
      "Cashout detail": [
        ""
      ],
      "Debited": [
        ""
      ],
      "Transferred": [
        "Trasferisci fondi a un altro conto di questa banca:"
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        ""
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=2; plural=n != 1;",
  "lang": "it",
  "completeness": 17
};

strings['he'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=4; plural=(n == 1) ? 0 : ((n == 2) ? 1 : ((n > 10 && n % 10 == 0) ? 2 : 3));",
        "lang": "he"
      },
      "Operation failed, please report": [
        ""
      ],
      "Request timeout": [
        ""
      ],
      "Request throttled": [
        ""
      ],
      "Malformed response": [
        ""
      ],
      "Network error": [
        ""
      ],
      "Unexpected request error": [
        ""
      ],
      "Unexpected error": [
        ""
      ],
      "An IBAN consists of capital letters and numbers only": [
        ""
      ],
      "IBAN numbers have more that 4 digits": [
        ""
      ],
      "IBAN numbers have less that 34 digits": [
        ""
      ],
      "IBAN country code not found": [
        ""
      ],
      "IBAN number is not valid, checksum is wrong": [
        ""
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        ""
      ],
      "Required": [
        ""
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        ""
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        ""
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        ""
      ],
      "Multi-factor authentication required": [
        ""
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        ""
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        ""
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        ""
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        ""
      ],
      "The bank configuration does not support cashout operations.": [
        ""
      ],
      "Close": [
        ""
      ],
      "Cashout is disabled": [
        ""
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "The server didn't understand the request.": [
        ""
      ],
      "The amount is too small": [
        ""
      ],
      "Conversion is not implemented.": [
        ""
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        ""
      ],
      "The currency is not supported": [
        ""
      ],
      "Invalid": [
        ""
      ],
      "Amount needs to be higher": [
        ""
      ],
      "Balance is not enough": [
        ""
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        ""
      ],
      "The total transfer to the destination will be zero": [
        ""
      ],
      "Cashout created": [
        ""
      ],
      "Second factor authentication required.": [
        ""
      ],
      "Account not found": [
        ""
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        ""
      ],
      "The conversion rate was applied incorrectly": [
        ""
      ],
      "The account does not have sufficient funds": [
        ""
      ],
      "Missing cashout URI in the profile": [
        ""
      ],
      "The amount is below the minimum amount permitted.": [
        ""
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        ""
      ],
      "The server doesn't support the current TAN channel.": [
        ""
      ],
      "Create cashout.": [
        ""
      ],
      "Cashout": [
        ""
      ],
      "Conversion rate": [
        ""
      ],
      "Balance": [
        ""
      ],
      "Fee": [
        ""
      ],
      "To account": [
        ""
      ],
      "Legal name": [
        ""
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        ""
      ],
      "Unable to cashout": [
        ""
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        ""
      ],
      "Transfer subject": [
        ""
      ],
      "Currency": [
        ""
      ],
      "Send %1$s": [
        ""
      ],
      "Receive %1$s": [
        ""
      ],
      "Amount": [
        ""
      ],
      "Total cost": [
        ""
      ],
      "Balance left": [
        ""
      ],
      "Before fee": [
        ""
      ],
      "Total cashout transfer": [
        ""
      ],
      "Not valid": [
        ""
      ],
      "Does not follow the pattern": [
        ""
      ],
      "The wire transfer was successfully completed!": [
        ""
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        ""
      ],
      "Not enough permission to complete the operation.": [
        ""
      ],
      "The bank administrator cannot be the transfer creditor.": [
        ""
      ],
      "The destination account \"%1$s\" was not found.": [
        ""
      ],
      "The origin and the destination of the transfer can't be the same.": [
        ""
      ],
      "Your balance is not sufficient for the operation.": [
        ""
      ],
      "The origin account \"%1$s\" was not found.": [
        ""
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        ""
      ],
      "A second factor authentication is required.": [
        ""
      ],
      "Confirm wire transfer.": [
        ""
      ],
      "Input wire transfer detail": [
        ""
      ],
      "Using a form": [
        ""
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        ""
      ],
      "QR code": [
        ""
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        ""
      ],
      "Recipient": [
        ""
      ],
      "ID of the recipient's account": [
        ""
      ],
      "username": [
        ""
      ],
      "IBAN of the recipient's account": [
        ""
      ],
      "Subject": [
        ""
      ],
      "Some text to identify the transfer": [
        ""
      ],
      "Amount to transfer": [
        ""
      ],
      "Payto URI:": [
        ""
      ],
      "Uniform resource identifier of the target account": [
        ""
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        ""
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        ""
      ],
      "The maximum amount for a wire transfer is %1$s": [
        ""
      ],
      "Cost": [
        ""
      ],
      "Send": [
        ""
      ],
      "Only \"x-taler-bank\" target are supported": [
        ""
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        ""
      ],
      "Account name is missing": [
        ""
      ],
      "Only \"IBAN\" target are supported": [
        ""
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        ""
      ],
      "The \"amount\" parameter is not valid": [
        ""
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        ""
      ],
      "The only currency allowed is \"%1$s\"": [
        ""
      ],
      "You cannot transfer an amount of zero.": [
        ""
      ],
      "The balance is not sufficient": [
        ""
      ],
      "Please enter a longer subject": [
        ""
      ],
      "Show withdrawal confirmation": [
        ""
      ],
      "Withdraw without setting amount": [
        ""
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        ""
      ],
      "Currently, the bank is not accepting new registrations!": [
        ""
      ],
      "The name is missing": [
        ""
      ],
      "Missing username": [
        ""
      ],
      "Missing password": [
        ""
      ],
      "The password should be longer than 8 letters": [
        ""
      ],
      "The passwords do not match": [
        ""
      ],
      "Server replied with invalid phone or email.": [
        ""
      ],
      "You are not authorised to create this account.": [
        ""
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        ""
      ],
      "That username can't be used because is reserved.": [
        ""
      ],
      "That username is already taken.": [
        ""
      ],
      "That account ID is already taken.": [
        ""
      ],
      "No information for the selected authentication channel.": [
        ""
      ],
      "Authentication channel is not supported.": [
        ""
      ],
      "Only an administrator is allowed to set the debt limit.": [
        ""
      ],
      "Only the administrator can change the conversion rate.": [
        ""
      ],
      "The conversion rate class doesn't exist.": [
        ""
      ],
      "Only admin can create accounts with second factor authentication.": [
        ""
      ],
      "The password is too short. Can't have less than 8 characters.": [
        ""
      ],
      "The password is too long. Can't have more than 64 characters.": [
        ""
      ],
      "Account registration": [
        ""
      ],
      "Login username": [
        ""
      ],
      "Password": [
        ""
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        ""
      ],
      "Repeat password": [
        ""
      ],
      "Full name": [
        ""
      ],
      "Register": [
        ""
      ],
      "Create a random temporary user": [
        ""
      ],
      "You have no permission to this account.": [
        ""
      ],
      "Wrong credentials for \"%1$s\"": [
        ""
      ],
      "Account login.": [
        ""
      ],
      "Session expired": [
        ""
      ],
      "Username": [
        ""
      ],
      "Password of the account": [
        ""
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        ""
      ],
      "Transactions history": [
        ""
      ],
      "No transactions yet.": [
        ""
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        ""
      ],
      "Date": [
        ""
      ],
      "Counterpart": [
        ""
      ],
      "sent": [
        ""
      ],
      "received": [
        ""
      ],
      "Invalid value": [
        ""
      ],
      "to": [
        ""
      ],
      "from": [
        ""
      ],
      "First page": [
        ""
      ],
      "Next": [
        ""
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        ""
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        ""
      ],
      "The operation ID is invalid.": [
        ""
      ],
      "The operation was not found.": [
        ""
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        ""
      ],
      "The bank requires a bank account which has not been specified yet.": [
        ""
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        ""
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        ""
      ],
      "Complete withdrawal.": [
        ""
      ],
      "Confirm the withdrawal operation": [
        ""
      ],
      "Wire transfer details": [
        ""
      ],
      "Payment Service Provider's account number": [
        ""
      ],
      "Payment Service Provider's name": [
        ""
      ],
      "Payment Service Provider's account bank hostname": [
        ""
      ],
      "Payment Service Provider's account id": [
        ""
      ],
      "Payment Service Provider's account address": [
        ""
      ],
      "No amount has yet been determined.": [
        ""
      ],
      "Transfer": [
        ""
      ],
      "Authentication required": [
        ""
      ],
      "This operation was created with another username": [
        ""
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        ""
      ],
      "Wire transfer completed!": [
        ""
      ],
      "Confirm withdrawal.": [
        ""
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        ""
      ],
      "The operation was rejected due to insufficient funds.": [
        ""
      ],
      "Withdrawal confirmed": [
        ""
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        ""
      ],
      "Do not show this again": [
        ""
      ],
      "If you have a Taler wallet installed on this device": [
        ""
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        ""
      ],
      "on this page": [
        ""
      ],
      "Withdraw": [
        ""
      ],
      "In case you have a Taler wallet on another device": [
        ""
      ],
      "Scan the QR below to start the withdrawal.": [
        ""
      ],
      "There is an operation already pending": [
        ""
      ],
      "Complete the operation in": [
        ""
      ],
      "this page": [
        ""
      ],
      "The server replied with an invalid taler://withdraw URI": [
        ""
      ],
      "Withdraw URI: %1$s": [
        ""
      ],
      "The operation was rejected due to insufficient funds": [
        ""
      ],
      "Current balance is %1$s": [
        ""
      ],
      "You can withdraw up to %1$s": [
        ""
      ],
      "Continue": [
        ""
      ],
      "Use your Taler wallet": [
        ""
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        ""
      ],
      "You need a Taler wallet": [
        ""
      ],
      "If you don't have one yet you can follow the instruction in": [
        ""
      ],
      "Send money": [
        ""
      ],
      "to a Taler wallet": [
        ""
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        ""
      ],
      "to another bank account": [
        ""
      ],
      "Make a wire transfer to an account with known bank account number.": [
        ""
      ],
      "This is a demo": [
        ""
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        ""
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        ""
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        ""
      ],
      "Preferences": [
        ""
      ],
      "Welcome": [
        ""
      ],
      "Welcome, %1$s": [
        ""
      ],
      "No enough permission to access the conversion rate list.": [
        ""
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        ""
      ],
      "Conversion rate classes": [
        ""
      ],
      "Create conversion rate class": [
        ""
      ],
      "No conversion rate class": [
        ""
      ],
      "Name": [
        ""
      ],
      "Description": [
        ""
      ],
      "Cashin": [
        ""
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        ""
      ],
      "Details": [
        ""
      ],
      "Delete": [
        ""
      ],
      "Credentials": [
        ""
      ],
      "Cashouts": [
        ""
      ],
      "Conversion": [
        ""
      ],
      "only admin can setup conversion": [
        ""
      ],
      "Wrong credentials": [
        ""
      ],
      "Conversion is disabled": [
        ""
      ],
      "Config cashout": [
        ""
      ],
      "Config cashin": [
        ""
      ],
      "Bad ratios": [
        ""
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        ""
      ],
      "Initial amount": [
        ""
      ],
      "Use it to test how the conversion will affect the amount.": [
        ""
      ],
      "Sending to this bank": [
        ""
      ],
      "Converted": [
        ""
      ],
      "Cashin after fee": [
        ""
      ],
      "Sending from this bank": [
        ""
      ],
      "Cashout after fee": [
        ""
      ],
      "Bad configuration": [
        ""
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        ""
      ],
      "Update": [
        ""
      ],
      "Rnvalid": [
        ""
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        ""
      ],
      "Only cashout operation above this threshold will be allowed.": [
        ""
      ],
      "Ratio": [
        ""
      ],
      "Conversion ratio between currencies": [
        ""
      ],
      "Example conversion": [
        ""
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        ""
      ],
      "Tiny amount": [
        ""
      ],
      "Rounding mode": [
        ""
      ],
      "Zero": [
        ""
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        ""
      ],
      "Up": [
        ""
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        ""
      ],
      "Nearest": [
        ""
      ],
      "Amount will be round to the closest possible value.": [
        ""
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        ""
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        ""
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        ""
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        ""
      ],
      "Amount to be deducted before amount is credited.": [
        ""
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "Unauthorized": [
        ""
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        ""
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        ""
      ],
      "The name of the conversion is already used.": [
        ""
      ],
      "Conversion rate class": [
        ""
      ],
      "Accounts": [
        ""
      ],
      "Test": [
        ""
      ],
      "Users": [
        ""
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        ""
      ],
      "This step can't be undone.": [
        ""
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        ""
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        ""
      ],
      "Remove": [
        ""
      ],
      "Add": [
        ""
      ],
      "Conversion rate name": [
        ""
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        ""
      ],
      "The rights to change the account are not sufficient": [
        ""
      ],
      "New conversion rate class": [
        ""
      ],
      "Create": [
        ""
      ],
      "History of public accounts": [
        ""
      ],
      "Make a wire transfer": [
        ""
      ],
      "Scan the QR code below to start the withdrawal.": [
        ""
      ],
      "Operation aborted": [
        ""
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        ""
      ],
      "Go to your wallet now": [
        ""
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        ""
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        ""
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        ""
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        ""
      ],
      "Operation not found": [
        ""
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        ""
      ],
      "Continue to dashboard": [
        ""
      ],
      "The Withdrawal URI is not valid": [
        ""
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        ""
      ],
      "Latest cashouts": [
        ""
      ],
      "Created": [
        ""
      ],
      "Total debit": [
        ""
      ],
      "Total credit": [
        ""
      ],
      "Cashout for account %1$s": [
        ""
      ],
      "Doesn't have the pattern of an email": [
        ""
      ],
      "Should start with +": [
        ""
      ],
      "A phone number consists of numbers only": [
        ""
      ],
      "Account ID for authentication": [
        ""
      ],
      "Name of the account holder": [
        ""
      ],
      "Internal account": [
        ""
      ],
      "If this field is empty, a random account ID will be assigned": [
        ""
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        ""
      ],
      "Email": [
        ""
      ],
      "To be used when second factor authentication is enabled": [
        ""
      ],
      "Phone": [
        ""
      ],
      "Enable second factor authentication": [
        ""
      ],
      "Using email": [
        ""
      ],
      "Add an email in your profile to enable this option": [
        ""
      ],
      "Using SMS": [
        ""
      ],
      "Add a phone number in your profile to enable this option": [
        ""
      ],
      "Cashout account": [
        ""
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        ""
      ],
      "Max debt": [
        ""
      ],
      "How much the balance can go below zero.": [
        ""
      ],
      "Is this account public?": [
        ""
      ],
      "Public accounts have their balance publicly accessible": [
        ""
      ],
      "Does this account belong to a Payment Service Provider?": [
        ""
      ],
      "Account updated": [
        ""
      ],
      "The username was not found": [
        ""
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        ""
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        ""
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        ""
      ],
      "Update account information.": [
        ""
      ],
      "Account \"%1$s\"": [
        ""
      ],
      "Removed": [
        ""
      ],
      "This account can't be used.": [
        ""
      ],
      "Change details": [
        ""
      ],
      "Merchant integration": [
        ""
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        ""
      ],
      "Account type": [
        ""
      ],
      "Method to use for wire transfer.": [
        ""
      ],
      "IBAN": [
        ""
      ],
      "International Bank Account Number.": [
        ""
      ],
      "Account name": [
        ""
      ],
      "Bank host where the service is located.": [
        ""
      ],
      "Bank account identifier for wire transfers.": [
        ""
      ],
      "Address": [
        ""
      ],
      "Owner's name": [
        ""
      ],
      "Legal name of the person holding the account.": [
        ""
      ],
      "Account info URL": [
        ""
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        ""
      ],
      "Repeated password doesn't match": [
        ""
      ],
      "Password changed": [
        ""
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        ""
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        ""
      ],
      "Your current password doesn't match, can't change to a new password.": [
        ""
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        ""
      ],
      "Update password": [
        ""
      ],
      "Current password": [
        ""
      ],
      "Your current password, for security": [
        ""
      ],
      "New password": [
        ""
      ],
      "Type it again": [
        ""
      ],
      "Repeat the same password": [
        ""
      ],
      "Change": [
        ""
      ],
      "Create account": [
        ""
      ],
      "Actions": [
        ""
      ],
      "Unknown": [
        ""
      ],
      "Change password": [
        ""
      ],
      "Querying for the current stats failed": [
        ""
      ],
      "The request parameters are wrong": [
        ""
      ],
      "The user is unauthorized": [
        ""
      ],
      "Querying for the previous stats failed": [
        ""
      ],
      "Transaction volume report": [
        ""
      ],
      "Last hour": [
        ""
      ],
      "Previous day": [
        ""
      ],
      "Last month": [
        ""
      ],
      "Last year": [
        ""
      ],
      "Last Year": [
        ""
      ],
      "Trading volume from %1$s to %2$s": [
        ""
      ],
      "Transferred from an external account to an account in this bank.": [
        ""
      ],
      "Transferred from an account in this bank to an external account.": [
        ""
      ],
      "Payin": [
        ""
      ],
      "Transferred from an account to a Taler exchange.": [
        ""
      ],
      "Payout": [
        ""
      ],
      "Transferred from a Taler exchange to another account.": [
        ""
      ],
      "Download stats as CSV": [
        ""
      ],
      "previous": [
        ""
      ],
      "Decreased by": [
        ""
      ],
      "Increased by": [
        ""
      ],
      "Account created with password \"%1$s\".": [
        ""
      ],
      "Server replied that phone or email is invalid": [
        ""
      ],
      "The rights to perform the operation are not sufficient": [
        ""
      ],
      "Account username is already taken": [
        ""
      ],
      "Account ID is already taken": [
        ""
      ],
      "Bank ran out of bonus credit.": [
        ""
      ],
      "Account username can't be used because is reserved": [
        ""
      ],
      "Can't create accounts": [
        ""
      ],
      "Only system admin can create accounts.": [
        ""
      ],
      "New bank account": [
        ""
      ],
      "only admin can download stats": [
        ""
      ],
      "Download bank stats": [
        ""
      ],
      "Include hour metric": [
        ""
      ],
      "Include day metric": [
        ""
      ],
      "Include month metric": [
        ""
      ],
      "Include year metric": [
        ""
      ],
      "Include table header": [
        ""
      ],
      "Add previous metric for compare": [
        ""
      ],
      "Fail on first error": [
        ""
      ],
      "Download": [
        ""
      ],
      "downloading... %1$s": [
        ""
      ],
      "Download completed": [
        ""
      ],
      "Click here to save the file in your computer.": [
        ""
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        ""
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        ""
      ],
      "Name doesn't match": [
        ""
      ],
      "Account removed": [
        ""
      ],
      "No enough permission to delete the account.": [
        ""
      ],
      "The username was not found.": [
        ""
      ],
      "Can't delete a reserved username.": [
        ""
      ],
      "Can't delete an account with balance different than zero.": [
        ""
      ],
      "Remove account.": [
        ""
      ],
      "You are going to remove the account": [
        ""
      ],
      "Deleting account \"%1$s\"": [
        ""
      ],
      "Verification": [
        ""
      ],
      "Enter the account name that is going to be deleted": [
        ""
      ],
      "Cashout id should be a number": [
        ""
      ],
      "This cashout not found. Maybe already aborted.": [
        ""
      ],
      "Cashout detail": [
        ""
      ],
      "Debited": [
        ""
      ],
      "Transferred": [
        ""
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        ""
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=4; plural=(n == 1) ? 0 : ((n == 2) ? 1 : ((n > 10 && n % 10 == 0) ? 2 : 3));",
  "lang": "he",
  "completeness": 0
};

strings['fr'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=2; plural=n > 1;",
        "lang": "fr"
      },
      "Operation failed, please report": [
        "L'opération a échoué, veuillez le signaler"
      ],
      "Request timeout": [
        "Délai d'attente dépassé"
      ],
      "Request throttled": [
        "Requête bloquée"
      ],
      "Malformed response": [
        "Réponse malformée"
      ],
      "Network error": [
        "Erreur réseau"
      ],
      "Unexpected request error": [
        "Erreur inattendue sur la requête"
      ],
      "Unexpected error": [
        "Erreur inattendue"
      ],
      "An IBAN consists of capital letters and numbers only": [
        "Un IBAN se compose uniquement de lettres majuscules et de chiffres"
      ],
      "IBAN numbers have more that 4 digits": [
        "Les numéros IBAN ont plus de 4 chiffres"
      ],
      "IBAN numbers have less that 34 digits": [
        "Les numéros IBAN ont moins de 34 chiffres"
      ],
      "IBAN country code not found": [
        "Le code pays de l'IBAN n'a pas été trouvé"
      ],
      "IBAN number is not valid, checksum is wrong": [
        "Le numéro IBAN n'est pas valide, la somme de contrôle est incorrecte"
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        "Utilisez des lettres, des chiffres ou l'un de ces caractères : - . _ ~"
      ],
      "Required": [
        "Obligatoire"
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        "Canal d'authentification"
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        "Nom d'utilisateur du compte"
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        "L’opération a échoué."
      ],
      "Multi-factor authentication required": [
        "Authentification obligatoire"
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        "Cette opération est protégée par une authentification à deuxième facteur. Pour la mener à bien, nous devons vérifier votre identité à l'aide du canal d'authentification que vous avez fourni."
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        "Autorisation insuffisante pour terminer l'opération."
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        "Annuler"
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        "Impossible de créer un encaissement"
      ],
      "The bank configuration does not support cashout operations.": [
        "La configuration bancaire ne prend pas en charge les opérations d'encaissement."
      ],
      "Close": [
        "Fermer"
      ],
      "Cashout is disabled": [
        "L'encaissement est désactivé"
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        "Le retrait doit être activé dans la configuration, le taux de conversion doit être initialisé avec des frais, des taux et un mode d'arrondi."
      ],
      "The server didn't understand the request.": [
        "Le serveur ne prend pas en charge le canal TAN actuel."
      ],
      "The amount is too small": [
        "Le mot de passe est trop long."
      ],
      "Conversion is not implemented.": [
        ""
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        "Désolé, cet identifiant de compte est déjà pris."
      ],
      "The currency is not supported": [
        "Le canal d'authentification n'est pas pris en charge."
      ],
      "Invalid": [
        "Invalide"
      ],
      "Amount needs to be higher": [
        "Le montant doit être plus élevé"
      ],
      "Balance is not enough": [
        "Le solde n'est pas suffisant"
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        "Il n'est pas possible d'encaisser moins de %1$s"
      ],
      "The total transfer to the destination will be zero": [
        "Le montant total transféré vers la destination sera nul"
      ],
      "Cashout created": [
        "Encaissement créé"
      ],
      "Second factor authentication required.": [
        "Authentification obligatoire"
      ],
      "Account not found": [
        "Compte non trouvé"
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        "Requête dupliquée détectée, vérifiez si l'opération a réussi ou réessayez."
      ],
      "The conversion rate was applied incorrectly": [
        "Le taux de conversion a été appliqué de manière incorrecte"
      ],
      "The account does not have sufficient funds": [
        "Le compte ne dispose pas de fonds suffisants"
      ],
      "Missing cashout URI in the profile": [
        "URI d'encaissement manquante dans le profil"
      ],
      "The amount is below the minimum amount permitted.": [
        "Le montant est inférieur au montant minimum autorisé."
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        "L'envoi du message de confirmation a échoué, réessayez plus tard ou contactez l'administrateur."
      ],
      "The server doesn't support the current TAN channel.": [
        "Le serveur ne prend pas en charge le canal TAN actuel."
      ],
      "Create cashout.": [
        "Créer un compte"
      ],
      "Cashout": [
        "Retrait"
      ],
      "Conversion rate": [
        "Taux de conversion"
      ],
      "Balance": [
        "Solde"
      ],
      "Fee": [
        "Frais"
      ],
      "To account": [
        "Compte de destination"
      ],
      "Legal name": [
        "Nom légal du bénéficiaire du compte bancaire"
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        "Si ce nom ne correspond pas au nom du titulaire du compte, votre transaction peut échouer."
      ],
      "Unable to cashout": [
        "Impossible de créer un encaissement"
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        "Avant de pouvoir effectuer un encaissement vers un compte bancaire, vous devez compléter votre profil"
      ],
      "Transfer subject": [
        "Référence du transfert"
      ],
      "Currency": [
        "Devise"
      ],
      "Send %1$s": [
        "Envoyer %1$s"
      ],
      "Receive %1$s": [
        "Recevoir %1$s"
      ],
      "Amount": [
        "Montant"
      ],
      "Total cost": [
        "Montant total des frais"
      ],
      "Balance left": [
        "Solde restant"
      ],
      "Before fee": [
        "Avant les frais"
      ],
      "Total cashout transfer": [
        "Transfert d'encaissement total"
      ],
      "Not valid": [
        "Non valide"
      ],
      "Does not follow the pattern": [
        "Ne suit pas le modèle"
      ],
      "The wire transfer was successfully completed!": [
        "Le virement bancaire a été effectué avec succès !"
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        "La requête n'était pas valide ou l'URI payto:// a utilisé des fonctionnalités inacceptables."
      ],
      "Not enough permission to complete the operation.": [
        "Autorisation insuffisante pour terminer l'opération."
      ],
      "The bank administrator cannot be the transfer creditor.": [
        "L'administrateur de la banque ne peut pas être le destinataire du transfert."
      ],
      "The destination account \"%1$s\" was not found.": [
        "Le compte de destination \"%1$s\" n'a pas été trouvé."
      ],
      "The origin and the destination of the transfer can't be the same.": [
        "L'origine et la destination du transfert ne peuvent pas être les mêmes."
      ],
      "Your balance is not sufficient for the operation.": [
        "Votre solde n'est pas suffisant pour l'opération."
      ],
      "The origin account \"%1$s\" was not found.": [
        "Le compte d'origine \"%1$s\" est introuvable."
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        "La tentative de création de la transaction a échoué. Essayez à nouveau."
      ],
      "A second factor authentication is required.": [
        "À utiliser lorsque l'authentification par deuxième facteur est activée"
      ],
      "Confirm wire transfer.": [
        "Effectuer un virement bancaire"
      ],
      "Input wire transfer detail": [
        "Détail du virement d'entrée"
      ],
      "Using a form": [
        "Utilisation d'un formulaire"
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        "Un URI spécial qui spécifie le montant à transférer et le compte de destination."
      ],
      "QR code": [
        "Code QR"
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        "Si votre appareil dispose d'une caméra, vous pouvez importer un URI-payto:// à partir d'un code QR."
      ],
      "Recipient": [
        "Destinataire"
      ],
      "ID of the recipient's account": [
        "Identifiant du compte du destinataire"
      ],
      "username": [
        "nom d'utilisateur"
      ],
      "IBAN of the recipient's account": [
        "IBAN du compte du destinataire"
      ],
      "Subject": [
        "Référence"
      ],
      "Some text to identify the transfer": [
        "Texte permettant d'identifier le transfert"
      ],
      "Amount to transfer": [
        "Montant à transférer"
      ],
      "Payto URI:": [
        "URI Payto :"
      ],
      "Uniform resource identifier of the target account": [
        "Identifiant de ressource uniforme (URI en anglais) du compte cible"
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://x-taler-bank/[serveur-de-la-banque]/[compte-destinataire]?message=[reference]&amount=[%1$s:X.Y]"
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://iban/[IBAN du destinataire]?message=[référence]&amount=[%1$s:X.Y]"
      ],
      "The maximum amount for a wire transfer is %1$s": [
        "Le montant maximum pour un virement bancaire est de %1$s"
      ],
      "Cost": [
        "Coût"
      ],
      "Send": [
        "Envoyer"
      ],
      "Only \"x-taler-bank\" target are supported": [
        "Seule la destination \"x-taler-bank\" est prise en charge"
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        "Seul cet hôte est autorisé. Utilisez \"%1$s\""
      ],
      "Account name is missing": [
        "Le nom du compte est manquant"
      ],
      "Only \"IBAN\" target are supported": [
        "\"IBAN\" est la seule destination supportée"
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        "Paramètre \"montant\" manquant pour spécifier le montant à transférer"
      ],
      "The \"amount\" parameter is not valid": [
        "Le paramètre \"montant\" n'est pas valide"
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        "Les paramètres \"message\" pour spécifier un texte de référence pour le transfert sont manquants"
      ],
      "The only currency allowed is \"%1$s\"": [
        "La seule devise autorisée est \"%1$s\""
      ],
      "You cannot transfer an amount of zero.": [
        "Vous ne pouvez pas transférer un montant égal à zéro."
      ],
      "The balance is not sufficient": [
        "Le solde n'est pas suffisant"
      ],
      "Please enter a longer subject": [
        "Veuillez saisir une référence plus longue"
      ],
      "Show withdrawal confirmation": [
        "Afficher la confirmation de retrait"
      ],
      "Withdraw without setting amount": [
        "Retirer sans fixer le montant"
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        "Afficher d'abord le portefeuille d'installation"
      ],
      "Currently, the bank is not accepting new registrations!": [
        "Actuellement, la banque n'accepte pas de nouvelles inscriptions !"
      ],
      "The name is missing": [
        "Nom manquant"
      ],
      "Missing username": [
        "Identifiant manquant"
      ],
      "Missing password": [
        "Mot de passe manquant"
      ],
      "The password should be longer than 8 letters": [
        "Le mot de passe doit comporter plus de 8 caractères"
      ],
      "The passwords do not match": [
        "Les mots de passe ne correspondent pas"
      ],
      "Server replied with invalid phone or email.": [
        "Le serveur a répondu avec un téléphone ou un e-mail invalide."
      ],
      "You are not authorised to create this account.": [
        "Vous n'êtes pas autorisé à créer ce compte."
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        "L'inscription est désactivée car la banque n'a plus de crédit bonus."
      ],
      "That username can't be used because is reserved.": [
        "Ce nom d'utilisateur ne peut pas être utilisé car il est réservé."
      ],
      "That username is already taken.": [
        "Désolé, ce nom d’utilisateur est déjà pris."
      ],
      "That account ID is already taken.": [
        "Désolé, cet identifiant de compte est déjà pris."
      ],
      "No information for the selected authentication channel.": [
        "Aucune information pour le canal d'authentification sélectionné."
      ],
      "Authentication channel is not supported.": [
        "Le canal d'authentification n'est pas pris en charge."
      ],
      "Only an administrator is allowed to set the debt limit.": [
        "Seul un administrateur est autorisé à fixer la limite d'endettement."
      ],
      "Only the administrator can change the conversion rate.": [
        "Seul l'administrateur peut modifier la limite minimale d'encaissement."
      ],
      "The conversion rate class doesn't exist.": [
        "Le taux de conversion a été appliqué de manière incorrecte"
      ],
      "Only admin can create accounts with second factor authentication.": [
        "Seul l'administrateur peut créer des comptes avec l'authentification à deuxième facteur."
      ],
      "The password is too short. Can't have less than 8 characters.": [
        "Le mot de passe doit comporter plus de 8 caractères"
      ],
      "The password is too long. Can't have more than 64 characters.": [
        "Le mot de passe doit comporter plus de 8 caractères"
      ],
      "Account registration": [
        "Nouveau compte"
      ],
      "Login username": [
        "Nom d'utilisateur pour le login"
      ],
      "Password": [
        "Mot de passe"
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        "Utilisez un mot de passe fort : 8 caractères minimum, n'utilisez aucune information publique vous concernant (noms, date de naissance, numéro de téléphone, etc.) et mélangez minuscules, majuscules, symboles et chiffres"
      ],
      "Repeat password": [
        "Répétez le mot de passe"
      ],
      "Full name": [
        "Nom complet"
      ],
      "Register": [
        "Inscription"
      ],
      "Create a random temporary user": [
        "Créer un utilisateur temporaire aléatoire"
      ],
      "You have no permission to this account.": [
        "Vous n'êtes pas autorisé à créer ce compte."
      ],
      "Wrong credentials for \"%1$s\"": [
        "Mauvaises informations d'identification pour \"%1$s\""
      ],
      "Account login.": [
        "Intitulé du compte"
      ],
      "Session expired": [
        "L'opération a expiré."
      ],
      "Username": [
        "Nom d'utilisateur"
      ],
      "Password of the account": [
        "Mot de passe du compte"
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        "Se connecter"
      ],
      "Transactions history": [
        "Historique des transactions"
      ],
      "No transactions yet.": [
        "Aucune transaction n'a encore été effectuée."
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        "Vous pouvez effectuer un virement ou un retrait sur votre portefeuille."
      ],
      "Date": [
        "Date"
      ],
      "Counterpart": [
        "Contrepartie"
      ],
      "sent": [
        "envoyé"
      ],
      "received": [
        "reçu"
      ],
      "Invalid value": [
        "Valeur non valide"
      ],
      "to": [
        "vers"
      ],
      "from": [
        "de"
      ],
      "First page": [
        "Première page"
      ],
      "Next": [
        "Suivante"
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        "Le retrait a été interrompu précédemment et ne peut être confirmé"
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        "L'opération de retrait ne peut pas être confirmée avant qu'un portefeuille n'accepte la transaction."
      ],
      "The operation ID is invalid.": [
        "L'identifiant de l'opération n'est pas valide."
      ],
      "The operation was not found.": [
        "L'opération est introuvable."
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        "Le montant du retrait de départ et le montant de la confirmation diffèrent."
      ],
      "The bank requires a bank account which has not been specified yet.": [
        "La banque exige un compte bancaire et il n'a pas encore été spécifié."
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        "Opération de retrait en attente"
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        "L'opération de réserve a été confirmée précédemment et ne peut plus être annulée"
      ],
      "Complete withdrawal.": [
        "Confirmer le retrait"
      ],
      "Confirm the withdrawal operation": [
        "Confirmer l'opération de retrait"
      ],
      "Wire transfer details": [
        "Détails du virement"
      ],
      "Payment Service Provider's account number": [
        "Numéro de compte du prestataire de services de paiement"
      ],
      "Payment Service Provider's name": [
        "Nom du prestataire de services de paiement"
      ],
      "Payment Service Provider's account bank hostname": [
        "Nom du serveur de la banque du compte du prestataire de services de paiement"
      ],
      "Payment Service Provider's account id": [
        "Identifiant du compte du prestataire de services de paiement"
      ],
      "Payment Service Provider's account address": [
        "Adresse du compte du prestataire de services de paiement"
      ],
      "No amount has yet been determined.": [
        "Aucun montant n'a encore été déterminé."
      ],
      "Transfer": [
        "Transfert"
      ],
      "Authentication required": [
        "Authentification obligatoire"
      ],
      "This operation was created with another username": [
        "Cette opération a été créée avec un autre nom d'utilisateur"
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        "L'opération de réserve a été confirmée précédemment et ne peut plus être annulée"
      ],
      "Wire transfer completed!": [
        "Virement bancaire terminé !"
      ],
      "Confirm withdrawal.": [
        "Confirmer le retrait"
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        "Non autorisé à effectuer l'opération, peut-être que la session a expiré ou que le mot de passe a été modifié."
      ],
      "The operation was rejected due to insufficient funds.": [
        "L'opération a été rejetée en raison de fonds insuffisants."
      ],
      "Withdrawal confirmed": [
        "Retrait confirmé"
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        "Le virement bancaire au profit du prestataire de services de paiement a été enclenché. Vous recevrez sous peu le montant demandé dans votre portefeuille Taler."
      ],
      "Do not show this again": [
        "Ne plus afficher à l'avenir"
      ],
      "If you have a Taler wallet installed on this device": [
        "Si vous avez un portefeuille Taler installé sur cet appareil"
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        "Votre portefeuille affichera les détails de la transaction, y compris les frais (le cas échéant). Si vous n'avez pas encore de portefeuille, veuillez suivre les instructions"
      ],
      "on this page": [
        "sur cette page"
      ],
      "Withdraw": [
        "Retirer"
      ],
      "In case you have a Taler wallet on another device": [
        "Si vous avez un portefeuille Taler sur un autre appareil"
      ],
      "Scan the QR below to start the withdrawal.": [
        "Scannez le code QR ci-dessous pour commencer le retrait."
      ],
      "There is an operation already pending": [
        "Une opération est déjà en attente"
      ],
      "Complete the operation in": [
        "Terminez l'opération dans"
      ],
      "this page": [
        "cette page"
      ],
      "The server replied with an invalid taler://withdraw URI": [
        "Le serveur a répondu avec un URI taler://withdraw invalide"
      ],
      "Withdraw URI: %1$s": [
        "URI de retrait : %1$s"
      ],
      "The operation was rejected due to insufficient funds": [
        "L'opération a été rejetée pour cause de fonds insuffisants"
      ],
      "Current balance is %1$s": [
        "Le solde actuel est de %1$s"
      ],
      "You can withdraw up to %1$s": [
        "Vous pouvez retirer jusqu'à %1$s"
      ],
      "Continue": [
        "Continuer"
      ],
      "Use your Taler wallet": [
        "Utilisez votre portefeuille Taler"
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        "Après avoir utilisé votre portefeuille, vous devrez autoriser ou annuler l'opération sur ce site."
      ],
      "You need a Taler wallet": [
        "Vous avez besoin d'un portefeuille Taler"
      ],
      "If you don't have one yet you can follow the instruction in": [
        "Si vous n'en avez pas encore, vous pouvez suivre les instructions dans"
      ],
      "Send money": [
        "Envoyer de l'argent"
      ],
      "to a Taler wallet": [
        "vers un portefeuille Taler"
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        "Retirez de l'argent numérique dans votre portefeuille mobile ou votre extension de navigateur"
      ],
      "to another bank account": [
        "sur un autre compte bancaire"
      ],
      "Make a wire transfer to an account with known bank account number.": [
        "Effectuez un virement bancaire sur un compte dont le numéro de compte bancaire est connu."
      ],
      "This is a demo": [
        "Ceci est une démo"
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        "Cette partie de la démo montre comment fonctionnerait une banque qui supporte directement Taler. Outre l'utilisation de votre propre compte bancaire, vous pouvez également consulter l'historique des transactions de certains %1$s ."
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        "Ici, vous pourrez voir comment une banque qui prend directement en charge Taler fonctionnerait."
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        "Erreur interne, veuillez signaler."
      ],
      "Preferences": [
        "Préférences"
      ],
      "Welcome": [
        "Bienvenue"
      ],
      "Welcome, %1$s": [
        "Bienvenue, %1$s"
      ],
      "No enough permission to access the conversion rate list.": [
        "Autorisation insuffisante pour terminer l'opération."
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        ""
      ],
      "Conversion rate classes": [
        "Taux de conversion"
      ],
      "Create conversion rate class": [
        "Taux de conversion"
      ],
      "No conversion rate class": [
        "Taux de conversion"
      ],
      "Name": [
        "Nom"
      ],
      "Description": [
        "Afficher la description de la démo"
      ],
      "Cashin": [
        ""
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        "Sélectionner une section"
      ],
      "Details": [
        "Détails"
      ],
      "Delete": [
        "Supprimer"
      ],
      "Credentials": [
        "Identifiants"
      ],
      "Cashouts": [
        "Retraits"
      ],
      "Conversion": [
        "Conversion"
      ],
      "only admin can setup conversion": [
        ""
      ],
      "Wrong credentials": [
        ""
      ],
      "Conversion is disabled": [
        ""
      ],
      "Config cashout": [
        ""
      ],
      "Config cashin": [
        ""
      ],
      "Bad ratios": [
        ""
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        ""
      ],
      "Initial amount": [
        ""
      ],
      "Use it to test how the conversion will affect the amount.": [
        ""
      ],
      "Sending to this bank": [
        ""
      ],
      "Converted": [
        ""
      ],
      "Cashin after fee": [
        ""
      ],
      "Sending from this bank": [
        ""
      ],
      "Cashout after fee": [
        ""
      ],
      "Bad configuration": [
        ""
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        ""
      ],
      "Update": [
        "Modification"
      ],
      "Rnvalid": [
        ""
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        ""
      ],
      "Only cashout operation above this threshold will be allowed.": [
        ""
      ],
      "Ratio": [
        ""
      ],
      "Conversion ratio between currencies": [
        ""
      ],
      "Example conversion": [
        ""
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        ""
      ],
      "Tiny amount": [
        "Compte de destination"
      ],
      "Rounding mode": [
        ""
      ],
      "Zero": [
        ""
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        ""
      ],
      "Up": [
        ""
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        ""
      ],
      "Nearest": [
        ""
      ],
      "Amount will be round to the closest possible value.": [
        ""
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        ""
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        ""
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        ""
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        ""
      ],
      "Amount to be deducted before amount is credited.": [
        ""
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        "Le retrait doit être activé dans la configuration, le taux de conversion doit être initialisé avec des frais, des taux et un mode d'arrondi."
      ],
      "Unauthorized": [
        "L'utilisateur n'est pas autorisé"
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        ""
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        ""
      ],
      "The name of the conversion is already used.": [
        "Une opération est déjà en attente"
      ],
      "Conversion rate class": [
        "Taux de conversion"
      ],
      "Accounts": [
        "Comptes"
      ],
      "Test": [
        ""
      ],
      "Users": [
        "Nom d'utilisateur"
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        ""
      ],
      "This step can't be undone.": [
        ""
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        "Compte"
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        "Actions"
      ],
      "Remove": [
        "Effacer"
      ],
      "Add": [
        "Adresse"
      ],
      "Conversion rate name": [
        "Taux de conversion"
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        "Taux de conversion"
      ],
      "The rights to change the account are not sufficient": [
        "Les droits de modification du compte ne sont pas suffisants"
      ],
      "New conversion rate class": [
        "Taux de conversion"
      ],
      "Create": [
        ""
      ],
      "History of public accounts": [
        "Historique de comptes publiques"
      ],
      "Make a wire transfer": [
        "Effectuer un virement bancaire"
      ],
      "Scan the QR code below to start the withdrawal.": [
        "Scannez le code QR ci-dessous pour commencer le retrait."
      ],
      "Operation aborted": [
        "Opération abandonnée"
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        "Le virement bancaire vers le compte du prestataire de services de paiement a été annulé depuis un autre endroit, votre solde n'a pas été affecté."
      ],
      "Go to your wallet now": [
        "Accédez à votre portefeuille maintenant"
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        "L'opération est marquée comme sélectionnée, mais un processus pendant le retrait a échoué"
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        "Aucun identifiant de réserve de retrait n'a été trouvé et aucun compte n'a été sélectionné."
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        "Il existe un identifiant de réserve de retrait, mais aucun compte n'a été sélectionné ou le compte sélectionné n'est pas valide."
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        "Le compte a été sélectionné, mais aucun identifiant de réserve de retrait n'a été trouvé."
      ],
      "Operation not found": [
        "Opération non trouvée"
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        "Ce processus n'est pas connu du serveur. L'identifiant du processus est incorrect ou le serveur a supprimé les informations sur le processus avant leur arrivée ici."
      ],
      "Continue to dashboard": [
        "Continuer vers le tableau de bord"
      ],
      "The Withdrawal URI is not valid": [
        "L'URI de retrait n'est pas valide"
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        "L'encaissement doit être activé dans la configuration, le taux de conversion doit être initialisé avec des frais, des taux et un mode d'arrondi."
      ],
      "Latest cashouts": [
        "Derniers encaissements"
      ],
      "Created": [
        "Créée"
      ],
      "Total debit": [
        "Débit total"
      ],
      "Total credit": [
        "Crédit total"
      ],
      "Cashout for account %1$s": [
        "Encaissement pour le compte %1$s"
      ],
      "Doesn't have the pattern of an email": [
        "N'a pas la forme d'une adresse mail"
      ],
      "Should start with +": [
        "Doit commencer par +"
      ],
      "A phone number consists of numbers only": [
        "Un numéro de téléphone se compose uniquement de chiffres"
      ],
      "Account ID for authentication": [
        "Identifiant de compte pour l'authentification"
      ],
      "Name of the account holder": [
        "Nom du titulaire du compte"
      ],
      "Internal account": [
        "Compte interne"
      ],
      "If this field is empty, a random account ID will be assigned": [
        "Si ce champ est vide, un identifiant de compte aléatoire sera attribué"
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        "Vous pouvez copier et partager ce numéro IBAN afin de recevoir des virements vers votre compte bancaire"
      ],
      "Email": [
        "Adresse mail"
      ],
      "To be used when second factor authentication is enabled": [
        "À utiliser lorsque l'authentification par deuxième facteur est activée"
      ],
      "Phone": [
        "Téléphone"
      ],
      "Enable second factor authentication": [
        "À utiliser lorsque l'authentification par deuxième facteur est activée"
      ],
      "Using email": [
        "Vers l'email"
      ],
      "Add an email in your profile to enable this option": [
        ""
      ],
      "Using SMS": [
        ""
      ],
      "Add a phone number in your profile to enable this option": [
        ""
      ],
      "Cashout account": [
        "Compte d'encaissement"
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        "Numéro de compte externe où l'argent va être envoyé lors des encaissements"
      ],
      "Max debt": [
        "Créance maximale"
      ],
      "How much the balance can go below zero.": [
        "De combien le solde peut-il descendre en dessous de zéro."
      ],
      "Is this account public?": [
        "Ce compte est-il public ?"
      ],
      "Public accounts have their balance publicly accessible": [
        "Le solde des comptes publics est accessible à tous"
      ],
      "Does this account belong to a Payment Service Provider?": [
        "Ce compte appartient-il à un prestataire de services de paiement ?"
      ],
      "Account updated": [
        "Compte mis à jour"
      ],
      "The username was not found": [
        "Le nom d'utilisateur n'a pas été trouvé"
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        "Vous ne pouvez pas modifier le nom légal, veuillez contacter l'administrateur de votre compte."
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        "Vous ne pouvez pas modifier la limite d'endettement, veuillez contacter l'administrateur de votre compte."
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        "Vous ne pouvez pas modifier l'adresse d'encaissement, veuillez contacter l'administrateur de votre compte."
      ],
      "Update account information.": [
        "Mise à jour des paramètres du compte"
      ],
      "Account \"%1$s\"": [
        "Compte \"%1$s\""
      ],
      "Removed": [
        "Supprimé"
      ],
      "This account can't be used.": [
        "Ce compte ne peut pas être utilisé."
      ],
      "Change details": [
        "Modifier les détails"
      ],
      "Merchant integration": [
        "Intégration des commerçants"
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        "Utilisez ces informations pour relier votre compte Taler Merchant Backoffice au compte bancaire actuel. Vous pouvez commencer par copier les valeurs, puis vous rendre chez votre fournisseur de services de backoffice marchand, vous connecter à votre compte et chercher le bouton \"importer\" dans la section \"compte bancaire\"."
      ],
      "Account type": [
        "Type de compte"
      ],
      "Method to use for wire transfer.": [
        "Méthode à utiliser pour un virement bancaire."
      ],
      "IBAN": [
        "IBAN"
      ],
      "International Bank Account Number.": [
        "Numéro de compte bancaire international (IBAN)."
      ],
      "Account name": [
        "Intitulé du compte"
      ],
      "Bank host where the service is located.": [
        "Serveur de la banque où se trouve le service."
      ],
      "Bank account identifier for wire transfers.": [
        "Identifiant du compte bancaire pour les virements."
      ],
      "Address": [
        "Adresse"
      ],
      "Owner's name": [
        "Nom du propriétaire"
      ],
      "Legal name of the person holding the account.": [
        "Nom légal de la personne titulaire du compte."
      ],
      "Account info URL": [
        "URL d'information de compte"
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        "Endroit d'où le commerçant peut télécharger des informations sur les virements entrants sur ce compte."
      ],
      "Repeated password doesn't match": [
        "Le mot de passe répété ne correspond pas"
      ],
      "Password changed": [
        "Mot de passe modifié"
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        "Pas autorisé à changer le mot de passe, peut-être que la session n'est pas valide."
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        "Vous devez fournir l'ancien mot de passe. Si vous ne l'avez pas, veuillez contacter l'administrateur."
      ],
      "Your current password doesn't match, can't change to a new password.": [
        "Votre mot de passe actuel ne correspond pas, vous ne pouvez pas changer de mot de passe."
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        "Modifier le mot de passe"
      ],
      "Update password": [
        "Modifier le mot de passe"
      ],
      "Current password": [
        "Mot de passe actuel"
      ],
      "Your current password, for security": [
        "Votre mot de passe actuel, par sécurité"
      ],
      "New password": [
        "Nouveau mot de passe"
      ],
      "Type it again": [
        "Saisissez-le à nouveau"
      ],
      "Repeat the same password": [
        "Confirmez le mot de passe"
      ],
      "Change": [
        "Modifier"
      ],
      "Create account": [
        "Créer un compte"
      ],
      "Actions": [
        "Actions"
      ],
      "Unknown": [
        "Inconnu"
      ],
      "Change password": [
        "Changer le mot de passe"
      ],
      "Querying for the current stats failed": [
        "Échec de la requête pour les statistiques actuelles"
      ],
      "The request parameters are wrong": [
        "Les paramètres de la requête sont erronés"
      ],
      "The user is unauthorized": [
        "L'utilisateur n'est pas autorisé"
      ],
      "Querying for the previous stats failed": [
        ""
      ],
      "Transaction volume report": [
        ""
      ],
      "Last hour": [
        ""
      ],
      "Previous day": [
        ""
      ],
      "Last month": [
        ""
      ],
      "Last year": [
        ""
      ],
      "Last Year": [
        ""
      ],
      "Trading volume from %1$s to %2$s": [
        ""
      ],
      "Transferred from an external account to an account in this bank.": [
        ""
      ],
      "Transferred from an account in this bank to an external account.": [
        ""
      ],
      "Payin": [
        ""
      ],
      "Transferred from an account to a Taler exchange.": [
        ""
      ],
      "Payout": [
        ""
      ],
      "Transferred from a Taler exchange to another account.": [
        ""
      ],
      "Download stats as CSV": [
        ""
      ],
      "previous": [
        ""
      ],
      "Decreased by": [
        ""
      ],
      "Increased by": [
        ""
      ],
      "Account created with password \"%1$s\".": [
        ""
      ],
      "Server replied that phone or email is invalid": [
        ""
      ],
      "The rights to perform the operation are not sufficient": [
        ""
      ],
      "Account username is already taken": [
        ""
      ],
      "Account ID is already taken": [
        "Désolé, cet identifiant de compte est déjà pris."
      ],
      "Bank ran out of bonus credit.": [
        ""
      ],
      "Account username can't be used because is reserved": [
        ""
      ],
      "Can't create accounts": [
        ""
      ],
      "Only system admin can create accounts.": [
        ""
      ],
      "New bank account": [
        ""
      ],
      "only admin can download stats": [
        ""
      ],
      "Download bank stats": [
        ""
      ],
      "Include hour metric": [
        ""
      ],
      "Include day metric": [
        ""
      ],
      "Include month metric": [
        ""
      ],
      "Include year metric": [
        ""
      ],
      "Include table header": [
        ""
      ],
      "Add previous metric for compare": [
        ""
      ],
      "Fail on first error": [
        ""
      ],
      "Download": [
        ""
      ],
      "downloading... %1$s": [
        ""
      ],
      "Download completed": [
        ""
      ],
      "Click here to save the file in your computer.": [
        ""
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        ""
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        ""
      ],
      "Name doesn't match": [
        ""
      ],
      "Account removed": [
        ""
      ],
      "No enough permission to delete the account.": [
        ""
      ],
      "The username was not found.": [
        ""
      ],
      "Can't delete a reserved username.": [
        ""
      ],
      "Can't delete an account with balance different than zero.": [
        ""
      ],
      "Remove account.": [
        "Suppression du compte"
      ],
      "You are going to remove the account": [
        ""
      ],
      "Deleting account \"%1$s\"": [
        ""
      ],
      "Verification": [
        ""
      ],
      "Enter the account name that is going to be deleted": [
        ""
      ],
      "Cashout id should be a number": [
        ""
      ],
      "This cashout not found. Maybe already aborted.": [
        ""
      ],
      "Cashout detail": [
        ""
      ],
      "Debited": [
        ""
      ],
      "Transferred": [
        "Transfert"
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        ""
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=2; plural=n > 1;",
  "lang": "fr",
  "completeness": 67
};

strings['es'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=2; plural=n != 1;",
        "lang": "es"
      },
      "Operation failed, please report": [
        "La operaicón falló, por favor reportelo"
      ],
      "Request timeout": [
        "La petición al servidor agoto su tiempo"
      ],
      "Request throttled": [
        "La petición al servidor interrumpida"
      ],
      "Malformed response": [
        "Respuesta malformada"
      ],
      "Network error": [
        "Error de conexión"
      ],
      "Unexpected request error": [
        "Error de pedido inesperado"
      ],
      "Unexpected error": [
        "Error inesperado"
      ],
      "An IBAN consists of capital letters and numbers only": [
        "IBAN debería tener letras mayúsculas y números"
      ],
      "IBAN numbers have more that 4 digits": [
        "Los números IBAN usualmente tienen mas de 4 digitos"
      ],
      "IBAN numbers have less that 34 digits": [
        "Los números IBAN usualmente tienen menos de 34 digitos"
      ],
      "IBAN country code not found": [
        "Código de pais de IBAN no encontrado"
      ],
      "IBAN number is not valid, checksum is wrong": [
        "El número IBAN no es válido, falló la verificación"
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        ""
      ],
      "Required": [
        "requerido"
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        "Autenticación requerida"
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        "nombre de usuario de la cuenta"
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        "La operación falló."
      ],
      "Multi-factor authentication required": [
        "Autenticación requerida"
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        ""
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        "Sin permisos suficientes para completar la operación."
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        "Cancelar"
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        "Imposible crear un egreso"
      ],
      "The bank configuration does not support cashout operations.": [
        "La configuración del banco no soporta operaciones de egreso."
      ],
      "Close": [
        "Cerrar"
      ],
      "Cashout is disabled": [
        "Egreso creado"
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "The server didn't understand the request.": [
        "Este servidor no tiene soporte para segundo factor de autenticación."
      ],
      "The amount is too small": [
        "La contraseña es demasiado larga."
      ],
      "Conversion is not implemented.": [
        "Egreso no soportado"
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        "El identificador de cuenta ya está tomado."
      ],
      "The currency is not supported": [
        "Operación de egreso no soportada."
      ],
      "Invalid": [
        "inválido"
      ],
      "Amount needs to be higher": [
        "necesita ser mayor debido a las comisiones"
      ],
      "Balance is not enough": [
        "el saldo no es suficiente"
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        ""
      ],
      "The total transfer to the destination will be zero": [
        "el total de la transferencia en destino será cero"
      ],
      "Cashout created": [
        "Egreso creado"
      ],
      "Second factor authentication required.": [
        "Autenticación requerida"
      ],
      "Account not found": [
        "Cuenta no encontrada"
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        "Se detectó una petición duplicada, verifique si la operación tuvo éxito o intente otra vez."
      ],
      "The conversion rate was applied incorrectly": [
        "La tasa de conversión se aplicó incorrectamente"
      ],
      "The account does not have sufficient funds": [
        "La cuenta no tiene fondos suficientes"
      ],
      "Missing cashout URI in the profile": [
        "Falta dirección de egreso en el perfíl"
      ],
      "The amount is below the minimum amount permitted.": [
        ""
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        "El envío del mensaje de confirmación falló, intente mas tarde o contacte al administrador."
      ],
      "The server doesn't support the current TAN channel.": [
        "Este servidor no tiene soporte para segundo factor de autenticación."
      ],
      "Create cashout.": [
        "Crear cuenta"
      ],
      "Cashout": [
        "Egreso"
      ],
      "Conversion rate": [
        "Tasa de conversión"
      ],
      "Balance": [
        "Saldo"
      ],
      "Fee": [
        "Comisión"
      ],
      "To account": [
        "Hacia cuenta"
      ],
      "Legal name": [
        ""
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        ""
      ],
      "Unable to cashout": [
        "Imposible crear un egreso"
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        "Antes de hacer un egreso necesita completar su perfíl"
      ],
      "Transfer subject": [
        "Asunto de transferencia"
      ],
      "Currency": [
        ""
      ],
      "Send %1$s": [
        "Envíar %1$s"
      ],
      "Receive %1$s": [
        "Recibir %1$s"
      ],
      "Amount": [
        "Monto"
      ],
      "Total cost": [
        "Costo total"
      ],
      "Balance left": [
        "Saldo remanente"
      ],
      "Before fee": [
        "Antes de comisión"
      ],
      "Total cashout transfer": [
        "Total de egreso"
      ],
      "Not valid": [
        "no válido"
      ],
      "Does not follow the pattern": [
        "no tiene un patrón valido"
      ],
      "The wire transfer was successfully completed!": [
        "Transferencia bancaria completada!"
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        "El pedido era inválido o el URI payto:// usado tiene características inaceptables."
      ],
      "Not enough permission to complete the operation.": [
        "Sin permisos suficientes para completar la operación."
      ],
      "The bank administrator cannot be the transfer creditor.": [
        ""
      ],
      "The destination account \"%1$s\" was not found.": [
        "La cuenta de destino \"%1$s\" no fue encontrada."
      ],
      "The origin and the destination of the transfer can't be the same.": [
        "El origen y destino de la transferencia no puede ser la misma."
      ],
      "Your balance is not sufficient for the operation.": [
        "El saldo no es suficiente para la operación."
      ],
      "The origin account \"%1$s\" was not found.": [
        "La cuenta origen \"%1$s\" no fue encontrada."
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        ""
      ],
      "A second factor authentication is required.": [
        "Hábilitar segundo factor de autenticación"
      ],
      "Confirm wire transfer.": [
        "Transferencia bancaria"
      ],
      "Input wire transfer detail": [
        "Detalle de transferencia bancaria"
      ],
      "Using a form": [
        "Usando un formulario"
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        ""
      ],
      "QR code": [
        "Enviar código"
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        ""
      ],
      "Recipient": [
        "Destinatario"
      ],
      "ID of the recipient's account": [
        "Numero IBAN de la cuenta destinataria"
      ],
      "username": [
        "Nombre de usuario"
      ],
      "IBAN of the recipient's account": [
        "Numero IBAN de la cuenta destinataria"
      ],
      "Subject": [
        "Asunto"
      ],
      "Some text to identify the transfer": [
        "algún texto para identificar la transferencia"
      ],
      "Amount to transfer": [
        "monto a transferir"
      ],
      "Payto URI:": [
        "payto URI:"
      ],
      "Uniform resource identifier of the target account": [
        "identificador de recurso uniforme de la cuenta destino"
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://x-taler-bank/[operador bancario]/[cuenta bancaria del destinatario]?message=[asunto]&amount=[%1$s:X.Y]"
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://iban/[IBAN del destinatario]?message=[asunto]&amount=[%1$s:X.Y]"
      ],
      "The maximum amount for a wire transfer is %1$s": [
        ""
      ],
      "Cost": [
        ""
      ],
      "Send": [
        "Envíar"
      ],
      "Only \"x-taler-bank\" target are supported": [
        "solo cuentas \"IBAN\" son soportadas"
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        ""
      ],
      "Account name is missing": [
        "Actualización de cuenta"
      ],
      "Only \"IBAN\" target are supported": [
        "solo cuentas \"IBAN\" son soportadas"
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        "usa el parámetro \"amount\" para indicar el monto a ser transferido"
      ],
      "The \"amount\" parameter is not valid": [
        "el monto no es válido"
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        "usa el parámetro \"message\" para indicar un texto de referencia en la transferencia"
      ],
      "The only currency allowed is \"%1$s\"": [
        ""
      ],
      "You cannot transfer an amount of zero.": [
        "No se puede transferir una cantidad de cero."
      ],
      "The balance is not sufficient": [
        "La cuenta no tiene fondos suficientes"
      ],
      "Please enter a longer subject": [
        "Asunto de transferencia"
      ],
      "Show withdrawal confirmation": [
        "Mostrar confirmación de extracción"
      ],
      "Withdraw without setting amount": [
        ""
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        "Mostrar instalar la billetera primero"
      ],
      "Currently, the bank is not accepting new registrations!": [
        "Actualmente, el banco no está aceptado nuevos registros!"
      ],
      "The name is missing": [
        ""
      ],
      "Missing username": [
        "Falta nombre de usuario"
      ],
      "Missing password": [
        "Falta contraseña"
      ],
      "The password should be longer than 8 letters": [
        "Debería ser mas grande que 0"
      ],
      "The passwords do not match": [
        "La contraseña no coincide"
      ],
      "Server replied with invalid phone or email.": [
        "El servidor repondio con teléfono o dirección de correo inválido."
      ],
      "You are not authorised to create this account.": [
        "Sin permisos suficientes para crear esa cuenta."
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        "El registro está deshabilitado porque el banco se quedó sin crédito bonus."
      ],
      "That username can't be used because is reserved.": [
        "El nombre de usuario no puede ser usado porque esta reservado."
      ],
      "That username is already taken.": [
        "El nombre de usuario ya está tomado."
      ],
      "That account ID is already taken.": [
        "El identificador de cuenta ya está tomado."
      ],
      "No information for the selected authentication channel.": [
        "No hay información para el canal de autenticación seleccionado."
      ],
      "Authentication channel is not supported.": [
        "Canal de autenticación no esta soportado."
      ],
      "Only an administrator is allowed to set the debt limit.": [
        "Solo el administrador tiene permitido cambiar el límite de deuda."
      ],
      "Only the administrator can change the conversion rate.": [
        "Solo los administradores del sistema pueden crear cuentas."
      ],
      "The conversion rate class doesn't exist.": [
        "La tasa de conversión se aplicó incorrectamente"
      ],
      "Only admin can create accounts with second factor authentication.": [
        "Solo el administrador puede crear cuentas con el segundo factor de autenticación."
      ],
      "The password is too short. Can't have less than 8 characters.": [
        "Debería ser mas grande que 0"
      ],
      "The password is too long. Can't have more than 64 characters.": [
        "Debería ser mas grande que 0"
      ],
      "Account registration": [
        "Registro de cuenta"
      ],
      "Login username": [
        "Nombre de usuario"
      ],
      "Password": [
        "Contrasena"
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        ""
      ],
      "Repeat password": [
        "Repita la contraseña"
      ],
      "Full name": [
        ""
      ],
      "Register": [
        "Registrarse"
      ],
      "Create a random temporary user": [
        "Crear un usuario aleatorio temporal"
      ],
      "You have no permission to this account.": [
        "No tiene permisos suficientes para eliminar la cuenta."
      ],
      "Wrong credentials for \"%1$s\"": [
        "Credenciales incorrectas para \"%1$s\""
      ],
      "Account login.": [
        "Actualización de cuenta"
      ],
      "Session expired": [
        "La operación expiró."
      ],
      "Username": [
        "Usuario"
      ],
      "Password of the account": [
        "contraseña de la cuenta"
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        "Acceso"
      ],
      "Transactions history": [
        ""
      ],
      "No transactions yet.": [
        "Aún no hay transacciones."
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        ""
      ],
      "Date": [
        "Fecha"
      ],
      "Counterpart": [
        "Contra cuenta"
      ],
      "sent": [
        "enviado"
      ],
      "received": [
        "recibido"
      ],
      "Invalid value": [
        "valor inválido"
      ],
      "to": [
        "hacia"
      ],
      "from": [
        "desde"
      ],
      "First page": [
        "Primera página"
      ],
      "Next": [
        "Siguiente"
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        "La extracción fue abortada anteriormente y no puede ser confirmada"
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        "La operación de extracción no puede ser confirmada antes de que una billetera acepte la transaccion."
      ],
      "The operation ID is invalid.": [
        "El id de operación es invalido."
      ],
      "The operation was not found.": [
        "La operación no se encontró."
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        ""
      ],
      "The bank requires a bank account which has not been specified yet.": [
        ""
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        "Operación pendiente de extracción"
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        "La operación en la reserva ya ha sido confirmada previamente y no puede ser abortada"
      ],
      "Complete withdrawal.": [
        "Confirme la operación de extracción"
      ],
      "Confirm the withdrawal operation": [
        "Confirme la operación de extracción"
      ],
      "Wire transfer details": [
        "Detalle de transferencia bancaria"
      ],
      "Payment Service Provider's account number": [
        "Cuenta del operador del Taler Exchange"
      ],
      "Payment Service Provider's name": [
        "Cuenta del operador del Taler Exchange"
      ],
      "Payment Service Provider's account bank hostname": [
        "Cuenta del operador del Taler Exchange"
      ],
      "Payment Service Provider's account id": [
        "Cuenta del operador del Taler Exchange"
      ],
      "Payment Service Provider's account address": [
        "Cuenta del operador del Taler Exchange"
      ],
      "No amount has yet been determined.": [
        ""
      ],
      "Transfer": [
        "Transferencia"
      ],
      "Authentication required": [
        "Autenticación requerida"
      ],
      "This operation was created with another username": [
        "Esta operación fue creada con otro usuario"
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        "La operación en la reserva ya ha sido confirmada previamente y no puede ser abortada"
      ],
      "Wire transfer completed!": [
        "Transferencia bancaria completada!"
      ],
      "Confirm withdrawal.": [
        "Confirme la operación de extracción"
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        "No autorizado para hacer la operación, quizá la sesión haya expirado or cambió la contraseña."
      ],
      "The operation was rejected due to insufficient funds.": [
        "La operación fue rechazada debido a saldo insuficiente."
      ],
      "Withdrawal confirmed": [
        "La extracción fue confirmada"
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        "La transferencia bancaria al operador Taler fue iniciada. Pronto recibirás el monto pedido en tu billetera Taler."
      ],
      "Do not show this again": [
        "No mostrar otra vez"
      ],
      "If you have a Taler wallet installed on this device": [
        "Si tienes una billetera Taler instalada en este dispositivo"
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        "Veras los detalles de la operación en tu billetera incluyendo comisiones (si aplicán). Si todavía no tienes una puedes instalarla siguiendo las instrucciones en"
      ],
      "on this page": [
        "esta página"
      ],
      "Withdraw": [
        "Retirar"
      ],
      "In case you have a Taler wallet on another device": [
        "O si tienes la billetera en otro dispositivo"
      ],
      "Scan the QR below to start the withdrawal.": [
        "Escanea el QR debajo para comenzar la extracción."
      ],
      "There is an operation already pending": [
        "Ya hay una operación"
      ],
      "Complete the operation in": [
        "Completa o cancela la operación en"
      ],
      "this page": [
        "esta página"
      ],
      "The server replied with an invalid taler://withdraw URI": [
        "El servidor respondió con una URI de extracción inválida"
      ],
      "Withdraw URI: %1$s": [
        "URI de extracción: %1$s"
      ],
      "The operation was rejected due to insufficient funds": [
        "La operación fue rechazada debido a fundos insuficientes"
      ],
      "Current balance is %1$s": [
        ""
      ],
      "You can withdraw up to %1$s": [
        ""
      ],
      "Continue": [
        "Continuar"
      ],
      "Use your Taler wallet": [
        "Utiliza tu cartera Taler"
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        "Despues de usar tu billetera necesitarás confirmar o cancelar la operación en este sitio."
      ],
      "You need a Taler wallet": [
        "Necesitas una GNU Taler Wallet"
      ],
      "If you don't have one yet you can follow the instruction in": [
        "Si no tienes una todavía puedes seguir las instrucciones en"
      ],
      "Send money": [
        "Enviar dinero"
      ],
      "to a Taler wallet": [
        "a una cartera Taler"
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        "Extraer dinero digital a tu billetera móvil o extensión web"
      ],
      "to another bank account": [
        "a otra cuenta bancaria"
      ],
      "Make a wire transfer to an account with known bank account number.": [
        "Hacer una transferencia bancaria a una cuenta con un número de cuenta conocido."
      ],
      "This is a demo": [
        "Este es un banco de demostración"
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        "Esta parte de la demostración muestra cómo funciona un banco que soporta Taler directamente. Además de usar tu propia cuenta de banco, también podrás ver el historial de transacciones de algunas %1$s."
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        "Esta parte de la demostración muetra como un banco que soporta Taler directamente funcionaría."
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        "Error interno, por favor reporte."
      ],
      "Preferences": [
        "Preferencias"
      ],
      "Welcome": [
        "Bienvenido/a"
      ],
      "Welcome, %1$s": [
        "Bienvenido/a, %1$s"
      ],
      "No enough permission to access the conversion rate list.": [
        "Sin permisos suficientes para completar la operación."
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        "Egreso no soportado"
      ],
      "Conversion rate classes": [
        "Tasa de conversión"
      ],
      "Create conversion rate class": [
        "Tasa de conversión"
      ],
      "No conversion rate class": [
        "Tasa de conversión"
      ],
      "Name": [
        "Nombre"
      ],
      "Description": [
        "Mostrar descripción de demo"
      ],
      "Cashin": [
        "Ingreso"
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        "Seleccione una sección"
      ],
      "Details": [
        "Detalles"
      ],
      "Delete": [
        "Borrar"
      ],
      "Credentials": [
        "Credenciales"
      ],
      "Cashouts": [
        "Egresos"
      ],
      "Conversion": [
        "Tasa de conversión"
      ],
      "only admin can setup conversion": [
        "Solo los administradores del sistema pueden crear cuentas."
      ],
      "Wrong credentials": [
        "Credenciales incorrectas para \"%1$s\""
      ],
      "Conversion is disabled": [
        "Tasa de conversión"
      ],
      "Config cashout": [
        "Egreso"
      ],
      "Config cashin": [
        "Ingreso"
      ],
      "Bad ratios": [
        ""
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        ""
      ],
      "Initial amount": [
        "Monto máximo de extracción"
      ],
      "Use it to test how the conversion will affect the amount.": [
        ""
      ],
      "Sending to this bank": [
        ""
      ],
      "Converted": [
        "Tasa de conversión"
      ],
      "Cashin after fee": [
        ""
      ],
      "Sending from this bank": [
        ""
      ],
      "Cashout after fee": [
        "Egreso creado"
      ],
      "Bad configuration": [
        ""
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        ""
      ],
      "Update": [
        "Actualizar"
      ],
      "Rnvalid": [
        "inválido"
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        ""
      ],
      "Only cashout operation above this threshold will be allowed.": [
        "La operación de egreso ya está abortada."
      ],
      "Ratio": [
        ""
      ],
      "Conversion ratio between currencies": [
        "Tasa de conversión"
      ],
      "Example conversion": [
        ""
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        ""
      ],
      "Tiny amount": [
        "Hacia cuenta"
      ],
      "Rounding mode": [
        ""
      ],
      "Zero": [
        ""
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        ""
      ],
      "Up": [
        ""
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        ""
      ],
      "Nearest": [
        ""
      ],
      "Amount will be round to the closest possible value.": [
        ""
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        ""
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        ""
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        ""
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        ""
      ],
      "Amount to be deducted before amount is credited.": [
        ""
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "Unauthorized": [
        "El nombre de usaurio no se encontró"
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        "Egreso no soportado"
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        "Egreso no soportado"
      ],
      "The name of the conversion is already used.": [
        "Ya hay una operación"
      ],
      "Conversion rate class": [
        "Tasa de conversión"
      ],
      "Accounts": [
        "Cuentas"
      ],
      "Test": [
        ""
      ],
      "Users": [
        "Usuario"
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        "Está por eliminar la cuenta"
      ],
      "This step can't be undone.": [
        "Este paso no puede ser deshecho."
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        "Cuenta"
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        "Acciones"
      ],
      "Remove": [
        "elimiar"
      ],
      "Add": [
        "direccion payto"
      ],
      "Conversion rate name": [
        "Tasa de conversión"
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        "Tasa de conversión"
      ],
      "The rights to change the account are not sufficient": [
        "Los permisos para cambiar la cuenta no son suficientes"
      ],
      "New conversion rate class": [
        "Tasa de conversión"
      ],
      "Create": [
        "Crear"
      ],
      "History of public accounts": [
        "Historial de cuentas públicas"
      ],
      "Make a wire transfer": [
        "Hacer una transferencia bancaria"
      ],
      "Scan the QR code below to start the withdrawal.": [
        "Escanea el QR debajo para comenzar la extracción."
      ],
      "Operation aborted": [
        "Operación abortada"
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        "La transferencia bancaria a la cuenta del operador del Taler Exchange fue abortada, su saldo no fue afectado."
      ],
      "Go to your wallet now": [
        "Accede a tu cartera ahora"
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        "La operación está marcada como 'seleccionada' pero algunos pasos en la extracción fallaron"
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        "No hay un identificador de extracción y ninguna cuenta a sido seleccionada o la seleccionada es inválida."
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        "Hay un identificador de extracción pero la cuenta no ha sido seleccionada o la selccionada es inválida."
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        "La cuenta está seleccionada pero no se encontró el identificador de extracción."
      ],
      "Operation not found": [
        "Operación no encontrada"
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        "Esta operación no es conocida por el servidor. El identificador de operación es incorrecto o el server borró la información de la operación antes de llegar hasta aquí."
      ],
      "Continue to dashboard": [
        "Continuar al panel"
      ],
      "The Withdrawal URI is not valid": [
        "El URI de estracción no es válido"
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        ""
      ],
      "Latest cashouts": [
        "Últimos egresos"
      ],
      "Created": [
        "Creado"
      ],
      "Total debit": [
        "Débito total"
      ],
      "Total credit": [
        "Crédito total"
      ],
      "Cashout for account %1$s": [
        "Egreso para cuenta %1$s"
      ],
      "Doesn't have the pattern of an email": [
        "no tiene el patrón de un correo electrónico"
      ],
      "Should start with +": [
        "debería comenzar con un +"
      ],
      "A phone number consists of numbers only": [
        "número de teléfono no puede tener otra cosa que numeros"
      ],
      "Account ID for authentication": [
        "Segundo factor de autenticación"
      ],
      "Name of the account holder": [
        "nombre de usuario de la cuenta"
      ],
      "Internal account": [
        "a otra cuenta bancaria"
      ],
      "If this field is empty, a random account ID will be assigned": [
        "si está vacío un número de cuenta aleatorio será asignado"
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        ""
      ],
      "Email": [
        "Correo eletrónico"
      ],
      "To be used when second factor authentication is enabled": [
        "Hábilitar segundo factor de autenticación"
      ],
      "Phone": [
        "Teléfono"
      ],
      "Enable second factor authentication": [
        "Hábilitar segundo factor de autenticación"
      ],
      "Using email": [
        "Usando correo eletrónico"
      ],
      "Add an email in your profile to enable this option": [
        "agrege un correo en su perfíl para habilitar esta opción"
      ],
      "Using SMS": [
        "Usando SMS"
      ],
      "Add a phone number in your profile to enable this option": [
        "agregue un número de teléfono para habilitar esta opción"
      ],
      "Cashout account": [
        "No hay cuenta de egreso"
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        "numero de cuenta donde el dinero será enviado cuando se ejecuten egresos"
      ],
      "Max debt": [
        "Máxima deuda"
      ],
      "How much the balance can go below zero.": [
        ""
      ],
      "Is this account public?": [
        "Es una cuenta pública?"
      ],
      "Public accounts have their balance publicly accessible": [
        "las cuentas públicas tienen su saldo accesible al público"
      ],
      "Does this account belong to a Payment Service Provider?": [
        "Es una cuenta pública?"
      ],
      "Account updated": [
        "Cuenta actualizada"
      ],
      "The username was not found": [
        "El nombre de usaurio no se encontró"
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        "No puede cambiar el nombre legal, por favor contacte el administrador de la cuenta."
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        "No puede cambiar el límite de deuda, por favor contacte el administrador de la cuenta."
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        "No puede cambiar la dirección de egreso, por favor contacte al administrador de la cuenta."
      ],
      "Update account information.": [
        "Operación pendiente de eliminación de cuenta"
      ],
      "Account \"%1$s\"": [
        "Cuenta \"%1$s\""
      ],
      "Removed": [
        "elimiar"
      ],
      "This account can't be used.": [
        "Este paso no puede ser deshecho."
      ],
      "Change details": [
        "Cambiar detalles"
      ],
      "Merchant integration": [
        "Registro de cuenta"
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        ""
      ],
      "Account type": [
        "Eliminación de cuenta"
      ],
      "Method to use for wire transfer.": [
        "Hacer una transferencia bancaria"
      ],
      "IBAN": [
        ""
      ],
      "International Bank Account Number.": [
        ""
      ],
      "Account name": [
        "Actualización de cuenta"
      ],
      "Bank host where the service is located.": [
        ""
      ],
      "Bank account identifier for wire transfers.": [
        "identificador de cuenta para transferencia bancaria"
      ],
      "Address": [
        "direccion payto"
      ],
      "Owner's name": [
        "Nombre de usuario"
      ],
      "Legal name of the person holding the account.": [
        "nombre de la persona dueña de la cuenta"
      ],
      "Account info URL": [
        "Cuenta no encontrada"
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        ""
      ],
      "Repeated password doesn't match": [
        "la contraseña no coincide"
      ],
      "Password changed": [
        "La contraseña cambió"
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        "No está autorizado a cambiar el password, quizá la sesión es invalida."
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        "Se necesita el password viejo para cambiar la contraseña. Si no lo tiene contacte a su administrador."
      ],
      "Your current password doesn't match, can't change to a new password.": [
        "Su actual contraseña no coincide, no puede cambiar a una nueva contraseña."
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        "Actualizar contraseña"
      ],
      "Update password": [
        "Actualizar contraseña"
      ],
      "Current password": [
        "Contraseña actual"
      ],
      "Your current password, for security": [
        "su actual contraseña, por seguridad"
      ],
      "New password": [
        "Nueva contraseña"
      ],
      "Type it again": [
        "Escribalo otra vez"
      ],
      "Repeat the same password": [
        "repita la misma contraseña"
      ],
      "Change": [
        "Cambiar"
      ],
      "Create account": [
        "Crear cuenta"
      ],
      "Actions": [
        "Acciones"
      ],
      "Unknown": [
        "desconocido"
      ],
      "Change password": [
        "cambiar contraseña"
      ],
      "Querying for the current stats failed": [
        ""
      ],
      "The request parameters are wrong": [
        ""
      ],
      "The user is unauthorized": [
        "El nombre de usaurio no se encontró"
      ],
      "Querying for the previous stats failed": [
        ""
      ],
      "Transaction volume report": [
        "La creación de la transferencia dió una respuesta erronea"
      ],
      "Last hour": [
        "Última hora"
      ],
      "Previous day": [
        ""
      ],
      "Last month": [
        "Último mes"
      ],
      "Last year": [
        "Último año"
      ],
      "Last Year": [
        "Último Año"
      ],
      "Trading volume from %1$s to %2$s": [
        "Vólumen de comercio en %1$s comparado con %2$s"
      ],
      "Transferred from an external account to an account in this bank.": [
        ""
      ],
      "Transferred from an account in this bank to an external account.": [
        "Hacer una transferencia bancaria a una cuenta con un número de cuenta conocido."
      ],
      "Payin": [
        "Envios de dinero"
      ],
      "Transferred from an account to a Taler exchange.": [
        ""
      ],
      "Payout": [
        "Recibos de dinero"
      ],
      "Transferred from a Taler exchange to another account.": [
        "Cuenta del operador del Taler Exchange"
      ],
      "Download stats as CSV": [
        "descargar estadísticas en CSV"
      ],
      "previous": [
        ""
      ],
      "Decreased by": [
        "Descendiente por"
      ],
      "Increased by": [
        "Ascendente por"
      ],
      "Account created with password \"%1$s\".": [
        ""
      ],
      "Server replied that phone or email is invalid": [
        "El servidor respondió que el teléfono o correo eletrónico es invalido"
      ],
      "The rights to perform the operation are not sufficient": [
        "Los permisos para ejecutar la operación no son suficientes"
      ],
      "Account username is already taken": [
        "El nombre del usuario ya está tomado"
      ],
      "Account ID is already taken": [
        "El id de cuenta ya está tomado"
      ],
      "Bank ran out of bonus credit.": [
        "El banco no tiene mas crédito de bonus."
      ],
      "Account username can't be used because is reserved": [
        "El nombre de usuario de la cuenta no puede userse porque está reservado"
      ],
      "Can't create accounts": [
        "No puede crear cuentas"
      ],
      "Only system admin can create accounts.": [
        "Solo los administradores del sistema pueden crear cuentas."
      ],
      "New bank account": [
        "Nueva cuenta"
      ],
      "only admin can download stats": [
        "Solo los administradores del sistema pueden crear cuentas."
      ],
      "Download bank stats": [
        "Descargar estadísticas del banco"
      ],
      "Include hour metric": [
        "Incluir métrica horaria"
      ],
      "Include day metric": [
        "Incluir métrica diaria"
      ],
      "Include month metric": [
        "Incluir métrica mensual"
      ],
      "Include year metric": [
        "Incluir métrica anual"
      ],
      "Include table header": [
        "Incluir encabezado de tabla"
      ],
      "Add previous metric for compare": [
        "Agregar métrica previa para comparar"
      ],
      "Fail on first error": [
        "Fallar en el primer error"
      ],
      "Download": [
        "Descargar"
      ],
      "downloading... %1$s": [
        "descargando... %1$s"
      ],
      "Download completed": [
        "Descarga completada"
      ],
      "Click here to save the file in your computer.": [
        "click aquí para guardar el archivo en su computadora"
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        "No se puede eliminar la cuenta"
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        "La cuenta no puede ser eliminada mientras tiene saldo. Primero aseguresé que el dueño haga un egreso completo."
      ],
      "Name doesn't match": [
        "el nombre no coincide"
      ],
      "Account removed": [
        "Cuenta eliminada"
      ],
      "No enough permission to delete the account.": [
        "No tiene permisos suficientes para eliminar la cuenta."
      ],
      "The username was not found.": [
        "El nombr ede usuario no se encontró."
      ],
      "Can't delete a reserved username.": [
        "No se puede eliminar un nombre de usuario reservado."
      ],
      "Can't delete an account with balance different than zero.": [
        "No se puede eliminar una cuenta con saldo diferente a cero."
      ],
      "Remove account.": [
        "Hacia cuenta"
      ],
      "You are going to remove the account": [
        "Está por eliminar la cuenta"
      ],
      "Deleting account \"%1$s\"": [
        "Borrando cuenta \"%1$s\""
      ],
      "Verification": [
        "Verificación"
      ],
      "Enter the account name that is going to be deleted": [
        "ingrese el nombre de cuenta que será eliminado"
      ],
      "Cashout id should be a number": [
        "debería ser un correo electrónico"
      ],
      "This cashout not found. Maybe already aborted.": [
        "Este egreso no se encontró. Quizá fue abortado."
      ],
      "Cashout detail": [
        "Detalles de egreso"
      ],
      "Debited": [
        "Debitado"
      ],
      "Transferred": [
        "Transferencia"
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        "Bienvenido a %1$s!"
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=2; plural=n != 1;",
  "lang": "es",
  "completeness": 74
};

strings['de'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=2; plural=n != 1;",
        "lang": "de"
      },
      "Operation failed, please report": [
        "Vorgang fehlgeschlagen, bitte Fehler melden"
      ],
      "Request timeout": [
        "Zeitüberschreitung der Anfrage"
      ],
      "Request throttled": [
        "Die Anfrage wird verzögert beantwortet"
      ],
      "Malformed response": [
        "Fehlerhafte Antwort"
      ],
      "Network error": [
        "Netzwerkfehler"
      ],
      "Unexpected request error": [
        "Unerwarteter Fehler bei der Anfrage"
      ],
      "Unexpected error": [
        "Unerwarteter Fehler"
      ],
      "An IBAN consists of capital letters and numbers only": [
        "Eine IBAN besteht nur aus Großbuchstaben und Zahlen"
      ],
      "IBAN numbers have more that 4 digits": [
        "Eine IBAN besteht normalerweise aus mehr als 4 Ziffern"
      ],
      "IBAN numbers have less that 34 digits": [
        "Eine IBAN besteht normalerweise aus weniger als 34 Ziffern"
      ],
      "IBAN country code not found": [
        "IBAN-Ländercode wurde nicht gefunden"
      ],
      "IBAN number is not valid, checksum is wrong": [
        "IBAN-Nummer ist ungültig, die Prüfsumme ist falsch"
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        "Verwenden Sie nur Buchstaben und Zahlen sowie als Sonderzeichen - . _ ~"
      ],
      "Required": [
        "Erforderlich"
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        "Authentifizierungskanal"
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        "Nutzername des Kontos"
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        "Der Vorgang ist fehlgeschlagen."
      ],
      "Multi-factor authentication required": [
        "Authentifizierung erforderlich"
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        "Dieser Vorgang wird durch eine Zwei-Faktor-Authentifizierung geschützt. Um ihn abschließen zu können, müssen wir Ihre Identität durch das von Ihnen gewählte Authentifizierungsverfahren überprüfen."
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        "Es besteht keine ausreichende Berechtigung, um den Vorgang abzuschließen."
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        "Abbrechen"
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        "Es war nicht möglich, eine Einzahlung auszuführen"
      ],
      "The bank configuration does not support cashout operations.": [
        "Die Konfiguration der Bankverbindung unterstützt keine Einzahlungen."
      ],
      "Close": [
        "Schließen"
      ],
      "Cashout is disabled": [
        "Einzahlungen aufs Konto sind deaktiviert"
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        "In den Einstellungen müssen die Einzahlungen aufs Konto aktiviert und der Umrechnungskurs einschließlich aller Gebühren, Kurse und einem Rundungsverfahren initialisiert worden sein."
      ],
      "The server didn't understand the request.": [
        "Der Server unterstützt nicht die aktuell gewählte TAN-Methode."
      ],
      "The amount is too small": [
        "Das Passwort ist zu lang."
      ],
      "Conversion is not implemented.": [
        "Umrechnungen sind deaktiviert"
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        "Diese Konto-ID ist bereits vergeben."
      ],
      "The currency is not supported": [
        "Das gewählte Authentifizierungsverfahren wird nicht unterstützt."
      ],
      "Invalid": [
        "Ungültig"
      ],
      "Amount needs to be higher": [
        "Es muss ein höherer Betrag gewählt werden"
      ],
      "Balance is not enough": [
        "Das Guthaben reicht nicht aus"
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        "Es ist nicht möglich, einen geringeren Betrag als %1$s einzuzahlen"
      ],
      "The total transfer to the destination will be zero": [
        "Der zu übertragende Gesamtbetrag beträgt Null"
      ],
      "Cashout created": [
        "Die Einzahlung wurde erstellt"
      ],
      "Second factor authentication required.": [
        "Authentifizierung erforderlich"
      ],
      "Account not found": [
        "Konto nicht gefunden"
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        "Eine gleichartige Anfrage wurde bereits gestellt, bitte überprüfen Sie den Vorgang oder versuchen Sie es erneut."
      ],
      "The conversion rate was applied incorrectly": [
        "Der Umrechnungskurs wurde fehlerhaft angewendet"
      ],
      "The account does not have sufficient funds": [
        "Das Konto verfügt über kein ausreichendes Guthaben"
      ],
      "Missing cashout URI in the profile": [
        "Die Einzahlungs-URI dieses Profils fehlt"
      ],
      "The amount is below the minimum amount permitted.": [
        "Der Betrag ist unterhalb des zulässigen Minimums."
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        "Der Versand der Bestätigung ist fehlgeschlagen, versuchen Sie den Vorgang bittespäter erneut oder kontaktieren Sie den Administrator."
      ],
      "The server doesn't support the current TAN channel.": [
        "Der Server unterstützt nicht die aktuell gewählte TAN-Methode."
      ],
      "Create cashout.": [
        "Konto anlegen"
      ],
      "Cashout": [
        "Auszahlung (Cashout)"
      ],
      "Conversion rate": [
        "Umrechnungskurs"
      ],
      "Balance": [
        "Salden"
      ],
      "Fee": [
        "Gebühr"
      ],
      "To account": [
        "Auf Bankkonto"
      ],
      "Legal name": [
        "Offizieller Name des Empfängers (wirtschaftlich Berechtigter des empfangenden Bankkontos)"
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        "Falls dieser Name nicht mit dem des wirtschaftlich Berechtigten des Bankkontos übereinstimmt, könnte Ihre Überweisung fehlschlagen."
      ],
      "Unable to cashout": [
        "Es war nicht möglich, eine Einzahlung auszuführen"
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        "Bevor Sie auf ein Bankkonto einzahlen können, müssen Sie Ihr Profil vervollständigen"
      ],
      "Transfer subject": [
        "Buchungsvermerk der Überweisung"
      ],
      "Currency": [
        "Währung"
      ],
      "Send %1$s": [
        "%1$s übertragen"
      ],
      "Receive %1$s": [
        "%1$s erhalten"
      ],
      "Amount": [
        "Betrag"
      ],
      "Total cost": [
        "Gesamte Gebühren"
      ],
      "Balance left": [
        "Verbleibendes Guthaben"
      ],
      "Before fee": [
        "Vor Abzug von Gebühren"
      ],
      "Total cashout transfer": [
        "Gesamter Einzahlungsbetrag"
      ],
      "Not valid": [
        "Nicht gültig"
      ],
      "Does not follow the pattern": [
        "Weicht vom Muster ab"
      ],
      "The wire transfer was successfully completed!": [
        "Die Banküberweisung wurde erfolgreich durchgeführt!"
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        "Die Anfrage war ungültig oder die payto://-URI nutzte inakzeptable Merkmale."
      ],
      "Not enough permission to complete the operation.": [
        "Es besteht keine ausreichende Berechtigung, um den Vorgang abzuschließen."
      ],
      "The bank administrator cannot be the transfer creditor.": [
        "Der Bankbetreiber kann nicht gleichzeitig Begünstigter von Überweisungen sein."
      ],
      "The destination account \"%1$s\" was not found.": [
        "Das Empfängerkonto \"%1$s\" wurde nicht gefunden."
      ],
      "The origin and the destination of the transfer can't be the same.": [
        "Ursprung und Ziel des Transfers können nicht gleich sein."
      ],
      "Your balance is not sufficient for the operation.": [
        "Das Guthaben reicht für den Vorgang nicht aus."
      ],
      "The origin account \"%1$s\" was not found.": [
        "Das Ursprungskonto \"%1$s\" wurde nicht gefunden."
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        "Die Vorbereitung der Transaktion hat nicht funktioniert. Bitte versuchen Sie es erneut."
      ],
      "A second factor authentication is required.": [
        "Dies wird verwendet, wenn die Zwei-Faktor-Authentifizierung aktiviert ist"
      ],
      "Confirm wire transfer.": [
        "Banküberweisung durchführen"
      ],
      "Input wire transfer detail": [
        "Überweisungsdetails einfügen"
      ],
      "Using a form": [
        "Mithilfe eines Formulars"
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        "Uniform Resource Identifier (URI) zum Bestimmen des Werts, der an das Empfängerkonto übertragen wird."
      ],
      "QR code": [
        "QR-Code"
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        "Wenn Ihr Gerät über eine Kamera verfügt, können Sie automatisch eine payto-Zahlungsanweisung (payto://-URI) aus einem QR-Code erstellen."
      ],
      "Recipient": [
        "Empfängerkonto"
      ],
      "ID of the recipient's account": [
        "ID des Empfängerkontos"
      ],
      "username": [
        "Name des Nutzers"
      ],
      "IBAN of the recipient's account": [
        "IBAN des Empfängerkontos"
      ],
      "Subject": [
        "Verwendungszweck"
      ],
      "Some text to identify the transfer": [
        "Eine Zeichenkette, um die Überweisung eindeutig zu benennen"
      ],
      "Amount to transfer": [
        "Zu überweisender Betrag"
      ],
      "Payto URI:": [
        "payto-URI:"
      ],
      "Uniform resource identifier of the target account": [
        "URI (Uniform Resource Identifier) des Empfängerkontos"
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://x-taler-bank/[Bankbetreiber]/[Empfängerkonto]?message=[Buchungsvermerk]&amount=[%1$s:X.Y]"
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        "payto://iban/[IBAN des Empfängers]?message=[Buchungsvermerk]&amount=[%1$s:X.Y]"
      ],
      "The maximum amount for a wire transfer is %1$s": [
        "Der Höchstbetrag für eine Überweisung beträgt %1$s"
      ],
      "Cost": [
        "Kosten"
      ],
      "Send": [
        "Überweisen"
      ],
      "Only \"x-taler-bank\" target are supported": [
        "Nur \"x-taler-bank\"-Ziele werden unterstützt"
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        "Nur dieser Bankbetreiber ist zulässig. Bitte verwenden Sie \"%1$s\""
      ],
      "Account name is missing": [
        "Name oder Bezeichnung des Kontos fehlt"
      ],
      "Only \"IBAN\" target are supported": [
        "Nur IBAN-Ziele werden unterstützt"
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        "Bitte geben Sie einen Betrag an, der übertragen werden soll"
      ],
      "The \"amount\" parameter is not valid": [
        "Der Betrag ist nicht gültig"
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        "Es fehlen Parameter für einen Referenz-Buchungsvermerk der Überweisungen"
      ],
      "The only currency allowed is \"%1$s\"": [
        "Die einzig zulässige Währung ist \"%1$s\""
      ],
      "You cannot transfer an amount of zero.": [
        "Sie können keinen Betrag überweisen, der Null ist."
      ],
      "The balance is not sufficient": [
        "Das Guthaben ist nicht ausreichend"
      ],
      "Please enter a longer subject": [
        "Bitte geben Sie einen längeren Buchungsvermerk der Überweisung an"
      ],
      "Show withdrawal confirmation": [
        "Zeige Bestätigung der Abhebung"
      ],
      "Withdraw without setting amount": [
        "Abheben ohne festgelegten Betrag"
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        "Hilfstext: Zuerst Wallet installieren"
      ],
      "Currently, the bank is not accepting new registrations!": [
        "Im Augenblick nimmt die Bank keine Neuregistrierungen an!"
      ],
      "The name is missing": [
        "Der Nutzername fehlt"
      ],
      "Missing username": [
        "Fehlender Nutzername"
      ],
      "Missing password": [
        "Fehlendes Passwort"
      ],
      "The password should be longer than 8 letters": [
        "Das Passwort sollte länger als 8 Zeichen sein"
      ],
      "The passwords do not match": [
        "Die Passwörter stimmen nicht überein"
      ],
      "Server replied with invalid phone or email.": [
        "Der Server gab an, dass Telefonnummer oder E-Mail-Adresse ungültig seien."
      ],
      "You are not authorised to create this account.": [
        "Sie sind nicht berechtigt, dieses Konto zu erstellen."
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        "Die Registrierung ist nicht möglich, da die Bank über kein ausreichendes Bonusguthaben verfügt."
      ],
      "That username can't be used because is reserved.": [
        "Dieser Nutzername kann nicht verwendet werden, da er schon reserviert ist."
      ],
      "That username is already taken.": [
        "Dieser Nutzername ist leider bereits vergeben."
      ],
      "That account ID is already taken.": [
        "Diese Konto-ID ist bereits vergeben."
      ],
      "No information for the selected authentication channel.": [
        "Es sind keine Informationen für das gewählte Authentifizierungsverfahren verfügbar."
      ],
      "Authentication channel is not supported.": [
        "Das gewählte Authentifizierungsverfahren wird nicht unterstützt."
      ],
      "Only an administrator is allowed to set the debt limit.": [
        "Nur ein Administrator ist befugt, die Kredithöhe festzulegen."
      ],
      "Only the administrator can change the conversion rate.": [
        "Nur der Administrator kann die geringste Höhe einer Auszahlung ändern."
      ],
      "The conversion rate class doesn't exist.": [
        "Der Umrechnungskurs wurde fehlerhaft angewendet"
      ],
      "Only admin can create accounts with second factor authentication.": [
        "Nur der Administrator kann Konten mit Zwei-Faktor-Authentifizierung erstellen."
      ],
      "The password is too short. Can't have less than 8 characters.": [
        "Das Passwort sollte länger als 8 Zeichen sein"
      ],
      "The password is too long. Can't have more than 64 characters.": [
        "Das Passwort sollte länger als 8 Zeichen sein"
      ],
      "Account registration": [
        "Kontoregistrierung"
      ],
      "Login username": [
        "Nutzername zum Anmelden"
      ],
      "Password": [
        "Passwort"
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        "Verwenden Sie ein starkes Passwort: Mindestens 8 Zeichen bestehend aus Kleinbuchstaben, Großbuchstaben, Symbolen und Zahlen und ohne öffentlich bekannte Informationen (wie Namen, Geburtstage, Telefonnummern usw.)"
      ],
      "Repeat password": [
        "Passwort wiederholen"
      ],
      "Full name": [
        "Vollständiger Name"
      ],
      "Register": [
        "Registrieren"
      ],
      "Create a random temporary user": [
        "Einen zufälligen temporären Nutzer anlegen"
      ],
      "You have no permission to this account.": [
        "Es besteht keine ausreichende Berechtigung zum Löschen des Kontos."
      ],
      "Wrong credentials for \"%1$s\"": [
        "Falsche Zugangsdaten für \"%1$s\""
      ],
      "Account login.": [
        "Kontenname"
      ],
      "Session expired": [
        "Dieser Vorgang ist abgelaufen."
      ],
      "Username": [
        "Nutzername"
      ],
      "Password of the account": [
        "Passwort des Kontos"
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        "Anmelden"
      ],
      "Transactions history": [
        "Transaktionsübersicht"
      ],
      "No transactions yet.": [
        "Es liegen noch keine Transaktionen vor."
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        "Sie können Geld in Ihre Wallet-App übertragen oder abheben lassen."
      ],
      "Date": [
        "Datum"
      ],
      "Counterpart": [
        "Gegenkonto"
      ],
      "sent": [
        "gesendet"
      ],
      "received": [
        "empfangen"
      ],
      "Invalid value": [
        "Ungültiger Wert"
      ],
      "to": [
        "an"
      ],
      "from": [
        "von"
      ],
      "First page": [
        "Erste Seite"
      ],
      "Next": [
        "Nächste Seite"
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        "Die Abhebung wurde zuvor abgebrochen und konnte daher nicht durchgeführt werden"
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        "Der Abhebevorgang kann nicht bestätigt werden, bevor eine Taler Wallet-App die Transaktion angenommen hat."
      ],
      "The operation ID is invalid.": [
        "Die Vorgangs-ID ist ungültig."
      ],
      "The operation was not found.": [
        "Der Vorgang konnte nicht gefunden werden."
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        "Der Betrag der Abhebung und der empfangene Betrag unterscheiden sich."
      ],
      "The bank requires a bank account which has not been specified yet.": [
        "Die Bank benötigt ein Bankkonto, das noch nicht festgelegt wurde."
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        "Abhebevorgang in Bearbeitung"
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        "Der Vorgang wurde vom Verrechnungskonto bereits bestätigt und kann daher nicht mehr abgebrochen werden"
      ],
      "Complete withdrawal.": [
        "Bestätigung der Abhebung"
      ],
      "Confirm the withdrawal operation": [
        "Bestätigen Sie den Abhebevorgang"
      ],
      "Wire transfer details": [
        "Details der Banküberweisung"
      ],
      "Payment Service Provider's account number": [
        "Bankkontonummer des Zahlungsdiensts"
      ],
      "Payment Service Provider's name": [
        "Name des Zahlungsdiensts"
      ],
      "Payment Service Provider's account bank hostname": [
        "Bezeichnung des Bankkontos des Zahlungsdiensts (PSP hostname)"
      ],
      "Payment Service Provider's account id": [
        "Konto-ID des Zahlungsdiensts"
      ],
      "Payment Service Provider's account address": [
        "Kontenadresse des Zahlungsdiensts"
      ],
      "No amount has yet been determined.": [
        "Es wurde bisher noch kein Betrag ermittelt."
      ],
      "Transfer": [
        "Überweisung"
      ],
      "Authentication required": [
        "Authentifizierung erforderlich"
      ],
      "This operation was created with another username": [
        "Dieser Vorgang wurde mit einem anderen Nutzernamen erstellt"
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        "Der Vorgang wurde vom Verrechnungskonto bereits bestätigt und kann daher nicht mehr abgebrochen werden"
      ],
      "Wire transfer completed!": [
        "Banküberweisung abgeschlossen!"
      ],
      "Confirm withdrawal.": [
        "Bestätigung der Abhebung"
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        "Sie sind nicht berechtigt, den Vorgang durchzuführen, vielleicht ist die Sitzung abgelaufen oder das Passwort wurde geändert."
      ],
      "The operation was rejected due to insufficient funds.": [
        "Der Vorgang wurde wegen unzureichendem Guthaben zurückgewiesen."
      ],
      "Withdrawal confirmed": [
        "Abhebung bestätigt"
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        "Die Überweisung an den Zahlungsdienst wurde eingeleitet. Ihre Taler-Wallet-App wird den angeforderten Betrag baldmöglichst abrufen."
      ],
      "Do not show this again": [
        "Diese Meldung nicht mehr anzeigen"
      ],
      "If you have a Taler wallet installed on this device": [
        "Falls Sie eine Taler-Wallet-App auf diesem Gerät installiert haben"
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        "In Ihrer Taler-Wallet-App werden die Details der Transaktion einschließlich der Gebühren (falls diese verlangt wurden) angezeigt. Wenn Sie noch keine Taler-Wallet-App haben, folgen Sie bitte den Anweisungen"
      ],
      "on this page": [
        "auf dieser Seite"
      ],
      "Withdraw": [
        "Abheben"
      ],
      "In case you have a Taler wallet on another device": [
        "Falls Sie eine Taler-Wallet-App auf einem anderen Gerät als diesem haben"
      ],
      "Scan the QR below to start the withdrawal.": [
        "Scannen Sie den QR-Code, um die Abhebung zu beginnen."
      ],
      "There is an operation already pending": [
        "Es ist bereits ein Vorgang in Bearbeitung"
      ],
      "Complete the operation in": [
        "Abschließen des Vorgangs in"
      ],
      "this page": [
        "diese Seite"
      ],
      "The server replied with an invalid taler://withdraw URI": [
        "Der Server antwortete mit einem ungültigen taler://withdraw URI"
      ],
      "Withdraw URI: %1$s": [
        "Abhebe-URI: %1$s"
      ],
      "The operation was rejected due to insufficient funds": [
        "Der Vorgang wurde wegen unzureichendem Guthaben zurückgewiesen"
      ],
      "Current balance is %1$s": [
        "Das aktuelle Guthaben beträgt %1$s"
      ],
      "You can withdraw up to %1$s": [
        "Sie können bis zu %1$s abheben"
      ],
      "Continue": [
        "Weiter"
      ],
      "Use your Taler wallet": [
        "Aktivieren Sie Ihr Taler-Wallet"
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        "Nachdem Sie Ihre Taler-Wallet-App aktiviert haben, müssen Sie auf dieser Website den Vorgang entweder mit Ihrer Freigabe bestätigen oder ihn abbrechen."
      ],
      "You need a Taler wallet": [
        "Sie benötigen eine Taler-Wallet-App"
      ],
      "If you don't have one yet you can follow the instruction in": [
        "Wenn Sie noch keine haben, folgen Sie bitte den Anweisungen in"
      ],
      "Send money": [
        "Geld senden"
      ],
      "to a Taler wallet": [
        "an ein Taler-Wallet (App oder WebExtension)"
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        "Elektronisches Bargeld in eine Smartphone-App oder in eine Browser-Erweiterung (WebExtension) abheben"
      ],
      "to another bank account": [
        "an ein anderes Bankkonto"
      ],
      "Make a wire transfer to an account with known bank account number.": [
        "Sie überweisen auf ein Konto mit einer Ihnen bekannten Bankkontonummer."
      ],
      "This is a demo": [
        "Dies ist eine Demo-Version"
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        "Dieser Teil der Demo-Version zeigt die Rolle einer Kundenbank, die Zahlungen mit dem Taler-System unterstützt. Sie sehen in der Demonstration Ihr eigenes Bankkonto und den %1$s-Transaktionsverlauf."
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        "Damit können Sie nachvollziehen, wie eine Kundenbank, die Zahlungen mit dem Taler-System unterstützt, funktionieren würde."
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        "Interner Fehler, um dessen Mitteilung wir Sie freundlich bitten."
      ],
      "Preferences": [
        "Präferenzen"
      ],
      "Welcome": [
        "Willkommen"
      ],
      "Welcome, %1$s": [
        "Herzlich willkommen, %1$s"
      ],
      "No enough permission to access the conversion rate list.": [
        "Es besteht keine ausreichende Berechtigung, um den Vorgang abzuschließen."
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        "Umrechnungen sind deaktiviert"
      ],
      "Conversion rate classes": [
        "Umrechnungskurs"
      ],
      "Create conversion rate class": [
        "Umrechnungskurs"
      ],
      "No conversion rate class": [
        "Umrechnungskurs"
      ],
      "Name": [
        "Name"
      ],
      "Description": [
        "Demobeschreibung anzeigen"
      ],
      "Cashin": [
        "Auszahlung (Cash-In)"
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        "Bitte wählen Sie einen Bereich aus"
      ],
      "Details": [
        "Detail-Angaben"
      ],
      "Delete": [
        "Löschen"
      ],
      "Credentials": [
        "Anmeldedaten"
      ],
      "Cashouts": [
        "Auszahlungen (Cashout)"
      ],
      "Conversion": [
        "Umrechnung (von Währungen)"
      ],
      "only admin can setup conversion": [
        "Nur ein Administrator kann Umrechnungskurse einrichten"
      ],
      "Wrong credentials": [
        "Ungültige Zugangsdaten"
      ],
      "Conversion is disabled": [
        "Umrechnungen sind deaktiviert"
      ],
      "Config cashout": [
        "Einzahlungen einrichten"
      ],
      "Config cashin": [
        "Auszahlungen einrichten (Cash-In)"
      ],
      "Bad ratios": [
        "Das Verhältnis passt nicht"
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        "Für ein stimmiges Verhältnis sollte die eine Währung höher oder gleich 1 sein und die andere Währung niedriger oder gleich 1 sein."
      ],
      "Initial amount": [
        "Guthaben bei Erstanlage des Kontos"
      ],
      "Use it to test how the conversion will affect the amount.": [
        "Hier testen Sie, um die Auswirkung des Umrechnungskurses auf einen Betrag zu prüfen."
      ],
      "Sending to this bank": [
        "An diese Bank senden"
      ],
      "Converted": [
        "Umgetauscht"
      ],
      "Cashin after fee": [
        "Auszahlung nach Abzug von Gebühren"
      ],
      "Sending from this bank": [
        "Senden von dieser Bank"
      ],
      "Cashout after fee": [
        "Einzahlung nach Abzug von Gebühren"
      ],
      "Bad configuration": [
        "Fehlerhafte Konfiguration"
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        "Diese Einstellung erlaubt Nutzern, höhere Beträge auf ihre Konten einzuzahlen als sie eingenommen haben."
      ],
      "Update": [
        "Aktualisieren"
      ],
      "Rnvalid": [
        "Ungültig"
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        "Minimaler Betrag"
      ],
      "Only cashout operation above this threshold will be allowed.": [
        "Es werden nur Einzahlungen oberhalb dieses Werts erlaubt"
      ],
      "Ratio": [
        "Verhältnis"
      ],
      "Conversion ratio between currencies": [
        "Umrechnungsverhältnis zwischen den Währungen"
      ],
      "Example conversion": [
        "Beispiel einer Währungsumrechnung"
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        "1 %1$s wird getauscht zu %2$s %3$s"
      ],
      "Tiny amount": [
        "Minimaler Betrag"
      ],
      "Rounding mode": [
        "Rundungsmethode"
      ],
      "Zero": [
        "Null"
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        "Der Betrag wird auf den größtmöglichen Wert abgerundet, der kleiner als die Eingabe ist."
      ],
      "Up": [
        "Aufrunden"
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        "Der Betrag wird auf den geringstmöglichen Wert aufgerundet, der größer als die Eingabe ist."
      ],
      "Nearest": [
        "Am nähesten"
      ],
      "Amount will be round to the closest possible value.": [
        "Der Betrag wird auf den nächstmöglichen Wert gerundet."
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        "Beispiele"
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        "Rundung eines Betrags von 1,24 mit Rundungswert 0,1"
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        "Angesichts des Rundungswertes von 0,1 sind die möglichen Werte, die am nächsten an 1,24 liegen, folgende: 1.1, 1.2, 1.3, 1.4."
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        "Mit der Methode „Null“ wird der Wert auf 1,2 gerundet"
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        "Mit der Methode „Nähestens“ wird der Wert auf 1,2 gerundet"
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        "Mit der Methode „Aufrunden“ wird der Wert auf 1,3 gerundet"
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        "Rundung eines Betrags von 1,26 mit Rundungswert 0,1"
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        "Mit der Methode „Nähestens“ wird der Wert auf 1,3 gerundet"
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        "Rundung eines Betrags von 1,24 mit Rundungswert 0,3"
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        "Mit einem Rundungswert von 0,3 sind die möglichen Werte, die am nähesten an 1,24 liegen, folgende: 0,9, 1,2, 1,5 und 1,8."
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        "Mit der Methode „Aufrunden“ wird der Wert auf 1,5 gerundet"
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        "Rundung eines Betrags von 1,26 mit Rundungswert 0,3"
      ],
      "Amount to be deducted before amount is credited.": [
        "Betrag, der vor der Gutschrift abzuziehen ist."
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        "In den Einstellungen müssen die Einzahlungen aufs Konto aktiviert und der Umrechnungskurs einschließlich aller Gebühren, Kurse und einem Rundungsverfahren initialisiert worden sein."
      ],
      "Unauthorized": [
        "Dieser Nutzer ist nicht berechtigt"
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        ""
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        ""
      ],
      "The name of the conversion is already used.": [
        "Es ist bereits ein Vorgang in Bearbeitung"
      ],
      "Conversion rate class": [
        "Umrechnungskurs"
      ],
      "Accounts": [
        "Konten"
      ],
      "Test": [
        ""
      ],
      "Users": [
        "Nutzername"
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        "Sie sind gerade dabei, das Konto zu löschen"
      ],
      "This step can't be undone.": [
        "Dieser Schritt kann später nicht mehr rückgängig gemacht werden."
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        "Konto"
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        "Aktionen"
      ],
      "Remove": [
        "Entfernen"
      ],
      "Add": [
        "Adresse"
      ],
      "Conversion rate name": [
        "Umrechnungskurs"
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        "Umrechnungskurs"
      ],
      "The rights to change the account are not sufficient": [
        "Es besteht keine ausreichende Berechtigung zum Ändern des Kontos"
      ],
      "New conversion rate class": [
        "Umrechnungskurs"
      ],
      "Create": [
        "Anlegen"
      ],
      "History of public accounts": [
        "Buchungen auf öffentlich sichtbaren Konten"
      ],
      "Make a wire transfer": [
        "Eine Banküberweisung durchführen"
      ],
      "Scan the QR code below to start the withdrawal.": [
        "Scannen Sie den QR-Code, um die Abhebung zu beginnen."
      ],
      "Operation aborted": [
        "Vorgang abgebrochen"
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        "Die Überweisung auf das Konto des Zahlungsdiensts wurde an einer anderen Stelle abgebrochen. Ihr Guthaben ist jedoch sicher und geht nicht verloren."
      ],
      "Go to your wallet now": [
        "Geh jetzt zu deiner Wallet"
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        "Der Vorgang wurde als ausgewählt markiert, aber ein Schritt während des Abhebevorgangs ist gescheitert"
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        "Es wurde keine Abhebe-ID gefunden und daher ist kein Bankkonto ausgewählt worden."
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        "Es gibt eine Abhebe-ID, aber es wurde kein Bankkonto ausgewählt oder das gewählte Bankkonto ist nicht gültig."
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        "Das Konto wurde ausgewählt, aber es wurde keine Abhebe-ID gefunden."
      ],
      "Operation not found": [
        "Vorgang nicht gefunden"
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        "Dieser Vorgang ist dem Server nicht bekannt. Die Vorgangs-ID stimmt nicht oder der Server hat die Informationen zum Vorgang gelöscht, bevor sie hier ankamen."
      ],
      "Continue to dashboard": [
        "Weiter zum Dashboard"
      ],
      "The Withdrawal URI is not valid": [
        "Die URI für die Abhebung ist nicht gültig"
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        "In den Einstellungen müssen die Einzahlungen aufs Konto aktiviert und der Umrechnungskurs einschließlich aller Gebühren, Kurse und einem Rundungsverfahren initialisiert worden sein."
      ],
      "Latest cashouts": [
        "Letzte Einzahlungen"
      ],
      "Created": [
        "Erzeugt"
      ],
      "Total debit": [
        "Gesamtbetrag der Belastung"
      ],
      "Total credit": [
        "Gesamtbetrag der Gutschrift"
      ],
      "Cashout for account %1$s": [
        "Einzahlung an Konto %1$s"
      ],
      "Doesn't have the pattern of an email": [
        "Dies entspricht keiner Email-Adresse"
      ],
      "Should start with +": [
        "Dies sollte mit einem + beginnen"
      ],
      "A phone number consists of numbers only": [
        "Eine Telefonnummer besteht nur aus Ziffern"
      ],
      "Account ID for authentication": [
        "Konto-ID zur Authentifizierung"
      ],
      "Name of the account holder": [
        "Name des Inhabers des Kontos"
      ],
      "Internal account": [
        "Internes Konto"
      ],
      "If this field is empty, a random account ID will be assigned": [
        "Wenn dieses Feld leer bleibt, wird eine zufällige Konto-ID vergeben"
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        "Sie können diese IBAN kopieren und übertragen, um Überweisungen an Ihr Bankkonto zu erhalten"
      ],
      "Email": [
        "E-Mail"
      ],
      "To be used when second factor authentication is enabled": [
        "Dies wird verwendet, wenn die Zwei-Faktor-Authentifizierung aktiviert ist"
      ],
      "Phone": [
        "Telefon"
      ],
      "Enable second factor authentication": [
        "Dies wird verwendet, wenn die Zwei-Faktor-Authentifizierung aktiviert ist"
      ],
      "Using email": [
        "an die Emailadresse"
      ],
      "Add an email in your profile to enable this option": [
        ""
      ],
      "Using SMS": [
        ""
      ],
      "Add a phone number in your profile to enable this option": [
        ""
      ],
      "Cashout account": [
        "Auszahlungskonto"
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        "Kontonummer für Einzahlungen aufs eigene Bankkonto (gewöhnlich eine IBAN)"
      ],
      "Max debt": [
        "Maximale Kredithöhe"
      ],
      "How much the balance can go below zero.": [
        "Dieser Wert gibt an, wie weit der Saldo ins Minus gehen kann."
      ],
      "Is this account public?": [
        "Ist dieses Konto ein öffentliches?"
      ],
      "Public accounts have their balance publicly accessible": [
        "Öffentliche Konten zeigen ihre Salden und Bewegungen offen einsehbar"
      ],
      "Does this account belong to a Payment Service Provider?": [
        "Gehört dieses Konto dem Anbieter eines Zahlungsdiensts?"
      ],
      "Account updated": [
        "Das Konto wurde aktualisiert"
      ],
      "The username was not found": [
        "Der Name des Nutzers konnte nicht gefunden werden"
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        "Sie können den Namen des wirtschaftlichen Berechtigten nicht ändern, bitte benachrichtigen Sie den Administrator des Kontos."
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        "Sie sind nicht befugt, die Kredithöhe zu ändern, bitte verständigen Sie den Administrator des Kontos."
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        "Sie können die Adresse für Einzahlungen nicht ändern, bitte benachrichtigen Sie Ihren Administrator des Kontos."
      ],
      "Update account information.": [
        "Aktualisieren der Kontoeinstellungen"
      ],
      "Account \"%1$s\"": [
        "Konto \"%1$s\""
      ],
      "Removed": [
        "Entfernt"
      ],
      "This account can't be used.": [
        "Dieses Konto kann nicht genutzt werden."
      ],
      "Change details": [
        "Details ändern"
      ],
      "Merchant integration": [
        "Händler-Integration"
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        "Verwenden Sie diese Information, um Ihr Konto im Taler Merchant-Backend mit dem normalen Bankkonto zu verknüpfen. Sie können dafür die im Onlinebanking angezeigten Angaben kopieren und mit der \"Import\"-Taste im Abschnitt \"Bankkonto\" des Taler Merchant-Backend selbst einfügen bzw. Ihren Dienste-Verwalter eintragen lassen."
      ],
      "Account type": [
        "Kontentyp"
      ],
      "Method to use for wire transfer.": [
        "Für Überweisungen zu verwendende Methode."
      ],
      "IBAN": [
        "IBAN"
      ],
      "International Bank Account Number.": [
        "IBAN (Internationale Bankkontonummer)."
      ],
      "Account name": [
        "Kontenname"
      ],
      "Bank host where the service is located.": [
        "Adresse des Bankservers, der den Dienst anbietet."
      ],
      "Bank account identifier for wire transfers.": [
        "Kennung des Bankkontos für Überweisungen."
      ],
      "Address": [
        "Adresse"
      ],
      "Owner's name": [
        "Name des Kontoinhabers"
      ],
      "Legal name of the person holding the account.": [
        "Rechtsgültiger Name des Kontoinhabers."
      ],
      "Account info URL": [
        "URL für Kontoinformationen"
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        "Von wo der Händler Informationen über eingehende Überweisungen auf dieses Konto herunterladen kann."
      ],
      "Repeated password doesn't match": [
        "Das Passwort stimmt nicht mit dem ersten überein"
      ],
      "Password changed": [
        "Das Passwort wurde geändert"
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        "Sie sind zum Ändern des Passworts nicht berechtigt, möglicherweise ist die Sitzung nicht mehr gültig."
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        "Sie müssen das alte Passwort eingeben, sollten Sie es nicht mehr haben, verständigen Sie bitte Ihren Administrator des Kontos."
      ],
      "Your current password doesn't match, can't change to a new password.": [
        "Dies stimmt nicht mit dem bisherigen Passwort überein, daher kann kein neues Passwort vergeben werden."
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        "Passwort erneuern"
      ],
      "Update password": [
        "Passwort erneuern"
      ],
      "Current password": [
        "Bisheriges Passwort"
      ],
      "Your current password, for security": [
        "Zur Sicherheit bitte ihr bisheriges Passwort"
      ],
      "New password": [
        "Neues Passwort"
      ],
      "Type it again": [
        "Bitte das Passwort wiederholen"
      ],
      "Repeat the same password": [
        "Geben Sie das gleiche Passwort noch einmal ein"
      ],
      "Change": [
        "Ändern"
      ],
      "Create account": [
        "Konto anlegen"
      ],
      "Actions": [
        "Aktionen"
      ],
      "Unknown": [
        "Unbekannt"
      ],
      "Change password": [
        "Passwort ändern"
      ],
      "Querying for the current stats failed": [
        "Die Abfrage der aktuellen Statistik ist fehlgeschlagen"
      ],
      "The request parameters are wrong": [
        "Die Abfrageparameter sind falsch"
      ],
      "The user is unauthorized": [
        "Dieser Nutzer ist nicht berechtigt"
      ],
      "Querying for the previous stats failed": [
        "Die Abfrage der vorherigen Statistik ist fehlgeschlagen"
      ],
      "Transaction volume report": [
        "Umsatzbericht"
      ],
      "Last hour": [
        "Vergangene Stunde"
      ],
      "Previous day": [
        "Tag zuvor"
      ],
      "Last month": [
        "Vergangener Monat"
      ],
      "Last year": [
        "Letztes Jahr"
      ],
      "Last Year": [
        "Vergangenes Jahr"
      ],
      "Trading volume from %1$s to %2$s": [
        "Umsatzvolumen von %1$s bis %2$s"
      ],
      "Transferred from an external account to an account in this bank.": [
        "Überwiesen von einem externen Bankkonto auf das Konto dieser Bank."
      ],
      "Transferred from an account in this bank to an external account.": [
        "Überwiesen von einem Konto dieser Bank auf ein externes Bankkonto."
      ],
      "Payin": [
        "Auszahlung (Pay-In)"
      ],
      "Transferred from an account to a Taler exchange.": [
        "Überwiesen von einem Bankkonto an einen Taler Exchange (der Zahlungsdienst dieses Bezahlsystems)."
      ],
      "Payout": [
        "Einzahlung (Pay-Out)"
      ],
      "Transferred from a Taler exchange to another account.": [
        "Überwiesen von einem Taler Exchange (Zahlungsdienst dieses Bezahlsystems) auf ein anderes Bankkonto."
      ],
      "Download stats as CSV": [
        "Statistik herunterladen als CSV-Datei"
      ],
      "previous": [
        "vorherige"
      ],
      "Decreased by": [
        "Verringert um"
      ],
      "Increased by": [
        "Vermehrt um"
      ],
      "Account created with password \"%1$s\".": [
        "Das Konto wurde angelegt mit dem Passwort \"%1$s\"."
      ],
      "Server replied that phone or email is invalid": [
        "Der Server meldete zurück, dass die Telefonnummer oder die Emailadresse falsch seien"
      ],
      "The rights to perform the operation are not sufficient": [
        "Die Berechtigung zum Durchführen des Vorgangs ist unzureichend"
      ],
      "Account username is already taken": [
        "Dieser Nutzername ist bereits vergeben"
      ],
      "Account ID is already taken": [
        "Diese Konto-ID ist bereits vergeben"
      ],
      "Bank ran out of bonus credit.": [
        "Die Bank verfügt über kein Bonusguthaben mehr."
      ],
      "Account username can't be used because is reserved": [
        "Dieser Nutzername kann für das Konto nicht verwendet werden, da er bereits reserviert ist"
      ],
      "Can't create accounts": [
        "Die Anlage von Konten ist nicht möglich"
      ],
      "Only system admin can create accounts.": [
        "Nur ein Systemadministrator kann Konten anlegen."
      ],
      "New bank account": [
        "Neues Konto"
      ],
      "only admin can download stats": [
        "Nur ein Administrator kann Umrechnungskurse einrichten"
      ],
      "Download bank stats": [
        "Bankstatistik herunterladen"
      ],
      "Include hour metric": [
        "Stunden-Metrik einbeziehen"
      ],
      "Include day metric": [
        "Tages-Metrik einbeziehen"
      ],
      "Include month metric": [
        "Monats-Metrik einbeziehen"
      ],
      "Include year metric": [
        "Jahres-Metrik einbeziehen"
      ],
      "Include table header": [
        "Tabellenkopfzeilen einbeziehen"
      ],
      "Add previous metric for compare": [
        "Vorherige Metrik zum Vergleich hinzufügen"
      ],
      "Fail on first error": [
        "Beim ersten Fehler abbrechen"
      ],
      "Download": [
        "Herunterladen"
      ],
      "downloading... %1$s": [
        "Beim Herunterladen... %1$s"
      ],
      "Download completed": [
        "Download abgeschlossen"
      ],
      "Click here to save the file in your computer.": [
        "Hier klicken zum Speichern der Datei auf Ihrem Rechner."
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        "Es war nicht möglich, das Konto zu löschen"
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        "Das Konto kann nicht gelöscht werden, solange es noch ein Guthaben aufweist. Bitte sorgen Sie dafür, dass der Konteninhaber eine vollständige Einzahlung auf das eigene Bankkonto durchführt."
      ],
      "Name doesn't match": [
        "Der Name stimmt nicht überein"
      ],
      "Account removed": [
        "Das Konto wurde gelöscht"
      ],
      "No enough permission to delete the account.": [
        "Es besteht keine ausreichende Berechtigung zum Löschen des Kontos."
      ],
      "The username was not found.": [
        "Der Nutzername wurde nicht gefunden."
      ],
      "Can't delete a reserved username.": [
        "Es ist nicht möglich, den reservierten Nutzernamen zu entfernen."
      ],
      "Can't delete an account with balance different than zero.": [
        "Es ist nicht möglich, ein Konto mit einem Saldo ungleich Null zu löschen."
      ],
      "Remove account.": [
        "Das Konto wird gelöscht"
      ],
      "You are going to remove the account": [
        "Sie sind gerade dabei, das Konto zu löschen"
      ],
      "Deleting account \"%1$s\"": [
        "Das Konto \"%1$s\" wird gelöscht"
      ],
      "Verification": [
        "Überprüfung"
      ],
      "Enter the account name that is going to be deleted": [
        "Zum Löschen geben Sie den Namen des Kontos an"
      ],
      "Cashout id should be a number": [
        "Die Einzahlungs-ID sollte eine Zahl sein"
      ],
      "This cashout not found. Maybe already aborted.": [
        "Diese Einzahlung konnte nicht gefunden werden, vielleicht wurde sie bereits abgebrochen."
      ],
      "Cashout detail": [
        "Einzahlungsdetails"
      ],
      "Debited": [
        "Belastet"
      ],
      "Transferred": [
        "Überweisung"
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        "Willkommen bei %1$s!"
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=2; plural=n != 1;",
  "lang": "de",
  "completeness": 88
};

strings['ca'] = {
  "locale_data": {
    "messages": {
      "": {
        "domain": "messages",
        "plural_forms": "nplurals=2; plural=n != 1;",
        "lang": "ca"
      },
      "Operation failed, please report": [
        ""
      ],
      "Request timeout": [
        ""
      ],
      "Request throttled": [
        ""
      ],
      "Malformed response": [
        ""
      ],
      "Network error": [
        ""
      ],
      "Unexpected request error": [
        ""
      ],
      "Unexpected error": [
        ""
      ],
      "An IBAN consists of capital letters and numbers only": [
        ""
      ],
      "IBAN numbers have more that 4 digits": [
        ""
      ],
      "IBAN numbers have less that 34 digits": [
        ""
      ],
      "IBAN country code not found": [
        ""
      ],
      "IBAN number is not valid, checksum is wrong": [
        ""
      ],
      "Use letters, numbers or any of these characters: - . _ ~": [
        ""
      ],
      "Required": [
        ""
      ],
      "Unknown challenge.": [
        ""
      ],
      "Failed to validate the verification code.": [
        ""
      ],
      "Too many challenges are active right now, you must wait or confirm current challenges.": [
        ""
      ],
      "Wrong authentication number.": [
        ""
      ],
      "Expired challenge.": [
        ""
      ],
      "Submit the transmitted code number.": [
        ""
      ],
      "The verification code sent to the email address starting with %1$s": [
        ""
      ],
      "The verification code sent to the phone number starting with %1$s": [
        ""
      ],
      "Code": [
        ""
      ],
      "Username of the account": [
        ""
      ],
      "It will expired at %1$s": [
        ""
      ],
      "The challenge is expired and can't be solved but you can go back and create a new challenge.": [
        ""
      ],
      "Back": [
        ""
      ],
      "Verify": [
        ""
      ],
      "Failed to send the verification code.": [
        ""
      ],
      "The request was valid, but the server is refusing action.": [
        ""
      ],
      "The backend is not aware of the specified MFA challenge.": [
        ""
      ],
      "It is too early to request another transmission of the challenge.": [
        ""
      ],
      "Code transmission failed.": [
        ""
      ],
      "Multi-factor authentication required": [
        ""
      ],
      "This operation is protected with second factor authentication. In order to complete it we need to verify your identity using the authentication channel you provided.": [
        ""
      ],
      "The next challenge needs to be completed to confirm the operation.": [
        ""
      ],
      "All the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "One of the next challenges need to be completed to confirm the operation.": [
        ""
      ],
      "To an phone starting with \" %1$s\"": [
        ""
      ],
      "To an email starting with \" %1$s\"": [
        ""
      ],
      "I have a code": [
        ""
      ],
      "Send me a message": [
        ""
      ],
      "You have to wait until %1$s to send a new code.": [
        ""
      ],
      "Cancel": [
        ""
      ],
      "Complete": [
        ""
      ],
      "Unable to create a cashout": [
        ""
      ],
      "The bank configuration does not support cashout operations.": [
        ""
      ],
      "Close": [
        ""
      ],
      "Cashout is disabled": [
        ""
      ],
      "Cashout should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "The server didn't understand the request.": [
        ""
      ],
      "The amount is too small": [
        ""
      ],
      "Conversion is not implemented.": [
        ""
      ],
      "At least debit or credit needs to be provided": [
        ""
      ],
      "The amount is malfored": [
        ""
      ],
      "The currency is not supported": [
        ""
      ],
      "Invalid": [
        ""
      ],
      "Amount needs to be higher": [
        ""
      ],
      "Balance is not enough": [
        ""
      ],
      "It is not possible to cashout less than %1$s: %2$s": [
        ""
      ],
      "The total transfer to the destination will be zero": [
        ""
      ],
      "Cashout created": [
        ""
      ],
      "Second factor authentication required.": [
        ""
      ],
      "Account not found": [
        ""
      ],
      "Duplicated request detected, check if the operation succeeded or try again.": [
        ""
      ],
      "The conversion rate was applied incorrectly": [
        ""
      ],
      "The account does not have sufficient funds": [
        ""
      ],
      "Missing cashout URI in the profile": [
        ""
      ],
      "The amount is below the minimum amount permitted.": [
        ""
      ],
      "Sending the confirmation message failed, retry later or contact the administrator.": [
        ""
      ],
      "The server doesn't support the current TAN channel.": [
        ""
      ],
      "Create cashout.": [
        ""
      ],
      "Cashout": [
        ""
      ],
      "Conversion rate": [
        ""
      ],
      "Balance": [
        ""
      ],
      "Fee": [
        ""
      ],
      "To account": [
        ""
      ],
      "Legal name": [
        ""
      ],
      "If this name doesn't match the account holder's name, your transaction may fail.": [
        ""
      ],
      "Unable to cashout": [
        ""
      ],
      "Before being able to cashout to a bank account, you need to complete your profile": [
        ""
      ],
      "Transfer subject": [
        ""
      ],
      "Currency": [
        ""
      ],
      "Send %1$s": [
        ""
      ],
      "Receive %1$s": [
        ""
      ],
      "Amount": [
        ""
      ],
      "Total cost": [
        ""
      ],
      "Balance left": [
        ""
      ],
      "Before fee": [
        ""
      ],
      "Total cashout transfer": [
        ""
      ],
      "Not valid": [
        ""
      ],
      "Does not follow the pattern": [
        ""
      ],
      "The wire transfer was successfully completed!": [
        ""
      ],
      "The request was invalid or the payto://-URI used unacceptable features.": [
        ""
      ],
      "Not enough permission to complete the operation.": [
        ""
      ],
      "The bank administrator cannot be the transfer creditor.": [
        ""
      ],
      "The destination account \"%1$s\" was not found.": [
        ""
      ],
      "The origin and the destination of the transfer can't be the same.": [
        ""
      ],
      "Your balance is not sufficient for the operation.": [
        ""
      ],
      "The origin account \"%1$s\" was not found.": [
        ""
      ],
      "The attempt to create the transaction has failed. Please try again.": [
        ""
      ],
      "A second factor authentication is required.": [
        ""
      ],
      "Confirm wire transfer.": [
        ""
      ],
      "Input wire transfer detail": [
        ""
      ],
      "Using a form": [
        ""
      ],
      "A special URI that specifies the amount to be transferred and the destination account.": [
        ""
      ],
      "QR code": [
        ""
      ],
      "If your device has a camera, you can import a payto:// URI from a QR code.": [
        ""
      ],
      "Recipient": [
        ""
      ],
      "ID of the recipient's account": [
        ""
      ],
      "username": [
        ""
      ],
      "IBAN of the recipient's account": [
        ""
      ],
      "Subject": [
        ""
      ],
      "Some text to identify the transfer": [
        ""
      ],
      "Amount to transfer": [
        ""
      ],
      "Payto URI:": [
        ""
      ],
      "Uniform resource identifier of the target account": [
        ""
      ],
      "payto://x-taler-bank/[bank-host]/[receiver-account]?message=[subject]&amount=[%1$s:X.Y]": [
        ""
      ],
      "payto://iban/[receiver-iban]?message=[subject]&amount=[%1$s:X.Y]": [
        ""
      ],
      "The maximum amount for a wire transfer is %1$s": [
        ""
      ],
      "Cost": [
        ""
      ],
      "Send": [
        ""
      ],
      "Only \"x-taler-bank\" target are supported": [
        ""
      ],
      "Only this host is allowed. Use \"%1$s\"": [
        ""
      ],
      "Account name is missing": [
        ""
      ],
      "Only \"IBAN\" target are supported": [
        ""
      ],
      "Missing \"amount\" parameter to specify the amount to be transferred": [
        ""
      ],
      "The \"amount\" parameter is not valid": [
        ""
      ],
      "\"message\" parameters to specify a reference text for the transfer are missing": [
        ""
      ],
      "The only currency allowed is \"%1$s\"": [
        ""
      ],
      "You cannot transfer an amount of zero.": [
        ""
      ],
      "The balance is not sufficient": [
        ""
      ],
      "Please enter a longer subject": [
        ""
      ],
      "Show withdrawal confirmation": [
        "Mostrar informació de retirada"
      ],
      "Withdraw without setting amount": [
        "Retirar sense fixar un import"
      ],
      "Hide demo hint.": [
        ""
      ],
      "Show install wallet first": [
        ""
      ],
      "Currently, the bank is not accepting new registrations!": [
        ""
      ],
      "The name is missing": [
        ""
      ],
      "Missing username": [
        ""
      ],
      "Missing password": [
        ""
      ],
      "The password should be longer than 8 letters": [
        ""
      ],
      "The passwords do not match": [
        ""
      ],
      "Server replied with invalid phone or email.": [
        ""
      ],
      "You are not authorised to create this account.": [
        ""
      ],
      "Registration is disabled because the bank ran out of bonus credit.": [
        ""
      ],
      "That username can't be used because is reserved.": [
        ""
      ],
      "That username is already taken.": [
        ""
      ],
      "That account ID is already taken.": [
        ""
      ],
      "No information for the selected authentication channel.": [
        ""
      ],
      "Authentication channel is not supported.": [
        ""
      ],
      "Only an administrator is allowed to set the debt limit.": [
        ""
      ],
      "Only the administrator can change the conversion rate.": [
        ""
      ],
      "The conversion rate class doesn't exist.": [
        ""
      ],
      "Only admin can create accounts with second factor authentication.": [
        ""
      ],
      "The password is too short. Can't have less than 8 characters.": [
        ""
      ],
      "The password is too long. Can't have more than 64 characters.": [
        ""
      ],
      "Account registration": [
        ""
      ],
      "Login username": [
        ""
      ],
      "Password": [
        ""
      ],
      "Use a strong password: 8 characters minimum, don't use any public information related to you (names, birthday, phone number, etc...) and mix lowercase, uppercase, symbols and numbers": [
        ""
      ],
      "Repeat password": [
        ""
      ],
      "Full name": [
        ""
      ],
      "Register": [
        ""
      ],
      "Create a random temporary user": [
        ""
      ],
      "You have no permission to this account.": [
        ""
      ],
      "Wrong credentials for \"%1$s\"": [
        ""
      ],
      "Account login.": [
        ""
      ],
      "Session expired": [
        ""
      ],
      "Username": [
        ""
      ],
      "Password of the account": [
        ""
      ],
      "Forget": [
        ""
      ],
      "Log in": [
        ""
      ],
      "Transactions history": [
        ""
      ],
      "No transactions yet.": [
        ""
      ],
      "You can make a transfer or a withdrawal to your wallet.": [
        ""
      ],
      "Date": [
        ""
      ],
      "Counterpart": [
        ""
      ],
      "sent": [
        ""
      ],
      "received": [
        ""
      ],
      "Invalid value": [
        ""
      ],
      "to": [
        ""
      ],
      "from": [
        ""
      ],
      "First page": [
        ""
      ],
      "Next": [
        ""
      ],
      "The withdrawal has been aborted previously and can't be confirmed": [
        ""
      ],
      "The withdrawal operation can't be confirmed before a wallet accepted the transaction.": [
        ""
      ],
      "The operation ID is invalid.": [
        ""
      ],
      "The operation was not found.": [
        ""
      ],
      "The starting withdrawal amount and the confirmation amount differs.": [
        ""
      ],
      "The bank requires a bank account which has not been specified yet.": [
        ""
      ],
      "Bad request": [
        ""
      ],
      "The withdrawal operation has been aborted.": [
        ""
      ],
      "The withdrawal operation has been confirmed previously and can’t be aborted.": [
        ""
      ],
      "Complete withdrawal.": [
        ""
      ],
      "Confirm the withdrawal operation": [
        ""
      ],
      "Wire transfer details": [
        ""
      ],
      "Payment Service Provider's account number": [
        ""
      ],
      "Payment Service Provider's name": [
        ""
      ],
      "Payment Service Provider's account bank hostname": [
        ""
      ],
      "Payment Service Provider's account id": [
        ""
      ],
      "Payment Service Provider's account address": [
        ""
      ],
      "No amount has yet been determined.": [
        ""
      ],
      "Transfer": [
        ""
      ],
      "Authentication required": [
        ""
      ],
      "This operation was created with another username": [
        ""
      ],
      "You are currently logged in with user \"%1$s\" and the operation was made with user \"%2$s\"": [
        ""
      ],
      "The reserve operation has been confirmed previously and can't be aborted": [
        ""
      ],
      "Wire transfer completed!": [
        ""
      ],
      "Confirm withdrawal.": [
        ""
      ],
      "Unauthorized to make the operation, maybe the session has expired or the password changed.": [
        ""
      ],
      "The operation was rejected due to insufficient funds.": [
        ""
      ],
      "Withdrawal confirmed": [
        ""
      ],
      "The wire transfer to the Payment Service Provider has been initiated. You will shortly receive the requested amount in your Taler wallet.": [
        ""
      ],
      "Do not show this again": [
        ""
      ],
      "If you have a Taler wallet installed on this device": [
        ""
      ],
      "Your wallet will display the details of the transaction including the fees (if applicable). If you do not yet have a wallet, please follow the instructions": [
        ""
      ],
      "on this page": [
        ""
      ],
      "Withdraw": [
        ""
      ],
      "In case you have a Taler wallet on another device": [
        ""
      ],
      "Scan the QR below to start the withdrawal.": [
        ""
      ],
      "There is an operation already pending": [
        ""
      ],
      "Complete the operation in": [
        ""
      ],
      "this page": [
        ""
      ],
      "The server replied with an invalid taler://withdraw URI": [
        ""
      ],
      "Withdraw URI: %1$s": [
        ""
      ],
      "The operation was rejected due to insufficient funds": [
        ""
      ],
      "Current balance is %1$s": [
        ""
      ],
      "You can withdraw up to %1$s": [
        ""
      ],
      "Continue": [
        ""
      ],
      "Use your Taler wallet": [
        ""
      ],
      "After using your wallet you will need to authorize or cancel the operation on this site.": [
        ""
      ],
      "You need a Taler wallet": [
        ""
      ],
      "If you don't have one yet you can follow the instruction in": [
        ""
      ],
      "Send money": [
        ""
      ],
      "to a Taler wallet": [
        ""
      ],
      "Withdraw digital money into your mobile wallet or browser extension": [
        ""
      ],
      "to another bank account": [
        ""
      ],
      "Make a wire transfer to an account with known bank account number.": [
        ""
      ],
      "This is a demo": [
        ""
      ],
      "This part of the demo shows how a bank that supports Taler directly would work. In addition to using your own bank account, you can also see the transaction history of some %1$s .": [
        ""
      ],
      "Here you will be able to see how a bank that supports Taler directly would work.": [
        ""
      ],
      "Internal error, please report. There should be more information in the console.": [
        ""
      ],
      "Internal error, please report.": [
        ""
      ],
      "Preferences": [
        ""
      ],
      "Welcome": [
        ""
      ],
      "Welcome, %1$s": [
        ""
      ],
      "No enough permission to access the conversion rate list.": [
        ""
      ],
      "Conversion list not found. Maybe conversion rate is not supported.": [
        ""
      ],
      "Conversion list not implemented.": [
        ""
      ],
      "Conversion rate classes": [
        ""
      ],
      "Create conversion rate class": [
        ""
      ],
      "No conversion rate class": [
        ""
      ],
      "Name": [
        ""
      ],
      "Description": [
        "Mostrar descripció de demostració"
      ],
      "Cashin": [
        ""
      ],
      "min:": [
        ""
      ],
      "fee:": [
        ""
      ],
      "Select a section": [
        ""
      ],
      "Details": [
        ""
      ],
      "Delete": [
        ""
      ],
      "Credentials": [
        ""
      ],
      "Cashouts": [
        ""
      ],
      "Conversion": [
        ""
      ],
      "only admin can setup conversion": [
        ""
      ],
      "Wrong credentials": [
        ""
      ],
      "Conversion is disabled": [
        ""
      ],
      "Config cashout": [
        ""
      ],
      "Config cashin": [
        ""
      ],
      "Bad ratios": [
        ""
      ],
      "One of the ratios should be higher or equal than 1 an the other should be lower or equal than 1.": [
        ""
      ],
      "Initial amount": [
        ""
      ],
      "Use it to test how the conversion will affect the amount.": [
        ""
      ],
      "Sending to this bank": [
        ""
      ],
      "Converted": [
        ""
      ],
      "Cashin after fee": [
        ""
      ],
      "Sending from this bank": [
        ""
      ],
      "Cashout after fee": [
        ""
      ],
      "Bad configuration": [
        ""
      ],
      "This configuration allows users to cash out more of what has been cashed in.": [
        ""
      ],
      "Update": [
        ""
      ],
      "Rnvalid": [
        ""
      ],
      "Must be > 0": [
        ""
      ],
      "Minimum amount": [
        ""
      ],
      "Only cashout operation above this threshold will be allowed.": [
        ""
      ],
      "Ratio": [
        ""
      ],
      "Conversion ratio between currencies": [
        ""
      ],
      "Example conversion": [
        ""
      ],
      "1 %1$s will be converted into %2$s %3$s": [
        ""
      ],
      "Tiny amount": [
        ""
      ],
      "Rounding mode": [
        ""
      ],
      "Zero": [
        ""
      ],
      "Amount will be round below to the largest possible value smaller than the input.": [
        ""
      ],
      "Up": [
        ""
      ],
      "Amount will be round up to the smallest possible value larger than the input.": [
        ""
      ],
      "Nearest": [
        ""
      ],
      "Amount will be round to the closest possible value.": [
        ""
      ],
      "If none specified the fallback value is \"%1$s \".": [
        ""
      ],
      "Examples": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.1": [
        ""
      ],
      "Given the rounding value of 0.1 the possible values closest to 1.24 are: 1.1, 1.2, 1.3, 1.4.": [
        ""
      ],
      "With the \"zero\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.2": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.1": [
        ""
      ],
      "With the \"nearest\" mode the value will be rounded to 1.3": [
        ""
      ],
      "Rounding an amount of 1.24 with rounding value 0.3": [
        ""
      ],
      "Given the rounding value of 0.3 the possible values closest to 1.24 are: 0.9, 1.2, 1.5, 1.8.": [
        ""
      ],
      "With the \"up\" mode the value will be rounded to 1.5": [
        ""
      ],
      "Rounding an amount of 1.26 with rounding value 0.3": [
        ""
      ],
      "Amount to be deducted before amount is credited.": [
        ""
      ],
      "Conversion should be enabled in the configuration, the conversion rate should be initialized with fee(s), rates and a rounding mode.": [
        ""
      ],
      "Unauthorized": [
        ""
      ],
      "Forbidden": [
        ""
      ],
      "NotFound": [
        ""
      ],
      "NotImplemented": [
        ""
      ],
      "Not Found": [
        ""
      ],
      "Not implemented": [
        ""
      ],
      "The name of the conversion is already used.": [
        ""
      ],
      "Conversion rate class": [
        ""
      ],
      "Accounts": [
        ""
      ],
      "Test": [
        ""
      ],
      "Users": [
        ""
      ],
      "Can't remove the conversion rate class": [
        ""
      ],
      "There are some user associated to this class. You need to remove them first.": [
        ""
      ],
      "You are going to remove the conversion rate class": [
        ""
      ],
      "This step can't be undone.": [
        ""
      ],
      "Filters": [
        ""
      ],
      "Show from other classes": [
        ""
      ],
      "Account": [
        ""
      ],
      "Group ID": [
        ""
      ],
      "No users in this conversion rate class": [
        ""
      ],
      "Class": [
        ""
      ],
      "Action": [
        ""
      ],
      "Remove": [
        ""
      ],
      "Add": [
        ""
      ],
      "Conversion rate name": [
        ""
      ],
      "Short description of the class": [
        ""
      ],
      "Conversion rate class created.": [
        ""
      ],
      "The rights to change the account are not sufficient": [
        ""
      ],
      "New conversion rate class": [
        ""
      ],
      "Create": [
        ""
      ],
      "History of public accounts": [
        ""
      ],
      "Make a wire transfer": [
        ""
      ],
      "Scan the QR code below to start the withdrawal.": [
        ""
      ],
      "Operation aborted": [
        ""
      ],
      "The wire transfer to the Payment Service Provider's account was aborted from somewhere else, your balance was not affected.": [
        ""
      ],
      "Go to your wallet now": [
        ""
      ],
      "The operation is marked as selected, but a process during the withdrawal failed": [
        ""
      ],
      "A withdrawal reserve ID was not found and no account has been selected.": [
        ""
      ],
      "There is a withdrawal reserve ID but no account has been selected or the selected account is invalid.": [
        ""
      ],
      "The account was selected, but no withdrawal reserve ID was found.": [
        ""
      ],
      "Operation not found": [
        ""
      ],
      "This process is not known to the server. The process ID is incorrect or the server has deleted the process information before it arrived here.": [
        ""
      ],
      "Continue to dashboard": [
        ""
      ],
      "The Withdrawal URI is not valid": [
        ""
      ],
      "Cashout should be enable by configuration and the conversion rate should be initialized with fee, ratio and rounding mode.": [
        ""
      ],
      "Latest cashouts": [
        ""
      ],
      "Created": [
        ""
      ],
      "Total debit": [
        ""
      ],
      "Total credit": [
        ""
      ],
      "Cashout for account %1$s": [
        ""
      ],
      "Doesn't have the pattern of an email": [
        ""
      ],
      "Should start with +": [
        ""
      ],
      "A phone number consists of numbers only": [
        ""
      ],
      "Account ID for authentication": [
        ""
      ],
      "Name of the account holder": [
        ""
      ],
      "Internal account": [
        ""
      ],
      "If this field is empty, a random account ID will be assigned": [
        ""
      ],
      "You can copy and share this IBAN number in order to receive wire transfers to your bank account": [
        ""
      ],
      "Email": [
        ""
      ],
      "To be used when second factor authentication is enabled": [
        ""
      ],
      "Phone": [
        ""
      ],
      "Enable second factor authentication": [
        ""
      ],
      "Using email": [
        ""
      ],
      "Add an email in your profile to enable this option": [
        ""
      ],
      "Using SMS": [
        ""
      ],
      "Add a phone number in your profile to enable this option": [
        ""
      ],
      "Cashout account": [
        ""
      ],
      "External account number where the money is going to be sent when doing cashouts": [
        ""
      ],
      "Max debt": [
        ""
      ],
      "How much the balance can go below zero.": [
        ""
      ],
      "Is this account public?": [
        ""
      ],
      "Public accounts have their balance publicly accessible": [
        ""
      ],
      "Does this account belong to a Payment Service Provider?": [
        ""
      ],
      "Account updated": [
        ""
      ],
      "The username was not found": [
        ""
      ],
      "You can't change the legal name, please contact the your account administrator.": [
        ""
      ],
      "You can't change the debt limit, please contact the your account administrator.": [
        ""
      ],
      "You can't change the cashout address, please contact the your account administrator.": [
        ""
      ],
      "Update account information.": [
        ""
      ],
      "Account \"%1$s\"": [
        ""
      ],
      "Removed": [
        ""
      ],
      "This account can't be used.": [
        ""
      ],
      "Change details": [
        ""
      ],
      "Merchant integration": [
        ""
      ],
      "Use this information to link your Taler Merchant Backoffice account with the current bank account. You can start by copying the values, then go to your merchant backoffice service provider, login into your account and look for the \"import\" button in the \"bank account\" section.": [
        ""
      ],
      "Account type": [
        ""
      ],
      "Method to use for wire transfer.": [
        ""
      ],
      "IBAN": [
        ""
      ],
      "International Bank Account Number.": [
        ""
      ],
      "Account name": [
        ""
      ],
      "Bank host where the service is located.": [
        ""
      ],
      "Bank account identifier for wire transfers.": [
        ""
      ],
      "Address": [
        ""
      ],
      "Owner's name": [
        ""
      ],
      "Legal name of the person holding the account.": [
        ""
      ],
      "Account info URL": [
        ""
      ],
      "From where the merchant can download information about incoming wire transfers to this account.": [
        ""
      ],
      "Repeated password doesn't match": [
        ""
      ],
      "Password changed": [
        ""
      ],
      "Not authorized to change the password, maybe the session is invalid.": [
        ""
      ],
      "You need to provide the old password. If you don't have it contact your account administrator.": [
        ""
      ],
      "Your current password doesn't match, can't change to a new password.": [
        ""
      ],
      "You don't have the rights to change the password.": [
        ""
      ],
      "Update account password.": [
        ""
      ],
      "Update password": [
        ""
      ],
      "Current password": [
        ""
      ],
      "Your current password, for security": [
        ""
      ],
      "New password": [
        ""
      ],
      "Type it again": [
        ""
      ],
      "Repeat the same password": [
        ""
      ],
      "Change": [
        ""
      ],
      "Create account": [
        ""
      ],
      "Actions": [
        ""
      ],
      "Unknown": [
        ""
      ],
      "Change password": [
        ""
      ],
      "Querying for the current stats failed": [
        ""
      ],
      "The request parameters are wrong": [
        ""
      ],
      "The user is unauthorized": [
        ""
      ],
      "Querying for the previous stats failed": [
        ""
      ],
      "Transaction volume report": [
        ""
      ],
      "Last hour": [
        ""
      ],
      "Previous day": [
        ""
      ],
      "Last month": [
        ""
      ],
      "Last year": [
        ""
      ],
      "Last Year": [
        ""
      ],
      "Trading volume from %1$s to %2$s": [
        ""
      ],
      "Transferred from an external account to an account in this bank.": [
        ""
      ],
      "Transferred from an account in this bank to an external account.": [
        ""
      ],
      "Payin": [
        ""
      ],
      "Transferred from an account to a Taler exchange.": [
        ""
      ],
      "Payout": [
        ""
      ],
      "Transferred from a Taler exchange to another account.": [
        ""
      ],
      "Download stats as CSV": [
        ""
      ],
      "previous": [
        ""
      ],
      "Decreased by": [
        ""
      ],
      "Increased by": [
        ""
      ],
      "Account created with password \"%1$s\".": [
        ""
      ],
      "Server replied that phone or email is invalid": [
        ""
      ],
      "The rights to perform the operation are not sufficient": [
        ""
      ],
      "Account username is already taken": [
        ""
      ],
      "Account ID is already taken": [
        ""
      ],
      "Bank ran out of bonus credit.": [
        ""
      ],
      "Account username can't be used because is reserved": [
        ""
      ],
      "Can't create accounts": [
        ""
      ],
      "Only system admin can create accounts.": [
        ""
      ],
      "New bank account": [
        ""
      ],
      "only admin can download stats": [
        ""
      ],
      "Download bank stats": [
        ""
      ],
      "Include hour metric": [
        ""
      ],
      "Include day metric": [
        ""
      ],
      "Include month metric": [
        ""
      ],
      "Include year metric": [
        ""
      ],
      "Include table header": [
        ""
      ],
      "Add previous metric for compare": [
        ""
      ],
      "Fail on first error": [
        ""
      ],
      "Download": [
        ""
      ],
      "downloading... %1$s": [
        ""
      ],
      "Download completed": [
        ""
      ],
      "Click here to save the file in your computer.": [
        ""
      ],
      "there was an error reading the balance": [
        ""
      ],
      "Can't delete the account": [
        ""
      ],
      "The account can't be delete while still holding some balance. First make sure that the owner make a complete cashout.": [
        ""
      ],
      "Name doesn't match": [
        ""
      ],
      "Account removed": [
        ""
      ],
      "No enough permission to delete the account.": [
        ""
      ],
      "The username was not found.": [
        ""
      ],
      "Can't delete a reserved username.": [
        ""
      ],
      "Can't delete an account with balance different than zero.": [
        ""
      ],
      "Remove account.": [
        ""
      ],
      "You are going to remove the account": [
        ""
      ],
      "Deleting account \"%1$s\"": [
        ""
      ],
      "Verification": [
        ""
      ],
      "Enter the account name that is going to be deleted": [
        ""
      ],
      "Cashout id should be a number": [
        ""
      ],
      "This cashout not found. Maybe already aborted.": [
        ""
      ],
      "Cashout detail": [
        ""
      ],
      "Debited": [
        ""
      ],
      "Transferred": [
        ""
      ],
      "This account is locked. If you have a active session you can change the password or contact the administrator.": [
        ""
      ],
      "New web session": [
        ""
      ],
      "Welcome to %1$s!": [
        ""
      ]
    }
  },
  "domain": "messages",
  "plural_forms": "nplurals=2; plural=n != 1;",
  "lang": "ca",
  "completeness": 0
};

