// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package daemon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetDebuginfoReader is a Reader for the GetDebuginfo structure.
type GetDebuginfoReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDebuginfoReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDebuginfoOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewGetDebuginfoFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /debuginfo] GetDebuginfo", response, response.Code())
	}
}

// NewGetDebuginfoOK creates a GetDebuginfoOK with default headers values
func NewGetDebuginfoOK() *GetDebuginfoOK {
	return &GetDebuginfoOK{}
}

/*
GetDebuginfoOK describes a response with status code 200, with default header values.

Success
*/
type GetDebuginfoOK struct {
	Payload *models.DebugInfo
}

// IsSuccess returns true when this get debuginfo o k response has a 2xx status code
func (o *GetDebuginfoOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get debuginfo o k response has a 3xx status code
func (o *GetDebuginfoOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get debuginfo o k response has a 4xx status code
func (o *GetDebuginfoOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get debuginfo o k response has a 5xx status code
func (o *GetDebuginfoOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get debuginfo o k response a status code equal to that given
func (o *GetDebuginfoOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get debuginfo o k response
func (o *GetDebuginfoOK) Code() int {
	return 200
}

func (o *GetDebuginfoOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /debuginfo][%d] getDebuginfoOK %s", 200, payload)
}

func (o *GetDebuginfoOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /debuginfo][%d] getDebuginfoOK %s", 200, payload)
}

func (o *GetDebuginfoOK) GetPayload() *models.DebugInfo {
	return o.Payload
}

func (o *GetDebuginfoOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DebugInfo)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDebuginfoFailure creates a GetDebuginfoFailure with default headers values
func NewGetDebuginfoFailure() *GetDebuginfoFailure {
	return &GetDebuginfoFailure{}
}

/*
GetDebuginfoFailure describes a response with status code 500, with default header values.

DebugInfo get failed
*/
type GetDebuginfoFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this get debuginfo failure response has a 2xx status code
func (o *GetDebuginfoFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get debuginfo failure response has a 3xx status code
func (o *GetDebuginfoFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get debuginfo failure response has a 4xx status code
func (o *GetDebuginfoFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this get debuginfo failure response has a 5xx status code
func (o *GetDebuginfoFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this get debuginfo failure response a status code equal to that given
func (o *GetDebuginfoFailure) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get debuginfo failure response
func (o *GetDebuginfoFailure) Code() int {
	return 500
}

func (o *GetDebuginfoFailure) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /debuginfo][%d] getDebuginfoFailure %s", 500, payload)
}

func (o *GetDebuginfoFailure) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /debuginfo][%d] getDebuginfoFailure %s", 500, payload)
}

func (o *GetDebuginfoFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *GetDebuginfoFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
