# frozen_string_literal: true

require 'spec_helper'
require 'net/ldap'
require 'msf/core/exploit/remote/ldap/active_directory'

RSpec.describe Msf::Exploit::Remote::LDAP::ActiveDirectory do
  subject(:helper) { Object.new.extend(described_class) }

  describe '#adds_get_object_by_samaccountname' do
    it 'returns nil without querying LDAP when a miss is cached' do
      ldap = Object.new
      helper.ldap_entry_cache.mark_missing_by_samaccountname('missing')

      expect(helper.adds_get_object_by_samaccountname(ldap, 'missing')).to be_nil
    end
  end

  describe '#adds_get_object_by_sid' do
    it 'returns nil without querying LDAP when a miss is cached' do
      ldap = Object.new
      helper.ldap_entry_cache.mark_missing_by_sid('S-1-5-21-111111111-222222222-333333333-4444')

      expect(helper.adds_get_object_by_sid(ldap, 'S-1-5-21-111111111-222222222-333333333-4444')).to be_nil
    end
  end

  describe '#adds_get_object_by_dn' do
    it 'returns nil without querying LDAP when a miss is cached' do
      ldap = Object.new
      helper.ldap_entry_cache.mark_missing_by_dn('cn=Missing,dc=example,dc=com')

      expect(helper.adds_get_object_by_dn(ldap, 'cn=Missing,dc=example,dc=com')).to be_nil
    end
  end
end
