# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
import datetime
from io import IOBase
import json
from typing import Any, AsyncIterator, Callable, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient, MatchConditions
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.serialization import Deserializer, Serializer
from ...operations._operations import (
    build_dps_certificate_create_or_update_request,
    build_dps_certificate_delete_request,
    build_dps_certificate_generate_verification_code_request,
    build_dps_certificate_get_request,
    build_dps_certificate_list_request,
    build_dps_certificate_verify_certificate_request,
    build_iot_dps_resource_check_provisioning_service_name_availability_request,
    build_iot_dps_resource_create_or_update_private_endpoint_connection_request,
    build_iot_dps_resource_create_or_update_request,
    build_iot_dps_resource_delete_private_endpoint_connection_request,
    build_iot_dps_resource_delete_request,
    build_iot_dps_resource_get_operation_result_request,
    build_iot_dps_resource_get_private_endpoint_connection_request,
    build_iot_dps_resource_get_private_link_resources_request,
    build_iot_dps_resource_get_request,
    build_iot_dps_resource_list_by_resource_group_request,
    build_iot_dps_resource_list_by_subscription_request,
    build_iot_dps_resource_list_keys_for_key_name_request,
    build_iot_dps_resource_list_keys_request,
    build_iot_dps_resource_list_private_endpoint_connections_request,
    build_iot_dps_resource_list_private_link_resources_request,
    build_iot_dps_resource_list_valid_skus_request,
    build_iot_dps_resource_update_request,
    build_operations_list_request,
)
from .._configuration import IotDpsClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]
List = list


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.iothubprovisioningservices.aio.IotDpsClient`'s
        :attr:`operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: IotDpsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncItemPaged["_models.Operation"]:
        """List the operations for the provider.

        :return: An iterator like instance of Operation
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothubprovisioningservices.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorDetails, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class DpsCertificateOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.iothubprovisioningservices.aio.IotDpsClient`'s
        :attr:`dps_certificate` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: IotDpsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Get the certificate from the provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CertificateResponse] = kwargs.pop("cls", None)

        _request = build_dps_certificate_get_request(
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            certificate_name=certificate_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        certificate_description: _models.CertificateResponse,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Add new certificate or update an existing certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param certificate_description: The certificate body. Required.
        :type certificate_description:
         ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        certificate_description: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Add new certificate or update an existing certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param certificate_description: The certificate body. Required.
        :type certificate_description: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        certificate_description: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Add new certificate or update an existing certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param certificate_description: The certificate body. Required.
        :type certificate_description: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        certificate_description: Union[_models.CertificateResponse, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Add new certificate or update an existing certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param certificate_description: The certificate body. Is one of the following types:
         CertificateResponse, JSON, IO[bytes] Required.
        :type certificate_description:
         ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse or JSON or IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(certificate_description, (IOBase, bytes)):
            _content = certificate_description
        else:
            _content = json.dumps(certificate_description, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_dps_certificate_create_or_update_request(
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            certificate_name=certificate_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        *,
        etag: str,
        match_condition: MatchConditions,
        certificate_name1: Optional[str] = None,
        certificate_raw_bytes: Optional[bytes] = None,
        certificate_is_verified: Optional[bool] = None,
        certificate_purpose: Optional[Union[str, _models.CertificatePurpose]] = None,
        certificate_created: Optional[datetime.datetime] = None,
        certificate_last_updated: Optional[datetime.datetime] = None,
        certificate_has_private_key: Optional[bool] = None,
        certificate_nonce: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Deletes the specified certificate associated with the Provisioning Service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Required.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Required.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword certificate_name1: This is optional, and it is the Common Name of the certificate.
         Default value is None.
        :paramtype certificate_name1: str
        :keyword certificate_raw_bytes: Raw data within the certificate. Default value is None.
        :paramtype certificate_raw_bytes: bytes
        :keyword certificate_is_verified: Indicates if certificate has been verified by owner of the
         private key. Default value is None.
        :paramtype certificate_is_verified: bool
        :keyword certificate_purpose: A description that mentions the purpose of the certificate. Known
         values are: "clientAuthentication" and "serverAuthentication". Default value is None.
        :paramtype certificate_purpose: str or
         ~azure.mgmt.iothubprovisioningservices.models.CertificatePurpose
        :keyword certificate_created: Time the certificate is created. Default value is None.
        :paramtype certificate_created: ~datetime.datetime
        :keyword certificate_last_updated: Certificate last updated time. Default value is None.
        :paramtype certificate_last_updated: ~datetime.datetime
        :keyword certificate_has_private_key: Indicates if the certificate contains a private key.
         Default value is None.
        :paramtype certificate_has_private_key: bool
        :keyword certificate_nonce: Random number generated to indicate Proof of Possession. Default
         value is None.
        :paramtype certificate_nonce: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_dps_certificate_delete_request(
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            certificate_name=certificate_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            certificate_name1=certificate_name1,
            certificate_raw_bytes=certificate_raw_bytes,
            certificate_is_verified=certificate_is_verified,
            certificate_purpose=certificate_purpose,
            certificate_created=certificate_created,
            certificate_last_updated=certificate_last_updated,
            certificate_has_private_key=certificate_has_private_key,
            certificate_nonce=certificate_nonce,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list(
        self, resource_group_name: str, provisioning_service_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.CertificateResponse"]:
        """Get all the certificates tied to the provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :return: An iterator like instance of CertificateResponse
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothubprovisioningservices.models.CertificateResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CertificateResponse]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dps_certificate_list_request(
                    resource_group_name=resource_group_name,
                    provisioning_service_name=provisioning_service_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.CertificateResponse], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorDetails, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def generate_verification_code(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        *,
        etag: str,
        match_condition: MatchConditions,
        certificate_name1: Optional[str] = None,
        certificate_raw_bytes: Optional[bytes] = None,
        certificate_is_verified: Optional[bool] = None,
        certificate_purpose: Optional[Union[str, _models.CertificatePurpose]] = None,
        certificate_created: Optional[datetime.datetime] = None,
        certificate_last_updated: Optional[datetime.datetime] = None,
        certificate_has_private_key: Optional[bool] = None,
        certificate_nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.VerificationCodeResponse:
        """Generate verification code for Proof of Possession.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Required.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Required.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword certificate_name1: Common Name for the certificate. Default value is None.
        :paramtype certificate_name1: str
        :keyword certificate_raw_bytes: Raw data of certificate. Default value is None.
        :paramtype certificate_raw_bytes: bytes
        :keyword certificate_is_verified: Indicates if the certificate has been verified by owner of
         the private key. Default value is None.
        :paramtype certificate_is_verified: bool
        :keyword certificate_purpose: Description mentioning the purpose of the certificate. Known
         values are: "clientAuthentication" and "serverAuthentication". Default value is None.
        :paramtype certificate_purpose: str or
         ~azure.mgmt.iothubprovisioningservices.models.CertificatePurpose
        :keyword certificate_created: Time the certificate is created. Default value is None.
        :paramtype certificate_created: ~datetime.datetime
        :keyword certificate_last_updated: Certificate last updated time. Default value is None.
        :paramtype certificate_last_updated: ~datetime.datetime
        :keyword certificate_has_private_key: Indicates if the certificate contains private key.
         Default value is None.
        :paramtype certificate_has_private_key: bool
        :keyword certificate_nonce: Random number generated to indicate Proof of Possession. Default
         value is None.
        :paramtype certificate_nonce: str
        :return: VerificationCodeResponse. The VerificationCodeResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.VerificationCodeResponse] = kwargs.pop("cls", None)

        _request = build_dps_certificate_generate_verification_code_request(
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            certificate_name=certificate_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            certificate_name1=certificate_name1,
            certificate_raw_bytes=certificate_raw_bytes,
            certificate_is_verified=certificate_is_verified,
            certificate_purpose=certificate_purpose,
            certificate_created=certificate_created,
            certificate_last_updated=certificate_last_updated,
            certificate_has_private_key=certificate_has_private_key,
            certificate_nonce=certificate_nonce,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.VerificationCodeResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_certificate(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        request: _models.VerificationCodeRequest,
        *,
        etag: str,
        match_condition: MatchConditions,
        certificate_name1: Optional[str] = None,
        certificate_raw_bytes: Optional[bytes] = None,
        certificate_is_verified: Optional[bool] = None,
        certificate_purpose: Optional[Union[str, _models.CertificatePurpose]] = None,
        certificate_created: Optional[datetime.datetime] = None,
        certificate_last_updated: Optional[datetime.datetime] = None,
        certificate_has_private_key: Optional[bool] = None,
        certificate_nonce: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Verifies the certificate's private key possession by providing the leaf cert issued by the
        verifying pre uploaded certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param request: The name of the certificate. Required.
        :type request: ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeRequest
        :keyword etag: check if resource is changed. Set None to skip checking etag. Required.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Required.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword certificate_name1: Common Name for the certificate. Default value is None.
        :paramtype certificate_name1: str
        :keyword certificate_raw_bytes: Raw data of certificate. Default value is None.
        :paramtype certificate_raw_bytes: bytes
        :keyword certificate_is_verified: Indicates if the certificate has been verified by owner of
         the private key. Default value is None.
        :paramtype certificate_is_verified: bool
        :keyword certificate_purpose: Describe the purpose of the certificate. Known values are:
         "clientAuthentication" and "serverAuthentication". Default value is None.
        :paramtype certificate_purpose: str or
         ~azure.mgmt.iothubprovisioningservices.models.CertificatePurpose
        :keyword certificate_created: Time the certificate is created. Default value is None.
        :paramtype certificate_created: ~datetime.datetime
        :keyword certificate_last_updated: Certificate last updated time. Default value is None.
        :paramtype certificate_last_updated: ~datetime.datetime
        :keyword certificate_has_private_key: Indicates if the certificate contains private key.
         Default value is None.
        :paramtype certificate_has_private_key: bool
        :keyword certificate_nonce: Random number generated to indicate Proof of Possession. Default
         value is None.
        :paramtype certificate_nonce: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify_certificate(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        request: JSON,
        *,
        etag: str,
        match_condition: MatchConditions,
        certificate_name1: Optional[str] = None,
        certificate_raw_bytes: Optional[bytes] = None,
        certificate_is_verified: Optional[bool] = None,
        certificate_purpose: Optional[Union[str, _models.CertificatePurpose]] = None,
        certificate_created: Optional[datetime.datetime] = None,
        certificate_last_updated: Optional[datetime.datetime] = None,
        certificate_has_private_key: Optional[bool] = None,
        certificate_nonce: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Verifies the certificate's private key possession by providing the leaf cert issued by the
        verifying pre uploaded certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param request: The name of the certificate. Required.
        :type request: JSON
        :keyword etag: check if resource is changed. Set None to skip checking etag. Required.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Required.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword certificate_name1: Common Name for the certificate. Default value is None.
        :paramtype certificate_name1: str
        :keyword certificate_raw_bytes: Raw data of certificate. Default value is None.
        :paramtype certificate_raw_bytes: bytes
        :keyword certificate_is_verified: Indicates if the certificate has been verified by owner of
         the private key. Default value is None.
        :paramtype certificate_is_verified: bool
        :keyword certificate_purpose: Describe the purpose of the certificate. Known values are:
         "clientAuthentication" and "serverAuthentication". Default value is None.
        :paramtype certificate_purpose: str or
         ~azure.mgmt.iothubprovisioningservices.models.CertificatePurpose
        :keyword certificate_created: Time the certificate is created. Default value is None.
        :paramtype certificate_created: ~datetime.datetime
        :keyword certificate_last_updated: Certificate last updated time. Default value is None.
        :paramtype certificate_last_updated: ~datetime.datetime
        :keyword certificate_has_private_key: Indicates if the certificate contains private key.
         Default value is None.
        :paramtype certificate_has_private_key: bool
        :keyword certificate_nonce: Random number generated to indicate Proof of Possession. Default
         value is None.
        :paramtype certificate_nonce: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify_certificate(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        request: IO[bytes],
        *,
        etag: str,
        match_condition: MatchConditions,
        certificate_name1: Optional[str] = None,
        certificate_raw_bytes: Optional[bytes] = None,
        certificate_is_verified: Optional[bool] = None,
        certificate_purpose: Optional[Union[str, _models.CertificatePurpose]] = None,
        certificate_created: Optional[datetime.datetime] = None,
        certificate_last_updated: Optional[datetime.datetime] = None,
        certificate_has_private_key: Optional[bool] = None,
        certificate_nonce: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Verifies the certificate's private key possession by providing the leaf cert issued by the
        verifying pre uploaded certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param request: The name of the certificate. Required.
        :type request: IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Required.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Required.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword certificate_name1: Common Name for the certificate. Default value is None.
        :paramtype certificate_name1: str
        :keyword certificate_raw_bytes: Raw data of certificate. Default value is None.
        :paramtype certificate_raw_bytes: bytes
        :keyword certificate_is_verified: Indicates if the certificate has been verified by owner of
         the private key. Default value is None.
        :paramtype certificate_is_verified: bool
        :keyword certificate_purpose: Describe the purpose of the certificate. Known values are:
         "clientAuthentication" and "serverAuthentication". Default value is None.
        :paramtype certificate_purpose: str or
         ~azure.mgmt.iothubprovisioningservices.models.CertificatePurpose
        :keyword certificate_created: Time the certificate is created. Default value is None.
        :paramtype certificate_created: ~datetime.datetime
        :keyword certificate_last_updated: Certificate last updated time. Default value is None.
        :paramtype certificate_last_updated: ~datetime.datetime
        :keyword certificate_has_private_key: Indicates if the certificate contains private key.
         Default value is None.
        :paramtype certificate_has_private_key: bool
        :keyword certificate_nonce: Random number generated to indicate Proof of Possession. Default
         value is None.
        :paramtype certificate_nonce: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def verify_certificate(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        certificate_name: str,
        request: Union[_models.VerificationCodeRequest, JSON, IO[bytes]],
        *,
        etag: str,
        match_condition: MatchConditions,
        certificate_name1: Optional[str] = None,
        certificate_raw_bytes: Optional[bytes] = None,
        certificate_is_verified: Optional[bool] = None,
        certificate_purpose: Optional[Union[str, _models.CertificatePurpose]] = None,
        certificate_created: Optional[datetime.datetime] = None,
        certificate_last_updated: Optional[datetime.datetime] = None,
        certificate_has_private_key: Optional[bool] = None,
        certificate_nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CertificateResponse:
        """Verifies the certificate's private key possession by providing the leaf cert issued by the
        verifying pre uploaded certificate.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param certificate_name: Name of the certificate to retrieve. Required.
        :type certificate_name: str
        :param request: The name of the certificate. Is one of the following types:
         VerificationCodeRequest, JSON, IO[bytes] Required.
        :type request: ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeRequest or JSON or
         IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Required.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Required.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword certificate_name1: Common Name for the certificate. Default value is None.
        :paramtype certificate_name1: str
        :keyword certificate_raw_bytes: Raw data of certificate. Default value is None.
        :paramtype certificate_raw_bytes: bytes
        :keyword certificate_is_verified: Indicates if the certificate has been verified by owner of
         the private key. Default value is None.
        :paramtype certificate_is_verified: bool
        :keyword certificate_purpose: Describe the purpose of the certificate. Known values are:
         "clientAuthentication" and "serverAuthentication". Default value is None.
        :paramtype certificate_purpose: str or
         ~azure.mgmt.iothubprovisioningservices.models.CertificatePurpose
        :keyword certificate_created: Time the certificate is created. Default value is None.
        :paramtype certificate_created: ~datetime.datetime
        :keyword certificate_last_updated: Certificate last updated time. Default value is None.
        :paramtype certificate_last_updated: ~datetime.datetime
        :keyword certificate_has_private_key: Indicates if the certificate contains private key.
         Default value is None.
        :paramtype certificate_has_private_key: bool
        :keyword certificate_nonce: Random number generated to indicate Proof of Possession. Default
         value is None.
        :paramtype certificate_nonce: str
        :return: CertificateResponse. The CertificateResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.CertificateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _content = json.dumps(request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_dps_certificate_verify_certificate_request(
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            certificate_name=certificate_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            certificate_name1=certificate_name1,
            certificate_raw_bytes=certificate_raw_bytes,
            certificate_is_verified=certificate_is_verified,
            certificate_purpose=certificate_purpose,
            certificate_created=certificate_created,
            certificate_last_updated=certificate_last_updated,
            certificate_has_private_key=certificate_has_private_key,
            certificate_nonce=certificate_nonce,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class IotDpsResourceOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.iothubprovisioningservices.aio.IotDpsClient`'s
        :attr:`iot_dps_resource` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: IotDpsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_operation_result(
        self,
        operation_id: str,
        resource_group_name: str,
        provisioning_service_name: str,
        *,
        asyncinfo: str,
        **kwargs: Any
    ) -> _models.AsyncOperationResult:
        """Gets the status of a long running operation, such as create, update or delete a provisioning
        service.

        :param operation_id: Operation id corresponding to long running operation. Use this to poll for
         the status. Required.
        :type operation_id: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :keyword asyncinfo: Async header used to poll on the status of the operation, obtained while
         creating the long running operation. Required.
        :paramtype asyncinfo: str
        :return: AsyncOperationResult. The AsyncOperationResult is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.AsyncOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AsyncOperationResult] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_get_operation_result_request(
            operation_id=operation_id,
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            asyncinfo=asyncinfo,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AsyncOperationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self, provisioning_service_name: str, resource_group_name: str, **kwargs: Any
    ) -> _models.ProvisioningServiceDescription:
        """Get the metadata of the provisioning service without SAS keys.

        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: ProvisioningServiceDescription. The ProvisioningServiceDescription is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ProvisioningServiceDescription] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_get_request(
            provisioning_service_name=provisioning_service_name,
            resource_group_name=resource_group_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ProvisioningServiceDescription, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        iot_dps_description: Union[_models.ProvisioningServiceDescription, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(iot_dps_description, (IOBase, bytes)):
            _content = iot_dps_description
        else:
            _content = json.dumps(iot_dps_description, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_iot_dps_resource_create_or_update_request(
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 201:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        iot_dps_description: _models.ProvisioningServiceDescription,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Create or update the metadata of the provisioning service. The usual pattern to modify a
        property is to retrieve the provisioning service metadata and security metadata, and then
        combine them with the modified values in a new body to update the provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param iot_dps_description: Description of the provisioning service to create or update.
         Required.
        :type iot_dps_description:
         ~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        iot_dps_description: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Create or update the metadata of the provisioning service. The usual pattern to modify a
        property is to retrieve the provisioning service metadata and security metadata, and then
        combine them with the modified values in a new body to update the provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param iot_dps_description: Description of the provisioning service to create or update.
         Required.
        :type iot_dps_description: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        iot_dps_description: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Create or update the metadata of the provisioning service. The usual pattern to modify a
        property is to retrieve the provisioning service metadata and security metadata, and then
        combine them with the modified values in a new body to update the provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param iot_dps_description: Description of the provisioning service to create or update.
         Required.
        :type iot_dps_description: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        iot_dps_description: Union[_models.ProvisioningServiceDescription, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Create or update the metadata of the provisioning service. The usual pattern to modify a
        property is to retrieve the provisioning service metadata and security metadata, and then
        combine them with the modified values in a new body to update the provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param iot_dps_description: Description of the provisioning service to create or update. Is one
         of the following types: ProvisioningServiceDescription, JSON, IO[bytes] Required.
        :type iot_dps_description:
         ~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription or JSON or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProvisioningServiceDescription] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                provisioning_service_name=provisioning_service_name,
                iot_dps_description=iot_dps_description,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.ProvisioningServiceDescription, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ProvisioningServiceDescription].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ProvisioningServiceDescription](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_initial(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        provisioning_service_tags: Union[_models.TagsResource, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(provisioning_service_tags, (IOBase, bytes)):
            _content = provisioning_service_tags
        else:
            _content = json.dumps(provisioning_service_tags, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_iot_dps_resource_update_request(
            resource_group_name=resource_group_name,
            provisioning_service_name=provisioning_service_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        provisioning_service_tags: _models.TagsResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Update an existing provisioning service's tags. to update other fields use the CreateOrUpdate
        method.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param provisioning_service_tags: Updated tag information to set into the provisioning service
         instance. Required.
        :type provisioning_service_tags: ~azure.mgmt.iothubprovisioningservices.models.TagsResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        provisioning_service_tags: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Update an existing provisioning service's tags. to update other fields use the CreateOrUpdate
        method.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param provisioning_service_tags: Updated tag information to set into the provisioning service
         instance. Required.
        :type provisioning_service_tags: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        provisioning_service_tags: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Update an existing provisioning service's tags. to update other fields use the CreateOrUpdate
        method.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param provisioning_service_tags: Updated tag information to set into the provisioning service
         instance. Required.
        :type provisioning_service_tags: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        provisioning_service_name: str,
        provisioning_service_tags: Union[_models.TagsResource, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ProvisioningServiceDescription]:
        """Update an existing provisioning service's tags. to update other fields use the CreateOrUpdate
        method.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param provisioning_service_tags: Updated tag information to set into the provisioning service
         instance. Is one of the following types: TagsResource, JSON, IO[bytes] Required.
        :type provisioning_service_tags: ~azure.mgmt.iothubprovisioningservices.models.TagsResource or
         JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns ProvisioningServiceDescription. The
         ProvisioningServiceDescription is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProvisioningServiceDescription] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                provisioning_service_name=provisioning_service_name,
                provisioning_service_tags=provisioning_service_tags,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

            deserialized = _deserialize(_models.ProvisioningServiceDescription, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ProvisioningServiceDescription].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ProvisioningServiceDescription](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_initial(
        self, provisioning_service_name: str, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_delete_request(
            provisioning_service_name=provisioning_service_name,
            resource_group_name=resource_group_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204, 404]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, provisioning_service_name: str, resource_group_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the Provisioning Service.

        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                provisioning_service_name=provisioning_service_name,
                resource_group_name=resource_group_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.ProvisioningServiceDescription"]:
        """Get a list of all provisioning services in the given resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of ProvisioningServiceDescription
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ProvisioningServiceDescription]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_iot_dps_resource_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ProvisioningServiceDescription], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorDetails, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncItemPaged["_models.ProvisioningServiceDescription"]:
        """List all the provisioning services for a given subscription id.

        :return: An iterator like instance of ProvisioningServiceDescription
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ProvisioningServiceDescription]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_iot_dps_resource_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ProvisioningServiceDescription], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorDetails, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_valid_skus(
        self, provisioning_service_name: str, resource_group_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.IotDpsSkuDefinition"]:
        """Gets the list of valid SKUs and tiers for a provisioning service.

        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of IotDpsSkuDefinition
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothubprovisioningservices.models.IotDpsSkuDefinition]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.IotDpsSkuDefinition]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_iot_dps_resource_list_valid_skus_request(
                    provisioning_service_name=provisioning_service_name,
                    resource_group_name=resource_group_name,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.IotDpsSkuDefinition], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorDetails, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_keys(
        self, provisioning_service_name: str, resource_group_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription"]:
        """List the primary and secondary keys for a provisioning service.

        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of
         SharedAccessSignatureAuthorizationRuleAccessRightsDescription
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]] = kwargs.pop(
            "cls", None
        )

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_iot_dps_resource_list_keys_request(
                    provisioning_service_name=provisioning_service_name,
                    resource_group_name=resource_group_name,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(
                List[_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription],
                deserialized.get("value", []),
            )
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorDetails, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def list_keys_for_key_name(
        self, provisioning_service_name: str, key_name: str, resource_group_name: str, **kwargs: Any
    ) -> _models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription:
        """List primary and secondary keys for a specific key name.

        :param provisioning_service_name: Name of the provisioning service to retrieve. Required.
        :type provisioning_service_name: str
        :param key_name: Logical key name to get key-values for. Required.
        :type key_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: SharedAccessSignatureAuthorizationRuleAccessRightsDescription. The
         SharedAccessSignatureAuthorizationRuleAccessRightsDescription is compatible with MutableMapping
        :rtype:
         ~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_list_keys_for_key_name_request(
            provisioning_service_name=provisioning_service_name,
            key_name=key_name,
            resource_group_name=resource_group_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription, response.json()
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_private_link_resources(
        self, resource_group_name: str, resource_name: str, group_id: str, **kwargs: Any
    ) -> _models.GroupIdInformation:
        """Get the specified private link resource for the given provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :param group_id: The name of the private link resource. Required.
        :type group_id: str
        :return: GroupIdInformation. The GroupIdInformation is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.GroupIdInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupIdInformation] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_get_private_link_resources_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            group_id=group_id,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GroupIdInformation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_private_link_resources(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.GroupIdInformation"]:
        """List private link resources for the given provisioning service.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :return: An iterator like instance of GroupIdInformation
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothubprovisioningservices.models.GroupIdInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.GroupIdInformation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_iot_dps_resource_list_private_link_resources_request(
                    resource_group_name=resource_group_name,
                    resource_name=resource_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.GroupIdInformation], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorDetails, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_private_endpoint_connection(
        self, resource_group_name: str, resource_name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> _models.PrivateEndpointConnection:
        """Get private endpoint connection properties.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :param private_endpoint_connection_name: The name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :return: PrivateEndpointConnection. The PrivateEndpointConnection is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PrivateEndpointConnection] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_get_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PrivateEndpointConnection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_private_endpoint_connection_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        resource_name: str,
        private_endpoint_connection_name: str,
        private_endpoint_connection: Union[_models.PrivateEndpointConnection, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(private_endpoint_connection, (IOBase, bytes)):
            _content = private_endpoint_connection
        else:
            _content = json.dumps(private_endpoint_connection, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_iot_dps_resource_create_or_update_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 201:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        resource_name: str,
        private_endpoint_connection_name: str,
        private_endpoint_connection: _models.PrivateEndpointConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Create or update the status of a private endpoint connection with the specified name.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :param private_endpoint_connection_name: The name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_connection: The private endpoint connection with updated properties.
         Required.
        :type private_endpoint_connection:
         ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        resource_name: str,
        private_endpoint_connection_name: str,
        private_endpoint_connection: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Create or update the status of a private endpoint connection with the specified name.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :param private_endpoint_connection_name: The name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_connection: The private endpoint connection with updated properties.
         Required.
        :type private_endpoint_connection: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        resource_name: str,
        private_endpoint_connection_name: str,
        private_endpoint_connection: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Create or update the status of a private endpoint connection with the specified name.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :param private_endpoint_connection_name: The name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_connection: The private endpoint connection with updated properties.
         Required.
        :type private_endpoint_connection: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        resource_name: str,
        private_endpoint_connection_name: str,
        private_endpoint_connection: Union[_models.PrivateEndpointConnection, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Create or update the status of a private endpoint connection with the specified name.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :param private_endpoint_connection_name: The name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_connection: The private endpoint connection with updated properties. Is
         one of the following types: PrivateEndpointConnection, JSON, IO[bytes] Required.
        :type private_endpoint_connection:
         ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PrivateEndpointConnection] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                resource_name=resource_name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                private_endpoint_connection=private_endpoint_connection,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.PrivateEndpointConnection, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.PrivateEndpointConnection].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.PrivateEndpointConnection](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_private_endpoint_connection_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, resource_name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_delete_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_private_endpoint_connection(
        self, resource_group_name: str, resource_name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Delete private endpoint connection with the specified name.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :param private_endpoint_connection_name: The name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PrivateEndpointConnection] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                resource_name=resource_name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.PrivateEndpointConnection, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.PrivateEndpointConnection].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.PrivateEndpointConnection](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def list_private_endpoint_connections(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> List[_models.PrivateEndpointConnection]:
        """List private endpoint connection properties.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: Name of the provisioning service to retrieve. Required.
        :type resource_name: str
        :return: list of PrivateEndpointConnection
        :rtype: list[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.PrivateEndpointConnection]] = kwargs.pop("cls", None)

        _request = build_iot_dps_resource_list_private_endpoint_connections_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.PrivateEndpointConnection], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def check_provisioning_service_name_availability(  # pylint: disable=name-too-long
        self, arguments: _models.OperationInputs, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.NameAvailabilityInfo:
        """Check if a provisioning service name is available.

        Check if a provisioning service name is available. This will validate if the name is
        syntactically valid and if the name is usable.

        :param arguments: The request body. Required.
        :type arguments: ~azure.mgmt.iothubprovisioningservices.models.OperationInputs
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: NameAvailabilityInfo. The NameAvailabilityInfo is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.NameAvailabilityInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_provisioning_service_name_availability(  # pylint: disable=name-too-long
        self, arguments: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.NameAvailabilityInfo:
        """Check if a provisioning service name is available.

        Check if a provisioning service name is available. This will validate if the name is
        syntactically valid and if the name is usable.

        :param arguments: The request body. Required.
        :type arguments: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: NameAvailabilityInfo. The NameAvailabilityInfo is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.NameAvailabilityInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_provisioning_service_name_availability(  # pylint: disable=name-too-long
        self, arguments: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.NameAvailabilityInfo:
        """Check if a provisioning service name is available.

        Check if a provisioning service name is available. This will validate if the name is
        syntactically valid and if the name is usable.

        :param arguments: The request body. Required.
        :type arguments: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: NameAvailabilityInfo. The NameAvailabilityInfo is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.NameAvailabilityInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_provisioning_service_name_availability(  # pylint: disable=name-too-long
        self, arguments: Union[_models.OperationInputs, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.NameAvailabilityInfo:
        """Check if a provisioning service name is available.

        Check if a provisioning service name is available. This will validate if the name is
        syntactically valid and if the name is usable.

        :param arguments: The request body. Is one of the following types: OperationInputs, JSON,
         IO[bytes] Required.
        :type arguments: ~azure.mgmt.iothubprovisioningservices.models.OperationInputs or JSON or
         IO[bytes]
        :return: NameAvailabilityInfo. The NameAvailabilityInfo is compatible with MutableMapping
        :rtype: ~azure.mgmt.iothubprovisioningservices.models.NameAvailabilityInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NameAvailabilityInfo] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(arguments, (IOBase, bytes)):
            _content = arguments
        else:
            _content = json.dumps(arguments, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_iot_dps_resource_check_provisioning_service_name_availability_request(
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorDetails, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.NameAvailabilityInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
