# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.paloaltonetworksngfw.aio import PaloAltoNetworksNgfwMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPaloAltoNetworksNgfwMgmtLocalRulesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PaloAltoNetworksNgfwMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_rules_list_by_local_rulestacks(self, resource_group):
        response = self.client.local_rules.list_by_local_rulestacks(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            api_version="2025-10-08",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_rules_get(self, resource_group):
        response = await self.client.local_rules.get(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_rules_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.local_rules.begin_create_or_update(
                resource_group_name=resource_group.name,
                local_rulestack_name="str",
                priority="str",
                resource={
                    "ruleName": "str",
                    "actionType": "str",
                    "applications": ["str"],
                    "auditComment": "str",
                    "category": {"feeds": ["str"], "urlCustom": ["str"]},
                    "decryptionRuleType": "str",
                    "description": "str",
                    "destination": {
                        "cidrs": ["str"],
                        "countries": ["str"],
                        "feeds": ["str"],
                        "fqdnLists": ["str"],
                        "prefixLists": ["str"],
                    },
                    "enableLogging": "str",
                    "etag": "str",
                    "id": "str",
                    "inboundInspectionCertificate": "str",
                    "name": "str",
                    "negateDestination": "str",
                    "negateSource": "str",
                    "priority": 0,
                    "protocol": "application-default",
                    "protocolPortList": ["str"],
                    "provisioningState": "str",
                    "ruleState": "str",
                    "source": {"cidrs": ["str"], "countries": ["str"], "feeds": ["str"], "prefixLists": ["str"]},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": [{"key": "str", "value": "str"}],
                    "type": "str",
                },
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_rules_begin_delete(self, resource_group):
        response = await (
            await self.client.local_rules.begin_delete(
                resource_group_name=resource_group.name,
                local_rulestack_name="str",
                priority="str",
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_rules_get_counters(self, resource_group):
        response = await self.client.local_rules.get_counters(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_rules_refresh_counters(self, resource_group):
        response = await self.client.local_rules.refresh_counters(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_rules_reset_counters(self, resource_group):
        response = await self.client.local_rules.reset_counters(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...
