
from pathlib import Path
from collections import defaultdict

header = '''
# This file has been generated by path_makers.py.
# Do not edit it, edit 'all_paths' file and run 'path_makers.py'.'''

class FilePrepare:
    def __init__(self):
        self.imports = set[str]()
        self.defines = dict[str, str]()
    
    @property
    def contents(self) -> str:
        imports = '\n'.join([
            f'from . import {m}' for m in self.imports])
        defines = '\n'.join([
            f"{k} = '{v}'" for k, v in self.defines.items()])
        return '\n'.join([header, imports, defines])

paths_file = Path(__file__).parent / 'all_paths'

with open(paths_file, 'r') as f:
    contents = f.read()

all_paths = contents.splitlines()

root = paths_file.parent / 'osc_paths'
root.mkdir(exist_ok=True)

file_prepares = defaultdict[Path, FilePrepare](FilePrepare)

for osc_str in all_paths:
    osc_str = osc_str.strip()
    if not osc_str.startswith('/'):
        continue
    
    rel = osc_str[1:]
    p = root / rel
    # p.parent.mkdir(exist_ok=True, parents=True)
    
    pdir = p.parent
    
    file_prepares[pdir].defines[p.name.upper()] = osc_str
    
    while root in pdir.parents or root == pdir.parent:
        file_prepares[pdir.parent].imports.add(pdir.name)
        pdir = pdir.parent

for path, file_prepare in file_prepares.items():
    path.mkdir(exist_ok=True, parents=True)
    
    init_py = path / '__init__.py'
    with open (init_py, 'w') as f:
        f.write(file_prepare.contents)

    # print(str(path))
    # print(file_prepare.contents)
    # print()
    # print('', 'imports', file_prepare.imports)
    # print('', 'defines', [d for d in file_prepare.defines.values()])
    ...

    # while pdir != root:
    #     if all_imports.get(pdir) is None:
    #         all_imports[pdir] = {}
    #     all_imports[pdir].add()