SET(CMAKE_SYSTEM_NAME Windows)

IF (DEFINED ENV{LLVM_MINGW_DIR})
  SET(LLVM_MINGW_ROOT "$ENV{LLVM_MINGW_DIR}")
ELSE ()
  SET(LLVM_MINGW_ROOT "C:/ProgramData/llvm-mingw")
ENDIF()

SET(CMAKE_C_COMPILER ${LLVM_MINGW_ROOT}/bin/x86_64-w64-mingw32-clang.exe)
SET(CMAKE_CXX_COMPILER ${LLVM_MINGW_ROOT}/bin/x86_64-w64-mingw32-clang++.exe)
SET(CMAKE_RC_COMPILER ${LLVM_MINGW_ROOT}/bin/x86_64-w64-mingw32-windres.exe)

SET(CMAKE_FIND_ROOT_PATH ${LLVM_MINGW_ROOT}/x86_64-w64-mingw32)

# We may need some advanced thread APIs to compile tinyusz. use 0x601(Win7) if required
# SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -D_WIN32_WINNT=0x601")

SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
