# Copyright (C) 2003 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

importer_class = "ChestnutDialerImporter"
    
import os.path
import libxml2
import importer
from chestnut_dialer.xml_account_set import XmlAccountSet
from chestnut_dialer import _
    
class ChestnutDialerImporter(XmlAccountSet):
  __doc__ = _("This may be useful for import accounts from another user.")
  author = _("Konstantin Korikov")
  constructor_args = (
    { "name": "file_name",
      "type": "filename",
      "display": _("Source File")},)
  program = "chestnut-dialer"
  _imp_accounts_xml = None
  def __init__(self, file_name):
    try:
      self._imp_accounts_xml = libxml2.parseFile(file_name)
    except libxml2.parserError, e:
      raise importer.ConstructImporterException(str(e))
    nodes = self._imp_accounts_xml.xpathEval("/account-list")
    if len(nodes) == 0:
      self._imp_accounts_xml.freeDoc()
      self._imp_accounts_xml = None
      raise importer.ConstructImporterException(
        _("No accounts found"))
    XmlAccountSet.__init__(self, nodes[0])
  def __del__(self):
    if self._imp_accounts_xml != None:
      self._imp_accounts_xml.freeDoc()  
