package Locales::DB::Territory::ro;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::ro::VERSION = '0.09';

$Locales::DB::Territory::ro::cldr_version = '2.0';

%Locales::DB::Territory::ro::code_to_name = (
    '001' => 'Lume',
    '002' => 'Africa',
    '003' => "America\ de\ Nord",
    '005' => "America\ de\ Sud",
    '009' => 'Oceania',
    '011' => "Africa\ Occidentală",
    '013' => "America\ Centrală",
    '014' => "Africa\ Orientală",
    '015' => "Africa\ Septentrională",
    '017' => "Africa\ Centrală",
    '018' => "Africa\ Meridională",
    '019' => 'Americi',
    '021' => "America\ Septentrională",
    '029' => 'Caraibe',
    '030' => "Asia\ Orientală",
    '034' => "Asia\ Meridională",
    '035' => "Asia\ de\ Sud\-Est",
    '039' => "Europa\ Meridională",
    '053' => "Australia\ și\ Noua\ Zeelandă",
    '054' => 'Melanezia',
    '057' => "Regiunea\ Micronezia",
    '061' => 'Polinezia',
    '062' => "Asia\ Centrală\ de\ Sud",
    142   => 'Asia',
    143   => "Asia\ Centrală",
    145   => "Asia\ Occidentală",
    150   => 'Europa',
    151   => "Europa\ Orientală",
    154   => "Europa\ Septentrională",
    155   => "Europa\ Occidentală",
    172   => "Comunitatea\ Statelor\ Independente",
    200   => 'Czechoslovakia',
    419   => "America\ Latină",
    830   => "Insulele\ Anglo\-Normande",
    'ac'  => "Insula\ Ascension",
    'ad'  => 'Andorra',
    'ae'  => "Emiratele\ Arabe\ Unite",
    'af'  => 'Afganistan',
    'ag'  => "Antigua\ și\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Albania',
    'am'  => 'Armenia',
    'an'  => "Antilele\ Olandeze",
    'ao'  => 'Angola',
    'aq'  => 'Antarctica',
    'ar'  => 'Argentina',
    'as'  => "Samoa\ Americană",
    'at'  => 'Austria',
    'au'  => 'Australia',
    'aw'  => 'Aruba',
    'ax'  => "Insulele\ Aland",
    'az'  => 'Azerbaidjan',
    'ba'  => "Bosnia\ și\ Herțegovina",
    'bb'  => 'Barbados',
    'bd'  => 'Bangladesh',
    'be'  => 'Belgia',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulgaria',
    'bh'  => 'Bahrain',
    'bi'  => 'Burundi',
    'bj'  => 'Benin',
    'bl'  => "Sfântul\ Bartolomeu",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Bolivia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brazilia',
    'bs'  => 'Bahamas',
    'bt'  => 'Bhutan',
    'bv'  => "Insula\ Bouvet",
    'bw'  => 'Botswana',
    'by'  => 'Bielorusia',
    'bz'  => 'Belize',
    'ca'  => 'Canada',
    'cc'  => "Insulele\ Cocos",
    'cd'  => "Congo\ \[RDC\]",
    'cf'  => "Republica\ Centrafricană",
    'cg'  => "Congo\ \[Republică\]",
    'ch'  => 'Elveția',
    'ci'  => "Coasta\ de\ Fildeş",
    'ck'  => "Insulele\ Cook",
    'cl'  => 'Chile',
    'cm'  => 'Camerun',
    'cn'  => 'China',
    'co'  => 'Columbia',
    'cp'  => "Insula\ Clipperton",
    'cr'  => "Costa\ Rica",
    'cs'  => "Serbia\ și\ Muntenegru",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Cuba',
    'cv'  => "Capul\ Verde",
    'cx'  => "Insula\ Christmas",
    'cy'  => 'Cipru',
    'cz'  => "Republica\ Cehă",
    'dd'  => "East\ Germany",
    'de'  => 'Germania',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Djibouti',
    'dk'  => 'Danemarca',
    'dm'  => 'Dominica',
    'do'  => "Republica\ Dominicană",
    'dz'  => 'Algeria',
    'ea'  => "Ceuta\ şi\ Melilla",
    'ec'  => 'Ecuador',
    'ee'  => 'Estonia',
    'eg'  => 'Egipt',
    'eh'  => "Sahara\ Occidentală",
    'er'  => 'Eritreea',
    'es'  => 'Spania',
    'et'  => 'Etiopia',
    'eu'  => "Uniunea\ Europeană",
    'fi'  => 'Finlanda',
    'fj'  => 'Fiji',
    'fk'  => "Insulele\ Falkland\ \[Insulele\ Malvine\]",
    'fm'  => 'Micronezia',
    'fo'  => "Insulele\ Feroe",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Franța',
    'fx'  => "Franța\ metropolitană",
    'ga'  => 'Gabon',
    'gb'  => "Marea\ Britanie",
    'gd'  => 'Grenada',
    'ge'  => 'Georgia',
    'gf'  => "Guyana\ Franceză",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghana',
    'gi'  => 'Gibraltar',
    'gl'  => 'Groenlanda',
    'gm'  => 'Gambia',
    'gn'  => 'Guineea',
    'gp'  => 'Guadelupa',
    'gq'  => "Guineea\ Ecuatorială",
    'gr'  => 'Grecia',
    'gs'  => "Georgia\ de\ Sud\ şi\ Insulele\ Sandwich\ de\ Sud",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guineea\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Insula\ Heard\ și\ Insulele\ McDonald",
    'hn'  => 'Honduras',
    'hr'  => 'Croația',
    'ht'  => 'Haiti',
    'hu'  => 'Ungaria',
    'ic'  => "Insulele\ Canare",
    'id'  => 'Indonezia',
    'ie'  => 'Irlanda',
    'il'  => 'Israel',
    'im'  => "Insula\ Man",
    'in'  => 'India',
    'io'  => "Teritoriul\ Britanic\ din\ Oceanul\ Indian",
    'iq'  => 'Irak',
    'ir'  => 'Iran',
    'is'  => 'Islanda',
    'it'  => 'Italia',
    'je'  => 'Jersey',
    'jm'  => 'Jamaica',
    'jo'  => 'Iordania',
    'jp'  => 'Japonia',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kârgâzstan',
    'kh'  => 'Cambodgia',
    'ki'  => 'Kiribati',
    'km'  => 'Comore',
    'kn'  => "Sfântul\ Kitts\ și\ Nevis",
    'kp'  => "Coreea\ de\ Nord",
    'kr'  => "Coreea\ de\ Sud",
    'kw'  => 'Kuweit',
    'ky'  => "Insulele\ Cayman",
    'kz'  => 'Kazahstan',
    'la'  => 'Laos',
    'lb'  => 'Liban',
    'lc'  => "Sfânta\ Lucia",
    'li'  => 'Liechtenstein',
    'lk'  => "Sri\ Lanka",
    'lr'  => 'Liberia',
    'ls'  => 'Lesotho',
    'lt'  => 'Lituania',
    'lu'  => 'Luxemburg',
    'lv'  => 'Letonia',
    'ly'  => 'Libia',
    'ma'  => 'Maroc',
    'mc'  => 'Monaco',
    'md'  => "Republica\ Moldova",
    'me'  => 'Muntenegru',
    'mf'  => "Sfântul\ Martin",
    'mg'  => 'Madagascar',
    'mh'  => "Insulele\ Marshall",
    'mi'  => "Midway\ Islands",
    'mk'  => "Macedonia\ \[FYROM\]",
    'ml'  => 'Mali',
    'mm'  => 'Myanmar',
    'mn'  => 'Mongolia',
    'mo'  => 'Macao',
    'mp'  => "Insulele\ Mariane\ de\ Nord",
    'mq'  => 'Martinica',
    'mr'  => 'Mauritania',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'Maldive',
    'mw'  => 'Malawi',
    'mx'  => 'Mexic',
    'my'  => 'Malaezia',
    'mz'  => 'Mozambic',
    'na'  => 'Namibia',
    'nc'  => "Noua\ Caledonie",
    'ne'  => 'Niger',
    'nf'  => "Insulele\ Norfolk",
    'ng'  => 'Nigeria',
    'ni'  => 'Nicaragua',
    'nl'  => 'Olanda',
    'no'  => 'Norvegia',
    'np'  => 'Nepal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "Noua\ Zeelandă",
    'om'  => 'Oman',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Polinezia\ Franceză",
    'pg'  => "Papua\ Noua\ Guinee",
    'ph'  => 'Filipine',
    'pk'  => 'Pakistan',
    'pl'  => 'Polonia',
    'pm'  => "Sfântul\ Pierre\ și\ Miquelon",
    'pn'  => 'Pitcairn',
    'pr'  => "Porto\ Rico",
    'ps'  => "Teritoriul\ Palestinian",
    'pt'  => 'Portugalia',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguay',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Qatar',
    'qo'  => "Oceania\ Periferică",
    're'  => 'Reunion',
    'ro'  => 'România',
    'rs'  => 'Serbia',
    'ru'  => 'Rusia',
    'rw'  => 'Rwanda',
    'sa'  => "Arabia\ Saudită",
    'sb'  => "Insulele\ Solomon",
    'sc'  => 'Seychelles',
    'sd'  => 'Sudan',
    'se'  => 'Suedia',
    'sg'  => 'Singapore',
    'sh'  => "Sfânta\ Elena",
    'si'  => 'Slovenia',
    'sj'  => "Svalbard\ și\ Jan\ Mayen",
    'sk'  => 'Slovacia',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'Senegal',
    'so'  => 'Somalia',
    'sr'  => 'Surinam',
    'st'  => "Sao\ Tome\ și\ Principe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Siria',
    'sz'  => 'Swaziland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Insulele\ Turks\ și\ Caicos",
    'td'  => 'Ciad',
    'tf'  => "Teritoriile\ Australe\ și\ Antarctice\ Franceze",
    'tg'  => 'Togo',
    'th'  => 'Thailanda',
    'tj'  => 'Tadjikistan',
    'tk'  => 'Tokelau',
    'tl'  => "Timorul\ de\ Est",
    'tm'  => 'Turkmenistan',
    'tn'  => 'Tunisia',
    'to'  => 'Tonga',
    'tr'  => 'Turcia',
    'tt'  => "Trinidad\-Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taiwan',
    'tz'  => 'Tanzania',
    'ua'  => 'Ucraina',
    'ug'  => 'Uganda',
    'um'  => "Insulele\ Minore\ Îndepărtate\ ale\ Statelor\ Unite\ ale\ Americii",
    'us'  => "Statele\ Unite\ ale\ Americii",
    'uy'  => 'Uruguay',
    'uz'  => 'Uzbekistan',
    'va'  => 'Vatican',
    'vc'  => "Sfântul\ Vincent\ și\ Grenadine",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "Insulele\ Virgine\ Britanice",
    'vi'  => "Insulele\ Virgine\ S\.U\.A\.",
    'vn'  => 'Vietnam',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ și\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemen',
    'yt'  => 'Mayotte',
    'za'  => "Africa\ de\ Sud",
    'zm'  => 'Zambia',
    'zw'  => 'Zimbabwe',
    'zz'  => "Regiune\ necunoscută",
);

%Locales::DB::Territory::ro::name_to_code = (
    'afganistan'                                             => 'af',
    'africa'                                                 => '002',
    'africacentrală'                                        => '017',
    'africadesud'                                            => 'za',
    'africameridională'                                     => '018',
    'africaoccidentală'                                     => '011',
    'africaorientală'                                       => '014',
    'africaseptentrională'                                  => '015',
    'albania'                                                => 'al',
    'algeria'                                                => 'dz',
    'americacentrală'                                       => '013',
    'americadenord'                                          => '003',
    'americadesud'                                           => '005',
    'americalatină'                                         => 419,
    'americaseptentrională'                                 => '021',
    'americi'                                                => '019',
    'andorra'                                                => 'ad',
    'angola'                                                 => 'ao',
    'anguilla'                                               => 'ai',
    'antarctica'                                             => 'aq',
    'antiguașibarbuda'                                      => 'ag',
    'antileleolandeze'                                       => 'an',
    'arabiasaudită'                                         => 'sa',
    'argentina'                                              => 'ar',
    'armenia'                                                => 'am',
    'aruba'                                                  => 'aw',
    'asia'                                                   => 142,
    'asiacentrală'                                          => 143,
    'asiacentralădesud'                                     => '062',
    'asiadesudest'                                           => '035',
    'asiameridională'                                       => '034',
    'asiaoccidentală'                                       => 145,
    'asiaorientală'                                         => '030',
    'australia'                                              => 'au',
    'australiașinouazeelandă'                              => '053',
    'austria'                                                => 'at',
    'azerbaidjan'                                            => 'az',
    'bahamas'                                                => 'bs',
    'bahrain'                                                => 'bh',
    'bangladesh'                                             => 'bd',
    'barbados'                                               => 'bb',
    'belgia'                                                 => 'be',
    'belize'                                                 => 'bz',
    'benin'                                                  => 'bj',
    'bermuda'                                                => 'bm',
    'bhutan'                                                 => 'bt',
    'bielorusia'                                             => 'by',
    'bolivia'                                                => 'bo',
    'bosniașiherțegovina'                                  => 'ba',
    'botswana'                                               => 'bw',
    'brazilia'                                               => 'br',
    'britishantarcticterritory'                              => 'bq',
    'brunei'                                                 => 'bn',
    'bulgaria'                                               => 'bg',
    'burkinafaso'                                            => 'bf',
    'burundi'                                                => 'bi',
    'cambodgia'                                              => 'kh',
    'camerun'                                                => 'cm',
    'canada'                                                 => 'ca',
    'cantonandenderburyislands'                              => 'ct',
    'capulverde'                                             => 'cv',
    'caraibe'                                                => '029',
    'ceutaşimelilla'                                        => 'ea',
    'chile'                                                  => 'cl',
    'china'                                                  => 'cn',
    'ciad'                                                   => 'td',
    'cipru'                                                  => 'cy',
    'coastadefildeş'                                        => 'ci',
    'columbia'                                               => 'co',
    'comore'                                                 => 'km',
    'comunitateastatelorindependente'                        => 172,
    'congordc'                                               => 'cd',
    'congorepublică'                                        => 'cg',
    'coreeadenord'                                           => 'kp',
    'coreeadesud'                                            => 'kr',
    'costarica'                                              => 'cr',
    'croația'                                               => 'hr',
    'cuba'                                                   => 'cu',
    'czechoslovakia'                                         => 200,
    'danemarca'                                              => 'dk',
    'diegogarcia'                                            => 'dg',
    'djibouti'                                               => 'dj',
    'dominica'                                               => 'dm',
    'dronningmaudland'                                       => 'nq',
    'eastgermany'                                            => 'dd',
    'ecuador'                                                => 'ec',
    'egipt'                                                  => 'eg',
    'elsalvador'                                             => 'sv',
    'elveția'                                               => 'ch',
    'emiratelearabeunite'                                    => 'ae',
    'eritreea'                                               => 'er',
    'estonia'                                                => 'ee',
    'etiopia'                                                => 'et',
    'europa'                                                 => 150,
    'europameridională'                                     => '039',
    'europaoccidentală'                                     => 155,
    'europaorientală'                                       => 151,
    'europaseptentrională'                                  => 154,
    'fiji'                                                   => 'fj',
    'filipine'                                               => 'ph',
    'finlanda'                                               => 'fi',
    'franța'                                                => 'fr',
    'franțametropolitană'                                  => 'fx',
    'frenchsouthernandantarcticterritories'                  => 'fq',
    'gabon'                                                  => 'ga',
    'gambia'                                                 => 'gm',
    'georgia'                                                => 'ge',
    'georgiadesudşiinsulelesandwichdesud'                   => 'gs',
    'germania'                                               => 'de',
    'ghana'                                                  => 'gh',
    'gibraltar'                                              => 'gi',
    'grecia'                                                 => 'gr',
    'grenada'                                                => 'gd',
    'groenlanda'                                             => 'gl',
    'guadelupa'                                              => 'gp',
    'guam'                                                   => 'gu',
    'guatemala'                                              => 'gt',
    'guernsey'                                               => 'gg',
    'guineea'                                                => 'gn',
    'guineeabissau'                                          => 'gw',
    'guineeaecuatorială'                                    => 'gq',
    'guyana'                                                 => 'gy',
    'guyanafranceză'                                        => 'gf',
    'haiti'                                                  => 'ht',
    'honduras'                                               => 'hn',
    'hongkong'                                               => 'hk',
    'india'                                                  => 'in',
    'indonezia'                                              => 'id',
    'insulaascension'                                        => 'ac',
    'insulabouvet'                                           => 'bv',
    'insulachristmas'                                        => 'cx',
    'insulaclipperton'                                       => 'cp',
    'insulaheardșiinsulelemcdonald'                         => 'hm',
    'insulaman'                                              => 'im',
    'insulelealand'                                          => 'ax',
    'insuleleanglonormande'                                  => 830,
    'insulelecanare'                                         => 'ic',
    'insulelecayman'                                         => 'ky',
    'insulelecocos'                                          => 'cc',
    'insulelecook'                                           => 'ck',
    'insulelefalklandinsulelemalvine'                        => 'fk',
    'insuleleferoe'                                          => 'fo',
    'insulelemarianedenord'                                  => 'mp',
    'insulelemarshall'                                       => 'mh',
    'insuleleminoreÎndepărtatealestatelorunitealeamericii' => 'um',
    'insulelenorfolk'                                        => 'nf',
    'insulelesolomon'                                        => 'sb',
    'insuleleturksșicaicos'                                 => 'tc',
    'insulelevirginebritanice'                               => 'vg',
    "insulelevirgines\.u\.a\."                               => 'vi',
    'iordania'                                               => 'jo',
    'irak'                                                   => 'iq',
    'iran'                                                   => 'ir',
    'irlanda'                                                => 'ie',
    'islanda'                                                => 'is',
    'israel'                                                 => 'il',
    'italia'                                                 => 'it',
    'jamaica'                                                => 'jm',
    'japonia'                                                => 'jp',
    'jersey'                                                 => 'je',
    'johnstonisland'                                         => 'jt',
    'kazahstan'                                              => 'kz',
    'kenya'                                                  => 'ke',
    'kiribati'                                               => 'ki',
    'kuweit'                                                 => 'kw',
    'kârgâzstan'                                           => 'kg',
    'laos'                                                   => 'la',
    'lesotho'                                                => 'ls',
    'letonia'                                                => 'lv',
    'liban'                                                  => 'lb',
    'liberia'                                                => 'lr',
    'libia'                                                  => 'ly',
    'liechtenstein'                                          => 'li',
    'lituania'                                               => 'lt',
    'lume'                                                   => '001',
    'luxemburg'                                              => 'lu',
    'macao'                                                  => 'mo',
    'macedoniafyrom'                                         => 'mk',
    'madagascar'                                             => 'mg',
    'malaezia'                                               => 'my',
    'malawi'                                                 => 'mw',
    'maldive'                                                => 'mv',
    'mali'                                                   => 'ml',
    'malta'                                                  => 'mt',
    'mareabritanie'                                          => 'gb',
    'maroc'                                                  => 'ma',
    'martinica'                                              => 'mq',
    'mauritania'                                             => 'mr',
    'mauritius'                                              => 'mu',
    'mayotte'                                                => 'yt',
    'melanezia'                                              => '054',
    'mexic'                                                  => 'mx',
    'micronezia'                                             => 'fm',
    'midwayislands'                                          => 'mi',
    'monaco'                                                 => 'mc',
    'mongolia'                                               => 'mn',
    'montserrat'                                             => 'ms',
    'mozambic'                                               => 'mz',
    'muntenegru'                                             => 'me',
    'myanmar'                                                => 'mm',
    'namibia'                                                => 'na',
    'nauru'                                                  => 'nr',
    'nepal'                                                  => 'np',
    'neutralzone'                                            => 'nt',
    'nicaragua'                                              => 'ni',
    'niger'                                                  => 'ne',
    'nigeria'                                                => 'ng',
    'niue'                                                   => 'nu',
    'northvietnam'                                           => 'vd',
    'norvegia'                                               => 'no',
    'nouacaledonie'                                          => 'nc',
    'nouazeelandă'                                          => 'nz',
    'oceania'                                                => '009',
    'oceaniaperiferică'                                     => 'qo',
    'olanda'                                                 => 'nl',
    'oman'                                                   => 'om',
    'pacificislandstrustterritory'                           => 'pc',
    'pakistan'                                               => 'pk',
    'palau'                                                  => 'pw',
    'panama'                                                 => 'pa',
    'panamacanalzone'                                        => 'pz',
    'papuanouaguinee'                                        => 'pg',
    'paraguay'                                               => 'py',
    "people\â\\sdemocraticrepublicofyemen"              => 'yd',
    'peru'                                                   => 'pe',
    'pitcairn'                                               => 'pn',
    'polinezia'                                              => '061',
    'polineziafranceză'                                     => 'pf',
    'polonia'                                                => 'pl',
    'portorico'                                              => 'pr',
    'portugalia'                                             => 'pt',
    'qatar'                                                  => 'qa',
    'regiuneamicronezia'                                     => '057',
    'regiunenecunoscută'                                    => 'zz',
    'republicacehă'                                         => 'cz',
    'republicacentrafricană'                                => 'cf',
    'republicadominicană'                                   => 'do',
    'republicamoldova'                                       => 'md',
    'reunion'                                                => 're',
    'românia'                                               => 'ro',
    'rusia'                                                  => 'ru',
    'rwanda'                                                 => 'rw',
    'saharaoccidentală'                                     => 'eh',
    'samoa'                                                  => 'ws',
    'samoaamericană'                                        => 'as',
    'sanmarino'                                              => 'sm',
    'saotomeșiprincipe'                                     => 'st',
    'senegal'                                                => 'sn',
    'serbia'                                                 => 'rs',
    'serbiașimuntenegru'                                    => 'cs',
    'seychelles'                                             => 'sc',
    'sfântaelena'                                           => 'sh',
    'sfântalucia'                                           => 'lc',
    'sfântulbartolomeu'                                     => 'bl',
    'sfântulkittsșinevis'                                  => 'kn',
    'sfântulmartin'                                         => 'mf',
    'sfântulpierreșimiquelon'                              => 'pm',
    'sfântulvincentșigrenadine'                            => 'vc',
    'sierraleone'                                            => 'sl',
    'singapore'                                              => 'sg',
    'siria'                                                  => 'sy',
    'slovacia'                                               => 'sk',
    'slovenia'                                               => 'si',
    'somalia'                                                => 'so',
    'spania'                                                 => 'es',
    'srilanka'                                               => 'lk',
    'stateleunitealeamericii'                                => 'us',
    'sudan'                                                  => 'sd',
    'suedia'                                                 => 'se',
    'surinam'                                                => 'sr',
    'svalbardșijanmayen'                                    => 'sj',
    'swaziland'                                              => 'sz',
    'tadjikistan'                                            => 'tj',
    'taiwan'                                                 => 'tw',
    'tanzania'                                               => 'tz',
    'teritoriileaustraleșiantarcticefranceze'               => 'tf',
    'teritoriulbritanicdinoceanulindian'                     => 'io',
    'teritoriulpalestinian'                                  => 'ps',
    'thailanda'                                              => 'th',
    'timoruldeest'                                           => 'tl',
    'togo'                                                   => 'tg',
    'tokelau'                                                => 'tk',
    'tonga'                                                  => 'to',
    'trinidadtobago'                                         => 'tt',
    'tristandacunha'                                         => 'ta',
    'tunisia'                                                => 'tn',
    'turcia'                                                 => 'tr',
    'turkmenistan'                                           => 'tm',
    'tuvalu'                                                 => 'tv',
    "u\.s\.miscellaneouspacificislands"                      => 'pu',
    'ucraina'                                                => 'ua',
    'uganda'                                                 => 'ug',
    'ungaria'                                                => 'hu',
    'unionofsovietsocialistrepublics'                        => 'su',
    'uniuneaeuropeană'                                      => 'eu',
    'uruguay'                                                => 'uy',
    'uzbekistan'                                             => 'uz',
    'vanuatu'                                                => 'vu',
    'vatican'                                                => 'va',
    'venezuela'                                              => 've',
    'vietnam'                                                => 'vn',
    'wakeisland'                                             => 'wk',
    'wallisșifutuna'                                        => 'wf',
    'yemen'                                                  => 'ye',
    'zambia'                                                 => 'zm',
    'zimbabwe'                                               => 'zw',
);

1;

