# Generated by default/object.tt
package Paws::ServiceQuotas::ServiceQuotaIncreaseRequestInTemplate;
  use Moose;
  has AwsRegion => (is => 'ro', isa => 'Str');
  has DesiredValue => (is => 'ro', isa => 'Num');
  has GlobalQuota => (is => 'ro', isa => 'Bool');
  has QuotaCode => (is => 'ro', isa => 'Str');
  has QuotaName => (is => 'ro', isa => 'Str');
  has ServiceCode => (is => 'ro', isa => 'Str');
  has ServiceName => (is => 'ro', isa => 'Str');
  has Unit => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ServiceQuotas::ServiceQuotaIncreaseRequestInTemplate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ServiceQuotas::ServiceQuotaIncreaseRequestInTemplate object:

  $service_obj->Method(Att1 => { AwsRegion => $value, ..., Unit => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ServiceQuotas::ServiceQuotaIncreaseRequestInTemplate object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsRegion

=head1 DESCRIPTION

Information about a quota increase request.

=head1 ATTRIBUTES


=head2 AwsRegion => Str

The AWS Region.


=head2 DesiredValue => Num

The new, increased value of the quota.


=head2 GlobalQuota => Bool

Indicates whether the quota is global.


=head2 QuotaCode => Str

The quota identifier.


=head2 QuotaName => Str

The quota name.


=head2 ServiceCode => Str

The service identifier.


=head2 ServiceName => Str

The service name.


=head2 Unit => Str

The unit of measurement.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ServiceQuotas>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

