/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.osgi;

import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.osgi.ServletExporter;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class HttpServiceTrackerCust
implements ServiceTrackerCustomizer<HttpService, HttpService> {
    private static final String CXF_CONFIG_PID = "org.apache.cxf.osgi";
    private final DestinationRegistry destinationRegistry;
    private final BundleContext context;
    private ServiceRegistration<ManagedService> servletPublisherReg;
    private ServletExporter servletExporter;

    HttpServiceTrackerCust(DestinationRegistry destinationRegistry, BundleContext context) {
        this.destinationRegistry = destinationRegistry;
        this.context = context;
    }

    public void removedService(ServiceReference<HttpService> reference, HttpService service) {
        this.servletPublisherReg.unregister();
        try {
            this.servletExporter.updated(null);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void modifiedService(ServiceReference<HttpService> reference, HttpService service) {
    }

    public HttpService addingService(ServiceReference<HttpService> reference) {
        HttpService httpService = (HttpService)this.context.getService(reference);
        CXFNonSpringServlet servlet = new CXFNonSpringServlet(this.destinationRegistry, false);
        this.servletExporter = new ServletExporter(servlet, httpService);
        this.servletPublisherReg = this.context.registerService(ManagedService.class, (Object)this.servletExporter, CollectionUtils.singletonDictionary("service.pid", CXF_CONFIG_PID));
        return httpService;
    }
}

