/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ooxml.util;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXHelper {
    private static final POILogger logger = POILogFactory.getLogger(SAXHelper.class);
    private static long lastLog;
    static final EntityResolver IGNORING_ENTITY_RESOLVER;
    private static final SAXParserFactory saxFactory;

    private SAXHelper() {
    }

    public static synchronized XMLReader newXMLReader() throws SAXException, ParserConfigurationException {
        XMLReader xmlReader = saxFactory.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(IGNORING_ENTITY_RESOLVER);
        SAXHelper.trySetSAXFeature(xmlReader, "http://javax.xml.XMLConstants/feature/secure-processing");
        SAXHelper.trySetXercesSecurityManager(xmlReader);
        return xmlReader;
    }

    private static void trySetSAXFeature(SAXParserFactory spf, String feature, boolean flag) {
        try {
            spf.setFeature(feature, flag);
        }
        catch (Exception e) {
            logger.log(5, "SAX Feature unsupported", feature, e);
        }
        catch (AbstractMethodError ame) {
            logger.log(5, "Cannot set SAX feature because outdated XML parser in classpath", feature, ame);
        }
    }

    private static void trySetSAXFeature(XMLReader xmlReader, String feature) {
        try {
            xmlReader.setFeature(feature, true);
        }
        catch (Exception e) {
            logger.log(5, "SAX Feature unsupported", feature, e);
        }
        catch (AbstractMethodError ame) {
            logger.log(5, "Cannot set SAX feature because outdated XML parser in classpath", feature, ame);
        }
    }

    private static void trySetXercesSecurityManager(XMLReader xmlReader) {
        block6: {
            for (String securityManagerClassName : new String[]{"org.apache.xerces.util.SecurityManager"}) {
                try {
                    Object mgr = Class.forName(securityManagerClassName).newInstance();
                    Method setLimit = mgr.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                    setLimit.invoke(mgr, 1);
                    xmlReader.setProperty("http://apache.org/xml/properties/security-manager", mgr);
                    return;
                }
                catch (ClassNotFoundException mgr) {
                }
                catch (Throwable e) {
                    if (System.currentTimeMillis() <= lastLog + TimeUnit.MINUTES.toMillis(5L)) continue;
                    logger.log(5, "SAX Security Manager could not be setup [log suppressed for 5 minutes]", e);
                    lastLog = System.currentTimeMillis();
                }
            }
            try {
                xmlReader.setProperty("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", 1);
            }
            catch (SAXException e) {
                if (System.currentTimeMillis() <= lastLog + TimeUnit.MINUTES.toMillis(5L)) break block6;
                logger.log(5, "SAX Security Manager could not be setup [log suppressed for 5 minutes]", e);
                lastLog = System.currentTimeMillis();
            }
        }
    }

    static {
        IGNORING_ENTITY_RESOLVER = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        };
        try {
            saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            saxFactory.setNamespaceAware(true);
            SAXHelper.trySetSAXFeature(saxFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXHelper.trySetSAXFeature(saxFactory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            SAXHelper.trySetSAXFeature(saxFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Error | RuntimeException re) {
            logger.log(5, "Failed to create SAXParserFactory", re);
            throw re;
        }
        catch (Exception e) {
            logger.log(5, "Failed to create SAXParserFactory", e);
            throw new RuntimeException("Failed to create SAXParserFactory", e);
        }
    }
}

