/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class TikaLoggingFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(TikaLoggingFilter.class);
    private boolean infoLevel;

    public TikaLoggingFilter(boolean infoLevel) {
        this.infoLevel = infoLevel;
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestUri = requestContext.getUriInfo().getRequestUri().toString();
        if (this.infoLevel) {
            LOG.info("Request URI: {}", (Object)requestUri);
        } else {
            LOG.debug("Request URI: {}", (Object)requestUri);
        }
    }
}

