# Generated by default/object.tt
package Paws::IoTSiteWise::Transform;
  use Moose;
  has Expression => (is => 'ro', isa => 'Str', request_name => 'expression', traits => ['NameInRequest'], required => 1);
  has Variables => (is => 'ro', isa => 'ArrayRef[Paws::IoTSiteWise::ExpressionVariable]', request_name => 'variables', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::Transform

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::Transform object:

  $service_obj->Method(Att1 => { Expression => $value, ..., Variables => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::Transform object:

  $result = $service_obj->Method(...);
  $result->Att1->Expression

=head1 DESCRIPTION

Contains an asset transform property. A transform is a one-to-one
mapping of a property's data points from one form to another. For
example, you can use a transform to convert a Celsius data stream to
Fahrenheit by applying the transformation expression to each data point
of the Celsius stream. A transform can only have a data type of
C<DOUBLE> and consume properties with data types of C<INTEGER> or
C<DOUBLE>.

For more information, see Transforms
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms)
in the I<AWS IoT SiteWise User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Expression => Str

The mathematical expression that defines the transformation function.
You can specify up to 10 variables per expression. You can specify up
to 10 functions per expression.

For more information, see Quotas
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
in the I<AWS IoT SiteWise User Guide>.


=head2 B<REQUIRED> Variables => ArrayRef[L<Paws::IoTSiteWise::ExpressionVariable>]

The list of variables used in the expression.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

