use strict;
use warnings;

package App::Embra::Plugin::PruneFiles;
$App::Embra::Plugin::PruneFiles::VERSION = '0.001'; # TRIAL
# ABSTRACT: exclude files from the site

use List::MoreUtils qw< any >;
use Method::Signatures;
use Moo;



has 'filename' => (
    is => 'ro',
    default => sub { [] },
);

method mvp_multivalue_args() { qw< filename >; }

method exclude_file( $file ) {
    return 1 if any { $_ eq $file->name } @{ $self->filename };
    return;
}

with 'App::Embra::Role::FilePruner';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::PruneFiles - exclude files from the site

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will remove files from the site and prevent them from being processed.

In your F<embra.ini>:

  [PruneFiles]
  filename = not_this_file
  filename = dont_even_think_about_publishing_this

=head1 ATTRIBUTES

=head2 filename

Name of file to exclude. May be used multiple times to exclude multiple files.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
