# Generated by default/object.tt
package Paws::GreengrassV2::CoreDevice;
  use Moose;
  has CoreDeviceThingName => (is => 'ro', isa => 'Str', request_name => 'coreDeviceThingName', traits => ['NameInRequest']);
  has LastStatusUpdateTimestamp => (is => 'ro', isa => 'Str', request_name => 'lastStatusUpdateTimestamp', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::CoreDevice

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::CoreDevice object:

  $service_obj->Method(Att1 => { CoreDeviceThingName => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::CoreDevice object:

  $result = $service_obj->Method(...);
  $result->Att1->CoreDeviceThingName

=head1 DESCRIPTION

Contains information about a AWS IoT Greengrass core device, which is
an AWS IoT thing that runs the AWS IoT Greengrass Core software.

=head1 ATTRIBUTES


=head2 CoreDeviceThingName => Str

The name of the core device. This is also the name of the AWS IoT
thing.


=head2 LastStatusUpdateTimestamp => Str

The time at which the core device's status last updated, expressed in
ISO 8601 format.


=head2 Status => Str

The status of the core device. Core devices can have the following
statuses:

=over

=item *

C<HEALTHY> E<ndash> The AWS IoT Greengrass Core software and all
components run on the core device without issue.

=item *

C<UNHEALTHY> E<ndash> The AWS IoT Greengrass Core software or a
component is in a failed state on the core device.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

