# Generated by default/object.tt
package Paws::SageMaker::ModelExplainabilityAppSpecification;
  use Moose;
  has ConfigUri => (is => 'ro', isa => 'Str', required => 1);
  has Environment => (is => 'ro', isa => 'Paws::SageMaker::MonitoringEnvironmentMap');
  has ImageUri => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ModelExplainabilityAppSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ModelExplainabilityAppSpecification object:

  $service_obj->Method(Att1 => { ConfigUri => $value, ..., ImageUri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ModelExplainabilityAppSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfigUri

=head1 DESCRIPTION

Docker container image configuration object for the model
explainability job.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ConfigUri => Str

JSON formatted S3 file that defines explainability parameters. For more
information on this JSON configuration file, see Configure model
explainability parameters
(https://docs.aws.amazon.com/sagemaker/latest/json-model-explainability-parameter-config.html).


=head2 Environment => L<Paws::SageMaker::MonitoringEnvironmentMap>

Sets the environment variables in the Docker container.


=head2 B<REQUIRED> ImageUri => Str

The container image to be run by the model explainability job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

