# This file is encoded in Shift_JIS.
die "This file is not encoded in Shift_JIS.\n" if '' ne "\x82\xA0";
die "This script is for perl only. You are using $^X.\n" if $^X =~ /jperl/i;

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";
use mb;
mb::set_script_encoding('sjis');
use vars qw(@test);

use vars qw($MSWin32_MBCS);
$MSWin32_MBCS = ($^O =~ /MSWin32/) and (qx{chcp} =~ m/[^0123456789](932|936|949|950|951|20932|54936)\Z/);

BEGIN {
    $SIG{__WARN__} = sub {
        local($_) = @_;
        /\AReplacement list is longer than search list at /             ? return :
        /\AUseless use of \/d modifier in transliteration operator at / ? return :
        warn $_[0];
    };
}

@test = (
##############################################################################
# 1
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/;          $r == 3                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/;          $_ eq '111'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/;        $r == 3                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/;        $_ eq '111'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/;      $r == 3                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/;      $_ eq '111'             },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/;        $r == 6                 },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/;        $_ eq '111222CCC'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/;        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/;        $_ eq '12C12C12C'       },
# 11
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/;         $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/;         $_ eq '11C11C11C'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 21
    sub { $_='AAA';             my $r=mb::tr($_,'A','1');          $r == 3                 },
    sub { $_='AAA';             my $r=mb::tr($_,'A','1');          $_ eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12');        $r == 3                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12');        $_ eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123');      $r == 3                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123');      $_ eq '111'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12');        $r == 6                 },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12');        $_ eq '111222CCC'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12');        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12');        $_ eq '12C12C12C'       },
# 31
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1');         $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1');         $_ eq '11C11C11C'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 41
    sub { $_='```';             my $r=mb::tr($_,'`','P');         $r == 3                    },
    sub { $_='```';             my $r=mb::tr($_,'`','P');         $_ eq 'PPP'             },
    sub { $_='```';             my $r=mb::tr($_,'``','PQ');     $r == 3                    },
    sub { $_='```';             my $r=mb::tr($_,'``','PQ');     $_ eq 'PPP'             },
    sub { $_='```';             my $r=mb::tr($_,'```','PQR'); $r == 3                    },
    sub { $_='```';             my $r=mb::tr($_,'```','PQR'); $_ eq 'PPP'             },
    sub { $_='```aaabbb'; my $r=mb::tr($_,'`a','PQ');     $r == 6                    },
    sub { $_='```aaabbb'; my $r=mb::tr($_,'`a','PQ');     $_ eq 'PPPQQQbbb' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PQ');     $r == 6                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PQ');     $_ eq 'PQbPQbPQb' },
# 51
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P');       $r == 6                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P');       $_ eq 'PPbPPbPPb' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 61
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/d;        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/d;        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/s;        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/s;        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/s;       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/s;       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/ds;       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/ds;       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/ds;      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/ds;      $_ eq '1C1C1C'          },
# 71
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/11/ds;     $r == 9                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/11/ds;     $_ eq '1'               },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/1/ds;      $r == 9                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/1/ds;      $_ eq '1'               },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 81
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','d');        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','d');        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','s');        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','s');        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','s');       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','s');       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','ds');       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','ds');       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','ds');      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','ds');      $_ eq '1C1C1C'          },
# 91
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','11','ds');     $r == 9                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','11','ds');     $_ eq '1'               },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','1','ds');      $r == 9                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','1','ds');      $_ eq '1'               },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 101
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','d');      $r == 6              },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','d');      $_ eq 'PbPbPb' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','s');      $r == 6              },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','s');      $_ eq 'PbPbPb' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','s');    $r == 6              },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','s');    $_ eq 'PbPbPb' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','ds');     $r == 6              },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','ds');     $_ eq 'PbPbPb' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','ds');   $r == 6              },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','ds');   $_ eq 'PbPbPb' },
# 111
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`ab','PP','ds'); $r == 9              },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`ab','PP','ds'); $_ eq 'P'           },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`ab','P','ds');   $r == 9              },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`ab','P','ds');   $_ eq 'P'           },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 121
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/c;         $r == 0                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/c;         $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/c;       $r == 0                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/c;       $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/c;     $r == 0                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/c;     $_ eq 'AAA'             },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/c;       $r == 3                 },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/c;       $_ eq 'AAABBB222'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/c;       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/c;       $_ eq 'AB2AB2AB2'       },
# 131
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/c;        $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/c;        $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cd;       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cd;       $_ eq 'ABABAB'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 141
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','c');         $r == 0                 },
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','c');         $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','c');       $r == 0                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','c');       $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','c');     $r == 0                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','c');     $_ eq 'AAA'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','c');       $r == 3                 },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','c');       $_ eq 'AAABBB222'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','c');       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','c');       $_ eq 'AB2AB2AB2'       },
# 151
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','c');        $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','c');        $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cd');       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cd');       $_ eq 'ABABAB'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 161
    sub { $_='```';             my $r=mb::tr($_,'`','P','c');         $r == 0                    },
    sub { $_='```';             my $r=mb::tr($_,'`','P','c');         $_ eq '```'             },
    sub { $_='```';             my $r=mb::tr($_,'``','PQ','c');     $r == 0                    },
    sub { $_='```';             my $r=mb::tr($_,'``','PQ','c');     $_ eq '```'             },
    sub { $_='```';             my $r=mb::tr($_,'```','PQR','c'); $r == 0                    },
    sub { $_='```';             my $r=mb::tr($_,'```','PQR','c'); $_ eq '```'             },
    sub { $_='```aaabbb'; my $r=mb::tr($_,'`a','PQ','c');     $r == 3                    },
    sub { $_='```aaabbb'; my $r=mb::tr($_,'`a','PQ','c');     $_ eq '```aaaQQQ' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PQ','c');     $r == 3                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PQ','c');     $_ eq '`aQ`aQ`aQ' },
# 171
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','c');       $r == 3                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','c');       $_ eq '`aP`aP`aP' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','cd');      $r == 3                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','cd');      $_ eq '`a`a`a'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 181
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cs;       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cs;       $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/cs;      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/cs;      $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/1/cds;       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/1/cds;       $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/12/cds;      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/12/cds;      $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/11/cds;     $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/11/cds;     $_ eq 'BCBCBC'          },
# 191
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/1/cds;      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/1/cds;      $_ eq 'BCBCBC'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 201
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cs');       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cs');       $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','cs');      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','cs');      $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','1','cds');       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','1','cds');       $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','12','cds');      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','12','cds');      $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','11','cds');     $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','11','cds');     $_ eq 'BCBCBC'          },
# 211
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','1','cds');      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','1','cds');      $_ eq 'BCBCBC'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 221
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','cs');    $r == 3                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','cs');    $_ eq '`aP`aP`aP' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','cs');  $r == 3                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','cs');  $_ eq '`aP`aP`aP' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'a','P','cds');     $r == 6                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'a','P','cds');     $_ eq 'aaa'             },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'a','PQ','cds');   $r == 6                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'a','PQ','cds');   $_ eq 'aaa'             },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'ab','PP','cds'); $r == 3                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'ab','PP','cds'); $_ eq 'ababab'       },
# 231
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'ab','P','cds');   $r == 3                    },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'ab','P','cds');   $_ eq 'ababab'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 241
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/A/1/r;         $r eq '111'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AA/12/r;       $r eq '111'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AAA/123/r;     $r eq '111'             }},
    sub { ($] < 5.014) or eval q{ $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/r;       $r eq '111222CCC'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/r;       $r eq '12C12C12C'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/r;        $r eq '11C11C11C'       }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 251
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/dr;       $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/sr;       $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/sr;      $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/dsr;      $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/dsr;     $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/11/dsr;    $r eq '1'               }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/1/dsr;     $r eq '1'               }},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 261
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','r');         $r eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','r');       $r eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','r');     $r eq '111'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','r');       $r eq '111222CCC'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','r');       $r eq '12C12C12C'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','r');        $r eq '11C11C11C'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 271
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','dr');       $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','sr');       $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','sr');      $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','dsr');      $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','dsr');     $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','11','dsr');    $r eq '1'               },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','1','dsr');     $r eq '1'               },
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 281
    sub { $_='```';             my $r=mb::tr($_,'`','P','r');         $r eq 'PPP'             },
    sub { $_='```';             my $r=mb::tr($_,'``','PQ','r');     $r eq 'PPP'             },
    sub { $_='```';             my $r=mb::tr($_,'```','PQR','r'); $r eq 'PPP'             },
    sub { $_='```aaabbb'; my $r=mb::tr($_,'`a','PQ','r');     $r eq 'PPPQQQbbb' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PQ','r');     $r eq 'PQbPQbPQb' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','r');       $r eq 'PPbPPbPPb' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 291
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','dr');      $r eq 'PbPbPb'       },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','sr');      $r eq 'PbPbPb'       },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','sr');    $r eq 'PbPbPb'       },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','dsr');     $r eq 'PbPbPb'       },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','dsr');   $r eq 'PbPbPb'       },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`ab','PP','dsr'); $r eq 'P'                 },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`ab','P','dsr');   $r eq 'P'                 },
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 301
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/A/1/cr;        $r eq 'AAA'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AA/12/cr;      $r eq 'AAA'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AAA/123/cr;    $r eq 'AAA'             }},
    sub { ($] < 5.014) or eval q{ $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/cr;      $r eq 'AAABBB222'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/cr;      $r eq 'AB2AB2AB2'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cr;       $r eq 'AB1AB1AB1'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cdr;      $r eq 'ABABAB'          }},
    sub {1},
    sub {1},
    sub {1},
# 311
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/csr;      $r eq 'AB1AB1AB1'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/csr;     $r eq 'AB1AB1AB1'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/B/1/cdsr;      $r eq 'BBB'             }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/B/11/cdsr;     $r eq 'BBB'             }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/BC/11/cdsr;    $r eq 'BCBCBC'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/BC/1/cdsr;     $r eq 'BCBCBC'          }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 321
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','cr');        $r eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','cr');      $r eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','cr');    $r eq 'AAA'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','cr');      $r eq 'AAABBB222'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','cr');      $r eq 'AB2AB2AB2'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cr');       $r eq 'AB1AB1AB1'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 331
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cdr');      $r eq 'ABABAB'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','csr');      $r eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','csr');     $r eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','1','cdsr');      $r eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','11','cdsr');     $r eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','11','cdsr');    $r eq 'BCBCBC'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','1','cdsr');     $r eq 'BCBCBC'          },
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 341
    sub { $_='```';             my $r=mb::tr($_,'`','P','cr');         $r eq '```'             },
    sub { $_='```';             my $r=mb::tr($_,'``','PQ','cr');     $r eq '```'             },
    sub { $_='```';             my $r=mb::tr($_,'```','PQR','cr'); $r eq '```'             },
    sub { $_='```aaabbb'; my $r=mb::tr($_,'`a','PQ','cr');     $r eq '```aaaQQQ' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PQ','cr');     $r eq '`aQ`aQ`aQ' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','cr');       $r eq '`aP`aP`aP' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 351
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','cdr');      $r eq '`a`a`a'       },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','P','csr');      $r eq '`aP`aP`aP' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'`a','PP','csr');    $r eq '`aP`aP`aP' },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'a','P','cdsr');       $r eq 'aaa'             },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'a','PP','cdsr');     $r eq 'aaa'             },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'ab','PP','cdsr');   $r eq 'ababab'       },
    sub { $_='`ab`ab`ab'; my $r=mb::tr($_,'ab','P','cdsr');     $r eq 'ababab'       },
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 361
    sub { $_='1AB';             my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='1AB';             my $r=    $_ =~ tr/AB/11/s;       $_ eq '11'              },
    sub { $_='AB1';             my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='AB1';             my $r=    $_ =~ tr/AB/11/s;       $_ eq '11'              },
    sub { $_='1AB1';            my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='1AB1';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '111'             },
    sub { $_='111';             my $r=    $_ =~ tr/AB/23/s;       $r == 0                 },
    sub { $_='111';             my $r=    $_ =~ tr/AB/23/s;       $_ eq '111'             },
    sub { $_='11AB';            my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='11AB';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '111'             },
# 371
    sub { $_='AB11';            my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='AB11';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '111'             },
    sub { $_='11AB11';          my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='11AB11';          my $r=    $_ =~ tr/AB/11/s;       $_ eq '11111'           },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/;        $r == 4                 },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/;        $_ eq '1111'            },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/s;       $r == 4                 },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '1'               },
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 381
    sub { $_='1AB';             my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='1AB';             my $r=mb::tr($_,'AB','11','s');       $_ eq '11'              },
    sub { $_='AB1';             my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='AB1';             my $r=mb::tr($_,'AB','11','s');       $_ eq '11'              },
    sub { $_='1AB1';            my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='1AB1';            my $r=mb::tr($_,'AB','11','s');       $_ eq '111'             },
    sub { $_='111';             my $r=mb::tr($_,'AB','23','s');       $r == 0                 },
    sub { $_='111';             my $r=mb::tr($_,'AB','23','s');       $_ eq '111'             },
    sub { $_='11AB';            my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='11AB';            my $r=mb::tr($_,'AB','11','s');       $_ eq '111'             },
# 391
    sub { $_='AB11';            my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='AB11';            my $r=mb::tr($_,'AB','11','s');       $_ eq '111'             },
    sub { $_='11AB11';          my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='11AB11';          my $r=mb::tr($_,'AB','11','s');       $_ eq '11111'           },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11');           $r == 4                 },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11');           $_ eq '1111'            },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11','s');       $r == 4                 },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11','s');       $_ eq '1'               },
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 401
    sub { $_='P`a';          my $r=mb::tr($_,'`a','PP','s');       $r == 2                 },
    sub { $_='P`a';          my $r=mb::tr($_,'`a','PP','s');       $_ eq 'PP'            },
    sub { $_='`aP';          my $r=mb::tr($_,'`a','PP','s');       $r == 2                 },
    sub { $_='`aP';          my $r=mb::tr($_,'`a','PP','s');       $_ eq 'PP'            },
    sub { $_='P`aP';        my $r=mb::tr($_,'`a','PP','s');       $r == 2                 },
    sub { $_='P`aP';        my $r=mb::tr($_,'`a','PP','s');       $_ eq 'PPP'          },
    sub { $_='PPP';          my $r=mb::tr($_,'`a','QR','s');       $r == 0                 },
    sub { $_='PPP';          my $r=mb::tr($_,'`a','QR','s');       $_ eq 'PPP'          },
    sub { $_='PP`a';        my $r=mb::tr($_,'`a','PP','s');       $r == 2                 },
    sub { $_='PP`a';        my $r=mb::tr($_,'`a','PP','s');       $_ eq 'PPP'          },
# 411
    sub { $_='`aPP';        my $r=mb::tr($_,'`a','PP','s');       $r == 2                 },
    sub { $_='`aPP';        my $r=mb::tr($_,'`a','PP','s');       $_ eq 'PPP'          },
    sub { $_='PP`aPP';    my $r=mb::tr($_,'`a','PP','s');       $r == 2                 },
    sub { $_='PP`aPP';    my $r=mb::tr($_,'`a','PP','s');       $_ eq 'PPPPP'      },
    sub { $_='`a`a';        my $r=mb::tr($_,'`a','PP');           $r == 4                 },
    sub { $_='`a`a';        my $r=mb::tr($_,'`a','PP');           $_ eq 'PPPP'        },
    sub { $_='`a`a';        my $r=mb::tr($_,'`a','PP','s');       $r == 4                 },
    sub { $_='`a`a';        my $r=mb::tr($_,'`a','PP','s');       $_ eq 'P'              },
    sub {1},
    sub {1},
##############################################################################
# 421
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/;   $_ eq '431nsli4431444'          },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/d;  $_ eq '31nsli43144'             },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/s;  $_ eq '431nsli4314'             },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/ds; $_ eq '31nsli4314'              },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 431
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234');      $_ eq '431nsli4431444'          },
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234','d');  $_ eq '31nsli43144'             },
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234','s');  $_ eq '431nsli4314'             },
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234','ds'); $_ eq '31nsli4314'              },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 441
    sub { $_='';  my $r=mb::tr($_,'','PQRS');      $_ eq 'SRPSSRPSSS' },
    sub { $_='';  my $r=mb::tr($_,'','PQRS','d');  $_ eq 'RPSRPSS'       },
    sub { $_='';  my $r=mb::tr($_,'','PQRS','s');  $_ eq 'SRPSRPS'       },
    sub { $_='';  my $r=mb::tr($_,'','PQRS','ds'); $_ eq 'RPSRPS'         },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 451
    sub { $_='transliteratee';  my $r=    $_ =~ tr/ae//;          $r == 5                        },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/ae//;          $_ eq 'transliteratee'         },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 461
    sub { $_='transliteratee';  my $r=mb::tr($_,'ae','');   $r == 5                        },
    sub { $_='transliteratee';  my $r=mb::tr($_,'ae','');   $_ eq 'transliteratee'         },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 471
    sub { $_='';  my $r=mb::tr($_,'','');   $r == 5                              },
    sub { $_='';  my $r=mb::tr($_,'','');   $_ eq '' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 481
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC\xeb};  my $r=    $_ =~ tr/\a\b\e\f\n\r\t\053\cC\xeb/ABCDEFGHIJ/;          $r == 10                            },
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC\xeb};  my $r=    $_ =~ tr/\a\b\e\f\n\r\t\053\cC\xeb/ABCDEFGHIJ/;          $_ eq 'ABCDEFGHIJ'                  },
    sub { $_=qq{ABCDEFGHIJ};                 my $r=    $_ =~ tr/ABCDEFGHIJ/\a\b\e\f\n\r\t\053\cC\xeb/;          $r == 10                            },
    sub { $_=qq{ABCDEFGHIJ};                 my $r=    $_ =~ tr/ABCDEFGHIJ/\a\b\e\f\n\r\t\053\cC\xeb/;          $_ eq qq{\a\b\e\f\n\r\t\053\cC\xeb} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 491
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC\xeb};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC\xeb},qq{ABCDEFGHIJ});          $r == 10                            },
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC\xeb};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC\xeb},qq{ABCDEFGHIJ});          $_ eq 'ABCDEFGHIJ'                  },
    sub { $_=qq{ABCDEFGHIJ};                 my $r=mb::tr($_,qq{ABCDEFGHIJ},qq{\a\b\e\f\n\r\t\053\cC\xeb});          $r == 10                            },
    sub { $_=qq{ABCDEFGHIJ};                 my $r=mb::tr($_,qq{ABCDEFGHIJ},qq{\a\b\e\f\n\r\t\053\cC\xeb});          $_ eq qq{\a\b\e\f\n\r\t\053\cC\xeb} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 501
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC\xeb};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC\xeb},qq{`abcdefghi});          $r == 10                            },
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC\xeb};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC\xeb},qq{`abcdefghi});          $_ eq '`abcdefghi'        },
    sub { $_=qq{`abcdefghi};       my $r=mb::tr($_,qq{`abcdefghi},qq{\a\b\e\f\n\r\t\053\cC\xeb});          $r == 10                            },
    sub { $_=qq{`abcdefghi};       my $r=mb::tr($_,qq{`abcdefghi},qq{\a\b\e\f\n\r\t\053\cC\xeb});          $_ eq qq{\a\b\e\f\n\r\t\053\cC\xeb} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
#
);

$|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" } ok($_->()) for @test;

__END__
