# Generated by default/object.tt
package Paws::NetworkFirewall::FirewallStatus;
  use Moose;
  has ConfigurationSyncStateSummary => (is => 'ro', isa => 'Str', required => 1);
  has Status => (is => 'ro', isa => 'Str', required => 1);
  has SyncStates => (is => 'ro', isa => 'Paws::NetworkFirewall::SyncStates');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::FirewallStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::FirewallStatus object:

  $service_obj->Method(Att1 => { ConfigurationSyncStateSummary => $value, ..., SyncStates => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::FirewallStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfigurationSyncStateSummary

=head1 DESCRIPTION

Detailed information about the current status of a Firewall. You can
retrieve this for a firewall by calling DescribeFirewall and providing
the firewall name and ARN.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ConfigurationSyncStateSummary => Str

The configuration sync state for the firewall. This summarizes the sync
states reported in the C<Config> settings for all of the Availability
Zones where you have configured the firewall.

When you create a firewall or update its configuration, for example by
adding a rule group to its firewall policy, Network Firewall
distributes the configuration changes to all zones where the firewall
is in use. This summary indicates whether the configuration changes
have been applied everywhere.

This status must be C<IN_SYNC> for the firewall to be ready for use,
but it doesn't indicate that the firewall is ready. The C<Status>
setting indicates firewall readiness.


=head2 B<REQUIRED> Status => Str

The readiness of the configured firewall to handle network traffic
across all of the Availability Zones where you've configured it. This
setting is C<READY> only when the C<ConfigurationSyncStateSummary>
value is C<IN_SYNC> and the C<Attachment> C<Status> values for all of
the configured subnets are C<READY>.


=head2 SyncStates => L<Paws::NetworkFirewall::SyncStates>

The subnets that you've configured for use by the Network Firewall
firewall. This contains one array element per Availability Zone where
you've configured a subnet. These objects provide details of the
information that is summarized in the C<ConfigurationSyncStateSummary>
and C<Status>, broken down by zone and configuration object.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

